{ ---->>>>TEST28<<<<-------------------------------------------

  Last Update: 9/29/93
  Author: Ed Jordan

  This program demonstrates the use of the accompanying App28 unit.

  TApp28 is defined in APP28.PAS.  A descendant of TApplication, 
  it over-rides TApplication's SetScreenMode method to allow the 
  use of a 28-line text mode on VGA adaptors.  It should operate 
  normally on other adaptors.

  App28 is free.  It is a simple thing, but it has not been 
  extensively tested, and I make no guarantees and accept no 
  liability.

  ------------------------------------------------------------- }

program Test28;
uses Objects, App, App28, Drivers, Views, Menus, Editors, 
     Memory, Dialogs, MsgBox;

type
  TTestApp = object(TApp28)
    constructor Init;
    procedure InitMenuBar; virtual;
    procedure HandleEvent (var Event: TEvent); virtual;
    function OpenEditor (FileName: FNameStr): PEditWindow;
  end;

const
  cm25Lines = 150;
  cm28Lines = 151;
  cm50Lines = 152;

var
  TestApp: TTestApp;

function FileExists (FileNm: string): boolean;
var Untyped: file;
begin
  {$I-}
  assign(Untyped,FileNm);
  FileMode := 0;
  reset(Untyped);
  close(Untyped);
  {$I+}
  FileExists := (IOResult = 0) and (FileNm <> '');
end;

function DoEditDialog (Dialog: Integer; Info: Pointer): Word; far;
begin
  case Dialog of
    edOutOfMemory:
      DoEditDialog := MessageBox ('Not enough memory for this operation.',
        nil, mfError + mfOkButton);
    edReadError:
      DoEditDialog := MessageBox ('Error reading file %s.',
        @Info, mfError + mfOkButton);
    edWriteError:
      DoEditDialog := MessageBox ('Error writing file %s.',
        @Info, mfError + mfOkButton);
    edCreateError:
      DoEditDialog := MessageBox ('Error creating file %s.',
        @Info, mfError + mfOkButton);
    edSaveModify: 
      DoEditDialog := cmNo;
    edSaveUntitled: 
      DoEditDialog := cmNo;
  end;
end;

constructor TTestApp.Init;
begin
  MaxHeapSize := 4096;
  inherited Init;
  EditorDialog := DoEditDialog;
end;

procedure TTestApp.InitMenuBar;
var R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y+1;
  MenuBar := New(PMenubar,Init(R,NewMenu(
    NewSubMenu('~F~ile',hcNoContext,NewMenu(
      NewItem('~O~pen','F3',kbF3,cmOpen,hcNoContext,
      NewItem('E~x~it','Alt+X',kbAltX,cmQuit,hcNoContext,
      nil))),
    NewSubMenu('~O~ptions',hcNoContext,NewMenu(
      NewItem('2~5~ lines','',0,cm25Lines,hcNoContext,
      NewItem('2~8~ lines','',0,cm28Lines,hcNoContext,
      NewItem('~4~3/50 lines','',0,cm50Lines,hcNoContext,
      nil)))),
    NewSubMenu('~W~indow',hcNoContext,NewMenu(
      StdWindowMenuItems(nil)),
    nil)
  )))));
end;

function TTestApp.OpenEditor;
var
  P: PView;
  R: TRect;
begin
  DeskTop^.GetExtent(R);
  P := Application^.ValidView(New(PEditWindow,
    Init(R, FileName, wnNoNumber)));
  DeskTop^.Insert(P);
  OpenEditor := PEditWindow(P);
end;

procedure TTestApp.HandleEvent;
const ViewFile = 'TEST28.PAS';
begin
  inherited HandleEvent(Event);
  if (Event.What = evCommand) then
    case Event.Command of
      cmOpen: 
        if FileExists(ViewFile) then OpenEditor(ViewFile)
          else OpenEditor('');
      cm25Lines: 
        if (ScreenMode and smFont8x8 <> 0) or
            (ScreenMode and smFont8x14 <> 0) then
          SetScreenMode((ScreenMode and not smFont8x8) 
                         and not smFont8x14);
      cm28Lines: 
        if ScreenMode and smFont8x14 = 0 then
          SetScreenMode((ScreenMode and not smFont8x8) 
                         or smFont8x14);
      cm50Lines: 
        if ScreenMode and smFont8x8 = 0 then
          SetScreenMode((ScreenMode or smFont8x8) 
                         and not smFont8x14);
    end; { case }
  ClearEvent(Event);
end;

begin
  TestApp.Init;
  TestApp.Run;
  TestApp.Done;
end.