Unit DialogWn;
{ Unit:      DialogWn
  Version:   1.07
  Purpose:   make a descendant of tWindow named tDialogWindow that behaves like
             a modeless or modal dialog.
  Features:  - tDialogWindow descends from tWindow
             - tDialogWindow and descendants may be used as MDI childs
             - support for calculated resources is included e.g. a dialog
               childs class & style may be changed on-the-fly (see GetChildClass)
               tJanusDialogWindow object is an example for this: it decides at
               runtime whether to uses BorDlg's or standard dialogs
             - support DropDownBoxes just like a dialog (tWindow doesn't)
  Date:      02/06/93

  Developer: Peter Sawatzki (PS)
             Buchenhof 3, D-5800 Hagen 1, Germany
 CompuServe: 100031,3002

  Date:     Author:
  04/22/92  PS       initial release by PS
  07/25/92  PS/jwp   added Scroller support
  08/01/92  PS       added RunModal and modal support
  08/12/92  PS       removed SetClassName and NewClass, fixed bug in MDI support
  08/14/92  PS       fixed Focus problems in MDI, give focus to first ws_TabStop child
  08/30/92  PS       fixed more focus problems in MDI, added SysModal support
  09/27/92  PS       call DefDlgProc to support DropDownBoxes and Multiline edit controls
  10/21/92  PS       some changes for new OWL
  01/28/93  PS       add LoadMenu for automatic menu load
  02/06/93  PS       add support for InitResource,
                     fix BWCC's WM_NCCREATE glitch


  Contributing: Jeroen W. Pluimers (jwp)

  Copyright (c) 1992 Peter Sawatzki. All Rights Reserved.

}
Interface
Uses
  WinTypes,
  Win31,
{$IfDef Custom}
  CustomWn,
{$EndIf}
  Objects,
  oWindows;
Type
  tChildClass = Record
    wX, wY, wCX, wCY: Integer;
    wID: Word;
    dwStyle: LongInt;
    szClass: Array[0..63] Of Char;
    szTitle: Array[0..131] Of Char;
    CtlDataSize: Byte;
    CtlData: Array[0..255] Of Byte;
  End;

  tDialogWindowAttr = Record
    Name: pChar;
    ItemCount: Integer;
    MenuName,
    ClassName,
    FontName: pChar;
    Font: hFont;
    PointSize: Integer;
    DlgItems: Pointer;
    ResW,
    ResH: Integer;
    wUnitsX,
    wUnitsY: Word
  End;

{$IfDef Custom}
  Ancestor = tCustomWindow;
{$Else}
  Ancestor = tWindow;
{$EndIf}
  pDialogWindow = ^tDialogWindow;
  tDialogWindow = Object(Ancestor)
    DialogAttr: tDialogWindowAttr;
    ModalCode: pInteger;
    Constructor Init (aParent: pWindowsObject; aName: pChar);
    Destructor Done;                   Virtual;
    Function  Create: Boolean;         Virtual;
    Procedure Destroy;                 Virtual;
    Procedure SetupWindow;             Virtual;
    Procedure GetWindowClass (Var aWndClass: tWndClass); Virtual;
    Function  GetWindowProc: tFarProc; Virtual;
    Procedure DefWndProc (Var Msg: tMessage); Virtual;
    Procedure DefDialogProc (Var Msg: tMessage); Virtual;
    Procedure wmPaint(Var Msg: tMessage); Virtual wm_First+wm_Paint;
    Function  GetClassName: pChar;     Virtual;
    Procedure GetChildClass (Var aChildClass: tChildClass); Virtual;
    Function  CreateDialogChild (Var aChildClass: tChildClass): hWnd; Virtual;
    Function  CreateDialogChildren: Boolean; Virtual;
    Procedure CreateDialogFont;
    Procedure GetDialogInfo (aPtr: Pointer);
    Procedure UpdateDialog;            Virtual;
    Function  RunModal: Integer;       Virtual;
    Procedure EndDlg (aRetValue: Integer); Virtual;
    Function  GetItemHandle (DlgItemID: Integer): hWnd;
    Function  SendDlgItemMsg (DlgItemID: Integer; aMsg, wParam: Word; lParam: LongInt): LongInt;
    Procedure Ok (Var Msg: tMessage);           Virtual id_First+id_Ok;
    Procedure Cancel (Var Msg: tMessage);       Virtual id_First+id_Cancel;
    Procedure wmClose (Var Msg: tMessage);      Virtual wm_First+wm_Close;
    Procedure wmSetFocus (Var Msg:  tMessage);  Virtual wm_First+wm_SetFocus;
    Procedure wmSize (Var Msg: tMessage);       Virtual wm_First+wm_Size;
    Procedure wmLButtonDown (Var Msg: tMessage);Virtual wm_First+wm_LButtonDown;
  End;

  pJanusDialogWindow = ^tJanusDialogWindow;
  tJanusDialogWindow = Object(tDialogWindow)
    useBWCC: Boolean;
    Constructor Init (aParent: pWindowsObject; aName: pChar; BorStyle: Boolean);
    Function  GetWindowProc: tFarProc; Virtual;
    Procedure GetChildClass (Var aChildClass: tChildClass); Virtual;
  End;

  Function ExecDialogWindow (aDialogWindow: pDialogWindow): Integer;

Implementation
Uses
  WinProcs,
  Strings;
Const
  sztDialogWindow = 'tDialogWindow';

  ws_MdiChild   = ws_Child Or ws_ClipSiblings Or ws_SysMenu Or ws_Caption Or
                  ws_ThickFrame Or ws_MinimizeBox Or ws_MaximizeBox Or ws_Visible;
  ws_MdiAllowed = ws_MdiChild Or ws_Minimize Or ws_Maximize Or ws_ClipChildren Or
                  ws_Disabled Or ws_HScroll Or ws_VScroll;

  BorDialog = 'BorDlg';
  BorButton = 'BorBtn';
  BorRadio  = 'BorRadio';
  BorCheck  = 'BorCheck';
  BorShade  = 'BorShade';
  BorStatic = 'BorStatic';

  bss_Group = 1; {group box}
  bss_Hdip  = 2; {horizontal border}
  bss_Vdip  = 3; {hertical border}
  bss_Hbump = 4; {horizontal speed bump}
  bss_Vbump = 5; {vertical speed bump}

  BWCCInst: tHandle = tHandle(0);
  aBWCCDefMdiChildProc: tDefaultProc = Nil;
  aBWCCDefWindowProc:   tDefaultProc = Nil;
  aBWCCDefDlgProc:      tDefaultProc = Nil;

  wm_EnterMenuLoop = $0211; {undocumented}

Function DlgToClientX (x, Units: Integer): Integer;
{DlgToClientX:= x*Units Div 4}
Inline($59/$58/    {Pop Cx Ax}
       $F7/$E1/    {Mul Cx}
       $D1/$E8/    {Shr Ax,1}
       $D1/$E8);   {Shr Ax,1}

Function DlgToClientY (y, Units: Integer): Integer;
{DlgToClientY:= y*Units Div 8}
Inline($59/$58/    {Pop Cx Ax}
       $F7/$E1/    {Mul Cx}
       $D1/$E8/    {Shr Ax,1}
       $D1/$E8/    {Shr Ax,1}
       $D1/$E8);   {Shr Ax,1}

Constructor tDialogWindow.Init (aParent: pWindowsObject; aName: pChar);
Begin
  Inherited Init(aParent,sztDialogWindow); {fake title}
  FillChar(DialogAttr,SizeOf(DialogAttr),0);
  ModalCode:= Nil;                        {assume modeless window}
  With DialogAttr Do
    If PtrRec(aName).Seg=0 Then Name:= aName Else Name:= StrNew(aName);
  DefaultProc:= GetWindowProc
End;

Destructor tDialogWindow.Done;
Begin
  With DialogAttr Do Begin
    If PtrRec(Name).Seg<>0 Then StrDispose(Name);
    If PtrRec(MenuName).Seg<>0 Then StrDispose(MenuName);
    StrDispose(ClassName);
    StrDispose(FontName)
  End;
  Inherited Done
End;

Function tDialogWindow.Create: Boolean;
Var
  aResInfo, aRes: tHandle;
  oStyle: LongInt;
Begin
  Create:= False;
  If (Status<>0) Or (DialogAttr.Name=Nil) Then
    Exit;
  aResInfo:= FindResource(hInstance, DialogAttr.Name, rt_Dialog);
  If aResInfo<>0 Then
    aRes:= LoadResource(hInstance, aResInfo);
  If (aResInfo=0) Or (aRes=0) Then
    Status:= em_InvalidWindow
  Else Begin
    If ModalCode<>Nil Then
      If Parent=Nil Then Begin
        Status:= em_InvalidWindow;
        Exit
      End Else Begin
        EnableWindow(Parent^.hWindow,False); {disable Parent}
        ModalCode^:= 0                       {begin modal state}
      End;
    GetDialogInfo(LockResource(aRes));
    If DialogAttr.MenuName<>Nil Then
      Attr.Menu:= LoadMenu(hInstance, DialogAttr.MenuName);
    CreateDialogFont;
    UpdateDialog;
    EnableKBHandler;
    oStyle:= Attr.Style; Attr.Style:= Attr.Style And Not ws_Visible;
    Create:= Inherited Create;
    Attr.Style:= oStyle;
    If Attr.Style And ws_Visible<>0 Then
      ShowWindow(hWindow, sw_Show);
    UnlockResource(aRes);
    FreeResource(aRes)
  End
End;

Procedure tDialogWindow.Destroy;
Begin
  If (ModalCode<>Nil) And (Parent<>Nil) Then Begin
    EnableWindow(Parent^.hWindow,True); {enable Parent}
    If ModalCode^=0 Then {terminate modal window if not already terminated}
      ModalCode^:= id_Cancel
  End;

  If DialogAttr.FontName<>Nil Then
    DeleteObject(DialogAttr.Font);
  Inherited Destroy
End;

Procedure tDialogWindow.SetupWindow;
Begin
  SendMessage(hWindow,wm_SetFont,DialogAttr.Font,0);
  If Not CreateDialogChildren Then
    Status:= em_InvalidChild;
  Inherited SetupWindow;
  If  Assigned(Scroller) Then
  With Scroller^ Do Begin
    {fix BWCC background quirk}
    XUnit:= (XUnit+1) And Not 1; { make even }
    YUnit:= (YUnit+1) And Not 1
  End
End;

Procedure tDialogWindow.GetWindowClass (Var aWndClass: tWndClass);
Begin
  Inherited GetWindowClass(aWndClass);
  aWndClass.cbWndExtra:= DlgWindowExtra;
End;

Function tDialogWindow.GetWindowProc: tFarProc;
Begin
  If IsFlagSet(wb_MDIChild) Then
    GetWindowProc:= @DefMdiChildProc
  Else
    GetWindowProc:= @DefWindowProc
End;

Procedure tDialogWindow.DefWndProc (Var Msg: tMessage);
Begin
  Case Msg.Message Of
    wm_NextDlgCtl,
    wm_EnterMenuLoop,
    wm_NCLButtonDown: DefDialogProc(Msg);
  Else
    Inherited DefWndProc(Msg)
  End
End;

Procedure tDialogWindow.DefDialogProc (Var Msg: tMessage);
Begin
  With Msg Do
    Result:= DefDlgProc(hWindow, Message, wParam, lParam)
End;

Procedure tDialogWindow.wmPaint(Var Msg: tMessage);
Var
  PaintInfo: tPaintStruct;
Begin
  PaintInfo.hDC:= GetWindowDC(hWindow);
  GetClientRect(hWindow, PaintInfo.rcPaint);
  If Assigned(Scroller) Then Scroller^.BeginView(PaintInfo.hDC, PaintInfo);
  Paint(PaintInfo.hDC, PaintInfo);
  If Assigned(Scroller) Then Scroller^.EndView;
  ReleaseDC(hWindow, PaintInfo.hDC);

  DefWndProc(Msg);
End;

Function tDialogWindow.GetClassName: pChar;
Begin
  If Assigned(DialogAttr.ClassName) Then
    GetClassName:= DialogAttr.ClassName
  Else
    GetClassName:= wc_Dialog
End;

Procedure tDialogWindow.GetChildClass (Var aChildClass: tChildClass);
{-change a childs window class. Standard windows behaviour is simulated here:
  change special resource shortcuts (#$80..#$85) to their appropriate class names}
Const
  PreDefClasses: Array[#$80..#$85] Of pChar =
    ('BUTTON','EDIT','STATIC','LISTBOX','SCROLLBAR','COMBOBOX');
Begin
  With aChildClass Do
    Case szClass[0] Of
      #$80..#$85: StrCopy(szClass,PreDefClasses[szClass[0]])
    End
End;

Function tDialogWindow.CreateDialogChild (Var aChildClass: tChildClass): hWnd;
Var
  aCtl: hWnd;
  lpDlgItemInfo: Pointer;
Begin
  With DialogAttr, aChildClass Do Begin
    If CtlDataSize=0 Then
      lpDlgItemInfo:= Nil
    Else
      lpDlgItemInfo:= @CtlData;
    aCtl:= CreateWindowEx(ws_Ex_NoParentNotify, szClass, szTitle, dwStyle,
                          DlgToClientX(wX,wUnitsX),  DlgToClientY(wY,wUnitsY),
                          DlgToClientX(wCX,wUnitsX), DlgToClientY(wCY,wUnitsY),
                          hWindow, wID, System.hInstance,
                          lpDlgItemInfo);
    If aCtl<>0 Then Begin
      SendMessage(aCtl, wm_SetFont, Font, 0);
      SendMessage(aCtl, wm_GetDlgCode, 0, 0)
    End
  End;
  CreateDialogChild:= aCtl
End;

Function tDialogWindow.CreateDialogChildren: Boolean;
Var
  i: Integer;
  sp: Pointer;
  anItem: tChildClass;
  aCtl: hWnd;
Begin
  CreateDialogChildren:= False;
  sp:= DialogAttr.DlgItems;
  With DialogAttr,anItem Do
  For i:= 1 To DialogAttr.ItemCount Do Begin
    {-copy fixed header and first byte of szClass}
    Move(sp^,anItem,15); Inc(Word(sp),15);
    Case szClass[0] Of
      #$80..#$85: szClass[1]:= #0;   {be safe}
    Else
      StrCopy(szClass+1,sp);       {copy rest of classname}
      Inc(Word(sp),StrLen(sp)+1)
    End;
    StrCopy(szTitle,sp); Inc(Word(sp),StrLen(sp)+1);
    Move(sp^,CtlDataSize,Byte(sp^)+1);
    Inc(Word(sp),CtlDataSize+1);
    {-maybe a descendant class wants to change child class :-) }
    GetChildClass(anItem);
    aCtl:= CreateDialogChild(anItem);
    If aCtl=0 Then
      Exit
    Else
      If (FocusChildHandle=0) And (anItem.dwStyle And ws_TabStop>0) Then
        FocusChildHandle:= aCtl
  End;
  CreateDialogChildren:= True
End;

Procedure tDialogWindow.GetDialogInfo (aPtr: Pointer);
Begin
  With Attr,DialogAttr Do Begin
    Style:= LongInt(aPtr^);   Inc(Word(aPtr),SizeOf(LongInt));
    ItemCount:= Byte(aPtr^);  Inc(Word(aPtr),SizeOf(Byte));
    If Not IsFlagSet(wb_MdiChild) Then
      X:= Integer(aPtr^);     Inc(Word(aPtr),SizeOf(Integer));
    Y:= Integer(aPtr^);       Inc(Word(aPtr),SizeOf(Integer));
    W:= Integer(aPtr^);       Inc(Word(aPtr),SizeOf(Integer));
    H:= Integer(aPtr^);       Inc(Word(aPtr),SizeOf(Integer));
    If Byte(aPtr^)=255 Then
      MenuName:= pChar(pWord(pChar(aPtr)+1)^) {<g>}
    Else
      MenuName:= StrNew(aPtr);Inc(Word(aPtr),StrLen(aPtr)+1);
    ClassName:= StrNew(aPtr); Inc(Word(aPtr),StrLen(aPtr)+1);
    Title:= StrNew(aPtr);     Inc(Word(aPtr),StrLen(aPtr)+1);
    If Style And ds_SetFont>0 Then Begin
      PointSize:= Integer(aPtr^); Inc(Word(aPtr),SizeOf(Integer));
      FontName:= StrNew(aPtr); Inc(Word(aPtr),StrLen(aPtr)+1)
    End Else Begin
      PointSize:= 0;
      FontName:= Nil
    End;
    If Style And ds_ModalFrame>0 Then
      ExStyle:= ExStyle Or ws_Ex_DlgModalFrame;
    DlgItems:= aPtr
  End
End;

Procedure tDialogWindow.UpdateDialog;
{-update and resize dialog window according to its style}
Var
  TheMDIClient: pMdiClient;
  aRect: tRect;
Begin With Attr, DialogAttr Do Begin
  {-update style bits for MDI}
  If isFlagSet(wb_MdiChild) Then Begin
    TheMDIClient:= Parent^.GetClient;
    {-check if the Client window has the MDIs_allChildStyles bit set}
    If (TheMDIClient=Nil)
    Or (GetWindowLong(TheMDIClient^.hWindow,gwl_Style) And 1=0) Then
      Style:= ws_MdiChild
    Else
      Style:= Style And ws_MdiAllowed Or ws_Child {reject disallowed styles}
  End;

  {-resize the window according to its style and size}
  With aRect Do Begin
    left:= 0;
    top:= 0;
    right:=  DlgToClientX(w, wUnitsX);
    bottom:= DlgToClientY(h, wUnitsY);
    AdjustWindowRect(aRect, Style, Menu<>0);
    w:= right-left;
    h:= bottom-top;
    ResW:= w;
    ResH:= h;
  End
End End;

Procedure tDialogWindow.CreateDialogFont;
{-create the dialog font and calculate dialog units based on font}
Const
  aWidthString = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
Var
  aDC: hDC;
  anOldFont: hFont;
  aLogFont: tLogFont;
  aTextMetric: tTextMetric;
Begin With DialogAttr Do Begin
  aDC:= GetDC(0);
  If FontName=Nil Then
    Font:= GetStockObject(System_Font)
  Else Begin
    FillChar(aLogFont,SizeOf(aLogFont),0);
    With aLogFont Do Begin
      StrCopy(lfFaceName,FontName);
      lfHeight:= -MulDiv(DialogAttr.PointSize,GetDeviceCaps(aDC, LogPixelsY),72);
      lfWeight:= FW_BOLD
    End;
    Font:= CreateFontIndirect(aLogFont)
  End;
  anOldFont:= SelectObject(aDC, Font);
  GetTextMetrics(aDC, aTextMetric);
  {-use the Microsoft recommended way to retrieve average width}
  wUnitsX:= (Word(GetTextExtent(aDC, aWidthString, Length(aWidthString)))
             Div (Length(aWidthString) Div 2) + 1) Div 2;
  wUnitsY:= aTextMetric.tmHeight;
  SelectObject(aDC, anOldFont);
  ReleaseDC(0, aDC)
End End;

Function tDialogWindow.RunModal: Integer;
Var
  aMsg: tMsg;
  ReturnCode: Integer;
Begin
  ReturnCode:= 0;
  ModalCode:= @ReturnCode;  {Trick OWL}
  SetFlags(wb_MDIChild, False);
  DefaultProc:= GetWindowProc;
  Create;

  If Status<>0 Then Begin
    RunModal:= Status;
    Exit
  End;

  Attr.Style:= Attr.Style Or ws_Visible;
  If Attr.Style And ds_SysModal>0 Then
    SetSysModalWindow(hWindow); {support SysModal dialogs as well}
  Repeat
    If PeekMessage(aMsg, 0, 0, 0, pm_Remove) Then
    If Not Application^.ProcessDlgMsg(aMsg) Then Begin
      TranslateMessage(aMsg);
      DispatchMessage(aMsg)
    End
  Until ReturnCode<>0; {until window is no longer modal}

  RunModal:= ReturnCode
End;

Procedure tDialogWindow.EndDlg (aRetValue: Integer);
Begin
  If ModalCode<>Nil Then {set return code if it's a modal window}
    ModalCode^:= aRetValue;
  CloseWindow
End;

Function tDialogWindow.GetItemHandle (DlgItemID: Integer): hWnd;
Begin
  GetItemHandle:= GetDlgItem(HWindow, DlgItemID);
End;

Function tDialogWindow.SendDlgItemMsg (DlgItemID: Integer; aMsg, wParam: Word; lParam: LongInt): LongInt;
Begin
  SendDlgItemMsg:= SendDlgItemMessage(hWindow, DlgItemID, AMsg, WParam, LParam);
End;

Procedure tDialogWindow.Ok (Var Msg: tMessage);
Begin
  If ModalCode=Nil Then
    CloseWindow
  Else
    If CanClose Then Begin
      TransferData(tf_GetData);
      EndDlg(id_Ok)
    End
End;

Procedure tDialogWindow.Cancel (Var Msg: tMessage);
Begin
  EndDlg(id_Cancel)
End;

Procedure tDialogWindow.wmClose (Var Msg:  tMessage);
Begin
  Cancel(Msg)
End;

Procedure tDialogWindow.wmSetFocus (Var Msg: tMessage);
Begin
  PostMessage(hWindow, wm_NextDlgCtl, FocusChildHandle, 1);
  FocusChild;
  Inherited DefWndProc(Msg)
End;

Procedure tDialogWindow.wmSize (Var Msg: tMessage);
Begin
  Inherited wmSize(Msg);
  If Scroller<>Nil Then With Scroller^ Do Begin
    AutoOrg:= Msg.wParam<>sizeIconic;
    If AutoOrg Then Begin
      With DialogAttr, Attr Do
        SetRange(ResW-W, ResH-H);
      ScrollTo(0, 0);
      InvalidateRect(HWindow, nil, True)
    End
  End
End;

Procedure tDialogWindow.wmLButtonDown (Var Msg: tMessage);
Begin
  If (Scroller<>Nil) And Scroller^.AutoMode Then
    DefDialogProc(Msg);
  Inherited wmLButtonDown(Msg)
End;

Function ExecDialogWindow (aDialogWindow: pDialogWindow): Integer;
Var
  ExecReturn: Integer;
Begin
  ExecDialogWindow:= id_Cancel;
  If Application^.ValidWindow(aDialogWindow)<>Nil Then Begin
    ExecReturn:= aDialogWindow^.RunModal;
    If ExecReturn<0 Then
      Application^.Error(ExecReturn)
    Else
      ExecDialogWindow:= ExecReturn;
  End
End;

Function LoadBWCC: Bool;
Var
  aWndClass: tWndClass;
  prevMode: Word;
Begin
  If BWCCInst=0 Then Begin
    prevMode:= SetErrorMode($8000); {SEM_NoOpenFileErrorBox}
    BWCCInst:= LoadLibrary('BWCC.DLL');
    SetErrorMode(prevMode);
    If BWCCInst<32 Then Begin
      LoadBWCC:= False;
      BWCCInst:= 0;
      Exit
    End;

    @aBWCCDefMdiChildProc:= GetProcAddress(BWCCInst,'BWCCDefMdiChildProc');
    @aBWCCDefWindowProc:=   GetProcAddress(BWCCInst,'BWCCDefWindowProc');
    @aBWCCDefDlgProc:=      GetProcAddress(BWCCInst,'BWCCDefDlgProc')
  End;
  LoadBWCC:= GetClassInfo(System.hInstance,BorButton,aWndClass)
End;

Procedure UnLoadBWCC;
Begin
  If BWCCInst<>0 Then Begin
    FreeLibrary(BWCCInst);
    BWCCInst:= 0
  End
End;

Constructor tJanusDialogWindow.Init (aParent: pWindowsObject; aName: pChar; BorStyle: Boolean);
Begin
  useBWCC:= BorStyle And LoadBWCC;
  Inherited Init(aParent, aName)
End;

Function tJanusDialogWindow.GetWindowProc: tFarProc;
Begin
  If useBWCC Then
    If IsFlagSet(wb_MDIChild) Then
      GetWindowProc:= @aBWCCDefMdiChildProc
    Else
      GetWindowProc:= @aBWCCDefWindowProc
  Else
    GetWindowProc:= Inherited GetWindowProc
End;

Procedure tJanusDialogWindow.GetChildClass (Var aChildClass: tChildClass);
Begin With aChildClass Do
  If useBWCC Then
    If szClass[0]=#$80 Then
      Case dwStyle And $F Of
        bs_CheckBox,
        bs_AutoCheckBox:        StrCopy(szClass,BorCheck);
        bs_RadioButton..bs_Auto3State,
        bs_AutoRadioButton:     StrCopy(szClass,BorRadio);
        bs_GroupBox:            StrCopy(szClass,BorShade);
      Else
        Inherited GetChildClass(aChildClass)
      End
    Else
      Inherited GetChildClass(aChildClass)
  Else
    If      (StrIComp(szClass,BorCheck)=0)
    Or      (StrIComp(szClass,BorRadio)=0)
    Or      (StrIComp(szClass,BorButton)=0) Then szClass[0]:= #$80
    Else If (StrIComp(szClass,BorShade)=0)  Then
      Case dwStyle And $F Of
        bss_Group: Begin szClass[0]:= #$80; dwStyle:= (dwStyle And $FFFFFFF0) Or bs_GroupBox End;
        bss_Hdip,
        bss_Hbump,
        bss_Vdip,
        bss_Vbump: Begin szClass[0]:= #$82; dwStyle:= (dwStyle And $FFFFFFF0) Or ss_BlackRect End;
      End;
    Inherited GetChildClass(aChildClass)
End;

Var
  PrevExit: Pointer;
Procedure DialogWnExit; Far;
Begin
  ExitProc:= PrevExit;
  UnLoadBWCC
End;

Begin
  PrevExit:= ExitProc;
  ExitProc:= @DialogWnExit
End.
