{ Program:   DlgTest
  Version:   1.03
  Purpose:   demonstrates tDialogWindow and tJanusDialogWindow as
             modeless Dialog Windows and MDI child windows.
  Features:  - creates a standard Dialog from BorDlg resource
             - creates a BorDlg from standard resource
             - creates Dialog as is
             - demonstrates the use of "non-standard" MDI child styles
               under Windows 3.1
  Uses:      BWCC.DLL if present. If not: it doesn't matter :-)
  Date:      07/25/92

  Developer: Peter Sawatzki (PS)
             Buchenhof 3, D-5800 Hagen 1, Germany
 CompuServe: 100031,3002

  Date:     Author:
  04/22/92  PS       initial release
  07/25/92  PS/jwp   added Scroller demo
  08/01/92  PS       fixed some bugs, added modal dialog demo
  08/30/92  PS       add MDI/non-MDI menu item

  Copyright (c) 1992 Peter Sawatzki. All Rights Reserved.
}
program DlgTest;

{$R DlgTest.Res}
Uses
  WinTypes,
  WinProcs,
  Strings,
  Objects,
  oWindows,
  oPrinter,
{$IfDef Custom} CustomWn, {$EndIf}
  DialogWn;

Const
  AppCtl: (MdiApp,NormApp,SwitchApp,TermApp) = MdiApp; {we want a Mdi app first}

Type
  {-tJanusDialogWindow with scroller activated}
  pScrollJDW = ^tScrollJDW;
  tScrollJDW = Object(tJanusDialogWindow)
    Constructor Init (aParent: pWindowsObject; aName: pChar; BorStyle: Boolean);
  End;

  {-tJanusDialogWindow with owner draw listbox}
  pOwnerLBWindow = ^tOwnerLBWindow;
  tOwnerLBWindow = Object(tJanusDialogWindow)
    Procedure SetupWindow; Virtual;
    Procedure wmMeasureItem (Var Msg: tMessage); Virtual wm_First+wm_MeasureItem;
    Procedure wmDrawItem (Var Msg: tMessage); Virtual wm_First+wm_DrawItem;
  End;

{-------------------- the scrolling tJanusDialogWindow }

Constructor tScrollJDW.Init (aParent: pWindowsObject; aName: pChar; BorStyle: Boolean);
Begin
  tJanusDialogWindow.Init(aParent, aName, BorStyle);
  Attr.Style:= Attr.Style Or ws_VScroll Or ws_HScroll;
  Scroller:= New(pScroller, Init(@self,1,1,0,0));
End;

{-------------------- the tJanusDialogWindow supporting an owner draw listbox }

Procedure tOwnerLBWindow.SetupWindow;
  Procedure AddLb (aString: pChar);
  Begin
    SendDlgItemMessage(hWindow,10,LB_ADDSTRING, 0, LongInt(aString))
  End;
Begin
  tJanusDialogWindow.SetupWindow;
  AddLb(#9'Asterisk');
  AddLb(#9'Exclamation');
  AddLb(#9'Hand');
  AddLb(#9'Question');
End;

Procedure tOwnerLBWindow.wmMeasureItem (Var Msg: tMessage);
Begin
  pMeasureItemStruct(Msg.lParam)^.itemHeight:= GetSystemMetrics (SM_CYICON)
End;

Procedure tOwnerLBWindow.wmDrawItem (Var Msg: tMessage);
Var
  Tmp: Array[0..60] Of Char;
  anIcon: hIcon;
Begin

  With pDrawItemStruct(Msg.lParam)^ Do Begin
    If itemAction And ODA_Focus>0 Then Begin
      DrawFocusRect(hDC,rcItem);
      Exit
    End;

    Case itemID Of
      0: anIcon:= LoadIcon(0,idi_Asterisk);
      1: anIcon:= LoadIcon(0,idi_Exclamation);
      2: anIcon:= LoadIcon(0,idi_Hand);
      3: anIcon:= LoadIcon(0,idi_Question);
    Else
      anIcon:= 0
    End;
    SendDlgItemMessage(hWindow,10,lb_GetText,itemID,LongInt(@Tmp));
    DrawText(hDC, Tmp, -1, rcItem, DT_Left+DT_SingleLine+DT_VCenter+DT_ExpandTabs);
    If anIcon<>0 Then
      DrawIcon(hDC, rcItem.left, rcItem.top, anIcon);
  End;
End;

Procedure SelectPrinter (aParent: pWindowsObject);
Var
  aPrinter: pPrinter;
Begin
  aPrinter:= New(pPrinter, Init);
  If Not Assigned(aPrinter) Then
    Exit;
  aPrinter^.Setup(aParent);
  Dispose(aPrinter, Done)
End;

{-all code for the window creation is in the Dispatch function:
  Dispatch is called from tWindow or tMdiWindow depending if this is an
  'normal' or a MDI application
}
Function Dispatch (aParent: pWindow; Var Msg: tMessage): Boolean;
Var
  aWin: pWindow;
Begin
  aWin:= Nil;
  Case Msg.wParam Of
    $100:  Begin
             AppCtl:= SwitchApp;
             PostMessage(Application^.MainWindow^.hWindow,wm_Close,0,0)
           End;
    $110:  SelectPrinter(aParent);
    $200,$300: aWin:= New(pScrollJDW,Init(aParent, 'aDialog', False)); {standard -> standard}
    $201,$301: aWin:= New(pScrollJDW,Init(aParent, 'aDialog', True));  {standard -> BorDlg}
    $202,$302: aWin:= New(pScrollJDW,Init(aParent, 'aBorDlg', False)); {BorDlg   -> standard}
    $203,$303: aWin:= New(pScrollJDW,Init(aParent, 'aBorDlg', True));  {BorDlg   -> BorDlg}
    $204,$304: aWin:= New(pOwnerLBWindow,Init(aParent, 'unusual', True));  {unusual Dialog}
    $1000:     aWin:= New(pJanusDialogWindow,Init(aParent, 'About',True)); {About Dialog}
  {$IfDef Custom}
    $206:      aWin:= New(pCustomWindow, InitTest(aParent, 'ThickFrame',
                          ws_MinimizeBox+ws_MaximizeBox+ws_ThickFrame+ws_Caption+ws_SysMenu, 1, 1));
    $207:      aWin:= New(pCustomWindow, InitTest(aParent, 'Caption',   ws_Caption+ws_SysMenu, 1, 1));
    $208:      aWin:= New(pCustomWindow, InitTest(aParent, 'DlgFrame',  ws_DlgFrame+ws_SysMenu, 1, 1));
    $209:      aWin:= New(pCustomWindow, InitTest(aParent, 'ThickFrame',
                          ws_MinimizeBox+ws_MaximizeBox+ws_ThickFrame+ws_Caption+ws_SysMenu, 5, 8));
    $20A:      aWin:= New(pCustomWindow, InitTest(aParent, 'Caption',   ws_Caption+ws_SysMenu, 3, 3));
    $20B:      aWin:= New(pCustomWindow, InitTest(aParent, 'DlgFrame',  ws_DlgFrame+ws_SysMenu, 2, 2));
  {$EndIf}
  End;
  If aWin<>Nil Then
    If Hi(Msg.wParam)=$02 Then
      Application^.MakeWindow(aWin)          {modeless}
    Else
      ExecDialogWindow(pDialogWindow(aWin)); {modal}
  Dispatch:= aWin<>Nil
End;

{$IfDef Custom}
Procedure AddCustomEntries (aMenu: hMenu);
Var
  aSubMenu: hMenu;
Begin
  aSubMenu:= GetSubMenu(aMenu,1);
  AppendMenu(aSubMenu,mf_Separator,0,Nil);
  AppendMenu(aSubMenu,mf_String,$206,'Custom Window (ThickFrame/small)');
  AppendMenu(aSubMenu,mf_String,$207,'Custom Window (Caption/small)');
  AppendMenu(aSubMenu,mf_String,$208,'Custom Window (DlgFrame/small)');
  AppendMenu(aSubMenu,mf_String,$209,'Custom Window (ThickFrame/large)');
  AppendMenu(aSubMenu,mf_String,$20A,'Custom Window (Caption/large)');
  AppendMenu(aSubMenu,mf_String,$20B,'Custom Window (DlgFrame/large)');
End;
{$EndIf}

Procedure PlaceWindow (aWnd: hWnd);
Var
  aRect: tRect;
  width, height: Integer;
Begin
  GetWindowRect(GetDeskTopWindow,aRect);
  With aRect Do Begin
    width:= (right-left) Div 4 * 3;
    height:= (bottom-top) Div 4 * 3;
    Inc(left,(right-left) Div 8);
    Inc(top, (bottom-top) Div 8);
    MoveWindow(aWnd,left, top, width, height, False)
  End
End;

{-------------------- the MDI part }

Type
  paMDIWindow = ^aMDIWindow;
  aMDIWindow = object(tMDIWindow)
    Procedure SetupWindow; Virtual;
    Procedure InitClientWindow; Virtual;
    Procedure DefCommandProc (Var Msg: tMessage); Virtual;
  End;

Procedure aMDIWindow.SetupWindow;
Begin
  tMDIWindow.SetupWindow;
  SetFlags(wb_Kbhandler,True);
{$IfDef PScc} AddPSccEntries(Attr.Menu); {$EndIf}
{$IfDef Custom} AddCustomEntries(Attr.Menu); {$EndIf}
  PlaceWindow(hWindow)
End;


Procedure aMDIWindow.InitClientWindow;
Begin
 ClientWnd:= New(pMdiClient, Init(@Self));
 With ClientWnd^.Attr do
   Style:= Style or WS_VSCROLL or WS_HSCROLL Or 1 {mdis_AllChildStyles = $0001}
End;

Procedure aMDIWindow.DefCommandProc (Var Msg: tMessage);
Begin
  If Not Dispatch(@Self,Msg) Then
    tMDIWindow.DefCommandProc(Msg)
End;

{-------------------- the normal window part }

Type
  paWindow = ^aWindow;
  aWindow = Object(tWindow)
    Constructor Init (aParent: pWindowsObject; aTitle: pChar);
    Procedure SetupWindow; Virtual;
    Procedure GetWindowClass(var WndClass: TWndClass); virtual;
    Procedure DefCommandProc (Var Msg: tMessage); Virtual;
  End;

Constructor aWindow.Init (aParent: pWindowsObject; aTitle: pChar);
Var
  i: Word;
Begin
  tWindow.Init(aParent, aTitle);
  Attr.Menu:= LoadMenu(hInstance,'aMenu');
  For i:= cm_ArrangeIcons To cm_CloseChildren Do
    EnableMenuItem(Attr.Menu,i,mf_ByCommand+mf_Disabled+mf_Grayed);
  ModifyMenu(Attr.Menu, $100, mf_ByCommand, $100, '&Switch to MDI mode');
{$IfDef PScc} AddPSccEntries(Attr.Menu); {$EndIf}
{$IfDef Custom} AddCustomEntries(Attr.Menu); {$EndIf}
End;

Procedure aWindow.SetupWindow;
Begin
  tWindow.SetupWindow;
  PlaceWindow(hWindow)
End;

Procedure aWindow.GetWindowClass(var WndClass: TWndClass);
Begin
  tWindow.GetWindowClass(WndClass);
  WndClass.lpszMenuName:= Nil
End;

Procedure aWindow.DefCommandProc (Var Msg: tMessage);
Begin
  If Not Dispatch(@Self,Msg) Then
    tWindow.DefCommandProc(Msg)
End;


{-------------------- the Application part }
Type
  tProgApp = Object(TApplication)
    MdiStyle: Boolean;
    Constructor Init (aName: pChar; asMdi: Boolean);
    Destructor Done; Virtual;
    Procedure InitMainWindow; Virtual;
    Function ProcessAppMsg (Var Message: tMsg): Boolean; Virtual;
  End;

Constructor tProgApp.Init (aName: pChar; asMdi: Boolean);
Begin
  MdiStyle:= asMdi;
  tApplication.Init(aName)
End;

Destructor tProgApp.Done;
Begin
  If AppCtl=SwitchApp Then
    If MdiStyle Then
      AppCtl:= NormApp
    Else
      AppCtl:= MdiApp
  Else
    AppCtl:= TermApp;
  tApplication.Done
End;

Procedure tProgApp.InitMainWindow;
Begin
  If MdiStyle Then
    MainWindow:= New(paMDIWindow, Init('DlgTest', LoadMenu(HInstance, 'aMenu')))
  Else
    MainWindow:= New(paWindow, Init(Nil, 'DlgTest'))
end;

Function tProgApp.ProcessAppMsg (Var Message: tMsg): Boolean;
Begin
  If MdiStyle Then
    ProcessAppMsg:= ProcessMDIAccels(Message)
                 Or ProcessDlgMsg(Message)
                 Or ProcessAccels(Message)
  Else
    ProcessAppMsg:= tApplication.ProcessAppMsg(Message)
End;

Var
  App: tProgApp;
Begin
  With App Do
    Repeat
      Init('DlgTest',AppCtl=MdiApp);
      Run;
      Done
    Until AppCtl=TermApp
End.
