{ Fido Pascal Conference  PASCAL 
Msg  : 576 of 587
From : Guy Mcloughlin                      1:229/15.0           06 Jun 93  22:54
To   : Gary Morris
Subj : FIND PRIME NUMBERS 1/2


  Hi, Michael:

GM>the way, it took about 20 mins. on my 386/40 to get prime numbers
GM>through 20000. I tried to come up with code to do the same with
GM>Turbo but it continues to elude me. Could anybody explain
GM>how to write such a routine in Pascal?

  ...The following PRIME routine should prove to be a bit faster:}

  (***** Find the square-root of a longint.                           *)
  (*                                                                  *)
  function FindSqrt({input} lo_IN : longint) : {output} longint;

    (***** SUB : Find square-root for numbers less than 65536.        *)
    (*                                                                *)
    function FS1(wo_IN : word) : word;
    var
      wo_Temp1,
      wo_Temp2 : word;
      lo_Error : integer;
    begin
      if (wo_IN > 0) then
        begin
          wo_Temp1 := 1;
          wo_Temp2 := wo_IN;
          while ((wo_Temp1 shl 1) < wo_Temp2) do
            begin
              wo_Temp1 := wo_Temp1 shl 1;
              wo_Temp2 := wo_Temp2 shr 1
            end;
          repeat
            wo_Temp1 := (wo_Temp1 + wo_Temp2) div 2;
            wo_Temp2 := wo_IN div wo_Temp1;
            lo_Error := (longint(wo_Temp1) - wo_Temp2)
          until (lo_Error <= 0);
          FS1 := wo_Temp1
        end
      else
        FS1 := 0
    end;      (* SUB : FS1.                                           *)

    (***** SUB : Find square-root for numbers greater than 65535.     *)
    (*                                                                *)
    function FS2(lo_IN : longInt) : longInt;
    var
      lo_Temp1, lo_Temp2, lo_Error : longInt;
    begin
      if (lo_IN > 0) then
        begin
          lo_Temp1 := 1;
          lo_Temp2 := lo_IN;
          while ((lo_Temp1 shl 1) < lo_Temp2) do
            begin
              lo_Temp1 := lo_Temp1 shl 1;
              lo_Temp2 := lo_Temp2 shr 1
            end;
          repeat
            lo_Temp1 := (lo_Temp1 + lo_Temp2) div 2;
            lo_Temp2 := lo_IN div lo_Temp1;
            lo_Error := (lo_Temp1 - lo_Temp2)
          until (lo_Error <= 0);
          FS2 := lo_Temp1
        end
      else
        FS2 := 0
    end;      (* SUB : FS2.                                           *)

  begin
    if (lo_IN < 65536) then
      FindSqrt := FS1(lo_IN)
    else
      FindSqrt := FS2(lo_IN)
  end;        (* FindSqrt.                                            *)


  (***** Check if a number is prime.                                  *)
  (*                                                                  *)
  function Prime({input } lo_IN : longint) : {output} boolean;
  var
    lo_Sqrt,
    lo_Loop : longint;
  begin
    if not odd(lo_IN) then
      begin
        Prime := (lo_IN = 2);
        exit
      end;
    if (lo_IN mod 3 = 0) then
      begin
        Prime := (lo_IN = 3);
        exit
      end;
    if (lo_IN mod 5 = 0) then
      begin
        Prime := (lo_IN = 5);
        exit
      end;
    lo_Sqrt := FindSqrt(lo_IN);
    lo_Loop := 7;
    while (lo_Loop < lo_Sqrt) do
      begin
        inc(lo_Loop, 2);
        if (lo_IN mod lo_Loop = 0) then
          begin
            Prime := false;
            exit
          end
      end;
    Prime := true
  end;        (* Prime.                                             *)
