{ Fido Pascal Conference  PASCAL 
Msg  : 333 of 362                                                               
From : Lou Duchez                          1:157/200.0          01 Jun 93  05:50 
To   : Christopher Young                                                         
Subj : Buffering Video                                                        

CY>I have not tried this out of lack of any specific idea, but is it 
CY>possible to map a portion of the regular (Text Mode) video memory
CY>to a Pascal buffer (in a similar way as using Settextbuf to a
CY>program created array for bigger read/write buffers?) and if so
CY>is there any practical use of this over the usual Write/Writeln
CY>(with gotoxy's)???

I'm not sure that you could set up a buffer along the lines of SetTextBuf:
whereas a buffer is used in transferring from file to file (typically),
video memory is a section of memory in a known place and of a known layout.
But here's a procedure I wrote that takes advantage of that known location
and layout: QWRITE does extremely fast video writes directly to memory, much
faster than WRITELN.  It needs Crt to function (for the LastMode variable).
If you want the cursor moved too, use GOTOXY.}


procedure qwrite(x, y: byte; s: string; f, b: byte);

{ Does a direct video write -- extremely fast.
  X, Y = screen location of first byte;
  S = string to display;
  F = foreground color;
  B = background color. }

type  videolocation = record    { the layout of a two-byte video location }
        videodata: char;        { character displayed }
        videoattribute: byte;   { attributes }
        end;

var cnter: byte;
    videosegment: word;         { the location of video memory }
    monosystem: boolean;        { mono vs. color }
    vidptr: ^videolocation;     { pointer to video locations }

begin

{ Find the memory location where the string will be displayed at, according to
  the monitor type and screen location.  Then associate the pointer VIDPTR with
  that memory location: VIDPTR is a pointer to type VIDEOLOCATION.  Insert a
  character and attribute; now go to the next character and video location. }

  monosystem := (lastmode in [0,2,7]);
  if monosystem then videosegment := $b000 else videosegment := $b800;
  vidptr := ptr(videosegment, 2*(80*(y - 1) + (x - 1)));
  for cnter := 1 to length(s) do begin
    vidptr^.videoattribute := (b shl 4) + f;  { high nibble=bg; lo nibble=fg }
    vidptr^.videodata := s[cnter];            { put character at location }
    inc(vidptr);                              { go to next video location }
    end;
  end;