{ Fido Pascal Conference  PASCAL 
Msg  : 521 of 613
From : Eef Hartman                         2:281/613.0          11 Jun 93  08:51
To   : Louis H. Nemec                      1:109/804.0
Subj : File handling

On 03-Jun-93 13:28 Louis H. Nemec (1:109/804) wrote to Kelly Small:

 LHN> BUT how you do it across drives? (From c to d for instance.) You
 LHN> cannot rename across drives.

Physically COPY it, than delete the original afterwards.
I once wrote a complete "MOVE" command, but it's much to big to post here and
DOS 6 got its own now anyway.
But the heart of it was:}

   PROCEDURE kopieer (VAR orig: padstr;VAR nieuw: padstr;VAR fout: BOOLEAN);
   { Copy file through DOS if not on same disk. Retain original date, time
     and size and delete the original. }

      CONST bufsize = $C000;            { About 48 KB }

      VAR   regset: registers;          { Registers record for DOS calls }
            src,dst: INTEGER;
            aantal,grootte: LONGINT;
            buffer: ARRAY[1..bufsize] OF BYTE;

      PROCEDURE delfile (VAR padnaam: padstr;VAR fout: BOOLEAN);

         VAR   regset: registers;       { Registers record for DOS calls }

         BEGIN
            WITH regset do BEGIN
               ah := $43;               { Make file R/W for delete }
               al := 1;
               cx := 0;                 { Normal file }
               ds := Seg(padnaam[1]);   { Padnaam is the fully qualified }
               dx := Ofs(padnaam[1]);   { pathname of file, 0 terminated }
               MsDos (regset);
               fout := (flags AND 1) <> 0;
               IF fout THEN
                  WriteLn ('Change attribute error: ',padnaam)
               ELSE BEGIN
                  ah := $41;            { Delete file through padnaam }
                  { ds:dx stil valid from set-attributes }
                  MsDos (regset);
                  IF (flags AND 1) <> 0 THEN BEGIN
                     fout := TRUE;
                     WriteLn ('Delete error: ',padnaam)
                     END
                  END
               END
         END;

      BEGIN
         WITH regset DO BEGIN
            ah := $3D;                  { Open existing file }
            al := 0;                    { Read-only }
            ds := Seg(orig[1]);         { Original filename (from) }
            dx := Ofs(orig[1]);
            MsDos (regset);
            fout := (flags AND 1) <> 0;
            IF fout THEN
               WriteLn ('Open error: ',orig)
            ELSE BEGIN
               src := ax;               { Handle of the file }

               ah := $3C;               { Create a new file }
               cx := 0;                 { Start as normal file }
               ds := Seg(nieuw[1]);     { Pathname to move TO }
               dx := Ofs(nieuw[1]);
               MsDos (regset);
               fout := (flags AND 1) <> 0;
               IF fout THEN
                  WriteLn ('Create error: ',nieuw)
               ELSE
                  dst := ax
               END
            END;

         grootte := zoekblk.size;       { Size of file, from "find" }
         WHILE (grootte > 0) AND NOT fout DO BEGIN
            IF grootte > bufsize THEN
               aantal := bufsize        { Too big for buffer, use buffer size }
            ELSE
               aantal := grootte;
            WITH regset DO BEGIN
               ah := $3F;               { Read block from file }
               bx := src;
               cx := aantal;
               ds := Seg(buffer);
               dx := Ofs(buffer);
               MsDos (regset);
               fout := (flags AND 1) <> 0;
               IF fout THEN
                  WriteLn ('Read error: ',orig)
               ELSE BEGIN
                  ah := $40;            { Write block to file }
                  bx := dst;
                  { cx and ds:dx still valid from Read }
                  MsDos (regset);
                  fout := (flags AND 1) <> 0;
                  IF fout THEN
                     WriteLn ('Write error: ',nieuw)
                  ELSE IF ax < aantal THEN BEGIN
                     WriteLn ('Disk full');
                     fout := TRUE
                     END
                  ELSE
                     grootte := grootte - aantal
                  END
               END
            END;

         IF NOT fout THEN WITH regset DO BEGIN
            ah := $57;                  { Adjust date and time of file }
            al := 1;                    { Set date }
            bx := dst;
            cx := zoekblk.time;         { Out of the "find" }
            dx := zoekblk.date;
            MsDos (regset);
            fout := (flags AND 1) <> 0;
            IF fout THEN
               WriteLn ('Change date/time error: ',nieuw)
            END;

         WITH regset DO BEGIN
            ah := $3E;                  { Close all files, even with errors! }
            bx := src;
            MsDos (regset);
            fout := fout OR ((flags AND 1) <> 0);
            ah := $3E;
            bx := dst;
            MsDos (regset);
            fout := fout OR ((flags AND 1) <> 0)
            END;

         IF fout THEN BEGIN
            DelFile (nieuw,fout);       { Delete copy }
            fout := TRUE                { We already HAD an error! }
            END
         ELSE WITH regset DO BEGIN
            ah := $43;                  { Set correct attributes to new file }
            al := 1;                    { Change attributes }
            cx := zoekblk.attr;         { Attribute out of "find" }
            ds := Seg(nieuw[1]);
            dx := Ofs(nieuw[1]);
            MsDos (regset);
            fout := (flags AND 1) <> 0;
            IF fout THEN
               WriteLn ('Change attribute error: ',nieuw)
            ELSE
               DelFile (orig,fout)      { Now delete the original }
            END
      END;

The rest of the program is commandline handling, handling the wildcards (* and
?), finding the files TO move, testing if the destination doesn't exist already
and using the $56 "rename" call when they ARE on the same disk.
The program has been working for more than 6 years now.
I originally wrote it in TP 3.0 for DOS 2.xx and 3.x
That's also why it doesn't use BlockRead/Write and/or procedures from the DOS
unit (except for the "Registers" type and the MsDos procedure, as it has been
converted from TP 3 which didn't have anymore DOS services than just the MsDos 
procedure.