{ Fido Pascal Conference  PASCAL 
Msg  : 404 of 422
From : Lou Duchez                          1:157/200.0          04 Jun 93  23:42
To   : Tom Bell
Subj : Screen Saver's

TB>             I'm just wondering if anyone out there would have any simple
TB>procedures or functions that they could post that will save the screen and
TB>then restore it from behind a window or if needing the whole  screen either
TB>way it's fine....


Here's the routines I use.  They save entire video screens on to the heap,
not just "windows".  Before drawing a window, save the screen.  To "close"
the window, restore the screen.  The routines are:}


procedure savescreen(i: byte);
procedure restorescreen(i: byte);
procedure releasescreen(i: byte);

where "i" can range from 1 to 32 (i.e., you can save up to 32 screens).



const screenmax = 32;                   { max number of saved screens }
      screensize = 4000;                { number of bytes in video screen }

type  savedscreen = record                    { video screen + cursor }
        screenimage: pointer;                 { video screen image }
        curspos, curstype: word;              { cursor position, appearance; }
        end;                                  { # of bytes stored in image }

var screenarray: array[1..screenmax] of savedscreen;  { saved screens }





procedure savescreen(i: byte);
var videosegment, ctword, cpword: word;
    videoimage: pointer:
    monosystem: boolean;
begin
  if (i >= 1) and (i <= screenmax) then with screenarray[i] do begin

{ Find the video memory, and copy the next 4000 bytes into the heap. }

    monosystem := (lastmode in [0,2,7]);
    if monosystem then videosegment := $b000 else videosegment := $b800;
    getmem(screenimage, screensize);
    videoimage := ptr(videosegment, $0000);
    move(videoimage^, screenimage^, screensize);

{ Store cursor position and format. }

    asm
      mov ah, 03h
      mov bh, 00h
      int 10h
      mov ctword, cx
      mov cpword, dx
      end;
    curstype := ctword;
    curspos := cpword;
    end;
  end;




procedure restorescreen(i: byte);
var videoimage, ctword, cpword: word;
    videoimage: pointer:
    monosystem: boolean;
begin
  if (i >= 1) and (i <= screenmax) then with screenarray[i] do begin

{ Restore video screen. }

    monosystem := (lastmode in [0,2,7]);
    if monosystem then videosegment := $b000 else videosegment := $b800;
    move(screenimage^, videoimage^, scrnsize);

{ Restore cursor. }

    ctword := curstype;
    cpword := curspos;
    asm
      mov ah, 01h
      mov cx, ctword
      int 10h
      mov ah, 02h
      mov bh, 00h
      mov dx, cpword
      int 10h
      end;
    end;
  end;




procedure releasescreen(i: byte);
begin
  if (i >= 1) and (i <= screenmax) then with screenarray[i] do
freemem(screenimage, scrnsize);
  end;