{ Fido Pascal Conference  PASCAL 
Msg  : 323 of 374
From : Steven Tallent                      1:3811/210.0         30 May 93  11:23
To   : All
Subj : 8-bit sound on PC spkr!
}
{ SOUNDS.INC  5-27-93  by Steven Tallent

This is a unit to play 8-bit raw sound files on any PC, up to 64k
large.  It supports the PC speaker or a DAC (LPT1 or LPT2), although
I do plan to upgrade it to support the SoundBlaster and Adlib sound
cards.  It is object-oriented in nature, with one instance of a
speaker defined automatically.  This unit is public domain, with
code and ideas captured from this echo and Dr. Dobbs Journal.

Using the code is simple.  Just setup the the Speaker.Kind,
Speaker.Silent, and Speaker.DisINT to the appropriate values, then
just use the methods included.  The SoundBoard object is very
flexible for your own code.

SoundBoard.Play  - Plays 8-bit music in What^ for Size length, with
                   Speed milliseconds between each byte, and SampleRate
                   as the sample rate (in Hz).  Speed will need to be
                   changed on different computers (of course).

SoundBoard.Sound - Plays a sound at HZ Hertz, Duration in ms, on
                   VOICE voice.  The code included is useable on
                   the PC speaker (1 voice) or the Tandy speaker
                   (3 voices!).

SoundBoard.Reset - Resets the sound board.

SoundBoard.Silent- Convenient variable that disables all PLAY and SOUND
                   if set to TRUE.

SoundBoard.DisINT- Disables all interrupts (except during delays)
                   while using PLAY.

This code may be freely distributed, changed, or included in your
own commercial or shareware code, as long as this isn't all your code
does.  This code may be included in commercial or shareware code
libraries only with my permission (I'd like to see someone get some
use out of it).
}

Unit Sounds;
Interface
Type BigArray = Array[0..0] of Byte;
     PBigArray= ^BigArray;
     KSoundBoard = (PCspeaker, Tandy, DAC1, DAC2, AdLib, SB, SBpro, SB16);
     SoundBoard = Object
         Kind   : KSoundBoard;
         Silent : Boolean;
         DisINT : Boolean;
         Procedure Play (What : PBigArray; Size : Word; Speed : Byte;
                         SampleRate : Word);
         Procedure Sound (Hz, Duration : Word; Voice, Volume : Byte);
         Procedure Reset;
         end;
Var Speaker : SoundBoard;

Procedure Delay (ms : Word);

Implementation

Procedure SoundBoard.Reset;
Begin
  Case Kind of
       PCspeaker, Tandy: Port[97] := Port[97] and $FC;
       end;
  end;

Procedure SoundBoard.Sound (Hz, Duration : Word; Voice, Volume : Byte);
VAR Count : Word; SendByte, VoiceID : Byte;
Begin
  Case Kind of
       PCspeaker: Begin
          Count := 1193180 div Hz;
          Port[97] := Port[97] or 3;
          Port[67] := 182;
          Port[66] := Lo(Count);
          Port[66] := Hi(Count);
          Delay(Duration);
          Port[97] := Port[97] and $FC;
          end;
       Tandy: Begin
          If Voice = 1 then VoiceId := 0 else
             If Voice = 2 then VoiceId := 32 else
                VoiceId := 64;
          Count := 111861 div Hz;
          SendByte := 128 + VoiceId + (Count mod 16);
          Port [$61] := $68;
          Port [$C0] := SendByte;
          Port [$C0] := Count div 16;
          If Voice = 1 then VoiceId := 16 else
             If Voice = 2 then VoiceId := 48 else
                VoiceId := 96;
          SendByte := 128 + VoiceId + (15 - Volume);
          Port [$61] := $68;
          Port [$C0] := SendByte;
          Delay(Duration);
          SendByte := 128 + VoiceId + 15;
          Port [$61] := $68;
          Port [$C0] := SendByte;
       DAC1:;
       DAC2:;
       AdLib:;
       SB:;
       SBPro:;
       SB16:;
  end;

Procedure SoundBoard.Play (What : PBigArray; Size : Word;
    Speed : Byte; SampleRate : Word);
VAR Loop : Word; Count, Data : Word;
Begin
  If NOT Silent then Begin
     Case Kind of
          PCspeaker, Tandy: Begin
             Port[97] := Port[97] or 3;
             Count := 1193180 div (SampleRate div 256);
             For Loop := 1 to Size do Begin
                 Data := Count div (What^[Loop] + 1);
                 Port[67] := 182;
                 Port[66] := Lo(Data);
                 Port[66] := Hi(Data);
                 Delay(Speed);
                 If DisINT then Asm CLI end;
                 end;
             Port[97] := Port[97] and $FC;
             end;
          DAC1: For Loop := 1 to Size do Begin
                    Port [$0378] := What^[Loop];
                    Delay (Speed);
                    If DisINT then Asm CLI end;
                    end;
          DAC2: For Loop := 1 to Size do Begin
                    Port [$0278] := What^[Loop];
                    Delay (Speed);
                    If DisINT then Asm CLI end;
                    end;
          AdLib:;
          SB:;
          SBPro:;
          SB16:;
          end;
     Asm STI end;
     end;
  end;

Procedure Delay (ms : Word); Assembler;
ASM
  STI
  MOV AH, $86
  MOV CX, 0
  MOV DX, [ms]
  INT $15
  end;
END.

{-----------------------------------------------------------------
Here's a program that will accept three values from the command
line, the file, its speed, and the sample rate, and plays it
through the PC speaker.  I've tried in on WAV, VOC, SAM, and even
Amiga sampled files, with no problems (limited to 64k). I've even
played MOD files to hear all the sampled instruments!  This program
does not strip header information, but plays it too, but I can't
hear the difference on WAV and VOC files.
}
Program TestSnd;
Uses Sounds;
Var I2   : PBigArray; spd  : integer; samp : Word; res : word;
    siz  : Word; s : string; f1 : file of byte; F : file;
Begin
  Speaker.Kind := PCspeaker;
  Speaker.DisINT := True;
  Speaker.Silent := False;
  s := ParamStr(1);
  Assign(f1,s);  {Get size of file}
  Reset(f1);
  Val (ParamStr(2), Spd, Res);
  Val (ParamStr(3), samp, Res);
  siz := FileSize(f1);
  close(f1);
  Assign(f,s);
  Reset(f);
  getmem (I2,siz);  {Allocate Memory for sound file}
  BlockRead(f,I2^,siz,res);  {Load sound into Memory}
  Speaker.Play (i2, siz, spd, samp);
  FreeMem (I2, siz);
end.