{ Fido Pascal Conference  PASCAL 
Msg  : 311 of 374                                                               
From : Trisdaresa Sumarjoso                1:272/38.0           29 May 93  01:49 
To   : Eric Anderson                                                             
Subj : READING SHIFT KEY?                                                     

 -=> Quoting Eric Anderson to David Sacerdote <=-

 DS> To obtain a shift status, you put a 2 in the AH register, and
 DS> call interrupt 16 hex.  The results are returned in the AL
 DS> register as follows:
 DS> Bit     Meaning
 DS> 1       Right Shift is down
 DS> 2       Left Shift is down
 DS> 3       Control is down
 DS> 4       Alt is down
 DS> 5       Scroll lock is down
 DS> 6       Num Lock is down
 DS> 7       Caps Lock is down
 DS> 8       Insert is down
 EA>
 EA> i also found this usefull, one question though, do you know how to SET
 EA> the status of the caps lock, scroll lock and numlock as well??
 EA> Eric Anderson

Hello Eric...

        To set the status (turn it on?), you might have to access the
        Bios variables directly (it's located at $40:$17).

        Here's a little code on how you could do it.}

Program TestStatKey;

Uses
    Crt;

Const
     Scroll_Lock        = 16;
     Num_Lock           = 32;
     Caps_Lock          = 64;
     Insert             = 128;
     Switch             : Array [0..1] Of String[3] = ('Off', 'On ');

Var
   StatVar      : Byte Absolute $40:$17;

Procedure SetBiosVar( Stats: Byte);
Begin
     StatVar := StatVar Or Stats;
End;

Procedure ReSetBiosVar( Stats: Byte);
Begin
     StatVar := StatVar And Not Stats;
End;

Procedure GetStatus( Var Stats: Byte);
Begin
     Stats := StatVar;
End;

Var
   TestStat     : Byte;
   Ch           : Char;

Begin
     ClrScr;
     Repeat
           GetStatus(TestStat);
           GotoXY(1,1);
           WriteLn('(S)croll lock status : ', Switch[(TestStat And Scroll_Lock)
                                                   Div Scroll_Lock]);
           WriteLn('(N)um lock status : ', Switch[(TestStat And Num_Lock) Div
                                                Num_Lock]);
           WriteLn('(C)aps lock status : ', Switch[(TestStat And Caps_Lock)
                                                 Div Caps_Lock]);
           WriteLn('(I)nsert status : ', Switch[(TestStat And Insert) Div
                                              Insert]);
           WriteLn( 'Press Upcase of the first letter to turn it on '+
                    ' or Lowcase to turn it off');
           WriteLn('Press <ENTER> to continue...');
           Ch := ReadKey;
           Case Ch Of
                'S'     : SetBiosVar(Scroll_Lock);
                's'     : ReSetBiosVar(Scroll_Lock);
                'N'     : SetBiosVar(Num_Lock);
                'n'     : ReSetBiosVar(Num_Lock);
                'C'     : SetBiosVar(Caps_Lock);
                'c'     : ReSetBiosVar(Caps_Lock);
                'I'     : SetBiosVar(Insert);
                'i'     : ReSetBiosVar(Insert);
           End;
     Until (Ch = #13);
End.

        It's not commented (originally, it's for my personal testing
        only), but the code shouldn't be too hard to understand (I
        hope). If you need more explanation regarding above code, just
        let me know. I'll try to clear it up for you.