{ Fido Pascal Conference  PASCAL 
Msg  : 604 of 643                                                               
From : Sean Palmer                         1:104/123.0          07 Jun 93  13:58 
To   : Charles Lumia                                                             
Subj : PC Speaker                                                             

CL>I have TP 6.0, and I'am looking for a way to address my PC Speaker.  I
don't
CL>know what Port it is (like PORT[$30] or something), or how to send raw
sound CL>data to it. Could someone help me?

Try this, or actually a variation on it. Doing VOC's and WAV's on a pc
speaker is not an easy task...

What you're looking for is embedded in the 'click' procedure below...

'click' only works while no tone is being produced. click at different
rates to get different pitches/effects.

so I guess the simple answer to your question is that it's controlled by
bit 1 (from 0 to 7) of port $61.}

unit uTone;
interface

procedure tone(freq:word);
procedure noTone;
procedure click;

implementation

const
 sCntrl=$61;  { sound control port }
 soundOn=$03; { bit mask to enable speaker }
 soundOff=$FC;{ bit mask to disable speaker }
 C8253=$43;   { port address to control 8253 }
 seTimer=$B6; { tell 8253 to expect freq data next }
 F8253=$42;   { frequency address on 8253 }

procedure tone(freq:word);assembler;asm
 mov al,$B6; out $43,al;            {write timer mode register}
 mov dx,$14; mov ax,$4F38; div freq;  {1331000/Frequency pulse}
 out $42,al; mov al,ah; out $42,al;  {write timer a byte at a time}
 in al,$61; or al,3; out $61,al; {port B-switch speaker on}
 end;

procedure noTone;assembler;asm
 in al,$61; and al,$FC; out $61,al;
 end;

procedure click;assembler;asm
 in al,$61; xor al,2; out $61,al;
 end;

end.