{ Fido Pascal Conference  PASCAL 
Msg  : 377 of 454
From : Max Maischein                       2:244/1106.17        08 Jul 93  19:59
To   : All
Subj : Some 386 inline stuff

I took a dive into the wondrous world of the 386 and conditional compilation
and came back with this :}

{FILE:sys.pas}
(*
Max Maischein                                Thursday,  8.07.1993
2:249/6.17                                         Frankfurt, GER

                            SYS.DOC

This unit contains some handy  type  definitions  and  some  very
usefull  inline routines. Most of these routines are designed for
the Intel 386  processor and up, but replacements in  pascal  are
compiled using the conditional define c386.

The routine FillWord() works just like FillChar(),  but  takes  a
word as a  parameter. Note that SizeOf() does not  work  anymore,
since the destination is filled with words. Use  SizeOf()  shr  1
instead !
The Max() / Min() routines return the larger / smaller  value  of
both  parameters. MinW() /  MaxW()  are  optimized  routines  for
words, Max() and Min()  take LongInts as  parameters.  Min()  and
Max() are inline 386 procedures,  but the ( not  so  optimized  )
Pascal equvalents are compiled  if  "c386"  is  not  $DEFINEd.  A
typical use for Min() would be :
                GetMem( Min( Bufsize, MaxAvail ))

The function BruteCompare() is a  crude  method  to  compare  two
structures  by comparing each byte they consist of. It  is  in  (
slightly optimized ) Pascal and thus slow, but it works !

The TUnsortedStringCollection  is  a  TCollection  that  collects
strings but  does _not_ sort them. If you only want to store some
strings, this is faster.

This piece of code  is  donated  to  the  public  domain,  but  I
request that, if you use this code, you mention me  in  the  DOCs
somewhere.

                                                             -max
*)
{$A-,B-,D+,E+,F-,G+,I+,L+,N+,O-,P-,Q+,R+,S+,T-,V-,X+,Y+}
{$M 65520,0,655360}
Unit Sys;
Interface
Uses Objects;

{ global defines for CPU dependent compilation }

{$DEFINE c386}
{.$DEFINE Overlays}

Const
{$IFDEF c386}
RTLVersion = ' 386 Version';
{$ELSE}
  {$IFOPT G+}
    RTLVersion = ' 286 Version';
  {$ELSE}
    RTLVersion = ' Borland RTL Version';
  {$ENDIF}
{$ENDIF}

Procedure FillWord(Var Ziel; Times, Datum : Word);
Inline(
$58/         { pop ax    }
$59/         { pop cx    }
$5F/         { pop di    }
$07/         { pop es    }
$FC/         { cld       }
$F3/$AB      { rep stosw }
);

Function MaxW( A,B : Word ) : Word;
Inline(
$58/                    { pop   ax      }
$5B/                    { pop   bx      }
$39/$D8/                { cmp   ax, bx  }
$77/$02/                { ja    xx      }
$89/$D8                 { mov   ax, bx  }
);

Function MinW( A,B : Word ) : Word;
Inline(
$58/                    { pop   ax      }
$5B/                    { pop   bx      }
$39/$D8/                { cmp   ax, bx  }
$72/$02/                { jb    xx      }
$89/$D8                 { mov   ax, bx  }
);

{$IFDEF c386}
Function Max( a, b : LongInt ) : LongInt;
Inline(
$66/$5B/
$66/$58/
$66/$3B/$C3/$7D/$03/
$66/$8B/$C3/
$66/$50/$58/$5A );

Function Min( a, b : LongInt ) : LongInt;
Inline(
$66/$5B/
$66/$58/
$66/$3B/$C3/$7E/$03/
$66/$8B/$C3/
$66/$50/$58/$5A );

Function InRange( L : LongInt; UpperBound : LongInt ) : Boolean;
  { This function returns true if the LongInt L is in the Range
[0..Upperbound].
    InRange is only defined for positive values of UpperBound, negative values
    return altough predictable but meaningless results. If you are missing the
    second compare, this is as designed, since a negative number can be treated
    as a large unsigned number and thus the second compare is not needed.
    This only works with 386 code, but it should work under any protected mode
    environment.
  }
Inline(
$66/$5B/                { pop   ebx      }
$66/$59/                { pop   ecx      }
$66/$39/$D9/            { cmp   ecx, ebx }
$0F/$93/$C0             { setae al       }
);

Function OutRange( L : LongInt; UpperBound : LongInt ) : Boolean;
  { This function returns true if the LongInt L is greater than Upperbound or
    a negative number. Just linke InRange, it is only defined for positive
values
    of UpperBound, negative values return meaningless results as well.
    Only one compare is needed since a negative number can be treated
    as a large unsigned number and thus the second compare is not needed.
    This only works with 386 code, but it should work under any protected mode
    environment.
  }
Inline(
$66/$5B/                { pop   ebx      }
$66/$59/                { pop   ecx      }
$66/$39/$D9/            { cmp   ecx, ebx }
$0F/$92/$C0             { setb  al       }
);
{$ELSE}
Function Min( a, b : LongInt ) : LongInt;
Function Max( a, b : LongInt ) : LongInt;
Function InRange( L : LongInt; UpperBound : LongInt ) : Boolean;
{$ENDIF}
Function BruteCompare( const Buf1, Buf2; Size : Word ) : Integer;

Type TArray = Array[ 0..65534 ] of Byte;
     PArray = ^TArray;

Type TLongRec = Record
       wLo : Word;
       wHi : Word;
     End;

Type TPointerArray = Array[ 0..16382 ] of Pointer;
     PPointerArray = ^TPointerArray;

Type TPStringArray = Array[ 0..16382 ] of PString;
     PPStringArray = ^TPStringArray;

Type PText = ^Text;
     TText = Text;

Type TUnsortedStringCollection = Object( TCollection )
       Procedure FreeItem( P : Pointer ); virtual;
       Function GetItem( Var S: TStream) : Pointer; virtual;
       Procedure PutItem( Var S: TStream; Item: Pointer ); virtual;
     End;
     PUnsortedStringCollection = ^TUnsortedStringCollection;

Type TCharSet = Set of Char;

Type String1 = String[ 1 ]; String2 = String[ 2 ]; String3 = String[ 3 ];
     ... write a small program to construct the table ...
     String253 = String[ 253 ]; String254 = String[ 254 ]; String255 = String[ 
255 ];

Implementation

{$IFNDEF c386}
Function Max (a,b: LongInt):LongInt;
Begin
   If a > b
     then Max := a
     else Max := b;
End;

Function Min(a,b: LongInt):LongInt;
Begin
   If a < b
     then Min := a
     else Min := b;
End;

Function InRange( L : LongInt; UpperBound : LongInt ) : Boolean;
Begin
  Inrange := ( L >= 0 ) and ( L <= UpperBound );
End;

Function OutRange( L : LongInt; UpperBound : LongInt ) : Boolean;
Begin
  Outrange := ( L < 0 ) or ( L > UpperBound );
End;
{$ENDIF c386}

Function BruteCompare;
Var W : Word;
    I : Integer;
Begin
  W := 0;
  I := 0;
  While ( I = 0 ) and  ( W < Size ) do
    Begin
      I := TArray( Buf1 )[ W ] - TArray( Buf2 )[ W ];
      Inc( W );
    End;
  If I = 0
    then BruteCompare := 0
    else BruteCompare := Pred( Ord( I and $8000 = 0 ) *2 ); { -1 fr I < 0 }
End;

Procedure TUnsortedStringCollection.FreeItem;
Begin
  If P <> nil
    then DisposeStr( P );
End;

Function TUnsortedStringCollection.GetItem( Var S: TStream ) : Pointer;
Begin
  GetItem := S.ReadStr;
End;

Procedure TUnsortedStringCollection.PutItem( Var S: TStream; Item: Pointer );
Begin
  S.WriteStr( Item );
End;

End.