{ Fido Pascal Conference  PASCAL 
Msg  : 246 of 278                                                               
From : Liam Stitt                          1:134/21.0           14 Jul 93  11:51 
To   : Digant Kasundra                                                           
Subj : virtual screens                                                        

Live Long and Prosper, Digant! On 07-13-93  07:15 you scribbled about Re:
virtual screens

 DK> It's a  214 area code call.  How can you send it to me.  Can you like,
 DK> attach it to a  message to me or something.  I'm new of this concept of
 DK> "NetMail".  But I  would like this program.  Try and write back.

 This is part one...

___VScreen.PAS: interface---}

unit VScreen;

(* I don't know who originally wrote this.  I found it on a local Pascal   *)
(* programming BBS.  If the real author reads this, would you stand up and *)
(* let us know who you are?                                                *)

(* All I did was add the proc and func listing, clean up the code - in     *)
(* other words, convert it to my style.                                    *)

interface

{$F+}                           (* allow it to be overlaid *)

const
  Rows = 25;                    (* Change for EGA 43x80 or VGA 50x80 modes *)
  Columns = 80;
  VsWordSize = Rows * Columns;
  VsByteSize = Rows * Columns * 2;

type
  FnString = String[12];        (* FileName string size *)
  VsPtr = ^VirtualScreenArray;  (* Virtual-screen pointer type *)
  VirtualScreenArray = Array[1..VsWordSize] of Word;
  XString = String[Columns];    (* XAxis length string-type *)
  YString = String[Rows];     (* Yaxis length string-type *)
  ScrollTypes = (Up, Down, Left, Right, FlipY, FlipX);

var
  MainScreen: VsPtr;
  ColorMode:  Boolean;

(* PUBLIC functions and procedures... *)

(* p VsInit(var VsPointer: VsPtr); - initializes VScreen pointer on heap   *)

(* p ReInitVsUnit; - reinitializes VScreen Unit                             *)

(* p ClrVScr(VsPointer: VsPtr; CAttr: Byte); - clear a VScreen w/color attr *)

(* p ClrVScrWindow(VsPointer: VsPtr; LxAxis, RxAxis, TopYaxis, BotYaxis,    *)
(*   CAttr: Byte); - clears Window within a VScreen with color attribute    *)

(* p WriteIntVs(VsPointer: VsPtr; IntNum: LongInt; Width, Xaxis, Yaxis,     *)
(*   CAttr: Byte); - writes Integer to a VScreen                            *)

(* p VWriteIntVs(VsPointer: VsPointer: VsPtr; IntNum: LongInt; Width,       *)
(*   Xaxis, Yaxis, CAttr: Byte); - vertically writes Integer to a VScreen   *)

(* p WriteRealVs(VsPointer: VsPtr; RealNum: Real; Width, Decimals, Xaxis,   *)
(*   Yaxis, CAttr: Byte); - writes Real to a VScreen                        *)

(* p VWriteRealVs(VsPointer: VsPtr; RealNum: Real; Width, Decimals, Xaxis,  *)
(*   Yaxis, CAttr: Byte); - vertically writes Real to a VScreen             *)

(* p WriteStringVs(VsPointer: VsPtr; InString: XString; Wrap: Boolean       *)
(*   Xaxis, Yaxis, CAttr: Byte); - writes a string to a VScreen. Quoting    *)
(*   the author, "wrap defines whether a string will wrap around to the     *)
(*   next line, it is not the bottom-line"                                  *)

(* p VWriteStringVs(VsPointer: VsPtr; InString: YString; Xaxis, Yaxis,      *)
(*   CAttr: Byte); - vertically write string to VScreen                     *)

(* p SaveToVs(VsPointer: VsPtr); - saves the current screen to a VScreen    *)

(* p DisplayVs(VsPointer: VsPtr); - display a VScreen                       *)

(* p SetVsXYAttr(VsPointer: VsPtr; AttrsToChange, Xaxis, Yaxis,             *)
(*   CAttr: Byte); Again quoting the author, "procedure to change           *)
(*   AttrsToChange number of VScreen color attributes"                      *)

(* p VSetVsXYAttr(VsPointer: VsPtr; AttrsToChange, Xaxis, Yaxis,            *)
(*   CAttr: Byte); - "procedure to vertically change AttrsToChange number   *)
(*   of VScreen color attributes                                            *)

(* p SetVsWindowAttr(VsPointer: VsPtr; LxAxis, RxAxis, TopYaxis, BotYaxis,  *)
(*   CAttr: Byte); - "procedure to change a window-block of VScreen color   *)
(*   attributes"                                                            *)

(* p SetVsAttr(VsPointer: VsPtr; CAttr: Byte); - sets the color attribute   *)
(*   for the entire VScreen                                                 *)

(* p SaveVsToDisk(VsPointer: VsPtr; FileName: FnString;                     *)
(*   ScreenNumber: Word); - saves a VScreen to a disk file.  "ScreenNumber  *)
(*   is the VScreen record number.                                          *)

(* p LoadVsFromDisk(VsPointer: VsPtr; FileName: FnString;                    *)
(*   ScreenNumber: Word); - saves a VScreen to a disk file.  "ScreenNumber  *)
(*   is the VScreen record number.                                          *)

(* f GetVsXYAttr(VsPointer: VsPtr; Xaxis, Yaxis: Byte): Byte; - function    *)
(*   to return the attribute byte of a VScreen char at position X,Y         *)

(* f GetVsXYChar(VsPointer: VsPtr; Xaxis, Yaxis: Byte): Char; - function    *)
(*   to return a character from position X,Y                                *)

(* f GetVsXYString(VsPointer: VsPtr; Xaxis, Yaxis,                          *)
(*   StringSize: Byte): String; - returns StringSize text string from X,Y   *)

(* f VGetVsXYString(VsPointer: VsPtr; Xaxis, Yaxis,                         *)
(*   StringSize: Byte): String; - returns vertical text string from X,Y     *)

(* p ScrollVs(VsPointer1: VsPtr; VsPointer2: VsPtr; Direction: ScrollTypes; *)
(*   ScrollNum: Word); - procedure to scroll a VScreen by ScrollNum in any  *)
(*   of the directions defined as ScrollType above; two other directions    *)
(*   also available - FlipY, which reverses the order of the VScreen rows,  *)
(*   and FlipX, which reverses the order of the VScreen columns, so that 1  *)
(*   becomes 80 and so on.  "ScrollNum is ignored with these routines" -    *)
(*   make whatever you can out of that, but it sounds to me like this proc  *)
(*   isn't quite functioning properly.                                      *)

(* p MoveVsChar(VsPointer1: VsPtr; Xaxis1, Yaxis1: Byte; VsPointer2: VsPtr; *)
(*   Xaxis2, Yaxis2: Byte); - moves character from X,Y to X,Y between       *)
(*   VScreens                                                               *)

(* p MoveVsBlock(VsPointer1: VsPtr; Xaxis1, Yaxis1: Byte;                   *)
(*   VsPointer2: VsPtr; Xaxis2, Yaxis2: Byte; CharsToMove: Word); - moves   *)
(*   block of chars defined by CharsToMove from X,Y to X,Y between VScreens *)

(* p MoveVsWindowBlock(VsPointer1: VsPtr; LxAxis1, RxAxis1, TopYaxis1,      *)
(*   BotYaxis1: Byte; VsPointer2: VsPtr; LxAxis2, RxAxis2, TopYaxis2,       *)
(*   BotYaxis2: Byte); - moves "window block" from VScreen1 to VScreen2    *)

  procedure VsInit(var VsPointer: VsPtr);
  procedure ReInitVsWrite;
  procedure ClrVScr(VsPointer: VsPtr; CAttr: Byte);
  procedure ClrVScrWindow(VsPointer: VsPtr; LxAxis, RxAxis, TopYaxis,
                          BotYaxis, CAttr: Byte);
  procedure WriteIntVs(VsPointer: VsPtr; IntNum: LongInt; Width, Xaxis,
                       Yaxis, CAttr: Byte);
  procedure VWriteIntVs(VsPointer: VsPtr; IntNum: LongInt; Width, Xaxis,
                        Yaxis, CAttr: Byte);
  procedure WriteRealVs(VsPointer: VsPtr; RealNum: Real; Width, Decimals,
                        Xaxis, Yaxis, CAttr: Byte);
  procedure VWriteRealVs(VsPointer: VsPtr; RealNum: Real; Width, Decimals,
                         Xaxis, Yaxis, CAttr: Byte);
  procedure WriteStringVs(VsPointer: VsPtr; InString: XString; Wrap: Boolean;
                          Xaxis, Yaxis, CAttr: Byte);
  procedure VWriteStringVs(VsPointer: VsPtr; InString: YString; Xaxis, Yaxis,
                           CAttr: Byte);
  procedure SaveToVs(VsPointer: VsPtr);
  procedure DisplayVs(VsPointer: VsPtr);
  procedure SetVsXYAttr(VsPointer: VsPtr; AttrsToChange, Xaxis, Yaxis,
                        CAttr: Byte);
  procedure VSetVsXYAttr(VsPointer: VsPtr; AttrsToChange, Xaxis, Yaxis,
                         CAttr: Byte);
  procedure SetVsWindowAttr(VsPointer: VsPtr; LxAxis, RxAxis, TopYaxis,
                            BotYaxis, CAttr: Byte);
  procedure SetVsAttr(VsPointer: VsPtr; CAttr: Byte);
  procedure SaveVsToDisk(VsPointer: VsPtr; FileName: FnString;
                        ScreenNumber: Word);
  procedure LoadVsFromDisk(VsPointer: VsPtr; FileName: FnString;
                           ScreenNumber: Word);
  function GetVsXYAttr(VsPointer: VsPtr; Xaxis, Yaxis: Byte): Byte;
  function GetVsXYchar(VsPointer: VsPtr; Xaxis, Yaxis: Byte): Char;
  function GetVsXYString(VsPointer: VsPtr; Xaxis, Yaxis,
                         StringSize: Byte): String;
  function VGetVsXYString(VsPointer: VsPtr; Xaxis, Yaxis,
                          StringSize: Byte): String;
  procedure ScrollVs(VsPointer1: VsPtr; VsPointer2: VsPtr;
                     Direction: ScrollTypes; ScrollNum: Word);
  procedure MoveVsChar(VsPointer1: VsPtr; Xaxis1, Yaxis1: Byte;
                       VsPointer2: VsPtr; Xaxis2, Yaxis2: Byte);
  procedure MoveVsBlock(VsPointer1: VsPtr; Xaxis1, Yaxis1: Byte;
                        VsPointer2: VsPtr; Xaxis2, Yaxis2: Byte;
                        CharsToMove: Word);
  procedure MoveVsWindowBlock(VsPointer1: VsPtr; LxAxis1, RxAxis1, TopYaxis1,
                              BotYaxis1: Byte; VsPointer2: VsPtr; LxAxis2,
                              RxAxis2, TopYaxis2, BotYaxis2: Byte);


implementation

uses Crt;

var
  VideoAddress: VsPtr;

  procedure VsInit(var VsPointer: VsPtr);
  begin
    if VsPointer = Nil then
      begin
        New(VsPointer);      (* Allocate Array on the Heap *)
        FillChar(VsPointer^,SizeOf(VirtualScreenArray), 0)
      end;
  end;

  procedure ClrVScr(VsPointer: VsPtr; CAttr: Byte);
  type
    ClrArrayType = Array[1..(VsWordSize - 1)] of Word;
  var
    ClrPtr1, ClrPtr2: ^ClrArrayType;
  begin
    if VsPointer <> Nil then
      begin
        if CAttr = 0 then
          FillChar(VsPointer^,VsByteSize, 0)
        else
          begin
            ClrPtr1 := Addr(VsPointer^[1]); ClrPtr2 := Addr(VsPointer^[2]);
            ClrPtr1^[1] := (32 + (CAttr shl 8)); ClrPtr2^ := ClrPtr1^;
          end;
      end;
  end;

  procedure WriteIntVs(VsPointer: VsPtr; IntNum: LongInt; Width, Xaxis,
                       Yaxis, CAttr: Byte);
  const
    TempString: XString = '';
  var
    TsIndex : Byte;
    VsOffset: Word;
  begin
    if VsPointer <> Nil then
      begin
        if (Yaxis > Rows) then Yaxis := Rows;

        Str(IntNum:Width, TempString);

        if (Yaxis = Rows) and ((Length(TempString) + Xaxis) > Columns) then
            TempString[0] := char((Columns + 1) - Xaxis);

        VsOffset := (((Yaxis - 1) * Columns) + Xaxis);

        for TsIndex := 0 to (Length(TempString) - 1) do
          VsPointer^[VsOffset + TsIndex] :=
                       (Byte(TempString[(TsIndex + 1)]) + (CAttr shl 8))
      end;
  end;

  procedure VWriteIntVs(VsPointer: VsPtr; IntNum: LongInt; Width, Xaxis,
                        Yaxis, CAttr: Byte);
  const
    TempString: YString = '';
  var
    TSindex : Byte;
    VsOffset: Word;
  begin
    if VsPointer <> Nil then
      begin
        if (Yaxis > Rows) then Yaxis := Rows;
        if (Xaxis > Columns) then Xaxis := Columns;

        VsOffset := (((Yaxis - 1) * Columns) + Xaxis);
        Str(IntNum:Width, TempString);

        if ((Length(TempString) + Yaxis) > Rows) then
          TempString[0] := char((Rows + 1) - Yaxis);

        for TSindex := 0 to (Length(TempString) - 1) do
          VsPointer^[VsOffset + (TSindex * Columns)] :=
                       (Byte(TempString[(TSindex + 1)]) + (CAttr shl 8))
      end;
  end;

  procedure WriteRealVs(VsPointer: VsPtr; RealNum: Real; Width, Decimals,
                        Xaxis, Yaxis, CAttr: Byte);
  const
    TempString: XString = '';
  var
    TsIndex : Byte;
    VsOffset: Word;
  begin
    if VsPointer <> Nil then
      begin
        if (Yaxis > Rows) then Yaxis := Rows;

        VsOffset := (((Yaxis - 1) * Columns) + Xaxis);
        Str(RealNum:Width:Decimals, TempString);

        if (Yaxis = Rows) and ((Length(TempString) + Xaxis) > Columns) then
            TempString[0] := char((Columns + 1) - Xaxis);

        for TsIndex := 0 to (Length(TempString) - 1) do
          VsPointer^[VsOffset + TsIndex] :=
                       (Byte(TempString[(TsIndex + 1)]) + (CAttr shl 8))
      end
  end;

  procedure VWriteRealVs(VsPointer: VsPtr; RealNum: Real; Width, Decimals,
                         Xaxis, Yaxis, CAttr: Byte);
  const
    TempString: YString = '';
  var
    TSindex : Byte;
    VsOffset: Word;
  begin
    if VsPointer <> Nil then
      begin
        if (Yaxis > Rows) then Yaxis := Rows;
        if (Xaxis > Columns) then Xaxis := Columns;

        VsOffset := (((Yaxis - 1) * Columns) + Xaxis);
        Str(RealNum:Width:Decimals, TempString);

        if ((Length(TempString) + Yaxis) > Rows) then
          TempString[0] := char((Rows + 1) - Yaxis);

        for TSindex := 0 to (Length(TempString) - 1) do
          VsPointer^[VsOffset + (TSindex * Columns)] :=
                       (Byte(TempString[(TSindex + 1)]) + (CAttr shl 8))
      end
  end;

  procedure WriteStringVs(VsPointer: VsPtr; InString: XString; Wrap: Boolean;
                          Xaxis, Yaxis, CAttr: Byte);
  var
    ISindex : Byte;
    VsOffset: Word;
  begin
    if VsPointer <> Nil then
      begin
        if (Yaxis > Rows) then Yaxis := Rows;

        VsOffset := (((Yaxis - 1) * Columns) + Xaxis);

        if (Yaxis = Rows) then Wrap := False;

        if not Wrap then
          if ((Length(InString) + Xaxis) > Columns) then
            InString[0] := char((Columns + 1) - Xaxis);

        for ISindex := 0 to (Length(InString) - 1) do
          VsPointer^[VsOffset + ISindex] :=
                         (Byte(InString[(ISindex + 1)]) + (CAttr shl 8))
      end
  end;

  procedure VWriteStringVs(VsPointer: VsPtr; InString: YString;
                           Xaxis, Yaxis, CAttr: Byte);
  var
    IsIndex : Byte;
    VsOffset: Word;
  begin
    if VsPointer <> Nil then
      begin
        if (Yaxis > Rows) then Yaxis := Rows;
        if (Xaxis > Columns) then Xaxis := Columns;

        VsOffset := (((Yaxis - 1) * Columns) + Xaxis);

        if ((Length(InString) + Yaxis) > Rows) then
          InString[0] := char((Rows + 1) - Yaxis);

        for IsIndex := 0 to (Length(InString) - 1) do
          VsPointer^[VsOffset + (IsIndex * Columns)] :=
                         (Byte(InString[(IsIndex + 1)]) + (CAttr shl 8));
      end;
  end;

  procedure ClrVScrWindow(VsPointer: VsPtr; LxAxis, RxAxis, TopYaxis,
                          BotYaxis, CAttr: Byte);
  var
    VsIndex, LineSize, VsOffset: Word;
  begin
    if VsPointer <> Nil then
      begin
        VsOffset := (((TopYaxis - 1) * Columns) + LxAxis);
        LineSize := (RxAxis - LxAxis) + 1;

        for VsIndex := 0 to (LineSize - 1) do
          VsPointer^[VsOffset + VsIndex] := (32 + (CAttr shl 8));

        for VsIndex := 1 to (BotYaxis - TopYaxis) do
          Move(VsPointer^[VsOffset], VsPointer^[VsOffset +
               (VsIndex * Columns)], (LineSize * 2));
      end;
  end;

  procedure SaveToVs(VsPointer: VsPtr);
  begin
    if VsPointer <> Nil then
      begin
        if VsPointer <> Nil then
          VsPointer^ := VideoAddress^
      end;
  end;

  procedure DisplayVs(VsPointer: VsPtr);
  begin
    if VsPointer <> Nil then
      begin
        if VsPointer <> Nil then
          VideoAddress^ := VsPointer^
      end;
  end;


  procedure SetVsXYAttr(VsPointer: VsPtr; AttrsToChange, Xaxis,
                        Yaxis, CAttr: Byte);
  var
    AttrIndex: Byte;
    VsOffset : Word;
  begin
    if VsPointer <> Nil then
      begin
        if (Yaxis > Rows) then Yaxis := Rows;

        VsOffset := (((Yaxis - 1) * Columns) + Xaxis);

        if (Yaxis = Rows) and ((AttrsToChange + Xaxis) > Columns) then
          AttrsToChange := ((Columns + 1) - Xaxis);

        for AttrIndex := 0 to (AttrsToChange - 1) do
          begin
            VsPointer^[VsOffset + AttrIndex] :=
              Lo(VsPointer^[VsOffset + AttrIndex]) + (CAttr shl 8);
          end;
      end;
  end;

  procedure VSetVsXYAttr(VsPointer: VsPtr; AttrsToChange, Xaxis,
                         Yaxis, CAttr: Byte);
  var
    AttrIndex: Byte;
    VsOffset : Word;
  begin
    if VsPointer <> Nil then
      begin
        if (Yaxis > Rows) then Yaxis := Rows;
        if (Xaxis > Columns) then Xaxis := Columns;

        VsOffset := (((Yaxis - 1) * Columns) + Xaxis);

        if ((AttrsToChange + Yaxis) > Rows) then
          AttrsToChange := ((Rows + 1) - Yaxis);

        for AttrIndex := 0 to (AttrsToChange - 1) do
          begin
            VsPointer^[VsOffSet + (AttrIndex * Columns)] :=
              Lo(VsPointer^[VsOffSet + (AttrIndex * Columns)]) +
                                                         (CAttr shl 8);
          end;
      end;
  end;

  procedure SetVsWindowAttr(VsPointer: VsPtr; LxAxis, RxAxis,
                            TopYaxis, BotYaxis, CAttr: Byte);
  var
    LineSize, VsOffSet, VsIndex1, VsIndex2: Word;
  begin
    if VsPointer <> Nil then
      begin
        VsOffset := (((TopYaxis - 1) * Columns) + LxAxis);
        LineSize := (RxAxis - LxAxis);

        for VsIndex1 := 0 to (BotYaxis - TopYaxis) do
        begin
          for VsIndex2 := 0 to LineSize do
            VsPointer^[VsOffset + VsIndex2] :=
                  Lo(VsPointer^[VsOffset + VsIndex2]) + (CAttr shl 8);
          Inc(VsOffset,  Columns);
        end;
      end;
  end;

  procedure SetVsAttr(VsPointer: VsPtr; CAttr: Byte);
  type
    VsAttrArray =  Array[1..VsByteSize] of Byte;
  var
    VsAaPtr      : ^VsAttrArray;
    AttrIndex    : Word;
  begin
    if VsPointer <> Nil then
    begin
      VsAaPtr := Addr(VsPointer^);
      for AttrIndex := 1 to VsWordSize do
        VsAaPtr^[AttrIndex * 2] := CAttr
    end
 end;

  procedure SaveVsToDisk(VsPointer: VsPtr; FileName: FnString;
                         ScreenNumber: Word);
  var
    ScreenFile: file of VirtualScreenArray;
  begin
    if VsPointer <> Nil then
      begin
        Assign(ScreenFile, FileName); {$I-} ReSet(ScreenFile); {$I+}
        if IOResult <> 0 then
          begin
            {$I-} ReWrite(ScreenFile); {I+}
            if IoResult <> 0 then Exit;
          end;
        Seek(ScreenFile, (ScreenNumber - 1));
        Write(ScreenFile, VsPointer^);
        Close(ScreenFile)
      end
  end;

  procedure LoadVsFromDisk(VsPointer: VsPtr; FileName: FnString;
                           ScreenNumber: Word);
  var
    ScreenFile: file of VirtualScreenArray;
  begin
    if VsPointer <> Nil then
      begin
        Assign(ScreenFile, FileName); {$I-} ReSet(ScreenFile); {$I+}
        if IOResult <> 0 then Exit;
        Seek(ScreenFile, (ScreenNumber - 1));
        Read(ScreenFile, VsPointer^);
        Close(ScreenFile)
     end
  end;

  function GetVsXYAttr(VsPointer: VsPtr; Xaxis, Yaxis: Byte): Byte;
  var
    VsOffset: Word;
  begin
    if VsPointer <> Nil then
      begin
        if (Yaxis > Rows) then Yaxis := Rows;
        if (Xaxis > Columns) then Xaxis := Columns;
        VsOffset := (((Yaxis - 1) * Columns) + Xaxis);
        GetVsXYAttr := Hi(VsPointer^[VsOffset]);
      end
  end;

  function GetVsXYchar(VsPointer: VsPtr; Xaxis, Yaxis: Byte): Char;
  var
    VsOffset: Word;
  begin
    if VsPointer <> Nil then
      begin
        if (Yaxis > Rows) then Yaxis := Rows;
        if (Xaxis > Columns) then Xaxis := Columns;
        VsOffset := (((Yaxis - 1) * Columns) + Xaxis);
        GetVsXYchar := char(Lo(VsPointer^[VsOffset]));
      end
  end;

  function GetVsXYString(VsPointer: VsPtr; Xaxis, Yaxis,
                         StringSize: Byte): String;
  const
    TempString: XString = '';
  var
    TsIndex, VsOffset: Word;
  begin
    if VsPointer <> Nil then
      begin
        if (Yaxis > Rows) then Yaxis := Rows;
        VsOffset := (((Yaxis - 1) * Columns) + Xaxis);
        if (Yaxis = Rows) and ((Xaxis + StringSize) > Columns) then
          TempString[0] := char((Columns + 1) - Xaxis)
        else
          TempString[0] := char(StringSize);
        for TsIndex := 0 to (Length(TempString) - 1) do
          TempString[(TsIndex + 1)] :=
                               Char(Lo(VsPointer^[VsOffset + TsIndex]));
        GetVsXYString := TempString;
      end
  end;

  function VGetVsXYString(VsPointer: VsPtr; Xaxis, Yaxis,
                          StringSize: Byte): String;
  const
    TempString: YString = '';
  var
    TsIndex,
    VsOffset: Word;
  begin
    if VsPointer <> Nil then
      begin
        if (Yaxis > Rows) then Yaxis := Rows;
        if (Xaxis > Columns) then Xaxis := Columns;
        VsOffset := (((Yaxis - 1) * Columns) + Xaxis);
        if ((StringSize + Yaxis) > Rows) then
          TempString[0] := char((Rows + 1) - Yaxis)
        else
          TempString[0] := char(StringSize);
        for TsIndex := 0 to (Length(TempString) - 1) do
          TempString[(TsIndex + 1)] := char(Lo(VsPointer^[VsOffset +
                                             (TsIndex * Columns)]));
        VGetVsXYString := TempString;
      end
  end;

  procedure ScrollVs(VsPointer1: VsPtr; VsPointer2: VsPtr;
                     Direction : ScrollTypes; ScrollNum : Word);
  var
    S1, S2: Word;
  begin
    if (VsPointer1 <> Nil)
      and (VsPointer2 <> Nil)
        and (VsPointer1 <> VsPointer2) then
      begin
        case Direction of
          Up: Move(VsPointer1^[(ScrollNum * Columns) + 1],
                    VsPointer2^[1], (VsByteSize - (ScrollNum *
                    Columns * 2)));
          Down: Move(VsPointer1^[1],
                      VsPointer2^[(ScrollNum * Columns) + 1],
                      (VsByteSize - (ScrollNum * Columns * 2)));
          Right: for S1 := 0 to (Rows - 1) do
                    Move(VsPointer1^[1 + (S1 * Columns)],
                          VsPointer2^[1 + (S1 * Columns) + ScrollNum],
                          ((Columns - ScrollNum) * 2));
          Left: for S1 := 0 to (Rows - 1) do
                   Move(VsPointer1^[1 + (S1 * Columns) + ScrollNum],
                          VsPointer2^[1 + (S1 * Columns)],
                          ((Columns - ScrollNum) * 2));
          FlipX: for S1 := 0 to (Rows - 1) do
                    for S2 := 0 to (Columns - 1) do
                      VsPointer2^[(Columns - S2) + (S1 * Columns)] :=
                        VsPointer1^[(S2 + 1) + (S1 * Columns)];
          FlipY: for S1 := 0 to (Rows - 1) do
                    Move(VsPointer1^[1 + (S1 * Columns)],
                         VsPointer2^[1 + ((Rows - (S1 + 1))
                         * Columns)], (Columns * 2));
        end;       (* case Direction of...                           *)
      end;
  end;

  procedure MoveVsChar(VsPointer1: VsPtr; Xaxis1, Yaxis1: Byte;
                       VsPointer2: VsPtr; Xaxis2, Yaxis2: Byte);
  var
    VsOffset1, VsOffset2: Word;
  begin
    if (VsPointer1 <> Nil)
      and (VsPointer2 <> Nil)
        and (VsPointer1 <> VsPointer2) then
      begin
        if (Yaxis1 > Rows) then Yaxis1 := Rows;
        if (Xaxis1 > Columns) then Xaxis1 := Columns;
        if (Yaxis2 > Rows) then Yaxis2 := Rows;
        if (Xaxis2 > Columns) then Xaxis2 := Columns;

        VsOffset1 := (((Yaxis1 - 1) * Columns) + Xaxis1);
        VsOffset2 := (((Yaxis2 - 1) * Columns) + Xaxis2);

        VsPointer2^[VsOffset2] := VsPointer1^[VsOffset1];
      end
  end;

  procedure MoveVsBlock(VsPointer1: VsPtr; Xaxis1, Yaxis1: Byte;
                        VsPointer2: VsPtr; Xaxis2, Yaxis2: Byte;
                        CharsToMove: Word);
  var
    VsOffset1, VsOffset2: Word;
  begin
    if (VsPointer1 <> Nil)
      and (VsPointer2 <> Nil)
        and (VsPointer1 <> VsPointer2) then
      begin
        if (Yaxis1 > Rows) then Yaxis1 := Rows;
        if (Yaxis2 > Rows) then Yaxis2 := Rows;
        if (Xaxis1 > Columns) then Xaxis1 := Columns;
        if (Xaxis2 > Columns) then Xaxis2 := Columns;

        VsOffset1 := (((Yaxis1 - 1) * Columns) + Xaxis1);
        VsOffset2 := (((Yaxis2 - 1) * Columns) + Xaxis2);

        if VsOffset1 > VsOffset2 then
        begin
          if CharsToMove > (VsWordSize - VsOffSet2) then
            CharsToMove := (VsWordSize - VsOffSet2);
        end
        else
          begin
            if CharsToMove > (VsWordSize - VsOffSet1) then
              CharsToMove := (VsWordSize - VsOffSet1);
          end;
        Move(VsPointer1^[VsOffset1], VsPointer2^[VsOffset2],
                                                     (CharsToMove * 2));
      end;
  end;

  procedure MoveVsWindowBlock(VsPointer1: VsPtr; LxAxis1, RxAxis1,
                              TopYaxis1, BotYaxis1: Byte; VsPointer2: VsPtr;
                              LxAxis2, RxAxis2, TopYaxis2, BotYaxis2: Byte);
  var
    LineSize, RowIndex, VsOffset1, VsOffset2, MoveIndex: Word;
  begin
    if (VsPointer1 <> Nil)
      and (VsPointer2 <> Nil)
        and (VsPointer1 <> VsPointer2) then
      begin
        if (BotYaxis1 > Rows) then BotYaxis1 := Rows;
        if (BotYaxis2 > Rows) then BotYaxis2 := Rows;
        if (RxAxis1 > Columns) then RxAxis1 := Columns;
        if (RxAxis2 > Columns) then RxAxis2 := Columns;

        VsOffset1 := (((TopYaxis1 - 1) * Columns) + LxAxis1);
        VsOffset2 := (((TopYaxis2 - 1) * Columns) + LxAxis2);

        if (RxAxis1 - LxAxis1) > (RxAxis2 - LxAxis2) then
          LineSize := (RxAxis2 - LxAxis2)
        else
          LineSize := (RxAxis1 - LxAxis1);
        if (BotYaxis1 - TopYaxis1) > (BotYaxis2 - TopYaxis2) then
          RowIndex := (BotYaxis2 - TopYaxis2)
        else
          RowIndex := (BotYaxis1 - TopYaxis1);
        for MoveIndex := 0 to RowIndex do
          Move(VsPointer1^[VsOffset1 + (MoveIndex * Columns)],
               VsPointer2^[VsOffset2 + (MoveIndex * Columns)],
                                                        (LineSize * 2));
      end;
  end;

{$F-}
                   (* Procedure to set the initial VideoAddress     *)
                   (* Determines either Color or B&W mode.          *)
  procedure SetVideoAddress;
  begin
    if ((Mem[$0000:$0410] and $30) <> $30) then
      begin
        VideoAddress := Ptr($B800, $0000);
        MainScreen := Ptr($B800, $0000);
        ColorMode := true
      end
    else
      begin
        VideoAddress := Ptr($B000, $0000);
        MainScreen := Ptr($B000, $0000);
        ColorMode := false
      end;
  end;

                   (* Procedure initialize/re-initialize the        *)
                   (* VScreen Write.                                 *)
  procedure ReInitVsWrite;
  begin
    SetVideoAddress;
  end;

begin
  SetVideoAddress  (* Initialize VideoAddress                       *)
end.