{ ========================================================================== }
{ PullDemo.pas - Full demonstration of pull-down menus.   var 7.0b, 09-24-93 }
{                                                                            }
{   Copyright (c) 1988,1993 James H. LeMay, All rights reserved.             }
{ ========================================================================== }

{$i pulldefs.inc }

{$M 16384,18000,18000 }

program PullDemo;

uses
  Crt,Qwik,Wndw,Pull,PullStat,
  {$ifdef UseDataEntryCode }
  PullData,
  {$endif }
  PullWork;  { You must include this unit for this demo! }

var
  OrigPathName: string[67];

procedure DisplayScreen;
begin
  WWrite ( 1, 1,'PULLDEMO v7.0b            Multi-level Pu'+
                'll-down Menus       Copr 1993  J H LeMay');
  ShowTopLine;
  SetWindowModes (PermMode);
  MakeWindow (3,1,CRTrows-3,CRTcols,White+BlueBG,White+BlueBG,DoubleBrdr,
              Window1);
  SetWindowModes (0);
  TitleWindow (Top,Left,SameAttr,'1');
  TWS.WndwAttr := Yellow+BlueBG;
  WWriteC ( 2,'PULL70B.ZIP - MULTI-LEVEL PULL-DOWN MENUS');
  WWriteC ( 9,'This is Work Window 1.');
  TWS.WndwAttr := TWS.OrigAttr;
  WWriteC ( 4,'Use F1 everywhere for some descriptions.');
  WWriteC ( 5,'Use ''Quit'' to exit demo program.        ');
  WWriteC ( 6,'Be sure to try a CR at "'^P'" marked lines.');
  WWriteC ( 7,'Also try all the EnterData lines.       ');
  WWrite(11, 9,'The following Data Entry fields have some arbitrary values');
  WWrite(12, 9,'and ranges.  Move the highlight and edit.  Press F1 for help.');
end;

begin
{ Qsnow := false; }
  GetDir (0,OrigPathName);
  PathName := OrigPathName;
  PreferMultiTask := true;   { Use Multi-tasking MTVB if possible. }
  InitPull (LightGray,false); { <<-- Be sure you do this!! }
  DisplayScreen;

  GotoKeyDispatcher;          { <<-- All keyboard entries go through here! }

  if OrigPathName<>PathName then
    begin
      {$I-} ChDir(OrigPathName); {$I+}
      if IOresult<>0 then;
    end;
  AccessWindow (Window0);
  WClrScr;
  WGotoRC (CRTrows,1);
  SetCursor (CursorInitial);
end.
