{ ========================================================================== }
{ Pullwork.pas - Work Window procedures for main work     ver 7.0b, 09-24-93 }
{                area for PULLSHEL.PAS                                       }
{ This file contains all the procedures executed for the Work Window.  These }
{ are the main steps of your program.  With this, you can create a sophisti- }
{ cated multi-level window environment.                                      }
{   Copyright (c) 1988,1993 James H. LeMay, All rights reserved.             }
{ ========================================================================== }

{$i pulldefs.inc }

UNIT PullWork;

INTERFACE

procedure WorkWndw;


IMPLEMENTATION

uses
  Crt,Qwik,Wndw,Pull,PullStat
  {$ifdef UseDataEntryCode }
  ,PullData;
  {$else }
  ;
  {$endif }

{ ========================= Work Window Steps ============================== }
{ This procedure will have all the procedures for the Work window(s).        }
{ Each step assumes that some keystroke has been pressed and returns a value }
{ for Key and ExtKey and any necessary change to WorkWndwStep.               }
{ -------------------------------------------------------------------------- }
var
  Start1: word;

{$ifdef MultiWorkWndws }
procedure ResetWorkWndwStep;
begin
  case TWS.WSname of
    Window1:  WorkWndwStep := 1;
    Window2:  WorkWndwStep := 3;
  end;
end;

procedure HideWorkWndw;
begin
  HideWindow;
  TopWorkWndwName := TWS.WSname;
  ResetWorkWndwStep;
end;

procedure AccessWorkWndw (WN: WindowNames);
begin
  if WN<>TWS.WSname then
    begin
      { -- if accessing a PermMode window, hide all upper windows. -- }
      if (GetLevelIndex(WN)<=PLI) then
        while (LI>PLI) do
          HideWindow;         { Use RemoveWindow for serial access }
      AccessWindow (WN);
      ResetWorkWndwStep;
    end;
end;
{$endif }

procedure KbdIdle; far;
begin
  { Nothing to include this time, but fill in what you want to do while }
  { the keyboard is idle. }
end;

procedure ShowFields;
begin
  WWrite ( 4, 2,'Integer:');
  DisplayFields (ord(aIntegerDE),ord(aIntegerDE));
end;
{
procedure MakeWorkWndw2;
begin
  SetWindowModes (HiddenMode);
  MakeWindow ( 8,21,10,40,LightBlue+LightGrayBG,LightBlue+LightGrayBG,
               DoubleBrdr,Window2);
  SetWindowModes (0);
  WriteToHidden (Window2);
  TitleWindow (Top   ,Left  ,SameAttr,'2');
  TitleWindow (Top   ,Center,SameAttr,' Work Window 2 ');
  TitleWindow (Bottom,Center,SameAttr,' Press ESC to Hide ');
  WWriteC (1,'Type in any input');
  WGotoRC (2,1);
  WriteToCRT;
end;
}
procedure EditFields;
begin
  EnterSeq (ord(aIntegerDE),ord(aIntegerDE),Start1);
end;

procedure InitWorkWndws;
begin
  ShowFields;
  WorkWndwStep := 1;
  Key := NullKey;  { #00 }
end;

procedure WorkWndw;
begin
  {$ifdef MultiWorkWndws }
  AccessWorkWndw (TopWorkWndwName);
  {$endif }
  case WorkWndwStep of
    0:  InitWorkWndws;
    1:  EditFields;
  end;
end;

BEGIN
  WorkWndwStep := 0;          { Initial step for work windows. }
  {$ifdef MultiWorkWndws }
  TopWorkWndwName := Window1;
  {$endif }
  Start1 := ord(aIntegerDE);
  CallWorkWndw := WorkWndw;
  CallKbdIdle  := KbdIdle;
END.
