Program RIPDoor;

{$F+}

{ RipDoor (RipDoor) - Copyright (C) 1994 by InterProgramming      }
{                     All rights reserved.                        }
{ Version 1.20      - For distribution with RipLink.              }
{                     FREE to all registered RipLink users.       }

{ This is a sample program to show the use of RIPlink.  RIPlink is a }
{ standalone product and requires the use of a door toolkit.  This   }
{ example covers both using RIPlink and interfacing with a door      }
{ toolkit.                                                           }

{ This sample makes reference to "DoorKit."  DoorKit is just a general }
{ reference to any door toolkit.                                       }

{ This example displays a simple screen to the user composed of various      }
{ things that RIPscrip supports.  Then it will wait for a character and then }
{ display the RIP file, CITY.RIP.  We've provided CITY.RIP as a convenience  }
{ to you.                                                                    }


uses
  Dos, Crt, DoorKit, RIPlink;

Type
{The RipLink Object - needed because we're overriding one procedure}
  RIPtr = ^RIPObject;
  RIPObject = object(RIPObj)
    procedure sendstr(instr : string); virtual;
    procedure sendstrcr(instr : string); virtual;
  end;

Var
  dummych       : char;
  RIP           : RIPtr; {an instance of the object}

Procedure RIPObject.SendStr(instr : string);
{give RipLink the command to send strings out the modem}
begin
  DisplayRemote(instr); {DisplayRemote is a DoorKit procedure that
                                sends strings over the modem without
                                displaying them locally.}
end;

Procedure RIPObject.SendStrCR(instr : string);
{give RipLink the command to send strings out the modem}
begin
  DisplayRemote(instr+#13#10); {DisplayRemote is a DoorKit procedure that
                                sends strings over the modem without
                                displaying them locally.}
end;

Procedure StatusL;
{Graphics procedure to override the DoorKit one}
{This can be as extensive or simple as you want it to be.}
var
  tstr  : string[75];
begin
  tstr := UserName+', '+baud+', Time: '+inttostr(timeremaining);
  RIP^.StatText := tstr;
  RIP^.StatLine;
end;

Procedure InitDoor;
{initializes door}
begin
  RIP := nil;     {clears pointer (to object)}
  ProcessParams;  {a DoorKit procedure}
  ReadDoorFile;   {another DoorKit procedure}

  {RIPexist : boolean; : Does the user want RIP? (a DoorKit variable)}
  if RIPexist then            {if user wants rip, initialize the object}
    New(RIP,Init(DoRIP,''));  {DoRIP : boolean; : Do graphics LOCALLY?}

  initcomm; {DoorKit procedure}
  if initfail then
  begin
    writeln('Error: Initializing Communications port.  Exiting.');
    if RIP <> nil then      {this is important!}
      Dispose(RIP, Done);
    Closecomm; {DoorKit procedure}
    Halt(1);
  end;

  {IcnPath : pathstr; : Path of local icon files}
  If RIP <> nil then
    RIP^.IconDir := IcnPath;  {RIPlink must be told where the icons are}
  if DoRIP and RIPexist then  {if the sysop wants Rip (DoRip) then assign the
                               graphics stat line to the status proc}
    StatProc := StatusL;
end;

Procedure Header;
const
  test : fpt = (146,73,36,146,73,36,146,73);
  t2   : fpt = (127,159,231,227,235,141,189,254);
var
  bla  : boolean;
begin
  if RIPexist then    {See comment below for line:
                       if (not RIPexist) or (not DoRip) then}
  begin
    RIP^.RipResetWindows;
      {good idea at beginning of every scene}
    RIP^.RipSetPalette(0,1,2,3,4,5,7,20,56,57,58,59,60,61,62,63);
      {define the color palette - this is the default setting}
    RIP^.RipTextWindow(1,8,80,20,true,0);
      {define a text window}
    RIP^.RipButtonStyle(0,0,2,768,3,15,0,15,8,7,0,0,15,7);
      {define a button style}
    RIP^.RipWriteMode(0);
      {set the write mode}
    RIP^.RipColor(12);
      {set the drawing color}
    RIP^.RipLineStyle(0,0,3);
      {set the line style}
    RIP^.RipFontStyle(2,0,1);
      {set the font type and style (Font 2)}
    RIP^.RipTextXY(10,4,'InterProgramming');
    RIP^.RipColor(14);
    RIP^.RipTextXY(14,9,'InterProgramming');
    RIP^.RipColor(11);
    RIP^.RipTextXY(18,14,'InterProgramming');
    RIP^.RipColor(10);
    RIP^.RipTextXY(22,19,'InterProgramming');
    RIP^.RipColor(13);
    RIP^.RipTextXY(26,25,'InterProgramming');
    RIP^.RipColor(12);
    RIP^.RipLoadIcon(10,100,0,true,'computer.icn');
    RIP^.RipPutImage(70,100,0);
      {copy image from clipboard - happens to be icon because of last command}
    RIP^.RipFillPattern(test,9);
      {define a fill pattern - see const above}
    RIP^.RipBar(250,100,450,150);
    RIP^.RipFillPattern(t2,6);
    RIP^.RipBar(250,175,450,250);
    RIP^.RipButtonStyle(0,0,0,768,0,11,0,15,8,9,0,0,0,13);
    RIP^.RipPixel(0,4);
    RIP^.RipButton(50,180,200,260,0,0,'','Button','');
    dummych := getch; {wait for a char; GetCh is a DoorKit function}

    RIP^.RipResetWindows; {reset everything again}
    bla := RIP^.DisplayRIPfile('city.rip'); {display the RIP file CITY.RIP}
    dummych := getch; {wait for a char}
  end;
  if (not RIPexist) or (not DoRip) then {This line and the line mentioned
                                         above handle RIP/non-RIP callers.
                                         Necessary to handle the sysop who
                                         doesn't want RIP even when the user
                                         does}
  begin
    clearscreen; {DoorKit proc}
    colorset(12,0); {DoorKit proc}
    displayln('InterProgramming'); {DoorKit proc}
    colorset(14,0);
    displayln(' InterProgramming');
    colorset(11,0);
    displayln('  InterProgramming');
    colorset(10,0);
    displayln('   InterProgramming');
    colorset(13,0);
    displayln('    InterProgramming');
    displayln('');
  end;
end;

Begin               {main block}
  {UnRegDelay := false;} {prompt for a random number when unregistered
                          number will have to be entered locally}
  UnRegDelay := true;    {delay for 10 seconds when unregistered}
  InitDoor;
  Header;
  dummych := getch; {wait for a char}
  if RIP <> nil then    {IMPORTANT!}
    Dispose(RIP, Done);
End.
