unit dosdate;

INTERFACE

Uses Dos;

Const WeekStr : array[0..7] of String[10] =
      ('Sunday',
       'Monday',
       'Tuesday',
       'Wednesday',
       'Thursday',
       'Friday',
       'Saturday',
       'All Week');

Const months : array[1..13] of string[3] =
   ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec','BUG');

function DosDateFormat(d:longint;format:byte):String;

implementation

(*
Format number

1 - Xpress method of display last usage date           Mmm DD,YYYY HH:MM:SSap
2 - opus display method for date written in messages   Mmm-DD-YY H:MMap
3 - Xpress Sysop menu display of last usage.           MM/DD/YY HH:MMap
4 - used for opus log                                  DD Mmm HH:MM:SS
5 - used for last usage date in user.bbs (opus)        DD Mmm YY HH:MM:SS
6 -                                                    Mmm DD, YY
7 - used for new files lister in OPUS 1.70             MM/DD/YY

*)


Function Format_Date(Dt:datetime;format : byte):String;
var ms,ds,hs,m1s,ss,mhs,ampm   : string[2];
    ys                         : string[4];


  begin
  ampm := 'am';
  with dt do
    begin
      str(month:2,ms);
      str(day:1,ds);
      str(year:1,ys);
      str(hour:1,mhs);
      if format = 4 then if length(mhs)=1 then mhs := '0'+mhs;
      if format in [3,4,7] then if length(ds)=1  then ds := '0'+ds;
      if format in [2,5] then ys := copy(ys,3,2);

      if hour >= 12 then
         begin
           ampm := 'pm';
           if hour > 12 then hour := Hour - 12;
         end;

      str(hour:1,hs);
      str(min:2,m1s);
      str(sec:2,ss);

      if (format=3) or (format=7) then if hour < 10 then hs := ' '+hs;
      if m1s[1] = ' ' then m1s[1] := '0';
      if ss[1] = ' '  then ss[1] := '0';
      if ms[1] = ' '  then ms[1] := '0';

      if not (month in [1..12]) then month := 13;
      if year < 1988 then month := 13;
      if year > 2000 then month := 13;

     if (format < 1) or (format > 7) then format := 1;
     case format of
      1 : Format_Date := Months[month]+' '+ds+','+ys+'  '+hs+':'+m1s+':'+ss+ampm;
      2 : Format_Date := Months[month]+'-'+ds+'-'+ys+' '+hs+':'+m1s+ampm;
      3 : Format_date := ms+'/'+ds+'/'+copy(ys,3,2)+' '+hs+':'+m1s+ampm;
      4 : Format_Date := ds+ ' '+Months[month]+' '+mhs+':'+m1s+':'+ss;
      5 : Format_Date := ds+ ' '+Months[month]+' '+ys+' '+mhs+':'+m1s+':'+ss;
      6 : Format_Date := Months[month]+' '+ds+','+ys;
      7 : Format_Date := ms+'/'+ds+'/'+copy(ys,3,2);
     end;
    end;
 end;

function DosDateFormat(d:longint;format:byte):String;
{- full date based on dos timestamp date/time two byte format storage}
var dt     : datetime;
    dtst   : record date, time : word; end absolute d;
 begin
   with dtst do
     begin
      dt.year  := (hi(date) shr 1) + 1980;
      dt.month := (date shr 5) and 15;
      dt.day   := lo(date) and 31;
      dt.Hour  := hi(time) shr 3;
      dt.min   := (time shr 5) and 63;
      dt.sec   := (lo(time) and 31) * 2;
     end;
   DosDateFormat := Format_date(dt,format);
 end;

end.
