/***************************************************************
 *                                                             *
 * B40.C - Base 40 compression/decompression routines          *
 * by Al Williams                                              *
 *                                                             *
 ***************************************************************/

#include <stdio.h>
#include <string.h>

/* default ASCII to B40 table (100=no mapping) */
char _b40_ascb40[256]=
  {
  0  ,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  39, 100,100,100,100,100,100,100,
  100,100,100,100, 38,100, 37,100,
  27,  28, 29, 30, 31, 32, 33, 34,
  35,  36,100,100,100,100,100,100,
  100,  1,  2,  3,  4,  5,  6,  7,
  8,    9, 10, 11, 12, 13, 14, 15,
  16,  17, 18, 19, 20, 21, 22, 23,
  24,  25, 26,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100
  };

/* pointer to ASCII to B40 table */
char *b40_ascb40=_b40_ascb40;

/* default B40 to ASCII table */
char _b40_b40asc[40]="\0ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789., ";

/* pointer to B40 to ASCII table */
char *b40_b40asc=_b40_b40asc;


/*******************************************************/
/* Encode string (src) to B40 string (dstin)
   returns length of encoded string or -1 for error */
int b40_encode(char *dstin,char *src)
  {
  unsigned short twobytes=0;
  unsigned char c[3];
  char *dst=dstin;
  do
    {
/* Collect 3 characters -- pad with 0's at end of string */
    c[0]=b40_ascb40[*src];
    if (c[0]) c[1]=b40_ascb40[*++src]; else c[1]='\0';
    if (c[1]) c[2]=b40_ascb40[*++src]; else c[2]='\0';

/* If any character not supported, return error */
    if (c[0]==100||c[1]==100||c[2]==100)
      return -1;

/* compute 2 byte B40 number */
    twobytes=c[0]*1600+c[1]*40+c[2];
/* store in destination */
    *((unsigned short *)dst)++=twobytes;
    } while (*src++);
/* return length */
  return dst-dstin;
  }

/*******************************************************/
/* Decode B40 string (src) of length n to ASCII (dst) */
int b40_decode(char *dst,char *src,int n)
  {
  unsigned short twobytes=0;
  unsigned char c[3];
  do
    {
    int tmp;
/* read two bytes from src */
    twobytes=*((unsigned short *)src)++;
/* split 3 B40 "digits" and decode from two byte code */
    c[2]=b40_b40asc[tmp=twobytes%40];
    c[1]=b40_b40asc[(tmp=((twobytes-tmp)%1600))/40];
    c[0]=b40_b40asc[(twobytes-tmp)/1600];
/* move to destination */
    memcpy(dst,c,3);
    dst+=3;
    n-=2;
    } while (n>0);       /* repeat for whole string */
  return 0;
  }

