#include <owl.h>
#include "nosave.h"

class TNoSave: public TApplication {
public:
  TNoSave(LPSTR AName, HINSTANCE AnInstance, HINSTANCE APrevInstance,
    LPSTR ACmdLine, int ACmdShow): TApplication(AName, AnInstance,
    APrevInstance, ACmdLine, ACmdShow) {};
  virtual void InitMainWindow();
};

class TNoSaveWin: public TWindow {
public:
  TNoSaveWin(PTWindowsObject AParent, LPSTR ATitle);
  virtual void CMFileExit(RTMessage)
    = [CM_FIRST + CM_FILEEXIT];
  virtual void WMSysCommand(RTMessage)
    = [WM_FIRST + WM_SYSCOMMAND];
};

void TNoSave::InitMainWindow()
{
  MainWindow = new TNoSaveWin(NULL, "Disable Screen Saver");
}

TNoSaveWin::TNoSaveWin(PTWindowsObject AParent, LPSTR ATitle)
  : TWindow(AParent, ATitle)
{
  AssignMenu(ID_MENU);
}

void TNoSaveWin::CMFileExit(RTMessage)
{
  CloseWindow();
}

void TNoSaveWin::WMSysCommand(RTMessage msg)
{
  if ((msg.WParam & 0xFFF0) != SC_SCREENSAVE)
    DefWndProc(msg);
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpszCmdLine, int nCmdShow)
{
  TNoSave NoSave("NoSave", hInstance, hPrevInstance,
    lpszCmdLine, nCmdShow);
  NoSave.Run();
  return NoSave.Status;
}
