#include <owl.h>
#include <array.h>
#include <strng.h>
#include "strlist.h"

const char * strings[10] = {
  "One  ", "Two  ", "Three", "Four ",
  "Five ", "Six  ", "Seven", "Eight",
  "Nine ", "Ten  " };

class TStrList: public TApplication {
public:
  TStrList(LPSTR AName, HINSTANCE AnInstance,
    HINSTANCE APrevInstance, LPSTR ACmdLine, int ACmdShow)
    : TApplication(AName, AnInstance, APrevInstance,
      ACmdLine, ACmdShow) {};
  virtual void InitMainWindow();
};

class TStrListWin: public TWindow {
public:
  TStrListWin(PTWindowsObject AParent, LPSTR ATitle);
  virtual void CMDialog(RTMessage)
    = [CM_FIRST + CM_DIALOG];
  virtual void CMExitDemo(RTMessage)
    = [CM_FIRST + CM_EXITDEMO];
};

class TStrListDialog: public TDialog {
public:
  TStrListDialog(PTWindowsObject AParent, int ResourceId);
  virtual ~TStrListDialog();
  virtual void IDButton(RTMessage)
    = [ID_FIRST + ID_BUTTON];
private:
  Array *aStrings;
  BOOL flag;
};

void TStrList::InitMainWindow()
{
  MainWindow = new TStrListWin(NULL, "String List Demo");
}

TStrListWin::TStrListWin(PTWindowsObject AParent, LPSTR ATitle)
  : TWindow(AParent, ATitle)
{
  AssignMenu(ID_MENU);
}

void TStrListWin::CMDialog(RTMessage)
{
  GetApplication()->ExecDialog(new TStrListDialog(this, ID_DIALOG));
}

void TStrListWin::CMExitDemo(RTMessage)
{
  CloseWindow();
}

TStrListDialog::TStrListDialog(PTWindowsObject AParent, int ResourceId)
  : TDialog(AParent, ResourceId)
{
  aStrings = new Array(10);
  int idx = 0;
  while (idx < 10) {
    String *sp = new String(strings[idx]);
    aStrings->add(*sp);
    idx++;
  }
  flag = FALSE;
}

TStrListDialog::~TStrListDialog()
{
  delete aStrings;
}

void TStrListDialog::IDButton(RTMessage)
{
  String *sp;
  const char *p;

  if (flag) return;
  for (int idx = 0; idx < aStrings->getItemsInContainer(); idx++) {
    sp = (String *)&(*aStrings)[idx];
    p = (const char *)*sp;
    SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LPARAM)p );
  }
  flag = TRUE;  // Prevent adding strings multiple times
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpszCmdLine, int nCmdShow)
{
  TStrList StrList("StrList", hInstance, hPrevInstance,
    lpszCmdLine, nCmdShow);
  StrList.Run();
  return StrList.Status;
}
