// Listing 2: stringcl.h
//	Implements a simple String class in C++.
//	Copyright (C) 1992 by Nicholas Wilt.  All rights reserved.

class String {
    char *s;
public:
    String();
    String(const char *);
    String(const String&);
    ~String();
    String& operator=(const String&);
    int operator[](int) const;
    int Len() const;
    String operator+(const String&) const;
    operator char*();
    friend ostream& operator<< (ostream&, const String&);
};

String::String()
{
    s = new char[1];
    s[0] = '\0';
}

String::String(const char *_s)
{
    s = new char[strlen(_s) + 1];
    strcpy(s, _s);
}

String::String(const String& _s)
{
    s = new char[strlen(_s.s) + 1];
    strcpy(s, _s.s);
}

String::~String()
{
    delete[] s;
}

String&
String::operator=(const String& _s)
{
    delete[] s;
    *this = String(_s);
    return *this;
}

int
String::operator[](int ind) const
{
    if (ind < 0 || ind >= Len())
	return -1;
    return s[ind];
}

int
String::Len() const
{
    return strlen(s);
}


String
String::operator+ (const String& _s) const
{
    char *tmp = new char[Len() + _s.Len() + 1];
    strcpy(tmp, s);
    strcat(tmp, _s.s);
    String ret = String(tmp);
    delete[] tmp;
    return ret;
}

String::operator char*()
{
    return s;
}

ostream&
operator<< (ostream& str, const String& _s)
{
    str << _s.s;
    return str;
}

