;===================================================================
; CHKUART.ASM - Identify the installed UARTs.
;
; To create an executable version of this program, use the following
; commands:
;       MASM CHKUART;
;       LINK CHKUART;
;       EXE2BIN CHKUART.EXE CHKUART.COM
;-------------------------------------------------------------------
; This program examines only those ports identified by the BIOS. The
; BIOS in some systems won't locate the ports at COM3 and COM4. If
; you prefer, you can hard-code the search. The std. addresses are:
; COM1=3F8H, COM2=2F8H, COM3=3E8H, COM4=2E8H.
;-------------------------------------------------------------------
CSEG            SEGMENT PARA    PUBLIC  'CODE'
        ASSUME  CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG
                ORG     100H                    ;COM file format

ENTRY:		JMP	MAIN

;===================================================================
; All program data appears here.
;-------------------------------------------------------------------
PROGID$         DB      "CHKUART 1.0 ",254," Copyright (c) 1993, "
		DB	"Robert L. Hummel"
CRLF$		DB	13,10,"$"

UARTIS$         DB      "UART #"
UARTNUM         DB      "1 is $"
TYPE_TBL$		DB	"not present (BIOS)$ "	;0
TYPE_LEN	EQU	$-OFFSET TYPE_TBL$
		DB	"fails register test$"	;1
		DB	"an 8250 or 8250-B$  "	;2
		DB	"an 8250A or 16450$  "	;3
		DB	"a 16550A (FIFO bug)$"	;4
		DB	"a 16550AF or 16550C$"	;5
		DB	"a 16552(dual 16550)$"	;6

;===================================================================
; MAIN
; This routine calls the UART_TYPE procedure to determine the
; presence and type of each UART reported by the BIOS.
;-------------------------------------------------------------------
MAIN            PROC    NEAR
        ASSUME  CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG

		CLD				;All str ops forward

		MOV	AH,9			;Display string
                MOV     DX,OFFSET PROGID$       ; copyright
		INT	21H			; thru DOS
;-------------------------------------------------------------------
; Retrieve the UART base address(es) from the BIOS data area.
;-------------------------------------------------------------------
		SUB	AX,AX			;Clear AX
		MOV	ES,AX			;Point to low memory
	ASSUME	ES:NOTHING

		MOV	SI,400H			;Point to data area
		MOV	CX,4			;Examine 4 addresses
;-------------------------------------------------------------------
; Loop through the addresses and display the installed devices.
;-------------------------------------------------------------------
MAIN_1:
		MOV	AH,9			;Display string
		MOV	DX,OFFSET UARTIS$	; start of message
		INT	21H			; thru DOS

		LODS	WORD PTR ES:[SI]      ;Get UART base address
		OR	AX,AX		      ;AX=0 if not installed
		JZ	MAIN_2
;-------------------------------------------------------------------
; Identify the UART. Returns the type code in AX.
;-------------------------------------------------------------------
		MOV	BX,AX			;Put base adr in BX
		CALL	UART_TYPE
;-------------------------------------------------------------------
; Translate the return code to an appropriate message.
;-------------------------------------------------------------------
MAIN_2:
		MOV	BL,TYPE_LEN	      ;Length of message
		MUL	BL		      ; get index into array
		MOV	DX,OFFSET TYPE_TBL$	;Start of table
		ADD	DX,AX			; start of message
		MOV	AH,9			;Display string
		INT	21H			; thru DOS

		MOV	AH,9			;Display string
		MOV	DX,OFFSET CRLF$		; move to new line
		INT	21H			; thru DOS
;-------------------------------------------------------------------
; Increment the UART # in the string and loop for remaining ports.
;-------------------------------------------------------------------
		INC	BYTE PTR [UARTNUM]	;Change ASCII char
		LOOP	MAIN_1

                MOV     AX,4C00H                ;Terminate program
                INT     21H                     ; thru DOS

MAIN            ENDP

;===================================================================
; UART_TYPE
; Verifies that a UART is present and identifies its type. This
; routine is not intended as an extensive UART diagnostic.
;-------------------------------------------------------------------
; Entry:
;	BX = base address of UART to identify
; Exit:
;	AX = 1: UART failed presence test
;	     2: 8250, 8250-B
;	     3: 8250A, 16450
;	     4: 16550A (with FIFO bug)
;	     5: 16550AF, 16550C
;	     6: 16552 (dual 16550)
;-------------------------------------------------------------------
IER		EQU	[BX+1]		;UART register equates
DLM		EQU	[BX+1]
FCR		EQU	[BX+2]
IIR		EQU	[BX+2]
AFR		EQU	[BX+2]
LCR		EQU	[BX+3]
SCR		EQU	[BX+7]

RET_TYPE	DW	1			;Return type here

UART_TYPE	PROC	NEAR
	ASSUME	CS:CSEG, DS:CSEG, ES:NOTHING, SS:CSEG

		MOV	[RET_TYPE],1		;Init return type
;-------------------------------------------------------------------
; Verify that a UART is present by testing the dual nature of
; register #1. Register 1 is 8 bits when acting as the DLM and 4
; bits when acting as the IER.
;-------------------------------------------------------------------
		LEA	DX,LCR			;Line control reg
		MOV	AL,80H			; set DLAB
		OUT	DX,AL

		JMP	$+2			;I/O delay

		IN	AL,DX			;Retrieve value
		CMP	AL,80H			;Must match
		JE	UT_2
;-------------------------------------------------------------------
; Exit here with the return type in AX.
;-------------------------------------------------------------------
UT_EXIT:
		MOV	AX,[RET_TYPE]		;Fetch return type
		RET
;-------------------------------------------------------------------
; Test the width of the DLM/IER register.
;-------------------------------------------------------------------
UT_2:
		LEA	DX,DLM		       ;Divisor latch (high)
		MOV	AL,0FFH		       ; set 8 bits
		OUT	DX,AL

		JMP	$+2			;I/O delay

		IN	AL,DX			;Retrieve value
		CMP	AL,0FFH			;Must match
		JNE	UT_EXIT

		LEA	DX,LCR			;Line control reg
		MOV	AL,03FH			; clear DLAB and set
		OUT	DX,AL			; all other bits

		JMP	$+2			;I/O delay

		IN	AL,DX			;Retrieve value
		CMP	AL,03FH			;Must match
		JNE	UT_EXIT

		LEA	DX,IER		      ;Interrupt enable reg
		MOV	AL,0FFH		      ; set 8 bits
		OUT	DX,AL

		JMP	$+2			;I/O delay

		IN	AL,DX		      ;Retrieve value
		CMP	AL,0FH		      ; Must have 4 bits set
		JNE	UT_EXIT
;-------------------------------------------------------------------
; 2. Test for the presence of the scratch pad register.
;-------------------------------------------------------------------
		INC	[RET_TYPE]		;Assume 8250

		LEA	DX,SCR			;Scratch pad reg
		MOV	AL,0AAH			; set bit pattern
		OUT	DX,AL

		JMP	$+2			;I/O delay

		IN	AL,DX			;Retrieve value
		CMP	AL,0AAH			;Must match
		JNE	UT_EXIT
;-------------------------------------------------------------------
; 3. Attempt to enable FIFO buffers.
;-------------------------------------------------------------------
		INC	[RET_TYPE]		;Assume 16450

		LEA	DX,FCR			;Fifo Ctrl Reg
		MOV	AL,0CFH			; enable FIFOs
		OUT	DX,AL

		LEA	DX,IIR			;Interrupt ID reg
		IN	AL,DX			;Check FIFO status

		AND	AL,0C0H		       ;If not enabled, done
		JZ	UT_EXIT

		INC	[RET_TYPE]		;Assume buggy 16550A
		TEST	AL,040H			; if bit 6 not set

		LEA	DX,FCR		       ;(FIFO Ctrl Reg)
		MOV	AL,0		       ;(turn off FIFOs)
		OUT	DX,AL		       ;Flags are unchanged)

		JNE	UT_EXIT			;Jump based on TEST
;-------------------------------------------------------------------
; 4. Check for 16552A variant.
;-------------------------------------------------------------------
		INC	[RET_TYPE]		;Assume good 16550AF

		LEA	DX,LCR			;Line control reg
		MOV	AL,80H			; set DLAB
		OUT	DX,AL

		LEA	DX,AFR			;Alt function reg
		MOV	AL,7			; set 3 bits
		OUT	DX,AL

		JMP	$+2			;I/O delay

		IN	AL,DX			;Retrieve value
		CMP	AL,7			;Must match
		JNE	UT_EXIT

		INC	[RET_TYPE]		;UART is 16552

		MOV	AL,0			;Clear bits
		OUT	DX,AL			; in AFR

		LEA	DX,LCR			;And clear
		OUT	DX,AL			; the DLAB

		JMP	UT_EXIT

UART_TYPE	ENDP

CSEG            ENDS
                END     ENTRY
