/******************************************************
**
**  KillProc.c- A process to kill off any process in
**              OS/2, provided you know the process ID.
**              Especially useful for terminating
**              detached processes.
**
**  Compiled and linked using JPI TopSpeed C++ for OS/2.
**
**  George Shepherd- June 23, 1993
**
**  Usage: killproc <process ID>
*/

#define INCL_DOS
#include <os2kernl.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>

main(int argc, char **argv) {
   char  szProcessID[5]; // holds process id arg
   USHORT uProcessID;

   /* Get the process id from the command line... */
   if(argc == 2) {
      char reply = '\0'; /* reply to confirm... */

      strncpy(szProcessID, argv[1], sizeof(szProcessID));
      szProcessID[sizeof(szProcessID)] = '\0';
      uProcessID = atoi(szProcessID);

      /* Confirm process id... */
      while((reply != 'Y') &&
            (reply != 'N')) {
         printf("Kill process %u <y/n>?\n", uProcessID);
         reply = toupper(getch());
      }

      if(reply == 'Y') {
         /* Kill the process. I trust this is the */
         /*  correct process ID...                */
         printf("Killing process: %u", uProcessID);
         DosKillProcess(DKP_PROCESS, uProcessID);
      }
   } else {
      puts("Usage: killproc <process ID>");
   }
}