unit RJInput;

interface {=== RJInput Unit ===}

uses
  Dialogs, Drivers, Views;

type
  PRJInputLine = ^TRJInputLine;
  TRJInputLine = object( TInputLine )
    function CanScroll( Delta: Integer ) : Boolean;
    procedure Draw; virtual;
  end;

implementation {=== RJInput Unit ===}

function TRJInputLine.CanScroll(Delta: Integer) : Boolean;
begin
  if Delta < 0 then
    CanScroll := FirstPos > 0
  else if Delta > 0 then
    CanScroll := Length( Data^ ) - FirstPos + 2 > Size.X
  else
    CanScroll := False;
end; {= TRJInputLine.CanScroll =}

procedure TRJInputLine.Draw;
var
  Color : Byte;
  L, R, Offset : Integer;
  B : TDrawBuffer;
begin
  Color := GetColor( 1 );         { Get normal Input line color }
  MoveChar( B, ' ', Color, Size.X );
  Offset := Size.X - Length( Data^ ) - 1;
  if Offset < 1 then            { Adjust offset into input line }
    Offset := 1;                 { Move string data into buffer }
  MoveStr( B[ Offset ], Copy( Data^,FirstPos+1,Size.X-2 ), Color );
  if CanScroll( 1 ) then    { Draw right scroll arrow if needed }
    MoveChar( B[ Size.X - 1 ], #16, GetColor( 4 ), 1 );
  if State and sfFocused <> 0 then
  begin
    if CanScroll( -1 ) then  { Draw left scroll arrow if needed }
      MoveChar( B[ 0 ], #17, GetColor( 4 ), 1 );
    L := SelStart - FirstPos + Offset - 1;
    R := SelEnd - FirstPos + Offset - 1;
    if L < 0 then
      L := 0;
    if R > Size.X - 2 then
      R := Size.X - 2;
    if L < R then                     { Highlight selected text }
      MoveChar( B[ L + 1 ], #0, GetColor( 3 ), R - L );
  end;
  WriteLine( 0, 0, Size.X, Size.Y, B );        { Display buffer }
  SetCursor( CurPos - FirstPos + Offset, 0 );   { Adjust cursor }
end; {= TRJInputLine.Draw =}

end. {=== RJInput Unit ===}