program TestSpin;

uses
  App, Drivers, MsgBox, Objects, Views, Dialogs, Menus, SpinBttn;

const
  cmWeather = 101;

type
  TransferRec = record
    CurTemp, NormTemp, Humidity, WindSpeed : Longint;
  end;

  TTestSpinApp = object( TApplication )
    procedure HandleEvent( var Event : TEvent ); virtual;
    procedure InitMenuBar; virtual;
  end;

function CreateWeatherDialog : PDialog;
var
  Dialog : PDialog;
  R : TRect;
  S : PSpinButton;
begin
  R.Assign( 0, 0, 40, 13 );
  Dialog := New( PDialog, Init( R, 'Today''s Weather' ) );
  with Dialog^ do
  begin
    Options := Options or ofCentered;
    R.Assign( 17, 2, 27, 3 );        { Current Temp Spin Button }
    S := New( PSpinButton, Init( R, -70, 150, 1, TRUE ) );
    R.Assign( 2, 2, 35, 3 );
    Insert( New( PLabel, Init( R,
            '~C~urrent Temp:            degrees', S ) ) );
    Insert( S );
    R.Assign( 17, 4, 27, 5 );         { Normal Temp Spin Button }
    S := New( PSpinButton, Init( R, -70, 150, 5, FALSE ) );
    R.Assign( 2, 4, 35, 5 );
    Insert( New( PLabel, Init( R,
            ' ~N~ormal Temp:            degrees', S ) ) );
    Insert( S );
    S^.SetState( sfDisabled, TRUE );
    R.Assign( 17, 6, 27, 7 );            { Humidity Spin Button }
    S := New( PSpinButton, Init( R, 0, 100, 1, FALSE ) );
    R.Assign( 2, 6, 35, 7 );
    Insert(New(PLabel, Init(R,'    ~H~umidity:            %',S )));
    Insert( S );
    R.Assign( 17, 8, 27, 9 );          { Wind Speed Spin Button }
    S := New( PSpinButton, Init( R, 0, 200, 5, FALSE ) );
    R.Assign( 2, 8, 35, 9 );
    Insert( New( PLabel, Init( R,
            '  ~W~ind Speed:            mph', S ) ) );
    Insert( S );
    R.Assign( 2, 10, 12, 12 );                 { OK Push Button }
    Insert( New( PButton, Init( R, 'Ok', cmOk, bfDefault ) ) );
    R.Move( 12, 0 );                       { Cancel Push Button }
    Insert(New(PButton, Init( R, 'Cancel', cmCancel, bfNormal )));
    SelectNext( FALSE );
  end;
  CreateWeatherDialog := Dialog;
end; {= CreateWeatherDialog =}

{==========================}
{== TTestSpinApp Methods ==}
{==========================}

procedure TTestSpinApp.HandleEvent( var Event : TEvent );
var
  Dialog : PDialog;
  ARec : TransferRec;
  Msg, T, H, W : String;
begin
  inherited HandleEvent( Event );
  if (Event.What = evCommand) and (Event.Command = cmWeather) then
  begin
    Dialog := CreateWeatherDialog;
    ARec.CurTemp := 82;                            { 82 Degrees }
    ARec.NormTemp := 80;                           { 80 Degrees }
    ARec.Humidity := 75;                  { 75 Percent Humidity }
    ARec.WindSpeed := 25;                        { 25 mph Winds }
    ExecuteDialog( Dialog, @ARec );
    Str( ARec.CurTemp, T );
    Str( ARec.Humidity, H );
    Str( ARec.WindSpeed, W );
    Msg := 'Current Temp: ' + T + #13 +
           'Humidity:     ' + H + #13 +
           'Wind Speed:   ' + W;
    MessageBox( Msg, nil, MfOkButton or MfInformation );
  end;
end; {= TTestSpinApp.HandleEvent =}

procedure TTestSpinApp.InitMenuBar;
var
  R : TRect;
begin
  GetExtent( R );
  R.B.Y := R.A.Y + 1;
  MenuBar := New( PMenuBar, Init( R, NewMenu(
    NewSubMenu( '~T~oday''s', HcNoContext, NewMenu(
      NewItem('~W~eather...', '', KbNoKey, cmWeather, HcNoContext,
      nil ) ), nil ) ) ) );
end; {= TTestSpinApp.InitMenuBar =}

var
  SpinApp : TTestSpinApp;

begin {=== MAIN ===}
  SpinApp.Init;
  SpinApp.Run;
  SpinApp.Done;
end.
