
// Matv - A Simple Matrix Class

// Version: 1.0
// Author: Mark Von Tress, Ph.D.
// Date: 10/11/92   

// Copyright(c) Mark Von Tress 1992


// DISCLAIMER: THIS PROGRAM IS PROVIDED AS IS, WITHOUT ANY
// WARRANTY, EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO FITNESS FOR A PARTICULAR PURPOSE. THE AUTHOR DISCLAIMS
// ALL LIABILITY FOR DIRECT OR CONSEQUENTIAL DAMAGES RESULTING
// FROM USE OF THIS PROGRAM.



#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <iostream.h>
#include <fstream.h>

//////////////////////////////////////////////////// vector
typedef enum bboolean { FFALSE, TTRUE } bboolean;

#ifndef SIGNATURE
#define SIGNATURE 0x5a5a
#endif

// uncomment the next lines to disable garbage checking
//#ifndef NO_CHECKING
//#define NO_CHECKING
//#endif

//to use double precision, uncomment the next lines
//#define USE_DOUBLES

#ifdef USE_DOUBLES
#ifndef FLOAT
#define FLOAT double
#define LFLOAT long double
#endif
#else
#ifndef FLOAT
#define FLOAT float
#define LFLOAT double
#endif
#endif


class Vector
{
private :
   FLOAT *c;           // vector of floats
   int n;              // number of floats
   bboolean CanDelete; // Gives permission to delete c - initially true
   bboolean CanAlias;  // Can be aliased - initially true
   long signature;     // for heap checking
   FLOAT *SetupVectors(int n);
   void PurgeVectors(void);

public :
   Vector(void);
   Vector(int n);
   Vector(int n, FLOAT *x);
   Vector(Vector &a);
   Vector &operator = (Vector &a);
   ~ Vector();

   FLOAT &operator() (int i);
   int rows(void) { return n; }

   static FLOAT Nrerror(const char *errormsg);
   void Garbage(const char *errormsg);

   friend ostream &operator << (ostream &s, Vector &v);
   void release() { if (CanAlias == TTRUE) CanDelete = FFALSE; }
   void CannotAlias() { CanAlias = FFALSE; }

};

/////////////////////////////////// matrix

class Matrix : public Vector
{
public :
   int r, c;

   FLOAT &operator() (int i, int j);
   Matrix(void) : Vector(1), r(1), c(1) { }
   Matrix(int rr, int cc) : Vector(rr*cc), r(rr), c(cc) { }
   Matrix(int rr, int cc, FLOAT *x) : Vector(rr*cc,x), r(rr), c(cc) { }
   Matrix(Matrix &a) : Vector(a), r(a.r), c(a.c) { }
   Matrix &operator = (Matrix &a);
   ~ Matrix() { }
   friend ostream &operator << (ostream &s, Matrix &m);
   void show(char *str);

   friend Matrix operator + (Matrix &a, Matrix &b);
   friend Matrix operator + (Matrix &a, FLOAT b);
   friend Matrix operator + (FLOAT b, Matrix &a);
   Matrix &operator += ( Matrix &a );
   Matrix &operator += ( FLOAT b );

   friend Matrix operator - (Matrix &a, Matrix &b);
   friend Matrix operator - (Matrix &a, FLOAT b);
   friend Matrix operator - (FLOAT b, Matrix &a);
   Matrix &operator -= ( Matrix &a );
   Matrix &operator -= ( FLOAT b );
   friend Matrix operator - (Matrix &a); // unary minus

   friend Matrix operator * (Matrix &a, Matrix &b);
   friend Matrix operator * (Matrix &a, FLOAT b);
   friend Matrix operator * (FLOAT b, Matrix &a);
   Matrix &operator *= ( Matrix &a );
   Matrix &operator *= ( FLOAT b );

   friend Matrix operator % (Matrix &a, Matrix &b); // emult
   friend Matrix operator % (FLOAT b, Matrix &a);
   friend Matrix operator % (Matrix &a, FLOAT b);
   Matrix &operator %= ( Matrix &a );
   Matrix &operator %= ( FLOAT b );

   friend Matrix operator / (Matrix &a, Matrix &b);
   friend Matrix operator / (Matrix &a, FLOAT b);
   friend Matrix operator / (FLOAT b, Matrix &a);
   Matrix &operator /= ( Matrix &a );
   Matrix &operator /= ( FLOAT b );


};


Matrix Tran(Matrix &a);                  // transpose
Matrix Sweep(int k1, int k2, Matrix &a); // g2 sweep
Matrix Inv(Matrix &a);                   // invert - G2 sweep
Matrix Fill(int r, int cc, FLOAT d = 0);
Matrix Ident(int n);
Matrix Submat(Matrix &a, int lr, int lc, int r, int c);
Matrix Ch( Matrix &a, Matrix &b);        // horizontal concatenation
Matrix Cv( Matrix &a, Matrix &b);        // vertical concatentation

Matrix Reada(char *filename);
void Writea(char *filename, Matrix &a, const char *filetitle = "A_Matrix");

