; ISHARE.ASM <dap@kandy.com>
; Tests to see if SHARE.EXE is loaded, and returns a message.
; Also lets user know if it's okay to load SHARE.

; SYNTAX: ishare
; Errorlevel: 
;    00H (0)   - Not installed, OK to install 
;    01H (1)   - Not installed, not OK to install 
;    FFH (255) - Installed

;------------------------------------------------------------------------------
; .COM FILE -- EXE2BIN!
text		SEGMENT 'CODE'
		ASSUME	CS:text, DS:text, SS:text, ES:text
		ORG	100h

start:

		mov	AH,10h			; Set up registers for
						;  installed call 
		mov	AL,00h			; for SHARE.EXE 
		int	2Fh			; Make the call, return value
						;  in AL 

		mov	result,al		; save the return value

		mov	dx,OFFSET sharemsg	; load pointer to string
		CALL	print			; call print routine

		cmp	BYTE PTR result,0FFh	; see if SHARE is installed
		je	inst			; jump if it is

		mov	dx,OFFSET notmsg	; pointer to string
		CALL	print			; print it

inst:
		mov	dx,OFFSET instmsg	; pointer to string
		CALL	print			; call print routine

		cmp	BYTE PTR result,0FFh	; is SHARE loaded?
		je	ender			; quit if it is

		cmp	result,0		; otherwise, check if okay to
		je	okay			;  install

		mov	dx,OFFSET notmsg	; pointer to string to display
		CALL	print			; call print to display it

okay:

		mov	dx,OFFSET okaymsg	; pointer to string
		CALL	print

ender:
		mov	dx,OFFSET eol		; tidy things up with a
		CALL	print			;  carriage return


		mov	al,BYTE PTR result	; get result back to AL
		mov	ah,4Ch			; exit with errorlevel in AL
		int	21h

;------------------------------------------------------------------------------
print		PROC	NEAR			; Subroutine prints a string
		mov	ah,9			; Display $-terminated string
		int	21h
		ret				; return to caller
print		ENDP

;------------------------------------------------------------------------------
;Data
result		DB ?
sharemsg	DB 'SHARE $'
instmsg		DB 'installed.  $'
notmsg		DB 'NOT $'
okaymsg		DB 'Okay to install.$'
eol		DB 13,10,'$'
text		ENDS
		END	start

