
 (* YESNO.PAS - TP6+ required to compile. Guy McLoughlin  Sept/93     *)
 (*                                                                   *)
 (* Public-domain utility that returns DOS ERRORLEVEL codes based     *)
 (* upon user's response to a "Yes / No" question. Default "answer"   *)
 (* is returned if user doesn't reply in time.                        *)
 (*                                                                   *)
 (*               KEY PRESSED     ERROR LEVEL RETURNED                *)
 (*               ===========     ====================                *)
 (*                 N or n                0                           *)
 (*                 Y or y                1                           *)
 (*                  ESC                  2                           *)


 {$A+,B-,D-,E-,F-,G-,I-,L-,N-,O-,P-,R-,S-,V-,X+}
 {$M 1024,0,0}

program YesNo_DOS_Utility;

type
  st_60 = string[60];


  (***** Read a key-press.                                            *)
  (*                                                                  *)
  function ReadKeyChar : {output} char; assembler;
  asm
    mov ah, 00h
    int 16h
  end;        (* ReadKeyChar.                                         *)


  (***** Function to indicate if a key is in the keyboard buffer.     *)
  (*                                                                  *)
  function KeyPressed : {output} boolean; assembler;
  asm
    mov ah, 01h
    int 16h
    mov ax, 00h
    jz @1
    inc ax
    @1:
  end;        (* KeyPressed.                                          *)


  (***** Clear the keyboard-buffer.                                   *)
  (*                                                                  *)
  procedure ClearKeyBuff;
  begin
    while KeyPressed do
      ReadKeyChar
  end;        (* ClearKeyBuff.                                        *)


              (* Constant definitions.                                *)
const
  co_EscKey      = #27;
  co_DefaultTime = trunc(5 * 18.2);

              (* Variable definitions.                                *)
var
              (* Absolute variable used to read current DOS "TICK"    *)
              (* count. NOTE: 18.2 "TICKS" = 1 second.                *)
  wo_Timer : word absolute $40:$6C;

  ch_Temp1,
  ch_Temp2 : char;

  in_Temp1 : integer;

  wo_Temp1,
  wo_Temp2 : word;

  st_Temp1 : st_60;

              (* Main program execution block.                        *)
BEGIN
              (* If 3 or more parameters were entered, then...        *)
  if (paramcount > 2) then
    begin
              (* Obtain number of seconds to wait from parameter 1.   *)
      st_Temp1 := paramstr(1);
      val(st_Temp1, wo_Temp1, in_Temp1);
      if (in_Temp1 <> 0) then
        wo_Temp1 := co_DefaultTime
      else
        wo_Temp1 := trunc(wo_Temp1 * 18.2);

              (* Obtain default 'Y' or 'N' answer from parameter 2.   *)
      st_Temp1  := paramstr(2);
      ch_Temp2 := upcase(st_Temp1[1]);

              (* If parameter 2 is neither 'Y' or 'N', then set it to *)
              (* the 'ESC' key character.                             *)
      if NOT (ch_Temp2 IN ['N', 'Y']) then
        ch_Temp2 := co_EscKey;

              (* Obtain question to display from all parameters after *)
              (* parameter number 2.                                  *)
      st_Temp1 := ' ';
      for wo_Temp2 := 3 to paramcount do
        st_Temp1 := st_Temp1 + paramstr(wo_Temp2) + ' ';

              (* Display question to ask.                             *)
      writeln;
      write(st_Temp1, '[Y/N] : ');

              (* Calculate final "TICK" count.                        *)
      wo_Temp1 := (wo_Temp1 + wo_Timer);

              (* Clear the keyboard buffer.                           *)
      ClearKeyBuff;

              (* Initialize input character to "NULL" char.           *)
      ch_Temp1 := #0;

              (* Repeat until user's key choice one of: Y y N n ESC   *)
              (* Or the time to wait has expired.                     *)
      repeat
              (* If a user hasn't pressed a key, then check "TICK"    *)
              (* count.                                               *)
        if NOT KeyPressed then
          wo_Temp2 := wo_Timer
        else
              (* Else read user's key-press.                          *)
          ch_Temp1 := upcase(ReadKeyChar)

      until (ch_Temp1 IN [co_EscKey, 'N', 'Y'])
         or (wo_Temp2 = wo_Temp1);

              (* If the time to wait has expired, then use the        *)
              (* default answer.                                      *)
      if (wo_Temp2 = wo_Temp1) then
        ch_Temp1 := ch_Temp2;

              (* Display answer.                                      *)
      if (ch_Temp1 <> co_EscKey) then
        writeln(ch_Temp1)
      else
        writeln('<ESC>');

              (* Return DOS ERRORLEVEL based on answer.               *)
      case ch_Temp1 of
        'N'       : halt(0);
        'Y'       : halt(1);
        co_EscKey : halt(2)
      end
    end
  else
              (* Else display syntax.                                 *)
    writeln;
    write('SYNTAX : YESNO  <Seconds to wait>  <Default answer [Y,N]>' +
          '  <Question to ask>')
END.

