'*********************************************************************
'*                         CHEKWIN.BAS                               *
'*                                                                   *
'*   This program will determine whether Windows is running and, if  *
'*   so, its operating mode.                                         *
'*   QuickBASIC must be loaded, as follows: QB /L QB                 *
'*   Copyright 1993 by John Riherd                                   *
'*********************************************************************
DEFINT A-Z 
DECLARE FUNCTION ChekWindows% (Ver1 AS INTEGER, Ver2 AS INTEGER)
                                                                                

'$INCLUDE: 'Qb.bi'           'Include file for interrupt calls
                                                                                

CONST MULTIPLEX = &H2F       'multiplex interrupt number
CONST NOWIN = &H0            'Return for no Windows
CONST WIN386 = &H1           'Return for Windows-386 V2.?
CONST REAL = &H81            'Return for Windows in real mode
CONST STANDARD = &H82        'Return for Windows in standard mode
CONST ENHANCED = &H83        'Return fo Windows in enhanced mode
                                                                                

DIM WellIsIt AS INTEGER
DIM Ver1 AS INTEGER           'Primary version number
DIM Ver2 AS INTEGER           'Secondary version number
                                                                                
  
WellIsIt = ChekWindows%(Ver1, Ver2)   'Do the test and return values
SELECT CASE WellIsIt
  CASE NOWIN
    PRINT "Windows is not running"
  CASE WIN386
    PRINT "Windows-386 V 2.? is running"
  CASE REAL
    PRINT "Windows is running in real mode"
  CASE STANDARD
    PRINT "Windows is running in standard mode"
  CASE ENHANCED
    PRINT "Windows Vers. "; LTRIM$(STR$(Ver1)); ".";
    PRINT LTRIM$(STR$(Ver2)); " is running in enhanced mode"
END SELECT
 
FUNCTION ChekWindows% (Ver1 AS INTEGER, Ver2 AS INTEGER)
                                                                                

DIM Regs AS RegTypeX         'Processor registers for interrupt call
DIM VBuffer AS INTEGER       'To store version number
                                                                                

Ver1 = 0                     'Initialize version numbers
Ver2 = 0
                                                                                

Regs.ax = &H1600             'Function number
CALL INTERRUPTX(MULTIPLEX, Regs, Regs)

VBuffer = Regs.ax            'Set regs.AX
                                                                                

SELECT CASE VBuffer MOD 256  'Get the low byte of AX
 
CASE &H1, &HFF               'Windows-386 running
    Ver1 = 2                 'Primary version
    Ver2 = 0                 'Secondary version is unavailable
    ChekWindows% = WIN386
 
CASE &H0, &H80
    Regs.ax = &H4680         'Check for real or standard mode
    CALL INTERRUPTX(MULTIPLEX, Regs, Regs)
    
    IF (Regs.ax MOD 256) = &H80 THEN 'Check if Windows is running
         ChekWindows% = NOWIN                'No
    ELSE                     'Check for real or standard mode
         Regs.ax = &H1605    'Set registers and function
         Regs.bx = &H0
         Regs.si = &H0
         Regs.cx = &H0
         Regs.es = &H0
         Regs.ds = &H0
         Regs.dx = &H1
         CALL INTERRUPTX(MULTIPLEX, Regs, Regs)
         
         IF Regs.cx = &H0 THEN  'Check for real mode
              ChekWindows% = REAL
         ELSE                   'Windows in standard mode
              ChekWindows% = STANDARD
         END IF
    END IF
 
CASE ELSE
    Ver1 = VBuffer AND &HF   'Get the low byte for primary version
    Ver2 = VBuffer \ 256     'Get the high byte for second. version
    ChekWindows% = ENHANCED
END SELECT
                                                                                

END FUNCTION
