{$X+,V-}
PROGRAM TestMetr;
USES App, Crt, Dialogs, Drivers, Menus, Objects, Views,
     Meter;
CONST
  cmMeterDemo   = 100;
TYPE
  TMyApp = OBJECT(TApplication)
   (* overriden methods *)
    PROCEDURE HandleEvent(VAR Event: TEvent);  VIRTUAL;
    PROCEDURE InitMenuBar;                     VIRTUAL;
    PROCEDURE InitStatusLine;                  VIRTUAL;
   (* new methods *)
    PROCEDURE ShowMeter;
  END;

PROCEDURE TMyApp.HandleEvent(VAR Event: TEvent);
BEGIN
  TApplication.HandleEvent(Event);
  IF Event.What = evCommand THEN
    BEGIN
      CASE Event.Command OF
        cmMeterDemo : ShowMeter;
        ELSE EXIT
      END;
      ClearEvent(Event);
    END;
END;

PROCEDURE TMyApp.InitMenuBar;
VAR R: TRect;
BEGIN
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar :=
    New(PMenuBar, Init(R, NewMenu(
      NewSubMenu('~F~ile', hcNoContext, NewMenu(
        NewItem('~M~eter control demo', 'F2', kbF2,
                   cmMeterDemo, hcNoContext,
        NewLine(
        NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
        NIL)))),
      NIL)
    )));
END;

PROCEDURE TMyApp.InitStatusLine;
VAR R: TRect;
BEGIN
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine :=
    New(PStatusLine, Init(R,
      NewStatusDef(0, $FFFF,
        NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
        NewStatusKey('~F2~ Demo for meter control',
                       kbF2, cmMeterDemo,
        NIL)),
      NIL)
    ));
END;

PROCEDURE TMyApp.ShowMeter;
(* demo procedure showing three different meter controls *)
VAR
  PM, PM2, PM3 : PMeter;
  PD : PDialog;
  i  : WORD;
  R  : TRect;
BEGIN
  R.Assign(25, 4, 55, 16);
  PD := New(PDialog, Init(R, 'Meter Demo Dialog'));
  Desktop^.Insert(PD);
 (* first meter, pretending some copying operation *)
  R.Assign(2, 2, 25, 4);
  PM := New(PMeter, Init(R, 'Copying...', 0, 250));
  PD^.Insert(PM);
 (* second meter, indicating some verification process *)
  R.Move(0, 3);
  PM2 := New(PMeter, Init(R, 'Verifying...', 100, 200));
  PM2^.SetColor($74, $2E);
  PD^.Insert(PM2);
 (* last meter shows some kind of conversion action *)
  R.Move(0, 3);
  PM3 := New(PMeter, Init(R, 'Converting...', 0, 300));
  PM3^.SetColor($71, $1A);
  PD^.Insert(PM3);
  FOR i := 1 TO 250 DO
    BEGIN
      PM^.SetValue(i);
      Delay(25);
    END;
  FOR i := 100 TO 200 DO
    BEGIN
      PM2^.SetValue(i);
      Delay(10);
    END;
  FOR i := 1 TO 300 DO
    BEGIN
      PM3^.SetValue(i);
      Delay(25);
    END;
  Delay(1000);
  Desktop^.Delete(PD);
  Dispose(PD, Done);
END;

VAR  MyApp : TMyApp;
BEGIN
  MyApp.Init;
  MyApp.Run;
  MyApp.Done;
END.
