/*
   doc$
   --------------------------------------------------------------------------
   File 	:	pf.c

   Copyright	:	placed in the public domain

   Author	:	jlMarriott

   Version	:	0x02

   Created	:	921110.1201

   Description	:	simulate dos execution path search

   --------------------------------------------------------------------------
   File History :       Rev	Date.Time	Who	What
		       ------------------------------------------------------
			01	921110.1201	jlm	created
			02	921113.1035	jlm	added "/v" option for
							more detailed display
   --------------------------------------------------------------------------
   end$
*/
#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <io.h>
#include <fcntl.h>
#include <conio.h>
#include <string.h>

char	fVerbose = 0;

// ---------------------------------------------------------------
// ---------------------------------------------------------------
void Usage(void)
{
		printf( "\nPath Search, v2.0, 921113jlm\n\n"
			"       Usage: pf [/v] filename [filename filename filename ...]\n\n"
			"       Wildcards are allowed. All matches found in path are shown.\n"
			"       Search begins in the current directory, then follows the PATH\n\n"
			"       /v = verbose mode. includes file date, time & size.\n");
		exit(0);
}

// ---------------------------------------------------------------
// find a file by searching the path, starting with the current
// directory. list all instances found
// ---------------------------------------------------------------
void	FindEmAll(char *pzFileName)
{
	static	char zFindFile[66] = "", zDosPath[129] = "";
	char	*pz;

	getcwd(&zDosPath,129);
	strcat(&zDosPath,";");
	pz = getenv("PATH");
	strcat(&zDosPath, pz);

	pz = strtok(&zDosPath,";");
	while (*pz)
	{
		struct ffblk ffblk;
		int done;
		char	z[66];

		strcpy(&zFindFile,pz);
		if (zFindFile[strlen(zFindFile)-1] != '\\')
			strcat(zFindFile,"\\");
		strcat(zFindFile,pzFileName);

		done = findfirst(&zFindFile,&ffblk,0);
		while (!done)
		{
			strcpy(z,pz);
			if (z[strlen(z)-1] != '\\')
				strcat(z,"\\");
			strcat(z,&ffblk.ff_name);
			if (fVerbose)
			{
				struct ftime	f;
				int	h;

				h = open(z,O_RDONLY);

				getftime(h,&f);

				printf("  %s\n\t%02u/%02u/%02u %02u.%02u %8ld\n",
					z,f.ft_month, f.ft_day,f.ft_year+1980,
					f.ft_hour,f.ft_min,ffblk.ff_fsize);
				close(h);
			}
			else
				printf("\t%s\n", z);

			done = findnext(&ffblk);
		}
		pz = strtok(NULL,";");

	}
}

// ---------------------------------------------------------------
// ---------------------------------------------------------------
void main(int cArgs, char **pzArgs)
{
	if (cArgs < 2)
		Usage();

	clrscr();

	pzArgs++;

	fVerbose = (stricmp(*pzArgs,"/v") == 0) ? 1 : 0;
	if (fVerbose)
		pzArgs++;
	else
	{
		fVerbose = (stricmp(*pzArgs,"-v") == 0) ? 1 : 0;
		if (fVerbose)
			pzArgs++;
	}

	if (!*pzArgs)
		Usage();
	else
	{
		printf("Searching PATH ...\n");

		while (*pzArgs)
		{
			FindEmAll(*pzArgs);
			pzArgs++;
		}
	}

	exit(0);
}

