/*  unique.cpp  */
/*
    this filter reads a text file, line at a time, and outputs only the
    first occurence of identical lines.

    written on 13 November 1991 by Ed Beroset
*/

/****************************************************************************
*                               includes                                    *
****************************************************************************/
#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>
#include <string.h>
#include <process.h>
#include <ctype.h>

#define VERSION  "1.01"    /* version number of this program  */
#define FALSE 0
#define TRUE (!FALSE)       /* useful constants  */

#define SWITCH_CHARS "-/"      /*  command line switch delimiters  */

#define MAXLINE 20000

/****************************************************************************
*                         function prototypes                               *
****************************************************************************/
int get_switches(int argc, char *argv[]);
void usage(void);

/****************************************************************************
*                           global variables                                *
****************************************************************************/
int countflag;

/****************************************************************************
*                                                                   main()  *
****************************************************************************/
int main(int argc, char *argv[] )
{
    char a[MAXLINE];    // string A
    char b[MAXLINE];    // string B
    unsigned int i;             // index variable
    int firstarg;

    countflag = 0;

    firstarg = get_switches(argc,argv);

    cin.getline(a,MAXLINE);
    i=0;
    while (cin)    {
        cin.getline(b,MAXLINE);
        i++;
        if (strcmp(a,b))    {
            if (countflag)
                cout << setw(4) << i << setw(0) << ':';
            cout << a << endl;
            strcpy(a,b);
            i=0;
        }
    }
    return(0);
}


/****************************************************************************
*                                                           get_switches()  *
*                                                                           *
*   parses the first arguments to extract the appropriate command line      *
*   switches and act on that info accordingly.  Also returns the number     *
*   of the first non-switch arg (e.g. from which argv the main routine      *
*   should start reading)                                                   *
*                                                                           *
****************************************************************************/
int get_switches(int argc, char *argv[])    {
    char *sw_ptr;
    int done;
    int cur_arg=1;      /*  start from arg AFTER program name  */
    int i;

    while ( ((sw_ptr = strpbrk(argv[cur_arg],SWITCH_CHARS)) != NULL) &&
            (cur_arg < argc))   {
        switch (sw_ptr[1])  {
            case '?':   /*  user wants help  */
            case 'H':
            case 'h':
                usage();
            case 'c':   /*  count frequency of each line  */
            case 'C':
                countflag=1;
                break;
            default:
                cerr << "\aUnknown command line switch: " << sw_ptr << endl;
                usage();
        }
        cur_arg++;
    }
    return(cur_arg);
}

/****************************************************************************
*                                                                  usage()  *
*                                                                           *
*   prints to the stderr device a short text blurb that describes the       *
*   proper usage (including command line switches) of this program.         *
*                                                                           *
****************************************************************************/
void usage(void)    {
    cerr << "\nUNIQUE.EXE   \ttext file extraction filter  \tversion " << VERSION;
    cerr << "\nCopyright (c) 1991 by Edward J. Beroset    Chapel Hill, NC  USA\n\n";
    cerr << "Syntax is UNIQUE [options] \n\n";
    cerr << "valid options are:\n";
    cerr << "\t-H or -?   displays this screen\n";
    cerr << "\t-C         prepend each line with occurence count\n";
    exit(0);
}


