;****************************************************************************
; COLOR sets the screen to the specified combination of colors.  Its
; syntax is
;
;       COLOR foreground background
;
; where "foreground" specifies the foreground color and "background"
; specifies the background color.  Valid values for these parameters are:
;
;       BLACK           RED
;       BLUE            MAGENTA
;       GREEN           YELLOW, ORANGE, or BROWN
;       CYAN            WHITE
;
; Preceding a color identifier with an underscore selects the intense
; version of that color (foreground colors only).  The ANSI.SYS driver
; must be installed.
;****************************************************************************

code            segment
                assume  cs:code,ds:code
                org     100h
begin:          jmp     main

helpmsg         db      "Sets the screen to the specified combination of "
                db      "colors.",13,10,13,10
                db      "COLOR foreground background",13,10,13,10
                db      "  foreground  Foreground color.",13,10
                db      "  background  Background color.",13,10,13,10
                db      "Valid colors are BLACK, BLUE, GREEN, CYAN, RED, "
                db      "MAGENTA, YELLOW, and WHITE.",13,10
                db      "ORANGE or BROWN may be substituted for YELLOW.  "
                db      "Preceding a color identifier",13,10
                db      "with an underscore highlights the color "
                db      "(foreground colors only).",13,10,"$"

errmsg1         db      "Syntax: COLOR foreground background",13,10,"$"
errmsg2         db      "DOS 4.0 or higher required",13,10,"$"
errmsg3         db      "ANSI.SYS not installed",13,10,"$"
errmsg4         db      "Invalid color identifier",13,10,"$"

color_ids       db      "BROWN",0               ;Color ID table
                db      "ORANGE",0
                db      "WHITE",0
                db      "CYAN",0
                db      "MAGENTA",0
                db      "BLUE",0
                db      "YELLOW",0
                db      "GREEN",0
                db      "RED",0
                db      "BLACK",0

command         db      27,"[0;3x;4xm$"         ;ANSI command string

;****************************************************************************
; Procedure MAIN
;****************************************************************************

main            proc    near
                cld                             ;Clear direction flag
                mov     si,81h                  ;Point SI to command line
                call    scanhelp                ;Scan for "/?" switch
                jnc     checkver                ;Branch if not found
                mov     ah,09h                  ;Display help text and exit
                mov     dx,offset helpmsg       ;  with ERRORLEVEL=0
                int     21h
                mov     ax,4C01h
                int     21h
;
; Make sure this is DOS 4.0 or higher and that ANSI.SYS is installed
; before proceeding.
;
checkver:       mov     dx,offset errmsg2       ;Exit if DOS version
                mov     ah,30h                  ;  is less than 4.0
                int     21h
                cmp     al,4
                jae     checkansi

error:          mov     ah,09h                  ;Display error message and
                int     21h                     ;  exit with ERRORLEVEL=1
                mov     ax,4C01h
                int     21h

checkansi:      mov     ax,1A00h                ;Check for ANSI.SYS using
                int     2Fh                     ;  the DOS multiplex
                mov     dx,offset errmsg3       ;  interrupt
                cmp     al,0FFh
                jne     error                   ;Error if not installed
;
; Capitalize everything on the command line.
;
                mov     si,81h                  ;Point SI to start
                mov     cl,[si-1]               ;Get character count in CX
                sub     ch,ch
                jcxz    parse                   ;Branch if nothing entered
capsloop:       lodsb                           ;Get a character
                cmp     al,"a"                  ;Branch if lower than "a"
                jb      skipchar
                cmp     al,"z"                  ;Branch if higher than "z"
                ja      skipchar
                and     byte ptr [si-1],0DFh    ;Capitalize the character
skipchar:       loop    capsloop                ;Loop until done
;
; Parse the command line for identifiers and build the command string.
;
parse:          mov     si,81h                  ;Reset SI again
                call    findchar                ;Find first parameter
                mov     dx,offset errmsg1       ;Error if no parameter
                jc      error                   ;  found
                cmp     byte ptr [si],5Fh       ;Test for an underscore
                jne     not_uscore              ;Branch if found
                inc     si                      ;Advance SI past underscore
                inc     byte ptr command[2]     ;Select intense foreground
not_uscore:     call    convert_color           ;Convert to a color code
                mov     dx,offset errmsg4       ;Exit if error occurred in
                jc      error                   ;  the conversion
                add     cl,30h                  ;Convert binary to ASCII
                mov     command[5],cl           ;Store in command string

                call    finddelim               ;Find end of parameter
                mov     dx,offset errmsg1       ;Exit if parameter ended
                jc      error                   ;  with a carriage return

                call    findchar                ;Find second parameter
                mov     dx,offset errmsg1       ;Error if no parameter
                jc      error                   ;  found
                call    convert_color           ;Convert to color code
                mov     dx,offset errmsg4       ;Exit if error occurred in
                jc      error                   ;  the conversion
                add     cl,30h                  ;Convert binary to ASCII
                mov     command[8],cl           ;Store in command string
;
; Output the command string to ANSI.SYS and terminate.
;
                mov     ah,09h                  ;Output the string with
                mov     dx,offset command       ;  DOS function 09H
                int     21h
                mov     ax,4C00h                ;Exit with ERRORLEVEL=0
                int     21h
main            endp

;****************************************************************************
; FINDCHAR advances SI to the next non-space or non-comma character.
; On return, carry set indicates EOL was encountered.
;****************************************************************************

findchar        proc    near
                lodsb                           ;Get the next character
                cmp     al,20h                  ;Loop if space
                je      findchar
                cmp     al,2Ch                  ;Loop if comma
                je      findchar
                dec     si                      ;Point SI to the character
                cmp     al,0Dh                  ;Exit with carry set if end
                je      eol                     ;  of line is reached

                clc                             ;Clear carry and exit
                ret

eol:            stc                             ;Set carry and exit
                ret
findchar        endp

;****************************************************************************
; FINDDELIM advances SI to the next space or comma character.  On return,
; carry set indicates EOL was encountered.
;****************************************************************************

finddelim       proc    near
                lodsb                           ;Get the next character
                cmp     al,20h                  ;Exit if space
                je      fd_exit
                cmp     al,2Ch                  ;Exit if comma
                je      fd_exit
                cmp     al,0Dh                  ;Loop back for more if end
                jne     finddelim               ;  of line isn't reached

                dec     si                      ;Set carry and exit
                stc
                ret

fd_exit:        dec     si                      ;Clear carry and exit
                clc
                ret
finddelim       endp

;****************************************************************************
; SCANHELP scans the command line for a /? switch.  If found, carry returns
; set and SI contains its offset.  If not found, carry returns clear.
;****************************************************************************

scanhelp        proc    near
                push    si                      ;Save SI
scanloop:       lodsb                           ;Get a character
                cmp     al,0Dh                  ;Exit if end of line
                je      scan_exit
                cmp     al,"?"                  ;Loop if not "?"
                jne     scanloop
                cmp     byte ptr [si-2],"/"     ;Loop if not "/"
                jne     scanloop

                add     sp,2                    ;Clear the stack
                sub     si,2                    ;Adjust SI
                stc                             ;Set carry and exit
                ret

scan_exit:      pop     si                      ;Restore SI
                clc                             ;Clear carry and exit
                ret
scanhelp        endp

;****************************************************************************
; CONVERT_COLOR compares the string pointed to by DS:SI against a list
; of ASCIIZ strings and returns carry clear if there's a match, carry set
; if there's not.  If carry is clear, CX holds the number of the string
; that was matched.
;****************************************************************************

convert_color   proc    near
                push    si                      ;Save SI on stack
                mov     bx,si                   ;Also save it in BX
;
; Compare the parameter to the list of color identifiers.
;
                mov     si,offset color_ids     ;Point SI to table
                mov     cx,9                    ;Initialize CX
cc1:            mov     di,bx                   ;Point DI to parameter
cc2:            lodsb                           ;Get a character
                or      al,al                   ;Is it zero?
                je      match                   ;Match if it is
                scasb                           ;Compare the characters
                je      cc2                     ;Loop if they're equal
                jcxz    nomatch                 ;Finished if CX is 0
                dec     cx                      ;Decrement count
cc3:            lodsb                           ;Skip to the first character
                or      al,al                   ;  beyond the next zero and
                jnz     cc3                     ;  compare the next string
                jmp     cc1                     ;  in the list
;
; Set the carry flag to 1 or 0, then exit.
;
nomatch:        pop     si                      ;Restore SI
                stc                             ;Set carry and exit
                ret

match:          cmp     cx,8                    ;Set CX to 3 if it's
                jb      match1                  ;  greater than 8
                mov     cx,3
match1:         pop     si                      ;Restore SI
                clc                             ;Clear carry and exit
                ret
convert_color   endp

code            ends
                end     begin
