;****************************************************************************
; CPUTYPE identifies the type of CPU installed in a PC.  On return,
; ERRORLEVEL is set as follows:
;
;       0       8086 or 8088
;       1       80286
;       2       80386
;       3       80486
;
; A CPU identified as a 386 could be either a 386DX or 386SX.
;****************************************************************************

code            segment
                assume  cs:code,ds:code
                org     100h
begin:          jmp     short main

text            db      13,10,"CPU is an 80$"
cpu_8086        db      "86 or 8088$"
cpu_286         db      "286$"
cpu_386         db      "386$"
cpu_486         db      "486$"
crlf            db      13,10,"$"
errorlevel      db      0

;****************************************************************************
; Procedure MAIN
;****************************************************************************

main            proc    near
                mov     ah,09h                  ;Print opening message
                mov     dx,offset text
                int     21h
;
; Test for an 8086/8088 by determing whether SP is decremented before
; or after a PUSH.
;
                mov     dx,offset cpu_8086
                push    sp
                pop     ax
                cmp     sp,ax
                jne     exit
;
; Test for a 286 by attempting to set the Nested Task (NT) bit in the
; FLAGS register.
;
                mov     dx,offset cpu_286
                inc     errorlevel
                pushf                           ;Push FLAGS
                pop     ax                      ;AX = FLAGS
                or      ax,4000h                ;Set NT bit (bit 14)
                push    ax                      ;Push new value
                popf                            ;Pop it into FLAGS
                pushf                           ;Push FLAGS
                pop     ax                      ;Pop FLAGS into AX
                test    ax,4000h                ;Test bit 14 and exit
                jz      exit                    ;  if it's not set

                and     ax,not 4000h            ;Clear the NT bit before
                push    ax                      ;  proceeding
                popf
;
; Separate 386s from 486s by attempting to toggle the Alignment Check (AC)
; bit in the EFLAGS register.
;
                .386
not_286:        mov     dx,offset cpu_386
                inc     errorlevel
                mov     ebx,esp                 ;Zero lower 2 bits of ESP
                and     esp,0FFFFFFFCh          ;  to avoid AC fault on 486
                pushfd                          ;Push EFLAGS register
                pop     eax                     ;EAX = EFLAGS
                mov     ecx,eax                 ;ECX = EFLAGS
                xor     eax,40000h              ;Toggle AC bit (bit 18) in
                                                ;  EFLAGS register
                push    eax                     ;Push new value
                popfd                           ;Put it in EFLAGS
                pushfd                          ;Push EFLAGS
                pop     eax                     ;EAX = EFLAGS
                and     eax,40000h              ;Isolate bit 18 in EAX
                and     ecx,40000h              ;Isolate bit 18 in ECX
                cmp     eax,ecx                 ;Are EAX and ECX equal?
                je      is_386                  ;Yes, then it's a 386

                mov     dx,offset cpu_486       ;No, then it's a 486
                inc     errorlevel
                push    ecx                     ;Restore EFLAGS
                popfd

is_386:         mov     esp,ebx                 ;Restore ESP
;
; Display CPU type, set return code, and exit.
;
exit:           mov     ah,09h                  ;Display CPU type
                int     21h
                mov     ah,09h
                mov     dx,offset crlf
                int     21h
                mov     ah,4Ch                  ;Exit with ERRORLEVEL set
                mov     al,errorlevel           ;  indicating CPU type
                int     21h
main            endp

code            ends
                end     begin
