'============================================================================
'   LZSelect 1.0 (C) 1991 Ziff Communications Co.  PC Magazine  Jay Munro
'   Utility to write PMF files Setup utility (May 30 1989)
'============================================================================
DEFINT A-Z   'All variables are Integers unless noted otherwise

' -------- BASIC Subroutines
DECLARE SUB BarMenu (Item$())                'Menu for selections
DECLARE SUB ClrSc (Ulr, Ulc, Lrr, Lrc, Colr) 'Clear screen
DECLARE SUB CopyFont (FontName$, ID$, TP)    'Copies soft font to printer
DECLARE SUB DeleteInst ()                    'Deletes element from PV array
DECLARE SUB Editor (Text$, LeftCol, RightCol, NumOnly, CapsOn, KeyCode) 'Text editor
DECLARE SUB GetText (Text$, NumDig, NumOnly, CapsOnly) 'Text input routine
DECLARE SUB GetFileName (Filename$, Prompt$) 'Gets Filename of PMF file
DECLARE SUB GetNextItem ()                   'Gets Menu item names
DECLARE SUB HelpScreen ()                    'Help messages
DECLARE SUB InsertInst (Choice)              'Inserts elements into PV array
DECLARE SUB MenuData ()                      'Menu and ESCcode data
DECLARE SUB PrintEsc (Escape$)               'Prints Esc codes on screen
DECLARE SUB PromptInp (Code$)                'Prompts for user input on ESC codes
DECLARE SUB PromptLine (Message$, Flash)     'Standard prompt lines
DECLARE SUB SaveFile ()                      'PMF save routine
DECLARE SUB ScrollMenu (Item$(), AFlag, Choice) 'Printer item array
DECLARE SUB SetColors ()                     'Menu color routine
DECLARE SUB TestPrint (Flag)                 'Prints current line to printer
DECLARE SUB WaitTwo (Msg$)                   'Beeps, prints MSG and waits 2 sec

' -------- BASIC Functions
DECLARE FUNCTION AddCode$ (OldCode$, NewCode$)  'Adds newcode to string
DECLARE FUNCTION BuildLine$ ()                  'Builds complete code string
DECLARE FUNCTION GetDigit$ (X$, X)              'Returns user input
DECLARE FUNCTION OneKey% ()                     'Integer inkey routine
DECLARE FUNCTION YesNo% ()                      'Yes or No replies

' -------- Assembler Subroutines
DECLARE SUB QPrint (Text$, Colr)               'QuickPrint routine
DECLARE SUB MovBytes (BYVAL Segment1, BYVAL Address1, BYVAL Segment2, BYVAL Address2, BYVAL NumEls)

'These two functions are QB4 work-alikes for BASIC 7 keywords
'   and should not be included if compiled with BASIC 7.X
DECLARE FUNCTION Dir$ (Filename$)               'Checks if file exists
DECLARE FUNCTION CurDir$ ()                     'Returns current directory

TYPE RegTypeX                           ' Define the type needed for INTERUPTX
  AX    AS INTEGER
  BX    AS INTEGER
  CX    AS INTEGER
  DX    AS INTEGER
  BP    AS INTEGER                      'un-usable in call interrupt
  SI    AS INTEGER
  DI    AS INTEGER
  Flags AS INTEGER
  DS    AS INTEGER
  ES    AS INTEGER
END TYPE
DECLARE SUB INTERRUPTX (IntNum AS INTEGER, InReg AS RegTypeX, OutReg AS RegTypeX)

TYPE CArray                             'Control array for menus
  CH AS INTEGER                         '   choice
  Ky AS INTEGER                         '   key pressed in menu
  No AS INTEGER                         '   combined normal color
  Ho AS INTEGER                         '   combined highlight color
  Hl AS INTEGER                         '   combined color for help screen
  CM AS INTEGER                         '   current menu number
END TYPE

TYPE PMFArray                           'PMF control array
  CN AS INTEGER                         '   current PMF menu item
  Combine AS INTEGER                    '   flag to Combine like codes
  EscLen AS INTEGER                     '   length of current ESC string
  LastSaved AS INTEGER                  '   flag for last time file was saved
  MI AS INTEGER                         '   maximum instructions
  CI AS INTEGER                         '   current instructions
  Port AS INTEGER                       '   printer port
END TYPE

TYPE Value                              'Instruction value array
  MnuNum AS INTEGER                     '   menu number
  MnuChc AS INTEGER                     '   menu choice
END TYPE

' -------- Use BASIC's error checking
ON ERROR GOTO ErrorDept                 'Point to error routines

' -------- Dimension arrays
X = 13                                 'Up to 13 menus
DIM SHARED InReg AS RegTypeX, OutReg AS RegTypeX, Filename$, esc$, QT$
DIM SHARED MC AS CArray, PMF AS PMFArray, Menu$(X, X), EscCode$(X, X)
DIM SHARED MenuTitle$, MaxedOut$, ExistPrompt$
PMF.MI = 100                            'Maximum instruction number
esc$ = "27"                             'ESC character in Setup
MaxedOut$ = "Maximum instructions reached"  'multiple use strings
ExistPrompt$ = " exists, overwrite ? Y/N "
QT$ = CHR$(34)                          '"quote" character
PMF.Combine = 0                         'Combine codes off -- default
PMF.Port = INSTR(COMMAND$, "/2") + 1    'Set printer port to LPT1 or LPT2
REDIM SHARED PMFI$(PMF.MI, 2)           'PMF item array
REDIM SHARED PV(PMF.MI) AS Value        'Instruction value array
REDIM SHARED Title$(PMF.MI)             'Instruction menu item names
REDIM SHARED UsrText$(PMF.MI)           'User text input

'============================================================================
'                            Main program
'============================================================================

  WIDTH LPRINT 255                      'Keep QB from interfering with printing
  CALL SetColors                        'Check monitor type and set colors

' -------- Clear and build main screen
  CLS
  IF INSTR(COMMAND$, "/?") THEN
     QPrint "LZSelect 1.0  (C) 1991 Ziff Communications Co.    PC Magazine    Jay Munro  ", 7
     LOCATE 3, 1, 0
     QPrint "Command line syntax:", 7
     LOCATE 4, 1
     QPrint "LZSELECT [/F filename],[/2], [/B], [?]", 7
     LOCATE 6, 1
     QPrint "/F filename - specify SETUP file to write to", 7
     LOCATE 7, 1
     QPrint "/2 - specify LPT2 for printer testing", 7
     LOCATE 8, 1
     QPrint "/B - force monochrome colors ", 7
     LOCATE 9, 1
     QPrint "/? - this help message ", 7
     LOCATE 11, 1
     QPrint "Press a key to continue, ESC to end ", 7
     DO
       X = OneKey%
     LOOP UNTIL X
     IF X = 27 THEN GOTO ExitHere
  END IF
 
  CALL ClrSc(1, 1, 25, 80, MC.Ho)
  LOCATE 1, 1, 0
  QPrint "  LZSelect 1.0  (C) 1991 Ziff Communications Co.    PC Magazine    Jay Munro  ", MC.Ho
  LOCATE 24, 1, 0                       'Print items
  QPrint " F1 - Help  F2 - Next Set   F3 - Test Print  F4 - Download Font   F6 - Mode > I ", MC.Ho
  LOCATE 25, 1, 0
  QPrint " F7 - Delete Line  F8 - Insert line  F10 - Save to SETUP   Line length -        ", MC.Ho
  CALL ClrSc(2, 2, 23, 79, MC.No)
  FOR X = 2 TO 17                       'Create vertical line
    LOCATE X, 40
    QPrint CHR$(222), MC.Ho
  NEXT X
 
  LOCATE 19, 2, 0                       'Build input area
    QPrint STRING$(78, 223), MC.Ho
  LOCATE 17, 2, 0
    QPrint STRING$(78, 220), MC.Ho

' -------- Initialize some variables and check command line for file name
  CALL MenuData                         'Load menu choices and Esc codes
  PMF.CI = 1                            'Initialize current instruction = 1
  PMF.CN = 0                            'Set current menu line item
  X = INSTR(COMMAND$, "/F")             'Did they specify a file ?
  IF X THEN                             '  yes, then parse out the name
    X = X + 2                           '  compensate for /F
    Temp$ = LTRIM$(MID$(COMMAND$, X))   '  make a copy to work with
    Z = INSTR(Temp$, " ")               '  search for a trailing space
    IF Z THEN                           'If there is a /F then
      Filename$ = MID$(Temp$, 1, Z)     '  extract the file name
    ELSE                                '  if not, then
      Filename$ = Temp$                 '  the whole thing is the name
    END IF
  END IF
  DO
    CALL GetNextItem                      'Ask for line item name
    IF MC.Ky = 27 THEN
      PromptLine "Menu text line required -- please re-enter or press ESC to quit", 0
      DO
        X = OneKey
      LOOP UNTIL X
      IF X = 27 THEN GOTO ExitHere
    ELSE
      EXIT DO
    END IF
  LOOP
  LastChoice = 1                        'Start main menu at 1

' -------- Main menu input area
MainMenu:                               'Label for error return
DO
  MC.CM = 0                             'Menu 0 = main menu
  MC.CH = LastChoice                    'Initialize first choice
DO
  CALL BarMenu(Menu$())                 'Display Menu
  SELECT CASE MC.Ky                     'Key press

' -------- Item selected with RETURN
    CASE 13                             'Return -
      IF MC.CM = 0 THEN                 'If main menu then call others
        MC.CM = MC.CH                   ' assign current menu to choice
        LastChoice = MC.CH              ' remember where it was
        MC.CH = 1                       ' set choice to 1
      ELSE
        IF PMF.CI <= PMF.MI THEN        'If current instrucion is < max items
          PV(PMF.CI).MnuNum = MC.CM     'Assign current instructions
          PV(PMF.CI).MnuChc = MC.CH     '  to PV array
          CALL PromptInp(EscCode$(PV(PMF.CI).MnuNum, PV(PMF.CI).MnuChc))
          IF MC.Ky <> 27 THEN           'Build ESC code
            Temp$ = BuildLine$
            IF LEN(Temp$) < 255 THEN
              PMFI$(PMF.CN, 1) = Temp$  'Assign Esc code to current line
              CALL PrintEsc(PMFI$(PMF.CN, 1)) 'print it
              PMF.LastSaved = -1         'Change flag
            ELSE
              CALL WaitTwo(MaxedOut$)    'If Len(temp$) > 255 signal user
              PMF.CI = PMF.CI - 1        'Roll back counter that Buildline bumped
              PV(PMF.CI).MnuNum = 0      'Reset PV() array elements
              PV(PMF.CI).MnuChc = 0
              UsrText$(PMF.CI) = ""      'Clear title and user text items
              Title$(PMF.CI) = ""
              CALL ScrollMenu(Title$(), -1, Choice) 'Redisplay items less offending item
            END IF
          END IF
        ELSE
          CALL WaitTwo(MaxedOut$)        'Too many instructions
        END IF
      END IF
  
' -------- Escape or ALT Q  -  return to main menu or quit
    CASE 27, -16
      EXIT DO

' -------- F1 - display help screen
    CASE -59
      CALL HelpScreen

' -------- ALT F1 - Change Colors
   
    CASE -59
      


' -------- F2 - save current item and prompt for new one
    CASE -60
      PMFI$(PMF.CN, 1) = BuildLine$     ' build escape codes
      CALL PrintEsc(PMFI$(PMF.CN, 1))   ' print escape codes
      CALL GetNextItem                  ' get next instruction line
      IF MC.Ky <> 27 THEN               ' if valid line entered, then
        GOSUB ClearVars                 ' clear current work variables
      END IF
      EXIT DO                           ' return to main menu
   
' -------- F3 - test print of current set of items
    CASE -61
      CALL TestPrint(0)                 ' print to printer

' -------- F4, ALT F4 - Download font
    CASE -62, -107
      IF MC.Ky = -62 THEN TP = -1 ELSE TP = 0   'Temporary/permanent flag
      CALL GetFileName(FontFile$, "Font File ?")'Prompt for name
      IF MC.Ky <> 27 THEN                       ' continue if <> ESC
        IF LEN(Dir$(FontFile$)) THEN            ' does it exist?
          CALL PromptLine("Enter ID number ", 0)' yes, get an ID #
          ID$ = ""
          CALL GetText(ID$, 5, 1, 0)            ' call text routine
          IF MC.Ky <> 27 THEN                   ' continue if <> ESC
            CALL PromptLine("Copying font file ", -1)  ' signal what's happening
            CALL CopyFont(FontFile$, ID$, TP)          ' copy the file
          END IF
        ELSE
          CALL WaitTwo("Font file not found")        ' file not there
        END IF
      END IF
      CALL ClrSc(18, 2, 18, 78, MC.No)
  
' -------- F5 - view all Setup menu items (sorry no editing)
    CASE -63
      REDIM Temp$(PMF.CN)               ' clear temp array
      FOR X = 1 TO PMF.CN               ' assign elements
        Temp$(X) = PMFI$(X, 0)          ' for scrollmenu
      NEXT X
      CALL ScrollMenu(Temp$(), 0, Choice)      'Call scroll menu- ignore choice
      CALL ScrollMenu(Title$(), -1, Choice)    'Refresh instructions
  
' -------- F6 - toggle individual/combined escape code format
    CASE -64
      LOCATE 24, 79                     '  and locate the cursor
      IF PMF.Combine THEN               '  Check current status and
        QPrint "I", MC.Ho               '  print opposite
      ELSE
        QPrint "C", MC.Ho
      END IF
      PMF.Combine = ABS(PMF.Combine = -1) - 1 'Toggle the code
      PMFI$(PMF.CN, 1) = BuildLine$     'Assign Esc code to current line
      CALL PrintEsc(PMFI$(PMF.CN, 1))   'Print it
   
' -------- F7 - delete menu item line
    CASE -65
      CALL DeleteInst                   'Delete current instruction
      IF MC.Ky <> 27 THEN               'continue unless <ESC> pressed
        PMFI$(PMF.CN, 1) = BuildLine$   'Assign Esc code to current line
        CALL PrintEsc(PMFI$(PMF.CN, 1)) ' and print it
      END IF

' -------- Ctrl F7 - delete all menu items
    CASE -100                           'Ctrl F7
      CALL PromptLine("Are you sure you want to delete everything", -1)
      IF YesNo THEN
        PMF.CN = 0                      'Set current menu line item
        GOSUB ClearAllVars              'Clear all arrays
        CALL PrintEsc(PMFI$(PMF.CN, 1)) ' and print it
        CALL ScrollMenu(Title$(), 0, Choice)
        CALL GetNextItem                'Ask for line item name
      END IF
      CALL ClrSc(18, 2, 18, 78, MC.No)
  
' -------- ALT F7 - delete current set of menu commands
    CASE -110                           'Alt F7
      CALL PromptLine("Are you sure you want to delete this set of commands", -1)
      IF YesNo THEN
        GOSUB ClearVars
        PMFI$(PMF.CN, 0) = ""           'Clear current PMFI item
        PMFI$(PMF.CN, 1) = ""
        CALL PrintEsc(PMFI$(PMF.CN, 1))   ' and print it
        CALL ScrollMenu(Title$(), -1, Choice)
      END IF
      CALL ClrSc(18, 2, 18, 78, MC.No)
    
' -------- F8 - insert menu item line
     CASE -66
      IF MC.CM > 0 THEN                 'Insert only on sub menus
        DO
          IF LEN(EscCode$(MC.CM, MC.CH)) + PMF.EscLen + ABS((PMF.Combine + 1) * 9) < 255 THEN
            TCI = PMF.CI                'Save current instruction
            CALL InsertInst(Choice)
            IF MC.Ky = 27 THEN EXIT DO
            PV(Choice).MnuNum = MC.CM   'Assign current instructions
            PV(Choice).MnuChc = MC.CH   ' to PV array
            PMF.CI = Choice             'Point at choice
            CALL PromptInp(EscCode$(PV(PMF.CI).MnuNum, PV(PMF.CI).MnuChc))
            PMF.CI = TCI                'retrieve temp PMF.CI
            IF MC.Ky <> 27 THEN
              PMFI$(PMF.CN, 1) = BuildLine$   'Assign Esc code to current line
              CALL PrintEsc(PMFI$(PMF.CN, 1)) ' print it to the screen
              PMF.CI = PMF.CI + 1             ' increment current instruction
            END IF
          END IF
          EXIT DO
        LOOP
      END IF
   
' -------- F9 - print escape sequences to file
    CASE -67
      CALL TestPrint(-1)                ' print to file
   
' -------- F10 - save Setup file
    CASE -68
      CALL SaveFile
      EXIT DO
  
' -------- ALT F10 - save Setup file with new name
    CASE -113                           'ALT F10 - save file w/new name
      Filename$ = ""
      CALL SaveFile
      EXIT DO
  
' -------- Right Arrow - changes focus to scroll menu
    CASE -77
      CALL ScrollMenu(Title$(), 0, Choice)
   
    CASE ELSE
  END SELECT
LOOP
  IF MC.Ky = -16 THEN EXIT DO           'ALT Q - leave now
LOOP

' -------- Check if file has been saved recently
IF PMF.CI > 1 AND PMF.LastSaved THEN    'If current file hasn't been
  CALL PromptLine("Do you want to save changes? Y/N", -1) ' saved, then
  DO                                                      ' prompt for it
    X = OneKey
  LOOP UNTIL X
  IF X = 89 OR X = 121 THEN CALL SaveFile     '<Y> or <y>es
  IF X = 27 THEN                              ' Esc returns to main menu
    CALL ClrSc(18, 2, 18, 78, MC.No)          'Clear message first
    GOTO MainMenu                             '  and return to menu
  END IF
END IF

' -------- Exit
ExitHere:
  CLS                                   'Clean up at the end
END                                     'End of program

' -------- Routine to clear work variables
ClearAllVars:
  REDIM SHARED PMFI$(PMF.MI, 2)         'PMF item array

ClearVars:
  REDIM SHARED Title$(PMF.MI)           'Instruction menu item names
  REDIM SHARED PV(PMF.MI) AS Value      'Instruction value array
  REDIM SHARED UsrText$(PMF.MI)         'User text input
  PMF.CI = 1                            'Initialize current instruction = 1
  PMF.EscLen = 0                        'Clear escape seq length
  RETURN

' -------- Error trapping and messages
ErrorDept:
  SELECT CASE ERR
    CASE 63
      ErMsg$ = "File not found"
      Filename$ = ""
      PMF.LastSaved = -1         'Change flag
    CASE 64
      ErMsg$ = "Bad file name"
      Filename$ = ""
      PMF.LastSaved = -1         'Change flag
    CASE 70
      ErMsg$ = "Permission denied"
      PMF.LastSaved = -1         'Change flag
    CASE 71
      ErMsg$ = "Drive not ready"
      PMF.LastSaved = -1         'Change flag
    CASE 75
      ErMsg$ = "Path/file access error"
      Filename$ = ""
      PMF.LastSaved = -1         'Change flag
    CASE 5
      ErMsg$ = "Illegal function call"
    CASE 24
      ErMsg$ = "Printer not responding"
    CASE 25
      ErMsg$ = "Printer not ready"
    CASE 27
      ErMsg$ = "Printer out of paper"
    CASE ELSE
      ErMsg$ = "Error " + STR$(ERR)
  END SELECT
  CLOSE
  CALL WaitTwo(ErMsg$)
  RESUME MainMenu

FUNCTION AddCode$ (OldCode$, NewCode$)
' -------- Checks for like ESC codes and adds new code to existing string
IF LEN(NewCode$) THEN                   'Is NewCode valid?
  IF LEN(OldCode$) THEN                 ' yes, then do we have an old code?

' -------- Text input
    IF LEFT$(NewCode$, 1) = "" THEN
      AddCode$ = OldCode$ + "," + QT$ + MID$(NewCode$, 2) + QT$
    ELSE
      SELECT CASE NewCode$              'Check for special characters
' -------- Control character - no compression
        CASE "12", "13", "10"
          AddCode$ = OldCode$ + "," + NewCode$

' -------- Combine commands
        CASE ELSE
          Search$ = LEFT$(NewCode$, 2)  'Get Group and Parameterize characters
          X = INSTR(OldCode$, Search$)  'Have we had a similar command before
          IF X AND PMF.Combine THEN     'Yes, insert new one
            CodeOnly$ = MID$(NewCode$, 3)     'Extract parameters and terminator only
            Y = INSTR(X, OldCode$, CHR$(34))  'Find next Quote
            Temp$ = LEFT$(OldCode$, Y - 2) + LCASE$(MID$(OldCode$, Y - 1, 1))
            AddCode$ = Temp$ + CodeOnly$ + MID$(OldCode$, Y) 'Too many concat's for QB
          ELSE
            AddCode$ = OldCode$ + "," + esc$ + "," + QT$ + NewCode$ + QT$
          END IF
      END SELECT
    END IF
  ELSE

' -------- Text entry has the  character as a marker
    IF LEFT$(NewCode$, 1) = "" THEN
      AddCode$ = QT$ + MID$(NewCode$, 2) + QT$
    ELSE
      SELECT CASE NewCode$
      
' --------- Control characters
        CASE "10", "12", "13"
          AddCode$ = NewCode$

' --------- Just add the code verbatum
        CASE ELSE
          AddCode$ = esc$ + "," + QT$ + NewCode$ + QT$
        END SELECT
      END IF
    END IF
ELSE
' -------- No old codes, so just add it
  AddCode$ = OldCode$
END IF

END FUNCTION

SUB BarMenu (Item$()) STATIC

' -------- Initialize variables
  DO UNTIL MaxLen                       'Do this just once
    Left = 7                            'Location of menu on screen
    Top = 3
    MaxLen = 24                         'Set maximum length
  LOOP                                  'Maxlen is zero only once. . .
  
  TRow = CSRLIN                         'Save current row/col
  TCol = POS(0)
  
  Max = UBOUND(Item$, 2)                'Find upper bound of array
  DO UNTIL LEN(Item$(MC.CM, Max))       'Find actual end of array
    Max = Max - 1
    IF Max < 1 THEN EXIT SUB
  LOOP
  
  LastChoice = MC.CH                    'Set temporary choice for erasing
  CALL ClrSc(2, 4, 15, 35, MC.No)       'Clear the menu area

' -------- Print menu title
  LOCATE 2, 1 + Left + (MaxLen - LEN(Item$(MC.CM, 0))) \ 2
  QPrint "* " + Item$(MC.CM, 0) + " *", MC.No

' -------- Print items
  FOR X = 1 TO Max                      'Print items
    LOCATE Top + X, Left
    QPrint Item$(MC.CM, X) + SPACE$(MaxLen - LEN(Item$(MC.CM, X))), MC.No
  NEXT X
  GOSUB Highlight                       'Highlight first item

' -------- Wait for input and handle it
DO
  DO
    MC.Ky = OneKey                      'Get a keystroke
  LOOP UNTIL MC.Ky
  SELECT CASE MC.Ky
    CASE 13                             'Enter
      IF MC.CM THEN                     ' if menu is not main then exit
        EXIT SUB                        ' without clearing and with choice
      ELSE                              ' else
        EXIT DO                         ' clear screen and exit
      END IF
    CASE 27, -16                        'ESC, ALT Q
      EXIT DO                           ' clear screen and exit
    CASE -80                            'Down Arrow
      MC.CH = MC.CH + 1                 ' increment choice
      IF MC.CH > Max THEN MC.CH = 1     ' if over the top, then = 1
    CASE -72                            'Up Arrow
      MC.CH = MC.CH - 1                 ' decrement choice
      IF MC.CH < 1 THEN MC.CH = Max     ' if < 1 then = max
    CASE -71, -73                       'Home,PgUp
      MC.CH = 1
    CASE -79, -81                       'End,PgDn
      MC.CH = Max
    CASE IS < 0                         'Extended key
      EXIT SUB
    CASE ELSE
  END SELECT
  MC.Ky = 0
  GOSUB Highlight                             'Highlight new selections
LOOP
  CALL ClrSc(Top - 1, Left, Top + Max, Left + MaxLen + 3, MC.No)
  LOCATE TRow, TCol
EXIT SUB

' -------- Highlight by printing reverse color of item
Highlight:
  LOCATE Top + (LastChoice), Left       'Reprint old menu item with
    QPrint Item$(MC.CM, LastChoice) + SPACE$(MaxLen - LEN(Item$(MC.CM, LastChoice))), MC.No
  LOCATE Top + (MC.CH), Left            'Print new menu item with
    QPrint Item$(MC.CM, MC.CH) + SPACE$(MaxLen - LEN(Item$(MC.CM, MC.CH))), MC.Ho
  LastChoice = MC.CH                    'Reset last choice
RETURN

END SUB

FUNCTION BuildLine$

' -------- Build escape string for display or files
' -------- T is the top item number in the menu
  T = PMF.CI + (PMF.CI > PMF.MI)        'subtract one if greater than max
  FOR X = 1 TO T                        'Build Esc string
    IF PV(X).MnuNum = 0 AND PV(X).MnuChc = 0 THEN
    ELSE
      Temp$ = EscCode$(PV(X).MnuNum, PV(X).MnuChc)
      NewCode$ = GetDigit$(Temp$, X)
      Code$ = AddCode$(Code$, NewCode$)
      PMF.EscLen = LEN(Code$)
    END IF
  NEXT X

' -- Alternate ASCII characters are used as place holders for some of
'    the actual character so the combined ESC mode works correctly

' -------- Replace reset character code
    DO                                  'Loop to catch all occurences
      X = INSTR(Code$, "")             'Special case for reset
      IF X THEN MID$(Code$, X, 1) = "E" 'Replace with reset character
   LOOP WHILE X

' -------- Replace clear margin character
   DO                                   'Loop to catch all occurences
     X = INSTR(Code$, "")              'Special case for clear margins
     IF X THEN MID$(Code$, X, 1) = "9"  'Replace with '9' character
   LOOP WHILE X
   BuildLine$ = Code$                   'Assign function
END FUNCTION

SUB ClrSc (Ulr, Ulc, Lrr, Lrc, Colr) STATIC

' -------- Clears an area of a screen to a color
   New$ = "&h" + HEX$(Colr) + "00"            'Fake shift left
   IntNum = &H10                              'Interrupt 10h
   InReg.AX = &H600                           'Service 6
   InReg.BX = VAL(New$)                       'BH = color
   InReg.CX = (Ulr - 1) * 256 + (Ulc - 1)     'CL = column, CH = row
   InReg.DX = (Lrr - 1) * 256 + (Lrc - 1)     'DL = column, DH = row
   CALL INTERRUPTX(IntNum, InReg, OutReg)     'Call interrupt 10h

END SUB

SUB CopyFont (FontName$, ID$, TP)

' -------- Copies binary font file to printer and assign ID #
EC$ = CHR$(27)                          'Setup an escape character
DO
  Printer$ = "LPT" + LTRIM$(STR$(PMF.Port)) 'Build a LPT string
  OPEN Printer$ FOR BINARY AS #2         'Open printer as a file
  OPEN FontName$ FOR BINARY AS #3        'Open the font file also
  ID$ = LTRIM$(RTRIM$(ID$))              'Retrieve ID$
  Prefont$ = EC$ + "*c" + ID$ + "D"      'Tell printer which font # to use
  PUT 2, , Prefont$                      'Identify the font
  BufLen% = 4096                         'Buffer size to use
  Buffer$ = SPACE$(BufLen%)              'Set up copy buffer
  FileLen& = LOF(3)                      'Get length of font file

' -------- Get font data and copy to printer
DO
  IF FileLen& < BufLen% THEN Buffer$ = SPACE$(FileLen&)
  GET 3, , Buffer$                     ' Get & Put through buffer
  PUT 2, , Buffer$
  FileLen& = FileLen& - LEN(Buffer$)   'Adjust amount of font left
LOOP WHILE FileLen&                    'Keep going until end of file

' -------- If the font is to be permanent, then set it
IF TP THEN
   PostFont$ = EC$ + "*c5F"            'Make font permanent
   PUT 2, , PostFont$
 END IF
 CLOSE                                 'Close the files
 EXIT DO
LOOP
END SUB

FUNCTION CurDir$

'Important Note:                                
'QB 4, 4.5 & BASIC 6 use only -- BASIC 7 users delete this function

   DIM DTABuf AS STRING * 128           'create a DTA
   InReg.AX = &H1900                    'Function 19h - get current disk
   CALL INTERRUPTX(&H21, InReg, OutReg) 'current drive returns in AX
   Drive$ = CHR$(65 + (OutReg.AX AND &HFF)) + ":"
   InReg.AX = &H4700                     'Function 47h get current directory
   InReg.DX = ASC(Drive$) - 64           'Drive number 0=A,1=B etc...
   InReg.DS = VARSEG(DTABuf)             'Segment of buffer into DS
   InReg.SI = VARPTR(DTABuf)             'Address of buffer into SI
   CALL INTERRUPTX(&H21, InReg, OutReg)  'Make the call
                                         'Find last valid character
   FOR X = 64 TO 1 STEP -1               ' by looping and testing
     IF MID$(DTABuf, X, 1) <> CHR$(0) THEN EXIT FOR
   NEXT X

   IF X THEN                             'If other than root, assign it
     CurDir$ = Drive$ + "\" + LEFT$(DTABuf, X) 'Assign the function
   ELSE
     CurDir$ = Drive$                    'Otherwise assign just the drive
   END IF
END FUNCTION

SUB DeleteInst

'--------- Deletes an instruction line
  IF PMF.CI > 1 THEN                    'PMF.CI = 1 then nothing to delete
    CALL PromptLine("Delete which line ? ", 1)
    CALL ScrollMenu(Title$(), 0, Choice)'Get a choice from list
    CALL ClrSc(18, 2, 18, 78, MC.No)    'Clear prompt line
    IF Choice < 1 THEN EXIT SUB         'choice = 0
    IF MC.Ky = 13 THEN                  'Enter
      IF Choice < PMF.CI THEN
        FOR X = Choice TO PMF.MI - 1    'Start at current Choice
          SWAP PV(X), PV(X + 1)         'Move Choices down by one
          SWAP Title$(X), Title$(X + 1)
          SWAP UsrText$(X), UsrText$(X + 1)
        NEXT X
        Choice = X                      'Re-assign Choice to work below
      ELSEIF Choice > PMF.CI THEN       'If deleted Choice is greater
        EXIT SUB                        ' than number available, exit
      END IF
      PV(Choice).MnuNum = 0             'Top item get a zero
      PV(Choice).MnuChc = PV(Choice).MnuNum 'so does menu choice
      Title$(Choice) = ""               'Clear Title$
      UsrText$(Choice) = ""             '  and UsrText$
      PMF.CI = PMF.CI - 1               'fake out print routine
      CALL ScrollMenu(Title$(), -1, Choice)
    END IF
  END IF
END SUB

FUNCTION Dir$ (Filename$)
  'This function is only for QB4.x, and Basic 6.x -- Delete for Basic 7.x
  'Note, to trap critical errors like disk drive door open etc... with
  'OnError, this program must be linked with fixed version of QB.LIB
  'available as apnote # S12351 from Microsoft or on Compuserve
  'Using the shipped version could cause lockups.

  DIM Buffer  AS STRING * 64            'Allocate a buffer
  DIM TFile  AS STRING * 67             'Temp ASCII Z string for file
  InReg.AX = &H1A00                     'Tell DOS about it (service 1A)
  InReg.DS = VARSEG(Buffer)             'Set segment of Buffer
  InReg.DX = VARPTR(Buffer)             'Set offset of Buffer
  CALL INTERRUPTX(&H21, InReg, OutReg)  'Do it

  LSET TFile = LTRIM$(RTRIM$(Filename$)) 'Put filename into Z string
  InReg.AX = &H4E00                      'Service 4E find first file
  InReg.CX = 32                         'Find archive or regular files
  InReg.DS = VARSEG(TFile)              'DS = segment of TFile
  InReg.DX = VARPTR(TFile)              'DX = offset of TFile
  CALL INTERRUPTX(&H21, InReg, OutReg)  'Call it
  IF OutReg.Flags AND &H1 THEN          'Carry bit (bit 0 of flag register)
     Found = 0                          '   set, file not found
     Dir$ = ""                          '   Len(Dir$) = 0
  ELSE Found = -1                                                                '   clear, file found
     Dir$ = MID$(Buffer, &H1E)          '   Len(Dir$) = 99 due to
  END IF                                '   trailing CHR$(0)'s
END FUNCTION

SUB Editor (Text$, LeftCol, RightCol, NumOnly, CapsOn, KeyCode)
  '----- Find the cursor's size in Scan Lines
  DEF SEG = 0                                 'Peek at low memory to see
  IF PEEK(&H463) = &HB4 THEN                  'what type of monitor we have
    CsrSize = 12                              'Monochrome uses 13 scan lines
  ELSE                                        '  (numbered 0 to 12)
    CsrSize = 7                               'Color uses 8 (0 to 7)
  END IF
    DEF SEG

  Edit$ = SPACE$(RightCol - LeftCol + 1)      'Make a temporary string for
  LSET Edit$ = Text$                          '  editing

  TxtPos = POS(0) - LeftCol + 1               'Get the cursor's location to
  IF TxtPos < 1 THEN TxtPos = 1               '  see where to begin editing
  IF TxtPos > LEN(Edit$) THEN TxtPos = LEN(Edit$)

  LOCATE , LeftCol                            'Print the editing string
  QPrint Edit$, MC.Ho
  IF KeyCode = -79 THEN GOTO KeyTest          'Force end for file names
  '----- Main loop for handling key presses
  DO
    LOCATE , LeftCol + TxtPos - 1, 1          'Locate the cursor, turn it on
    DO                                        'Wait for a key press
      Ky$ = INKEY$
    LOOP UNTIL LEN(Ky$)

    IF LEN(Ky$) = 1 THEN                      'Make a key code from Ky$
       KeyCode = ASC(Ky$)                     'Single character key
    ELSE
       KeyCode = -ASC(RIGHT$(Ky$, 1))         'Extended keys are negative
    END IF

KeyTest:
    '----- Branch according to the key pressed
    SELECT CASE KeyCode
     
      CASE 8                              '----- Backspace
        TxtPos = TxtPos - 1               'Back up the text pointer
        LOCATE , LeftCol + TxtPos - 1, 0  'Locate 1 to the left
        IF TxtPos > 0 THEN                'Still within the field?
          IF LZInsert THEN                'Truncate the string
             MID$(Edit$, TxtPos) = MID$(Edit$, TxtPos + 1) + " "
          ELSE                            'Blank the letter
             MID$(Edit$, TxtPos) = " "
          END IF
          QPrint MID$(Edit$, TxtPos), MC.Ho 'Print the new part of text
        END IF
     
      CASE 13, 27                         '----- Enter or Escape
        EXIT DO                           'Bail out
     
      CASE 32 TO 254                      '----- Letter keys
        IF NumOnly THEN
          IF KeyCode < 48 OR KeyCode > 57 THEN
            IF KeyCode <> 45 AND KeyCode <> 43 AND KeyCode <> 46 THEN
              BEEP
              EXIT DO
            END IF
          END IF
        END IF
        IF CapsOn THEN Ky$ = UCASE$(Ky$)
        LOCATE , , 0                      'Turn the cursor off
        IF LZInsert THEN                  'Expand the text string
          MID$(Edit$, TxtPos) = Ky$ + MID$(Edit$, TxtPos)
          QPrint MID$(Edit$, TxtPos), MC.Ho'Print the expanded part
        ELSE
          MID$(Edit$, TxtPos) = Ky$       'Put the new letter in string
          QPrint Ky$, MC.Ho               'Print the letter
        END IF
          TxtPos = TxtPos + 1             'Increment the text pointer
     
      CASE -75                            '----- Left arrow
        TxtPos = TxtPos - 1               'Decrement the text pointer
    
      CASE -77                            '----- Right arrow
        TxtPos = TxtPos + 1               'Increment the text pointer
    
      CASE -71                            '----- Home
        TxtPos = 1                        'Move text pointer to 1

      CASE -79                            '----- End
        FOR N = LEN(Edit$) TO 1 STEP -1 'Look backwards for non-blank
          IF MID$(Edit$, N, 1) <> " " THEN EXIT FOR
        NEXT
        TxtPos = N + 1                    'Set pointer to last char +1
        IF TxtPos > LEN(Edit$) THEN TxtPos = LEN(Edit$)

      CASE -82                            '----- Insert key
        LZInsert = NOT LZInsert           'Toggle the Insert state
        IF LZInsert THEN                  'Adjust the cursor size
          LOCATE , , , CsrSize \ 2, CsrSize
        ELSE
          LOCATE , , , CsrSize - 1, CsrSize
        END IF
                                          '----- Delete
      CASE -83                            'Truncate the text
        MID$(Edit$, TxtPos) = MID$(Edit$, TxtPos + 1) + " "
        LOCATE , , 0                      'Print the truncated part
        QPrint MID$(Edit$, TxtPos), MC.Ho

      CASE ELSE                           'All other keys,
        EXIT DO                           ' bail out
    END SELECT

    LOOP UNTIL TxtPos < 1 OR TxtPos > LEN(Edit$) 'If cursor is out of field,
                                                 '  quit editing

    Text$ = RTRIM$(Edit$)                       'Trim the right side of text

END SUB

FUNCTION GetDigit$ (Code$, Index) STATIC  'Replace parameters in ESCcode$
 
  X = INSTR(Code$, "#")                   'Get position to replace
  X = X + INSTR(Code$, "")               'Get position to replace
  X = X + INSTR(Code$, "")               'Get position to replace
  IF INSTR(Code$, "") THEN Y = 3 ELSE Y = 2

  IF X THEN                               'If there is a # sign
    Temp$ = LEFT$(Code$, X - 1)           '  then save chars to the left
    T$ = LTRIM$(RTRIM$(UsrText$(Index)))  '  get input from before
    GetDigit$ = Temp$ + T$ + MID$(Code$, X + Y)  'Assign function to code
  ELSEIF INSTR(Code$, "") THEN           '  Just text flag
    GetDigit$ = UsrText$(Index)           '  get from text array
  ELSE
    GetDigit$ = Code$                     'If no input needed, then
  END IF                                  '  use incoming string
END FUNCTION

SUB GetFileName (FlName$, Prompt$)
  CALL PromptLine(Prompt$, 0)           'Prompt for file name
  LOCATE 18, 4 + LEN(Prompt$)
  IF FlName$ = "" THEN
     Text$ = CurDir$                    'Get current directory
     IF RIGHT$(Text$, 1) <> "\" THEN
        Text$ = Text$ + "\"             ' add back slash to end
     END IF
  ELSE
     Text$ = FlName$
  END IF
  MC.Ky = -79                           'Force an END key
  CALL GetText(Text$, 60, 0, 1)         'Max file len = 60, all caps
  IF MC.Ky <> 27 THEN                   'Anything but ESC
    CALL ClrSc(18, 2, 18, 79, MC.No)    'Clear the prompt area
    FOR X = 1 TO LEN(Text$)             'Squeeze out any spaces
      IF MID$(Text$, X, 1) <> CHR$(32) THEN Temp$ = Temp$ + MID$(Text$, X, 1)
    NEXT X
    FlName$ = Temp$                     'Assign the filename
  END IF
END SUB

SUB GetNextItem
  IF PMF.CN = PMF.MI THEN               'Warn if over 50 lines
    CALL PromptLine("Maximum Lines Reached Please save file", -1)
  ELSE
    P$ = "Enter menu text" + STR$(PMF.CN + 1)
    CALL PromptLine(P$, 0)
    LOCATE 18, 21
    CALL GetText(Temp$, 20, 0, 0)       '20 characters max
    IF MC.Ky <> 27 THEN                 'Unless ESC was pressed
      IF Temp$ <> "" THEN
        PMF.CN = PMF.CN + 1             'Increment current line
        PMFI$(PMF.CN, 0) = Temp$        'Assign text
        PMFI$(PMF.CN, 1) = ""           'Clear variable
        CALL ClrSc(20, 2, 23, 66, MC.No)'Clear ESC print area
        CALL ClrSc(2, 41, 16, 79, MC.No)
        Temp$ = "Current item:" + STR$(PMF.CN) + " " + Temp$    'Current line
        LOCATE 2, 61 - (LEN(Temp$) \ 2)     'Locate and print
        QPrint Temp$, MC.No
        PMF.CI = 1                      'Reset instruction pointer
        PMF.EscLen = 0                  'Reset esc code length
        CALL PrintEsc("")               'Clear print area
      ELSE
        MC.Ky = 27                      'make it look like ESC pressed
      END IF
    END IF
  END IF
  CALL ClrSc(18, 2, 18, 78, MC.No)
END SUB

SUB GetText (Text$, NumDig, NumOnly, CapsOn)  'text in routine
  TRow = CSRLIN                           'save current cursor position
  TCol = POS(0)
  LeftCol = TCol                          'Set left column for editing
  RightCol = LeftCol + NumDig - 1         'Ditto for right column
  LOCATE TRow                             'Set the line number for editing
  DO                                      'Edit the field
    CALL Editor(Text$, LeftCol, RightCol, NumOnly, CapsOn, MC.Ky)
    IF MC.Ky = -59 THEN CALL HelpScreen   'Call for help
  LOOP UNTIL MC.Ky = 13 OR MC.Ky = 27     'Do until Enter or Escape is pressed
  LOCATE TRow, TCol, 0                    ' and print to clear area
END SUB

SUB HelpScreen STATIC
' -------- Displays help screen
DIM ScrArray(2000)                      'Create an array to save it to
DIM Help$(20)
  DEF SEG = 0                           'Point default segment to 0 (low memory)

' -------- Check low memory to see what type of monitor is current
  IF PEEK(&H463) <> &HB4 THEN           'Color save screen
    DEF SEG                             'Set back to default segment
    PCOPY 0, 1                          'Copy current page to back page
    GOSUB HelpStuff                     ' Print our help message
    PCOPY 1, 0                          'Copy saved page back
  ELSE                                  'mono/hercules save screen
    DEF SEG
' -------- Copy screen into an integer array
    MovBytes &HB000, 0, VARSEG(ScrArray(0)), VARPTR(ScrArray(0)), 2000
    GOSUB HelpStuff
' -------- Copy integer array back to screen
    MovBytes VARSEG(ScrArray(0)), VARPTR(ScrArray(0)), &HB000, 0, 2000
  END IF
EXIT SUB

' -------- Hard code an array of help
HelpStuff:
   TCol = POS(0)                        'Preserve cursor location
   TRow = CSRLIN
   CALL ClrSc(3, 7, 20, 73, MC.Hl)      'Clear a nice area
    DO UNTIL LEN(Help$(20))             'Assign strings only once
    Help$(1) = "͵  LZSelect Help  ͻ"
    Help$(2) = "                                                                  "
    Help$(3) = " ESC - Main Menu or Cancel         F6 - Individual/Combined mode  "
    Help$(4) = " ALT Q - Quit LZSelect             F7 - Delete line               "
    Help$(5) = " F1 - Help                         Alt F7  - Clear menu item set  "
    Help$(6) = " F2 - Next SETUP menu item         Ctrl F7 - Clear all item sets  "
    Help$(7) = " F3 - Send line to printer         F8 - Insert line               "
    Help$(8) = " F4 - Download permanent font      F9 - Save Esc file             "
    Help$(9) = " Alt F4 - Download temporary font  F10 - Save current SETUP file  "
   Help$(10) = " F5 - View SETUP menu items        Alt F10 - Save new SETUP file  "
   Help$(11) = "   Right arrow switches from left to right menu to view items     "
   Help$(12) = "                                                                  "
   Help$(13) = "                           Fill patterns                          "
   Help$(14) = "                /////     \\\\\     ¿     /\/\/\      "
   Help$(15) = "                /////     \\\\\     Ŵ     \/\/\/      "
   Help$(16) = "                /////     \\\\\          /\/\/\      "
   Help$(17) = "       #1        #2       #3        #4        #5        #6        "
   Help$(18) = "  Horizontal  Vertical  Diagonal  Diagonal   Cross    Diagonal    "
   Help$(19) = "     Lines      Lines    Lines     Lines     Hatch     Hatch      "
   Help$(20) = "ͼ"
   LOOP
   FOR X = 1 TO 20                      'Print help$ array
      LOCATE 2 + X, 7, 0
      QPrint Help$(X), MC.Hl
   NEXT X
   DO                                   'Wait for a key press
   LOOP UNTIL OneKey
   LOCATE TRow, TCol, 0                 'Put cursor back
RETURN
END SUB

SUB InsertInst (Choice) STATIC
IF PMF.CI > 1 THEN                       'PMF.CI = 1 then nothing to delete
  CALL PromptLine("Insert at which line ? ", 1)
  CALL ScrollMenu(Title$(), 0, Choice)
  CALL ClrSc(18, 2, 18, 78, MC.No)
  IF MC.Ky = 13 THEN
    IF Choice < PMF.CI THEN
      FOR X = PMF.CI TO (Choice + 1) STEP -1  'Start at current Choice
        SWAP PV(X), PV(X - 1)            'Swap-faster than assignments
        SWAP Title$(X), Title$(X - 1)
        SWAP UsrText$(X), UsrText$(X - 1)
      NEXT X
    ELSEIF Choice > PMF.CI THEN          'If inserted Choice is greater
      EXIT SUB                           ' than number available, exit
    END IF
  END IF
END IF

END SUB

SUB MenuData
'============================================================================
'Format for ESC codes:
'                                   "&l#3L"
' Group and parameterized identifier  / || \termination character (always caps)
' code that parameters will be inserted/  \ maximum number of digits allowed
' Above Esc code will have # replaced by up to 3 characters
'============================================================================
' Menu selections
'============================================================================

Menu$(0, 0) = "Main Menu"
Menu$(0, 1) = "Job Control":
Menu$(0, 2) = "Page Control":
Menu$(0, 3) = "Standard Font Setups":
Menu$(0, 4) = "Font Selection":
Menu$(0, 5) = "Lines Per Inch":
Menu$(0, 6) = "Font Style":
Menu$(0, 7) = "Paper Source":
Menu$(0, 8) = "Macros"
Menu$(0, 9) = "Cursor and Text "
Menu$(0, 10) = "Print Direction & Model":
Menu$(0, 11) = "LaserJet III Fonts":
Menu$(0, 12) = "Rectangular Fills"
Menu$(0, 13) = "Set Font Attributes"

Menu$(1, 0) = Menu$(0, 1)
Menu$(1, 1) = "Printer Reset":         EscCode$(1, 1) = ""
Menu$(1, 2) = "Portrait":              EscCode$(1, 2) = "&l0O"
Menu$(1, 3) = "Landscape":             EscCode$(1, 3) = "&l1O"
Menu$(1, 4) = "Number of Copies":      EscCode$(1, 4) = "&l#2X"
Menu$(1, 5) = "Line Wrap On":          EscCode$(1, 5) = "&s0C"
Menu$(1, 6) = "Line Wrap Off":         EscCode$(1, 6) = "&s1C"
Menu$(1, 7) = "Perf Skip On":          EscCode$(1, 7) = "&l1L"
Menu$(1, 8) = "Perf Skip Off":         EscCode$(1, 8) = "&l0L"
Menu$(1, 9) = "Left Offset in 1/720":  EscCode$(1, 9) = "&l#5U"
Menu$(1, 10) = "Top Offset in 1/720":  EscCode$(1, 10) = "&l#5Z"
Menu$(1, 11) = "Display Function On":  EscCode$(1, 11) = "Y"
Menu$(1, 12) = "Display Function Off": EscCode$(1, 12) = "Z"

Menu$(2, 0) = Menu$(0, 2)
Menu$(2, 1) = "Clear Horiz Margins":   EscCode$(2, 1) = ""     '9
Menu$(2, 2) = "Left Margin":           EscCode$(2, 2) = "&a#3L"
Menu$(2, 3) = "Right Margin":          EscCode$(2, 3) = "&a#3M"
Menu$(2, 4) = "Top Margin":            EscCode$(2, 4) = "&l#3E"
Menu$(2, 5) = "Text Length":           EscCode$(2, 5) = "&l#3F"
Menu$(2, 6) = "Page Feed":             EscCode$(2, 6) = "12"
Menu$(2, 7) = "Eject Page":            EscCode$(2, 7) = "&l0H"
                                       
Menu$(3, 0) = Menu$(0, 3)
Menu$(3, 1) = "Portrait 10cpi":        EscCode$(3, 1) = "(s0p10H"
Menu$(3, 2) = "Portrait 12cpi":        EscCode$(3, 2) = "(s0p12H"
Menu$(3, 3) = "Portrait 16cpi":        EscCode$(3, 3) = "(s0p16.66H"
Menu$(3, 4) = "Landscape 10cpi":       EscCode$(3, 4) = "&l1o5.45C" + QT$ + ",27," + QT$ + "(s0p10H"
Menu$(3, 5) = "Landscape 12cpi":       EscCode$(3, 5) = "&l1o5.45C" + QT$ + ",27," + QT$ + "(s0p12H"
Menu$(3, 6) = "Landscape 16cpi":       EscCode$(3, 6) = "&l1o5.45C" + QT$ + ",27," + QT$ + "(s0p16.66H"
                                       
Menu$(4, 0) = Menu$(0, 4)
Menu$(4, 1) = "Courier":               EscCode$(4, 1) = "(s3T"
Menu$(4, 2) = "Line Printer":          EscCode$(4, 2) = "(s0T"
Menu$(4, 3) = "10 Pitch":              EscCode$(4, 3) = "(s10H"
Menu$(4, 4) = "12 Pitch":              EscCode$(4, 4) = "(s12H"
Menu$(4, 5) = "16.66 Pitch":           EscCode$(4, 5) = "(s16.66H"
Menu$(4, 6) = "Set pitch":             EscCode$(4, 6) = "(s#5H"
Menu$(4, 7) = "Helv":                  EscCode$(4, 7) = "(s4T"
Menu$(4, 8) = "TmsRmn":                EscCode$(4, 8) = "(s5H"
Menu$(4, 9) = "Typeface Family":       EscCode$(4, 9) = "(s#4T"
Menu$(4, 10) = "Set Point Size":       EscCode$(4, 10) = "(s#4V"
Menu$(4, 11) = "Soft Font ID #":       EscCode$(4, 11) = "(#4X"
                                       
Menu$(5, 0) = Menu$(0, 5)
Menu$(5, 1) = "4 Lines per inch":      EscCode$(5, 1) = "&l4D"
Menu$(5, 2) = "6 Lines per inch":      EscCode$(5, 2) = "&l6D"
Menu$(5, 3) = "8 Lines per inch":      EscCode$(5, 3) = "&l8D"
Menu$(5, 4) = "12 Lines per inch":     EscCode$(5, 4) = "&l12D"
Menu$(5, 5) = "16 Lines per inch":     EscCode$(5, 5) = "&l16D"
Menu$(5, 6) = "24 Lines per inch":     EscCode$(5, 6) = "&l24D"
Menu$(5, 7) = "48 Lines per inch":     EscCode$(5, 7) = "&l48D"
Menu$(5, 8) = "Page Length":           EscCode$(5, 8) = "&l#3P"
                                       
Menu$(6, 0) = Menu$(0, 6)
Menu$(6, 1) = "Light":                 EscCode$(6, 1) = "(s-3B"
Menu$(6, 2) = "Normal":                EscCode$(6, 2) = "(s0B"
Menu$(6, 3) = "Bold":                  EscCode$(6, 3) = "(s3B"
Menu$(6, 4) = "Underline On":          EscCode$(6, 4) = "&d0D"
Menu$(6, 5) = "Floating Underline":    EscCode$(6, 5) = "&d3D"
Menu$(6, 6) = "Underline Off":         EscCode$(6, 6) = "&d@"
Menu$(6, 7) = "Upright":               EscCode$(6, 7) = "(s0S"
Menu$(6, 8) = "Italic":                EscCode$(6, 8) = "(s1S"
Menu$(6, 9) = "PC-8 Symbol Set":       EscCode$(6, 9) = "(10U"
Menu$(6, 10) = "Roman 8 Symbol Set":   EscCode$(6, 10) = "(8U"
Menu$(6, 11) = "Set Symbol Set":       EscCode$(6, 11) = "(#4"

Menu$(7, 0) = Menu$(0, 7)
Menu$(7, 1) = "Executive":             EscCode$(7, 1) = "&l1A"
Menu$(7, 2) = "Letter":                EscCode$(7, 2) = "&l2A"
Menu$(7, 3) = "Legal":                 EscCode$(7, 3) = "&l3A"
Menu$(7, 4) = "A4":                    EscCode$(7, 4) = "&l26A"
Menu$(7, 5) = "Monarch Envelope":      EscCode$(7, 5) = "&l80A"
Menu$(7, 6) = "COM 10 Envelope":       EscCode$(7, 6) = "&l81A"
Menu$(7, 7) = "DL Envelope":           EscCode$(7, 7) = "&l90A"
Menu$(7, 8) = "C5 Envelope":           EscCode$(7, 8) = "&l91A"
Menu$(7, 9) = "Paper Tray":            EscCode$(7, 9) = "&l1H"
Menu$(7, 10) = "Manual Feed":          EscCode$(7, 10) = "&l2H"
Menu$(7, 11) = "Envelope Feed":        EscCode$(7, 11) = "&l3H"
Menu$(7, 12) = "Lower Tray Feed IIP":  EscCode$(7, 12) = "&l4H"
                                       
Menu$(8, 0) = Menu$(0, 8)
Menu$(8, 1) = "Start Macro #":         EscCode$(8, 1) = "&f#5y0X"
Menu$(8, 2) = "End Temp Macro":        EscCode$(8, 2) = "&f1x9X"
Menu$(8, 3) = "End Perm Macro":        EscCode$(8, 3) = "&f1x10X"
Menu$(8, 4) = "Set New Macro #":       EscCode$(8, 4) = "&f#5Y"
Menu$(8, 5) = "Execute Macro #":       EscCode$(8, 5) = "&f#5y2X"
Menu$(8, 6) = "Call Macro #":          EscCode$(8, 6) = "&f#5y3X"
Menu$(8, 7) = "Enable Overlay #":      EscCode$(8, 7) = "&f#5y4X"
Menu$(8, 8) = "Disable Overlay #":     EscCode$(8, 8) = "&f#5y5X"
Menu$(8, 9) = "Delete All Macros":     EscCode$(8, 9) = "&f6X"
Menu$(8, 10) = "Delete Temp Macros":   EscCode$(8, 10) = "&f7X"
Menu$(8, 11) = "Delete One Macro #":   EscCode$(8, 11) = "&f#5y8X"
                                       
Menu$(9, 0) = Menu$(0, 9)
Menu$(9, 1) = "Horiz Pos'n - Dots":     EscCode$(9, 1) = "*p#5X"
Menu$(9, 2) = "Horiz Pos'n - Columns":  EscCode$(9, 2) = "&a#4C"
Menu$(9, 3) = "Horiz Pos'n - Decip'ts": EscCode$(9, 3) = "&a#5H"
Menu$(9, 4) = "Vert Pos'n - Dots":      EscCode$(9, 4) = "*p#5Y"
Menu$(9, 5) = "Vert Pos'n - Rows":      EscCode$(9, 5) = "&a#4R"
Menu$(9, 6) = "Horiz Pos'n - Decip'ts": EscCode$(9, 6) = "&a#5V"
Menu$(9, 7) = "Push Cursor":            EscCode$(9, 7) = "&f0S"
Menu$(9, 8) = "Pop Cursor":             EscCode$(9, 8) = "&f1S"
Menu$(9, 9) = "Half Line Feed":         EscCode$(9, 9) = "="
Menu$(9, 10) = "Full Line Feed":        EscCode$(9, 10) = "10"
Menu$(9, 11) = "Carriage Return":       EscCode$(9, 11) = "13"
Menu$(9, 12) = "Enter Text":            EscCode$(9, 12) = ""

Menu$(10, 0) = Menu$(0, 10)
Menu$(10, 1) = "Rotate 0   ":         EscCode$(10, 1) = "&a0P"
Menu$(10, 2) = "Rotate 90  ":         EscCode$(10, 2) = "&a90P"
Menu$(10, 3) = "Rotate 180 ":         EscCode$(10, 3) = "&a180P"
Menu$(10, 4) = "Rotate 270 ":         EscCode$(10, 4) = "&a270P"
Menu$(10, 5) = "Source Transparent":   EscCode$(10, 5) = "*v0N"
Menu$(10, 6) = "Source Opaque":        EscCode$(10, 6) = "*v1N"
Menu$(10, 7) = "Pattern Transparent":  EscCode$(10, 7) = "*v0O"
Menu$(10, 8) = "Pattern Opaque":       EscCode$(10, 8) = "*v1O"
Menu$(10, 9) = "Pattern - Black":      EscCode$(10, 9) = "*v0T"
Menu$(10, 10) = "Pattern - White":     EscCode$(10, 10) = "*v1T"
Menu$(10, 11) = "Pattern - Shading":   EscCode$(10, 11) = "*v2T"
Menu$(10, 12) = "Pattern - Cross Hatch": EscCode$(10, 12) = "*v3T"

Menu$(11, 0) = Menu$(0, 11)
Menu$(11, 1) = "Font size":            EscCode$(11, 1) = "(s#3V"
Menu$(11, 2) = "Univers":              EscCode$(11, 2) = "(10U" + QT$ + ",27," + QT$ + "(s1p#3v0s0b4148T"
Menu$(11, 3) = "CG Times":             EscCode$(11, 3) = "(10U" + QT$ + ",27," + QT$ + "(s1p#3v0s0b4101T"
Menu$(11, 4) = "Univers Bold":         EscCode$(11, 4) = "(10U" + QT$ + ",27," + QT$ + "(s1p#3v0s3b4148T"
Menu$(11, 5) = "CG Times Bold":        EscCode$(11, 5) = "(10U" + QT$ + ",27," + QT$ + "(s1p#3v0s3b4101T"
Menu$(11, 6) = "Univers Italic":       EscCode$(11, 6) = "(10U" + QT$ + ",27," + QT$ + "(s1p#3v1s0b4148T"
Menu$(11, 7) = "CG Times Italic":      EscCode$(11, 7) = "(10U" + QT$ + ",27," + QT$ + "(s1p#3v1s0b4101T"
Menu$(11, 8) = "Univers Bold Italic":  EscCode$(11, 8) = "(10U" + QT$ + ",27," + QT$ + "(s1p#3v1s3b4148T"
Menu$(11, 9) = "CG Times Bold Italic": EscCode$(11, 9) = "(10U" + QT$ + ",27," + QT$ + "(s1p#3v1s3b4101T"

Menu$(12, 0) = Menu$(0, 12)
Menu$(12, 1) = "Horiz Size-Dots":      EscCode$(12, 1) = "*c#4A"
Menu$(12, 2) = "Horiz Size-Deci Pts":  EscCode$(12, 2) = "*c#4H"
Menu$(12, 3) = "Vert Size-Dots":       EscCode$(12, 3) = "*c#4B"
Menu$(12, 4) = "Vert Size-Deci Pts":   EscCode$(12, 4) = "*c#4V"
Menu$(12, 5) = "Fill Shade 1 - 100%":  EscCode$(12, 5) = "*c#3G"
Menu$(12, 6) = "HP Pattern 1 - 6 ":    EscCode$(12, 6) = "*c#1G "
Menu$(12, 7) = "Fill Black":           EscCode$(12, 7) = "*c0P"
Menu$(12, 8) = "Fill White (IIP-III)": EscCode$(12, 8) = "*c1P"
Menu$(12, 9) = "Fill Shading":         EscCode$(12, 9) = "*c2P"
Menu$(12, 10) = "Fill Pattern":        EscCode$(12, 10) = "*c3P"

Menu$(13, 0) = Menu$(0, 13)
Menu$(13, 1) = "Symbol Set ":          EscCode$(13, 1) = "(4"
Menu$(13, 2) = "Spacing Fixed":        EscCode$(13, 2) = "(s0P"
Menu$(13, 3) = "Spacing Prop":         EscCode$(13, 3) = "(s1P"
Menu$(13, 4) = "Pitch (Fixed Only)":   EscCode$(13, 4) = "(s#5H"
Menu$(13, 5) = "Height":               EscCode$(13, 5) = "(s#5V"
Menu$(13, 6) = "Style":                EscCode$(13, 6) = "(s#3S"
Menu$(13, 7) = "Stroke Weight":        EscCode$(13, 7) = "(s#2B"
Menu$(13, 8) = "Escape Sequence":      EscCode$(13, 8) = "50"
 
END SUB

FUNCTION OneKey%

' -------- Onekey is polled in a loop, so there is no waiting here
  A$ = INKEY$                           'If a key was pressed, process it
  X = LEN(A$)
  IF X THEN
    IF X = 2 THEN                       ' extended keys have a LEN of 2
      OneKey% = ASC(RIGHT$(A$, 1)) * -1 ' create negative of ASCII value
    ELSE
      OneKey% = ASC(A$)                 ' or return ASCII of character                                        ' all others just ASCII values
    END IF
  ELSE
    OneKey% = 0                         'ASC(0) is illegal, so do this
  END IF
END FUNCTION

SUB PrintEsc (Escape$)

' -------- Print Escape$ in lower screen area
  CALL ClrSc(20, 2, 23, 78, MC.No)      'Clear print area
  X = 0
  Max = 64
' -------- Test length of string, if greater than 255 don't print
'          otherwise break into 4 strings of 64 chars each
  IF PMF.EscLen < 256 THEN              '255 char maximum
    IF PMF.EscLen > Max THEN
      DO
        LOCATE 20 + X, 8
        QPrint MID$(Escape$, Max * X + 1, Max), MC.No
        X = X + 1
      LOOP WHILE LEN(MID$(Escape$, Max * X + 1, Max))
    ELSE
      LOCATE 20, 8
      QPrint Escape$, MC.No
    END IF
  ELSE
    CALL WaitTwo(MaxedOut$)             'too many chars
  END IF
 
  LOCATE 25, 75, 0                     'print length of escape code
  QPrint SPACE$(4), MC.Ho              'clear old number
  QPrint STR$(PMF.EscLen), MC.Ho       'print new one

END SUB

SUB PromptInp (PCode$)

' -------- Prompts for user input on ESC codes that require it
  TRow = CSRLIN                               '  save current cursor position
  TCol = POS(0)
  X = INSTR(PCode$, "#")                          'Test for replaceable parameters
  CapsCode% = 1
  NumDigits% = 1
 
  IF X THEN
    NumCode% = 1                                  'numbers only
  ELSE
    X = INSTR(PCode$, "")                        'Test for replaceable parameters
    IF X THEN
      NumCode% = 0                                'alpha
    ELSE
      X = INSTR(PCode$, "")
      IF X THEN
        NumCode% = 0
        CapsCode% = 0
        NumDigits% = 2
      END IF
    END IF

  END IF

  IF X THEN                                     'If user input needed then
    Prompt$ = RTRIM$(Menu$(PV(PMF.CI).MnuNum, PV(PMF.CI).MnuChc))
    CALL PromptLine(Prompt$, 0)
    LOCATE 18, 4 + LEN(Prompt$)
    CALL GetText(UsrText$(PMF.CI), VAL(MID$(PCode$, X + 1, NumDigits%)), NumCode%, CapsCode%) 'Call input routine
    IF LEN(UsrText$(PMF.CI)) THEN
      IF MC.Ky <> 27 THEN                       '  save info unless ESC was pressed
        Title$(PMF.CI) = LEFT$(RTRIM$(Menu$(PV(PMF.CI).MnuNum, PV(PMF.CI).MnuChc)) + " " + UsrText$(PMF.CI), 29)
        CALL ScrollMenu(Title$(), -1, X)        'Print all current instructions
        PMF.CI = PMF.CI + 1                     '  point to next instruction
      END IF
    ELSE
      MC.Ky = 27
    END IF
    CALL ClrSc(18, 2, 18, 78, MC.No)            'Clear user prompt
    LOCATE TRow, TCol, 0
  ELSEIF INSTR(PCode$, "") THEN                'Test for replaceable parameters
    X = INSTR(PCode$, "")                      'Test for replaceable parameters
    Prompt$ = RTRIM$(Menu$(PV(PMF.CI).MnuNum, PV(PMF.CI).MnuChc))
    CALL PromptLine(Prompt$, 0)
    LOCATE 18, 4 + LEN(Prompt$)
    Temp1 = (252 - PMF.EscLen)                  ' how manu characters can we fit?
      DO
        IF Temp1 > 60 THEN                      ' is there at least 60 chars
          Temp = 60                             ' yes than get 60
        ELSEIF Temp1 > 0 THEN                   ' well, at least 1 character
          Temp = Temp1                          ' the difference
        ELSE
          MC.Ky = 27                            ' if too small, get out
          EXIT DO
        END IF
        CALL GetText(T$, Temp, 0, 0)            'Call input routine
        IF LEN(T$) THEN
          IF MC.Ky <> 27 THEN                   'Save info unless ESC was pressed
            UsrText$(PMF.CI) = "" + T$
            Title$(PMF.CI) = RTRIM$(Menu$(PV(PMF.CI).MnuNum, PV(PMF.CI).MnuChc))
            CALL ScrollMenu(Title$(), -1, X)    'Print all current instructions
            PMF.CI = PMF.CI + 1                 '  point to next instruction
          END IF
        ELSE
          MC.Ky = 27
        END IF
        EXIT DO
      LOOP
      CALL ClrSc(18, 2, 18, 78, MC.No)          'Clear user prompt
      LOCATE TRow, TCol, 0
  ELSE                                          'If no input needed
    Title$(PMF.CI) = RTRIM$(Menu$(PV(PMF.CI).MnuNum, PV(PMF.CI).MnuChc)) ' save code
    CALL ScrollMenu(Title$(), -1, X)            'Print all current instructions
    PMF.CI = PMF.CI + 1                         ' point to next instruction
  END IF
END SUB

SUB PromptLine (Message$, Flash) STATIC

' -------- Prints message either with flashing color, or constant
  CALL ClrSc(18, 2, 18, 78, MC.No)      'clear prompt area
  IF Flash THEN                         'do we flash the message?
    Colr = MC.No OR 128                 'turn on High bit of background
  ELSE
    Colr = MC.No                        'use normal color
  END IF
  LOCATE 18, 3, 0
  QPrint Message$, Colr                 'print message
END SUB

SUB SaveFile STATIC

' -------- PMF file save routine
  IF PMF.CI > 1 THEN                    'Make sure all codes are included
    PMFI$(PMF.CN, 1) = BuildLine$       'Assign Esc code to current line
    CALL PrintEsc(PMFI$(PMF.CN, 1))     'print it
  END IF

' -------- Request file name, using current directory as default
PromptForFile:
DO
  IF RIGHT$(Filename$, 1) = "\" OR Filename$ = "" THEN  'Just path, no file
    CALL GetFileName(Filename$, "PMF File Name")
  ELSEIF LEN(Dir$(Filename$)) THEN      'Check if it exists
    CALL PromptLine(Filename$ + ExistPrompt$, -1)
    IF YesNo THEN EXIT DO
       CALL GetFileName(Filename$, "PMF File Name")
  ELSE
      EXIT DO
  END IF
LOOP UNTIL MC.Ky = 27

  IF MC.Ky = 27 THEN                    'user pressed Escape
    CALL ClrSc(18, 2, 18, 78, MC.No)
    EXIT SUB
  END IF

' -------- Ask for a title for the menu being saved
  IF MenuTitle$ = "" THEN
     MenuTitle$ = "Hewlett Packard LaserJet"  'Default title
  END IF
  LOCATE 18, 2
  QPrint "Enter title or <ENTER> for default ", MC.No
  LOCATE , 37
  CALL GetText(MenuTitle$, 26, 0, 0)    'text routine
  IF MC.Ky <> 27 THEN
    CALL ClrSc(18, 2, 18, 78, MC.No)
    PMF.LastSaved = 0                   'Clear last saved flag

' -------- Open file and save escape strings
    OPEN Filename$ FOR OUTPUT AS #1
    A$ = "#"                            'print header rem character
    PRINT #1, A$; STRING$(40, 61)       'string of '='s
    PRINT #1, A$; " HP Laserjet Make File"
    PRINT #1, A$; " Copyright (c) 1990 Ziff Communications"
    PRINT #1, A$; " Created by LZSelect 1.0"
    PRINT #1, A$; STRING$(40, 61)
    PRINT #1, MenuTitle$
    B$ = A$ + STRING$(40, 45)
    FOR X = 1 TO PMF.CN                 'Print instructions to file
      IF X MOD 10 = 0 THEN PRINT #1, B$ '  with a break every 10
      IF PMFI$(X, 0) <> "" AND PMFI$(X, 1) <> "" THEN 'skip blanks
        PRINT #1, PMFI$(X, 0); CHR$(59); 'Print menu text
        PRINT #1, TAB(25); LEFT$(PMFI$(X, 1), 256) 'print ESC codes
      END IF
    NEXT
    CLOSE #1                            'close Setup File
  ELSE
    CALL ClrSc(18, 2, 18, 78, MC.No)
  END IF
END SUB

SUB ScrollMenu (Item$(), AFlag, Choice) STATIC

' -------- Menu to show more than 10 items
  DO UNTIL MaxLen                       'Do it once
    TopLine = 4
    MaxLen = 29                         'Maximum length of Item$
  LOOP
  Max = UBOUND(Item$)                   'Find upper bound of array
  CALL ClrSc(4, 45, 16, 78, MC.No)      'Clear instruction area
  DO WHILE LEN(Item$(Max)) = 0          'Find actual end of array
    Max = Max - 1
    IF Max < 1 THEN EXIT SUB
  LOOP
  
  TopEl = Max

' -------- Update display of total items
  LOCATE 16, 50, 0
  QPrint "Total Items " + STR$(Max), MC.No

' -------- Find top group of 10 for starting point
  Start = 1 + (ABS(Max > 10) * (Max - 10))
  Choice = Start
  TChoice = Choice
  GOSUB Display
  IF AFlag THEN EXIT SUB
    GOSUB HiLite
  DO
    DO
      MC.Ky = OneKey
    LOOP UNTIL MC.Ky
    SELECT CASE MC.Ky
      CASE -80                     'down arrow
        Choice = Choice + 1
        IF Choice > TopEl THEN
          IF TopEl < Max THEN
            TopEl = TopEl + 1
            Start = Start + 1
            Choice = TopEl
            GOSUB Display
          ELSEIF Choice > Max THEN
            Choice = Max
          END IF
        END IF
      CASE -72                  'up arrow
        Choice = Choice - 1
        IF Choice < Start THEN
          IF Start > 1 THEN
            Start = Start - 1
            TopEl = TopEl - 1
            Choice = Start
            GOSUB Display
          ELSEIF Choice < 1 THEN
            Choice = 1
          END IF
        END IF
      CASE 27, -75                    'ESC, left arrow
        Choice = 0
        EXIT DO
      CASE 13
        EXIT DO
      CASE ELSE
    END SELECT
    GOSUB HiLite
  LOOP
  GOSUB UnHilite
EXIT SUB

Display:
  Y = 0
  FOR X = Start TO TopEl
    LOCATE TopLine + Y, 45, 0
    QPrint LTRIM$(STR$(X)) + ": " + Item$(X) + SPACE$(MaxLen - LEN(Item$(X))), MC.No
    Y = Y + 1
  NEXT X
RETURN

UnHilite:
  LOCATE TopLine + (TChoice - Start), 45, 0
  QPrint LTRIM$(STR$(TChoice)) + ": " + Item$(TChoice) + SPACE$(MaxLen - LEN(Item$(TChoice))), MC.No
RETURN

HiLite:
  GOSUB UnHilite
  LOCATE TopLine + (Choice - Start), 45, 0
  QPrint LTRIM$(STR$(Choice)) + ": " + Item$(Choice) + SPACE$(MaxLen - LEN(STR$(Choice) + ": " + Item$(Choice))), MC.Ho
  TChoice = Choice
RETURN
  
END SUB

SUB SetColors STATIC
' -------- Set colors of menu and prompts
CNFFile$ = "LZSelect.CNF"

IF LEN(Dir$(CNFFile$)) THEN
   OPEN CNFFile$ FOR INPUT AS #5
   LINE INPUT #5, X$
   MC.No = VAL(LEFT$(X$, 3))
   LINE INPUT #5, X$
   MC.Ho = VAL(LEFT$(X$, 3))
   LINE INPUT #5, X$
   MC.Hl = VAL(LEFT$(X$, 3))
   CLOSE #5
ELSE
  DEF SEG = 0
  IF PEEK(&H463) = &HB4 OR INSTR(COMMAND$, "/B") THEN  'mono
    MC.No = 7                           ' white on black
    MC.Ho = 112                         ' black on white
    MC.Hl = 15                          ' bright white on black (help)
  ELSE                                  'Color
    MC.No = 30                          ' yellow on blue
    MC.Ho = 113                         ' blue on white
    MC.Hl = 31                          ' brigh white on blue (help)
  END IF
  DEF SEG

   OPEN CNFFile$ FOR OUTPUT AS #5
   PRINT #5, LTRIM$(STR$(MC.No)), "Normal"
   PRINT #5, LTRIM$(STR$(MC.Ho)), "Highlight"
   PRINT #5, LTRIM$(STR$(MC.Hl)), "Help Screen"
   CLOSE #5
END IF
END SUB

SUB TestPrint (ToFile) STATIC
' -------- Prints actual escape sequences to printer or file
DIM Ctrl$(1 TO 6)                       'Scan values for FF,CR,LF
  Ctrl$(1) = "10,": Ctrl$(4) = ",10"
  Ctrl$(2) = "12,": Ctrl$(5) = ",12"
  Ctrl$(3) = "13,": Ctrl$(6) = ",13"

DO
  IF LEN(PMFI$(PMF.CN, 1)) THEN         'Is there something to print?
    IF ToFile = 0 THEN                  ' printer flag = 0
      Printer$ = "LPT" + LTRIM$(STR$(PMF.Port)) 'Build a LPT string
    ELSE
      Printer$ = ""
      DO
        CALL GetFileName(Printer$, "Print to File: ")
        IF MC.Ky = 27 THEN EXIT DO
        IF LEN(Dir$(Printer$)) THEN
          CALL PromptLine(Printer$ + ExistPrompt$, -1)
          DO
            X = OneKey%
          LOOP UNTIL X
          IF X = 121 OR X = 89 THEN
            KILL Printer$
            EXIT DO
          END IF
        ELSE
          EXIT DO
        END IF
      LOOP
    END IF
    IF MC.Ky = 27 THEN EXIT DO               'ESC out
    CALL PromptLine("Sending line to " + Printer$, -1)
    Temp$ = PMFI$(PMF.CN, 1)            'Just one number
    IF LEN(Temp$) = 2 THEN
      Temp$ = CHR$(VAL(Temp$))
    ELSE
      DO WHILE INSTR(Temp$, "27,")      'Scan for 27's
        Temp$ = LEFT$(Temp$, INSTR(Temp$, "27,") - 1) + CHR$(27) + MID$(Temp$, INSTR(Temp$, "27,") + 3)
      LOOP
      FOR Z = 0 TO 1                    'Scan for 10,12,13 using CTRL$
        FOR Y = 1 + (3 * Z) TO 3 + (3 * Z)
          DO
            X = INSTR(Temp$, Ctrl$(Y))
            IF X THEN
              X$ = MID$(Temp$, X + Z, 2)
              Temp$ = LEFT$(Temp$, X - 1) + CHR$(VAL(X$)) + "," + MID$(Temp$, X + 3)
            ELSE
              EXIT DO
            END IF
          LOOP
        NEXT Y
      NEXT Z
    END IF
    Temp2$ = ""
    FOR X = 1 TO LEN(Temp$)             'Filter out quotes and commas
      X$ = MID$(Temp$, X, 1)
      IF X$ <> CHR$(34) AND X$ <> CHR$(44) THEN
        Temp2$ = Temp2$ + X$
      END IF
    NEXT X
    OPEN Printer$ FOR BINARY AS #2
    PUT 2, , Temp2$
    CLOSE #2
END IF
EXIT DO
LOOP
CALL ClrSc(18, 2, 18, 78, MC.No)
END SUB

SUB WaitTwo (Msg$)
  CALL PromptLine(Msg$, -1)
  BEEP
  T& = TIMER
  DO
  LOOP WHILE TIMER < T& + 2
  CALL ClrSc(18, 2, 18, 78, MC.No)
END SUB

FUNCTION YesNo%
  DO
    A% = OneKey
  LOOP UNTIL A%
  YesNo = (A% = 121) OR (A% = 89)
END FUNCTION

