;****************************************************************************
; NDPTYPE determines whether or not a math coprocessor is installed and
; identifies it as an 8087, 80287, or 80387.  On return, ERRORLEVEL is
; set as follows:
;
;       0       No coprocessor installed
;       1       8087
;       2       80287
;       3       80387
;
; 486-based PCs will report that an 80387 is installed because the 486
; has the equivalent of an 80387 built in.
;****************************************************************************

                .8087

code            segment
                assume  cs:code,ds:code
                org     100h
begin:          jmp     short main

no_ndp          db      13,10,"No coprocessor installed",13,10,"$"
ndp_is          db      13,10,"Coprocessor is an 80$"
ndp_8087        db      "87$"
ndp_80287       db      "287$"
ndp_80387       db      "387$"
crlf            db      13,10,"$"
cword           dw      0
errorlevel      db      1

;****************************************************************************
; Procedure MAIN
;****************************************************************************

main            proc    near
                fninit                          ;Check for coprocessor
                fnstcw  cword                   ;  by initializing it
                cmp     byte ptr [cword+1],3    ;  and checking to see
                je      ndp_installed           ;  if FNINIT works
                mov     ah,09h                  ;Print "No coprocessor
                mov     dx,offset no_ndp        ;  installed" message
                int     21h
                mov     ax,4C00h                ;Set ERRORLEVEL and exit
                int     21h
;
; Test for an 8087 by seeing if the FDISI instruction sets the IEM bit
; in the coprocessor control word.
;
ndp_installed:  mov     ah,09h                  ;Print opening message
                mov     dx,offset ndp_is
                int     21h

                mov     dx,offset ndp_8087
                and     cword,0FF7Fh
                fldcw   cword                   ;Load control word
                fdisi                           ;Disable NDP interrupts
                fstcw   cword                   ;Store control word
                test    cword,0080h             ;Test bit 7
                jnz     exit                    ;Exit if set
;
; Separate 287s from 387s by seeing whether the coprocessor defaults to
; affine (387) or projective closure (287)
;
                mov     dx,offset ndp_80287
                inc     errorlevel
                finit                           ;Initialize the coprocessor
                fld1                            ;Push 1.0 onto the stack
                fldz                            ;Push 0.0 onto the stack
                fdiv                            ;Divide 1.0 by 0.0
                fld     st                      ;Duplicate infinity
                fchs                            ;Change the sign of one
                fcompp                          ;Compare the two infinities
                fstsw   cword                   ;Get status word from compare
                fwait
                mov     ax,cword                ;Transfer it to FLAGS
                sahf
                jz      exit                    ;287 if infinities equal

                mov     dx,offset ndp_80387     ;It's a 387!
                inc     errorlevel
;
; Display NDP type, set return code, and exit.
;
exit:           mov     ah,09h                  ;Display NDP type
                int     21h
                mov     ah,09h
                mov     dx,offset crlf
                int     21h
                mov     ah,4Ch                  ;Exit with ERRORLEVEL set
                mov     al,errorlevel           ;  indicating NDP type
                int     21h
main            endp

code            ends
                end     begin
