;****************************************************************************
; NUKE deletes an entire directory full of files and all the files
; and subdirectories in it.  Its syntax is:
;
;       NUKE [d:]path
;
; where "path" is the name of the top-level subdirectory to be removed.
; NUKE will delete files and subdirectories with hidden, read-only, and
; system attributes, but it cannot delete the root directory.  Careful:
; Starting NUKE at the root directory level will erase an entire disk.
;****************************************************************************

code            segment
                assume  cs:code,ds:code
                org     100h
begin:          jmp     main

helpmsg         db      "Deletes a subdirectory and everything in it.",13,10
                db      13,10
                db      "NUKE [d:]path",13,10,"$"

errmsg1         db      "Syntax: NUKE [d:]path",13,10,"$"
errmsg2         db      "Invalid drive specification",13,10,"$"
errmsg3         db      "Invalid path specification",13,10,"$"
errmsg4         db      "Unable to remove attribute(s) from $"
errmsg5         db      "Unable to delete $"
errmsg6         db      "Unable to remove $"
errmsg7         db      "Not enough memory",13,10,"$"
msg1            db      "Removed $"

drive           db      ?                       ;Home drive
updir           db      "..",0                  ;Command to move up a level
filespec        db      "*.*",0                 ;File spec for searches
homedir db      "\",64 dup (?)                  ;Name of home directory
currdir db      "x:\",64 dup (?)                ;Name of current directory

;****************************************************************************
; Procedure MAIN
;****************************************************************************

main            proc    near
                cld                             ;Clear direction flag
                mov     si,81h                  ;Point SI to command line
                call    scanhelp                ;Scan for "/?" switch
                jnc     checkmem                ;Branch if not found
                mov     ah,09h                  ;Display help text and exit
                mov     dx,offset helpmsg       ;  with ERRORLEVEL=0
                int     21h
                mov     ax,4C00h
                int     21h

checkmem:       mov     dx,offset errmsg7       ;Make sure there's enough
                cmp     sp,4000h                ;  memory to run the
                ja      parse                   ;  program

error:          mov     ah,09h                  ;Display error message and
                int     21h                     ;  exit with ERRORLEVEL=1
                mov     ax,4C01h
                int     21h
;
; Parse the command line.
;
parse:          call    findchar                ;Find first parameter
                jnc     charfound               ;Branch if found
error1:         mov     dx,offset errmsg1       ;Error if not
                jmp     error
;
; Save the current drive and directory.
;
charfound:      push    si                      ;Save address
                mov     ah,19h                  ;Get default drive and
                int     21h                     ;  save it in DRIVE
                mov     drive,al
                mov     ah,47h                  ;Get current directory and
                sub     dl,dl                   ;  save it in HOMEDIR
                mov     si,offset homedir+1
                int     21h
                pop     si
;
; Go to the drive and directory entered on the command line.
;
                push    si
                call    finddelim               ;Find end of entry
                mov     byte ptr [si],0         ;Convert to ASCIIZ
                pop     si                      ;Retrieve starting address
                cmp     byte ptr [si+1],":"     ;Branch if path does not
                jne     nodrive                 ;  contain a drive code

                mov     al,byte ptr [si+2]      ;Make sure a directory name
                cmp     al,20h                  ;  appears after the drive
                je      error1                  ;  code
                cmp     al,2Ch
                je      error1
                cmp     al,0
                je      error1

                lodsb                           ;Get drive code
                and     al,0DFh                 ;Capitalize it
                sub     al,41h                  ;Normalize it (0=A, 1=B...)
                mov     ah,0Eh                  ;Set default drive
                mov     dl,al
                int     21h
                mov     ah,19h                  ;See if it worked by seeing
                int     21h                     ;  what is now the default
                cmp     al,dl                   ;Error if AL != DL
                mov     dx,offset errmsg2
                jne     error
                inc     si                      ;Point SI to directory name

nodrive:        mov     ah,19h                  ;Get default drive and add
                int     21h                     ;  it to CURRDIR for
                add     al,41h                  ;  status messages
                mov     currdir,al
                mov     ah,3Bh                  ;Change directories
                mov     dx,si
                int     21h
                jnc     nukem                   ;Branch if the call succeeded
                mov     ah,0Eh                  ;Restore the default drive
                mov     dl,drive                ;  and exit if it did not
                int     21h
                mov     dx,offset errmsg3
                jmp     error
;
; Nuke everything from the current directory down.
;
nukem:          call    nuke                    ;Nuke everything

                mov     ah,47h                  ;Get current directory
                sub     dl,dl
                mov     si,offset currdir+3
                int     21h
                mov     ah,3Bh                  ;Go up one level
                mov     dx,offset updir
                int     21h
                jc      root                    ;Branch if root directory

                mov     ah,3Ah                  ;Remove the final
                mov     dx,offset currdir       ;  subdirectory
                int     21h
                jnc     showdir                 ;Branch if call succeeded
                mov     dx,offset errmsg6       ;Error if subdirectory could
                jmp     fatal_exit              ;  not be removed

showdir:        call    status                  ;Display directory name

root:           mov     ah,0Eh                  ;Restore default drive
                mov     dl,drive
                int     21h
                mov     ah,3Bh                  ;Restore current directory
                mov     dx,offset homedir
                int     21h

main_exit:      mov     ax,4C00h                ;Exit with ERRORLEVEL=0
                int     21h
main            endp

;****************************************************************************
; FINDCHAR advances SI to the next non-space or non-comma character.
; On return, carry set indicates EOL was encountered.
;****************************************************************************

findchar        proc    near
                lodsb                           ;Get the next character
                cmp     al,20h                  ;Loop if space
                je      findchar
                cmp     al,2Ch                  ;Loop if comma
                je      findchar
                dec     si                      ;Point SI to the character
                cmp     al,0Dh                  ;Exit with carry set if end
                je      eol                     ;  of line is reached

                clc                             ;Clear carry and exit
                ret

eol:            stc                             ;Set carry and exit
                ret
findchar        endp

;****************************************************************************
; FINDDELIM advances SI to the next space or comma character.  On return,
; carry set indicates EOL was encountered.
;****************************************************************************

finddelim       proc    near
                lodsb                           ;Get the next character
                cmp     al,20h                  ;Exit if space
                je      fd_exit
                cmp     al,2Ch                  ;Exit if comma
                je      fd_exit
                cmp     al,0Dh                  ;Loop back for more if end
                jne     finddelim               ;  of line isn't reached

                dec     si                      ;Set carry and exit
                stc
                ret

fd_exit:        dec     si                      ;Clear carry and exit
                clc
                ret
finddelim       endp

;****************************************************************************
; SCANHELP scans the command line for a /? switch.  If found, carry returns
; set and SI contains its offset.  If not found, carry returns clear.
;****************************************************************************

scanhelp        proc    near
                push    si                      ;Save SI
scanloop:       lodsb                           ;Get a character
                cmp     al,0Dh                  ;Exit if end of line
                je      scan_exit
                cmp     al,"?"                  ;Loop if not "?"
                jne     scanloop
                cmp     byte ptr [si-2],"/"     ;Loop if not "/"
                jne     scanloop

                add     sp,2                    ;Clear the stack
                sub     si,2                    ;Adjust SI
                stc                             ;Set carry and exit
                ret

scan_exit:      pop     si                      ;Restore SI
                clc                             ;Clear carry and exit
                ret
scanhelp        endp

;****************************************************************************
; NUKE clears out files and subdirectories.  It sets up a DTA on the stack
; and calls itself recursively to get the job done.  The directory that is
; current when NUKE is called is the one that is cleared out.
;****************************************************************************

nuke            proc    near
                push    bp                      ;Save BP
                mov     ah,2Fh                  ;Get current DTA address
                int     21h
                push    bx                      ;Save it
                push    es
                sub     sp,2Bh                  ;Make room on the stack
                mov     bp,sp                   ;Establish addressability
                mov     ah,1Ah                  ;Set DTA address to a
                mov     dx,bp                   ;  location in the
                int     21h                     ;  stack
;
; Find the first file or subdirectory name.
;
                mov     ah,4Eh                  ;Call function 4Eh (DOS
                mov     cx,17h                  ;  Find First)
                mov     dx,offset filespec
                int     21h
                jnc     testname                ;Proceed if call succeeded
;
; Restore BP, the DTA, and the stack, then exit.
;
nuke_exit:      add     sp,2Bh                  ;Adjust the stack pointer
                mov     ah,1Ah                  ;Restore the DTA to where
                mov     bx,ds                   ;  it was on entry
                pop     ds
                pop     dx
                int     21h
                mov     ds,bx
                pop     bp                      ;Restore BP
                ret                             ;Return to caller
;
; Find another entry and decide what to do with it.
;
findnext:       mov     ah,4Fh                  ;Call function 4Fh (DOS
                int     21h                     ;  Find Next)
                jc      nuke_exit               ;Exit if nothing found

testname:       cmp     byte ptr [bp+30],2Eh    ;Skip . and .. entries
                je      findnext
                test    byte ptr [bp+21],10h    ;Branch if name returned is
                jnz     rmdir                   ;  a subdirectory name
;
; Delete the file whose name was just returned.
;
                mov     ax,4301h                ;Remove any existing file
                sub     cx,cx                   ;  attributes with a call
                mov     dx,bp                   ;  to DOS function 43h
                add     dx,30
                int     21h
                mov     dx,offset errmsg4
                jc      fatal_exit              ;Exit if call failed

                mov     ah,41h                  ;Delete the file
                mov     dx,bp
                add     dx,30
                int     21h
                mov     dx,offset errmsg5
                jc      fatal_exit              ;Exit if call failed
                jmp     findnext                ;Loop back for more
;
; Clear out and remove the subdirectory whose name was just returned.
;
rmdir:          mov     ah,3Bh                  ;Change to the subdirectory
                mov     dx,bp
                add     dx,30
                int     21h

                call    nuke                    ;Clear it out

                mov     ah,47h                  ;Get current directory
                sub     dl,dl
                mov     si,offset currdir+3
                int     21h
                mov     ah,3Bh                  ;Go up a directory level
                mov     dx,offset updir
                int     21h
                mov     ah,3Ah                  ;Remove the subdirectory
                mov     dx,bp
                add     dx,30
                int     21h
                mov     dx,offset errmsg6       ;Exit on error
                jc      fatal_exit

                call    status                  ;Show directory name
                jmp     findnext                ;Loop back for more
;
; A fatal error occurred.  Say what it was and terminate.
;
fatal_exit:     mov     bx,dx                   ;Save DX in BX
                mov     ah,09h                  ;Display error message
                int     21h
                cmp     bx,offset errmsg6       ;Branch if file delete
                jne     showfile                ;  error

                call    status2                 ;Display directory name
                jmp     short fatal2            ;  and exit

showfile:       mov     si,offset currdir       ;Display directory name
                call    textout
                cmp     byte ptr [si-2],"\"     ;Append a backslash if
                je      noslash                 ;  it's not the root
                mov     ah,02h                  ;  directory
                mov     dl,"\"
                int     21h
noslash:        mov     si,bp                   ;Display file name too
                add     si,30
                call    textout

fatal2:         mov     ah,0Eh                  ;Restore default drive
                mov     dl,drive
                int     21h
                mov     ah,3Bh                  ;Restore current directory
                mov     dx,offset homedir
                int     21h
                mov     ax,4C01h                ;Exit with ERRORLEVEL=1
                int     21h
nuke            endp

;****************************************************************************
; STATUS displays the name of the subdirectory that was just removed.
;****************************************************************************

status          proc    near
                mov     ah,09h                  ;Print "Removed"
                mov     dx,offset msg1
                int     21h
status2:        mov     si,offset currdir       ;Display directory name
                call    textout
                mov     ah,09h                  ;Move cursor to next line
                mov     dx,offset errmsg1+21
                int     21h
                ret
status          endp

;****************************************************************************
; TEXTOUT displays the ASCIIZ text string pointed to by DS:SI.
;****************************************************************************

textout         proc    near
                lodsb                           ;Get a character
                or      al,al                   ;Exit if zero
                jz      to_exit
                mov     ah,02h                  ;Display it using DOS
                mov     dl,al                   ;  function 02H
                int     21h
                jmp     textout                 ;Loop back for more
to_exit:        ret
textout         endp

code            ends
                end     begin
