'*************************************************************************
' PASSAGES is a game program for the QBasic Interpreter in which you
' try to find your way out of a maze.  The Up-Arrow key moves you one
' step forward in the maze, while the Left-, Right-, and Down-Arrow keys
' turn you 90 degrees to the left, 90 degrees to the right, and around
' 180 degrees, respectively.  The maze has more than 200 rooms.  Your
' goal is to find the exit.  If you succeed, your efforts are rewarded
' with a short tune.  If you decide to give up, press the End key to
' terminate the program.
'
' PASSAGES runs in 320 by 200 16-color graphics mode and uses
' page-flipping for fast animation.  It requires an EGA or VGA
' video adapter.  Written June 1991.
'*************************************************************************

DEFINT A-Z
CONST LineColor = 1

DECLARE SUB DrawHeader ()
DECLARE SUB DrawPassage (Room, Direction, APage, VPage)
DECLARE SUB DrawExit ()

DIM SHARED Map(225)
DIM SHARED Move(4)
DIM SHARED RCoords(20, 5)
DIM SHARED LCoords(20, 5)
DIM SHARED FCoords(24, 5)
DIM SHARED EndCoords(8, 5)
DIM SHARED DirText$(4)

ON ERROR GOTO ScreenError
SCREEN 7, , 0, 0
ON ERROR GOTO 0
COLOR 14, 0
CLS

CALL DrawHeader
PRINT
PRINT
PRINT "Circling the globe in search of the"
PRINT "remnants of ancient civilizations and"
PRINT "cultures is not without its hazards,"
PRINT "you have found.  No sooner did you step"
PRINT "through the entrance to Egypt's Great"
PRINT "Pyramid of Cheops than a false wall"
PRINT "slammed over the opening, blocking your"
PRINT "exit.  Your attempts to open it prove"
PRINT "futile.  As you turn your back to the"
PRINT "door and peer north into the musty"
PRINT "passageways, you realize that your only"
PRINT "hope for survival lies at the end of a"
PRINT "twisty maze of corridors whose walls"
PRINT "haven't heard human footsteps in centu-"
PRINT "ries.  The lantern in your hand flickers";
PRINT "in protest as you begin your journey..."

Direction = 0
Room = 221
APage = 0
VPage = 0

FOR I = 1 TO 225
    READ Map(I)
NEXT

FOR I = 0 TO 3
    READ Move(I)
NEXT

FOR I = 0 TO 3
    READ DirText$(I)
NEXT

FOR I = 1 TO 5
    FOR J = 1 TO 20
        READ RCoords(J, I)
    NEXT
NEXT

FOR I = 1 TO 5
    FOR J = 1 TO 20
        READ LCoords(J, I)
    NEXT
NEXT

FOR I = 1 TO 4
    FOR J = 1 TO 24
        READ FCoords(J, I)
    NEXT
NEXT

FOR J = 17 TO 24
    READ FCoords(J, 5)
NEXT

FOR I = 1 TO 5
    FOR J = 1 TO 8
        READ EndCoords(J, I)
    NEXT
NEXT

LOCATE 23, 9
COLOR 15
PRINT "Press any key to begin"
DO UNTIL INKEY$ <> ""
LOOP

DO WHILE INKEY$ <> ""
LOOP

CALL DrawPassage(Room, Direction, APage, VPage)

DO WHILE Room > 0
    DO
        A$ = INKEY$
    LOOP UNTIL LEN(A$) = 2

    SELECT CASE ASC(RIGHT$(A$, 1))
        CASE 72
            IF (Map(Room) AND (2 ^ Direction)) = 0 THEN
                LOCATE 24, 1
                COLOR 15
                PRINT "Sorry, but you can't go that way";
            ELSE
                Room = Room + Move(Direction)
                IF Room > 0 THEN
                    CALL DrawPassage(Room, Direction, APage, VPage)
                END IF
            END IF

        CASE 75
            Direction = Direction + 1
            IF Direction > 3 THEN
                Direction = Direction - 4
            END IF
            IF (Room = 4) AND (Direction = 0) THEN
                DrawExit
            ELSE
                CALL DrawPassage(Room, Direction, APage, VPage)
            END IF

        CASE 77
            Direction = Direction + 3
            IF Direction > 3 THEN
                Direction = Direction - 4
            END IF
            IF (Room = 4) AND (Direction = 0) THEN
                DrawExit
            ELSE
                CALL DrawPassage(Room, Direction, APage, VPage)
            END IF


        CASE 79
            SCREEN 0, , 0, 0
            WIDTH 80
            END

        CASE 80
            Direction = Direction + 2
            IF Direction > 3 THEN
                Direction = Direction - 4
            END IF
            IF (Room = 4) AND (Direction = 0) THEN
                DrawExit
            ELSE
                CALL DrawPassage(Room, Direction, APage, VPage)
            END IF
    END SELECT
LOOP

SCREEN 0, , 0, 0
WIDTH 80
COLOR 7, 0
LOCATE 1, 1
PRINT "Congratulations, Professor!!!"
PLAY "O3 MS L6D L6D MN L12G L12F L12D L6C P24 O1 L12G L6A L4A#"
END

ScreenError:
    CLS
    PRINT "EGA or VGA video adapter required"
    END

' Data for Map array
DATA 4,8,6,9,14,6,8,14,14,6,8,10,10,6,4
DATA 9,6,9,10,3,9,10,7,1,13,14,6,12,15,3
DATA 12,3,12,14,2,12,6,9,14,3,5,9,7,13,6
DATA 13,2,5,13,10,11,11,6,9,10,11,2,13,6,1
DATA 9,14,3,1,12,10,14,7,12,10,6,12,7,9,6
DATA 12,15,10,10,7,4,1,9,11,6,1,5,1,12,3
DATA 5,5,8,10,3,9,6,12,2,9,10,15,10,7,4
DATA 5,9,10,6,12,10,11,3,4,8,10,11,2,9,3
DATA 9,2,12,3,5,8,6,12,11,2,8,6,12,2,4
DATA 8,14,11,10,7,12,11,3,12,10,2,13,3,8,7
DATA 12,7,12,2,1,13,14,14,15,2,12,11,6,12,3
DATA 1,5,9,6,4,13,3,1,13,10,7,12,3,9,6
DATA 4,9,6,5,5,9,14,10,11,6,5,9,6,4,5
DATA 13,2,13,7,9,6,5,4,4,1,13,10,15,3,5
DATA 9,10,3,9,10,11,3,9,11,10,3,8,11,10,3

' Data for Move and DirText$ arrays
DATA -15,-1,15,1
DATA North,West,South,East

' Data for RCoords array
DATA 319,31,319,163,290,35,319,35,290,163,319,163,290,35,319,31,290,163,305,175
DATA 246,41,246,127,230,43,246,43,230,115,246,115,230,43,246,41,230,115,246,127
DATA 206,45,206,95,196,47,206,47,196,88,206,88,196,47,206,45,196,88,206,95
DATA 182,49,182,76,176,50,182,50,176,71,182,71,176,50,182,49,176,71,182,76
DATA 168,51,168,65,164,51,168,51,164,63,168,63,164,51,168,51,164,63,168,65

' Data for LCoords array
DATA 0,31,0,163,29,35,0,35,29,163,0,163,29,35,0,31,29,163,14,175
DATA 73,41,73,127,89,43,73,43,89,115,73,115,89,43,73,41,89,115,73,127
DATA 113,45,113,95,123,47,113,47,123,88,113,88,123,47,113,45,123,88,113,95
DATA 137,49,137,76,143,50,137,50,143,71,137,71,143,50,137,49,143,71,137,76
DATA 151,51,151,65,155,51,151,51,155,63,151,63,155,51,151,51,155,63,151,65

' Data for FCoords array
DATA 290,35,246,41,290,163,246,127,29,35,73,41,29,163,73,127,290,35,29,35
DATA 290,163,29,163,230,43,206,45,230,115,206,95,89,43,113,45,89,115,113,95
DATA 230,43,89,43,230,115,89,115,196,47,182,49,196,88,182,76,123,47,137,49
DATA 123,88,137,76,196,47,123,47,196,88,123,88,176,50,168,51,176,71,168,65
DATA 143,50,151,51,143,71,151,65,176,50,143,50,176,71,143,71,164,51,155,51
DATA 164,63,155,63

' Data for EndCoords array
DATA 290,35,290,163,29,35,29,163
DATA 230,43,230,115,89,43,89,115
DATA 196,47,196,88,123,47,123,88
DATA 176,50,176,71,143,50,143,71
DATA 164,51,164,63,155,51,155,63

SUB DrawExit
    CLS
    CALL DrawHeader
    LINE (0, 25)-(319, 175), LineColor, B
       
    LINE (319, 35)-(290, 35), LineColor
    LINE -(290, 163), LineColor
    LINE -(319, 163), LineColor

    LINE (290, 35)-(230, 43), LineColor
    LINE -(230, 115), LineColor
    LINE -(290, 163), LineColor

    LINE (230, 43)-(206, 43), LineColor
    LINE -(206, 115), LineColor
    LINE -(230, 115), LineColor

    LINE (206, 43)-(192, 45), LineColor
    LINE -(192, 103), LineColor
    LINE -(206, 115), LineColor

    LINE (192, 45)-(127, 45), LineColor
    LINE -(127, 103), LineColor
    LINE -(192, 103), LineColor

    LINE (0, 30)-(89, 43), LineColor
    LINE -(89, 115), LineColor
    LINE -(14, 175), LineColor

    LINE (89, 43)-(113, 43), LineColor
    LINE -(113, 115), LineColor
    LINE -(89, 115), LineColor
       
    LINE (113, 43)-(127, 45), LineColor
    LINE (113, 115)-(127, 103), LineColor
    LINE (127, 75)-(192, 75), LineColor
       
    LINE (144, 75)-(176, 55), LineColor
    LINE -(192, 67), LineColor
    LINE (176, 55)-(160, 75), LineColor

    PAINT (140, 55), 14, LineColor
    LOCATE 24, 1
    COLOR 15
    PRINT "Facing North... and the exit!";
END SUB

SUB DrawHeader
    COLOR 14
    LOCATE 2, 15
    PRINT "PASSAGEWAYS"
    LINE (25, 4)-(294, 18), LineColor, B
    LINE (0, 2)-(319, 20), LineColor, B
END SUB

SUB DrawPassage (Room, Direction, APage, VPage)
    APage = APage XOR 1
    SCREEN , , APage, VPage

    CLS
    CALL DrawHeader
    LINE (0, 25)-(319, 175), LineColor, B

    Level = 1
    RoomNo = Room

    DR = Direction + 3
    IF DR > 3 THEN
        DR = DR - 4
    END IF

    DL = Direction + 1
    IF DL > 3 THEN
        DL = DL - 4
    END IF

    DO
        IF (Map(RoomNo) AND (2 ^ DR)) <> 0 THEN
            LINE (RCoords(1, Level), RCoords(2, Level))-(RCoords(3, Level), RCoords(4, Level)), LineColor
            LINE (RCoords(5, Level), RCoords(6, Level))-(RCoords(7, Level), RCoords(8, Level)), LineColor
            LINE (RCoords(9, Level), RCoords(10, Level))-(RCoords(11, Level), RCoords(12, Level)), LineColor
        ELSE
            LINE (RCoords(13, Level), RCoords(14, Level))-(RCoords(15, Level), RCoords(16, Level)), LineColor
            LINE (RCoords(17, Level), RCoords(18, Level))-(RCoords(19, Level), RCoords(20, Level)), LineColor
        END IF

        IF (Map(RoomNo) AND (2 ^ DL)) <> 0 THEN
            LINE (LCoords(1, Level), LCoords(2, Level))-(LCoords(3, Level), LCoords(4, Level)), LineColor
            LINE (LCoords(5, Level), LCoords(6, Level))-(LCoords(7, Level), LCoords(8, Level)), LineColor
            LINE (LCoords(9, Level), LCoords(10, Level))-(LCoords(11, Level), LCoords(12, Level)), LineColor
        ELSE
            LINE (LCoords(13, Level), LCoords(14, Level))-(LCoords(15, Level), LCoords(16, Level)), LineColor
            LINE (LCoords(17, Level), LCoords(18, Level))-(LCoords(19, Level), LCoords(20, Level)), LineColor
        END IF

        IF (Map(RoomNo) AND (2 ^ Direction)) <> 0 THEN
            LINE (FCoords(1, Level), FCoords(2, Level))-(FCoords(3, Level), FCoords(4, Level)), LineColor
            LINE (FCoords(5, Level), FCoords(6, Level))-(FCoords(7, Level), FCoords(8, Level)), LineColor
            LINE (FCoords(9, Level), FCoords(10, Level))-(FCoords(11, Level), FCoords(12, Level)), LineColor
            LINE (FCoords(13, Level), FCoords(14, Level))-(FCoords(15, Level), FCoords(16, Level)), LineColor
        ELSE
            LINE (FCoords(17, Level), FCoords(18, Level))-(FCoords(19, Level), FCoords(20, Level)), LineColor
            LINE (FCoords(21, Level), FCoords(22, Level))-(FCoords(23, Level), FCoords(24, Level)), LineColor
        END IF

        IF (((Map(RoomNo) AND (2 ^ Direction)) <> 0) AND ((Map(RoomNo) AND (2 ^ DR)) <> 0)) OR (((Map(RoomNo) AND (2 ^ Direction)) = 0) AND ((Map(RoomNo) AND (2 ^ DR)) = 0)) THEN
            LINE (EndCoords(1, Level), EndCoords(2, Level))-(EndCoords(3, Level), EndCoords(4, Level)), LineColor
        END IF

        IF (((Map(RoomNo) AND (2 ^ Direction)) <> 0) AND ((Map(RoomNo) AND (2 ^ DL)) <> 0)) OR (((Map(RoomNo) AND (2 ^ Direction)) = 0) AND ((Map(RoomNo) AND (2 ^ DL)) = 0)) THEN
            LINE (EndCoords(5, Level), EndCoords(6, Level))-(EndCoords(7, Level), EndCoords(8, Level)), LineColor
        END IF

        LastRoomNo = RoomNo
        RoomNo = RoomNo + Move(Direction)
        Level = Level + 1
    LOOP UNTIL (Map(LastRoomNo) AND (2 ^ Direction)) = 0

    LOCATE 24, 1
    COLOR 15
    PRINT "Facing "; DirText$(Direction);
    VPage = APage
    SCREEN , , , VPage
END SUB

