;****************************************************************************
; PC-LIST lists a data file created by PC-DIAL to the standard output
; device so that data files can be printed or captured in ASCII format
; suitable for export to other database managers.  Its syntax is
;
;       PC-LIST [d:][path]filename
;
; where "filename" is the name of the data file to be printed.
;****************************************************************************

code            segment
                assume  cs:code,ds:code
                org     100h
begin:          jmp     main

helpmsg         db      "Lists data files created by PC-DIAL to standard "
                db      "output.",13,10,13,10
                db      "PC-LIST [d:][path]filename",13,10,13,10
                db      "Use output redirection to print the list or "
                db      "capture it to a file.",13,10,"$"

errmsg1         db      "You must specify a file name",13,10,"$"
errmsg2         db      "File not found or path invalid",13,10,"$"
errmsg3         db      "An error occurred while the file was being read"
crlf            db      13,10,"$"
errmsg4         db      "This file was not created by PC-DIAL",13,10,"$"

signature       db      0,1,2,"PC-DIAL",2,1,0

records         dw      0                       ;Number of records
characters      db      ?                       ;Length of data field

;****************************************************************************
; Procedure MAIN
;****************************************************************************

main            proc    near
                cld                             ;Clear direction flag
                mov     si,81h                  ;Point SI to command line
                call    scanhelp                ;Scan for "/?" switch
                jnc     parse                   ;Branch if not found
                mov     ah,09h                  ;Display help text and exit
                mov     dx,offset helpmsg       ;  with ERRORLEVEL=0
                int     21h
                mov     ax,4C00h
                int     21h
;
; Open the data file and read it in.
;
parse:          call    findchar                ;Find the file name
                jnc     parse1                  ;Branch if it's there

                mov     dx,offset errmsg1       ;Point DX to error message
error:          mov     ah,09h                  ;Display error message and
                int     21h                     ;  exit with ERRORLEVEL=1
                mov     ax,4C01h
                int     21h

parse1:         push    si                      ;Save the file name address
                call    finddelim               ;Find the end of the string
                mov     byte ptr [si],0         ;Convert it to ASCIIZ format
                pop     dx                      ;Retrieve file name address

                mov     ax,3D00h                ;Open the file for reading
                int     21h
                mov     dx,offset errmsg2       ;Error if call failed
                jc      error

                mov     bx,ax                   ;Transfer file handle to BX
                mov     ah,3Fh                  ;Read the first 13 bytes of
                mov     cx,13                   ;  the file into the file
                mov     dx,offset buffer        ;  I/O buffer at the end
                int     21h                     ;  of the program
                mov     dx,offset errmsg3       ;Error if call failed
                jc      error
                mov     dx,offset errmsg4       ;Also an error if the file
                cmp     ax,13                   ;  contained less than 13
                jb      error                   ;  bytes

                mov     si,offset signature     ;Compare the header at the
                mov     di,offset buffer        ;  beginning of the file
                mov     cx,13                   ;  against the PC-DIAL
                repe    cmpsb                   ;  signature and exit if
                mov     dx,offset errmsg4       ;  they don't match
                jne     error

                mov     ah,3Fh                  ;Read the record count
                mov     cx,2                    ;  from the file
                mov     dx,offset records
                int     21h
                mov     dx,offset errmsg3       ;Error if call failed
                jc      error
                mov     dx,offset errmsg4       ;Error if two bytes were
                cmp     ax,2                    ;  not read
                jb      error

                mov     ah,3Fh                  ;Read the remainder of the
                mov     cx,0FFFFh               ;  the file
                mov     dx,offset buffer
                int     21h
                mov     dx,offset errmsg3       ;Error if call failed
                jc      error

                mov     ah,3Eh                  ;Close the file
                int     21h
;
; Send the records to the standard output device padded with spaces.
;
                mov     cx,records              ;Get record count in CX
                mov     si,offset buffer        ;Point SI to first record

listloop:       push    cx                      ;Save record count
                mov     cx,26                   ;Output the first field
                call    print_field
                call    print_separator
                mov     cx,26                   ;Output the second field
                call    print_field
                call    print_separator
                mov     cx,18                   ;Output the third field
                call    print_field
                call    print_crlf              ;Go to the next line
                pop     cx                      ;Retrieve count
                loop    listloop                ;Loop until done

                mov     ax,4C00h                ;Terminate with
                int     21h                     ;  ERRORLEVEL =0
main            endp

;****************************************************************************
; PRINT_FIELD outputs one zero-delimited field from the data buffer.  On
; entry, CX holds the length of the field.
;****************************************************************************

print_field     proc    near
                lodsb                           ;Get a character
                or      al,al                   ;Branch if it's zero
                jz      print_spaces
                mov     ah,02h                  ;Send it to standard output
                mov     dl,al                   ;  using DOS function 02H
                int     21h
                dec     cx                      ;Decrement the count and
                jmp     print_field             ;  return for more

print_spaces:   jcxz    pf_exit                 ;Exit if CX is zero
                mov     ah,02h                  ;Output a space
                mov     dl,20h
                int     21h
                loop    print_spaces            ;Loop until the field is
pf_exit:        ret                             ;  padded out, then exit
print_field     endp

;****************************************************************************
; PRINT_SEPARATOR outputs two spaces to separate consecutive fields.
;****************************************************************************

spaces          db      32,32,"$"

print_separator proc    near
                mov     ah,09h
                mov     dx,offset spaces
                int     21h
                ret
print_separator endp

;****************************************************************************
; PRINT_CRLF outputs a carriage return/line feed pair.
;****************************************************************************

print_crlf      proc    near
                mov     ah,09h
                mov     dx,offset crlf
                int     21h
                ret
print_crlf      endp

;****************************************************************************
; FINDCHAR advances SI to the next non-space or non-comma character.
; On return, carry set indicates EOL was encountered.
;****************************************************************************

findchar        proc    near
                lodsb                           ;Get the next character
                cmp     al,20h                  ;Loop if space
                je      findchar
                cmp     al,2Ch                  ;Loop if comma
                je      findchar
                dec     si                      ;Point SI to the character
                cmp     al,0Dh                  ;Exit with carry set if end
                je      eol                     ;  of line is reached

                clc                             ;Clear carry and exit
                ret

eol:            stc                             ;Set carry and exit
                ret
findchar        endp

;****************************************************************************
; FINDDELIM advances SI to the next space or comma character.  On return,
; carry set indicates EOL was encountered.
;****************************************************************************

finddelim       proc    near
                lodsb                           ;Get the next character
                cmp     al,20h                  ;Exit if space
                je      fd_exit
                cmp     al,2Ch                  ;Exit if comma
                je      fd_exit
                cmp     al,0Dh                  ;Loop back for more if end
                jne     finddelim               ;  of line isn't reached

                dec     si                      ;Set carry and exit
                stc
                ret

fd_exit:        dec     si                      ;Clear carry and exit
                clc
                ret
finddelim       endp

;****************************************************************************
; SCANHELP scans the command line for a /? switch.  If found, carry returns
; set and SI contains its offset.  If not found, carry returns clear.
;****************************************************************************

scanhelp        proc    near
                push    si                      ;Save SI
scanloop:       lodsb                           ;Get a character
                cmp     al,0Dh                  ;Exit if end of line
                je      scan_exit
                cmp     al,"?"                  ;Loop if not "?"
                jne     scanloop
                cmp     byte ptr [si-2],"/"     ;Loop if not "/"
                jne     scanloop

                add     sp,2                    ;Clear the stack
                sub     si,2                    ;Adjust SI
                stc                             ;Set carry and exit
                ret

scan_exit:      pop     si                      ;Restore SI
                clc                             ;Clear carry and exit
                ret
scanhelp        endp

buffer          =       $                       ;File I/O buffer

code            ends
                end     begin
