'=======================================================================
' PCBook.BAS                                                           '
' Utility to print ASCII text files to LaserJet Series II, IIp or III  '
'    in booklet format                                                 '
'                                                                      '
' Copyright (C) 1990  Ziff Communications  PC Magazine  Jay Munro    '
' Written by Jay Munro                                                 '
'                                                                      '
' Compiler syntax:                                                     '
'    BC /o PCBook.BAS;                                                 '
'    Link /Ex /Noe /Nod PCBook _Noval _Noread Str16384 ,,Nul,PDQ;      '
'    Note--this version has been specially modified for use with       '
'      Crescent Softwares P.D.Q. library to achieve a small .EXE       '
'      Original PCBook compiled with BC7.1 - 48K                       '
'=======================================================================
DEFINT A-Z
DECLARE SUB BuildArray (PtrArray&(), PgCount%)
DECLARE SUB Header (Page%)                      'Print Header
DECLARE SUB PrintSetup ()                       'Set up macros, fonts
DECLARE SUB PrintLogo ()                        'Credits
DECLARE FUNCTION ErrorDept% (TErr%)             'Error reporting function
DECLARE FUNCTION PDQExist% (FileName$)          'File exist
DECLARE FUNCTION PDQInkey% ()                   'Integer Inkey replacement
DECLARE FUNCTION PrintLine% (Text$)             'Printing function
DECLARE SUB PDQSound (Freq%, Duration%)         'Beep replacement
DECLARE SUB Interrupt (IntNum%, Regs AS ANY)    'Call interrupt function

'----- Type variable for Interrupt registers
TYPE RegType
     AX        AS INTEGER
     BX        AS INTEGER
     CX        AS INTEGER
     DX        AS INTEGER
     BP        AS INTEGER
     SI        AS INTEGER
     DI        AS INTEGER
     Flags     AS INTEGER
     DS        AS INTEGER
     ES        AS INTEGER
     SS        AS INTEGER
     SP        AS INTEGER
     BusyFlag  AS INTEGER
     Address   AS INTEGER
     Segment   AS INTEGER
     ProcAdr   AS INTEGER
     ProcSeg   AS INTEGER
     IntNum    AS INTEGER
END TYPE

'============== 'Misc flag variables
TYPE Flags
  CurDate AS INTEGER
  DoHeader AS INTEGER
  FileTitle AS INTEGER
  LineLen AS INTEGER
  LineWrap AS INTEGER
  TotalPages AS INTEGER
  PgNumber AS INTEGER
  ErrFlag AS INTEGER
  BiosLpt AS INTEGER
  AltFile AS INTEGER
  ErrorTrap AS INTEGER
END TYPE

'============== Shared variables
DIM SHARED ESC$, FF$, LF$, FileName$
DIM SHARED PC AS Flags, CrLf$

DIM Registers AS RegType                        'Type structure for interrupt

PC.TotalPages = 512                             'Set default (thats a lot!)
REDIM PtrArray&(PC.TotalPages + 1)              'Total number of pages to allow

'============== Error trapping printer output routine
DEF FnBIOSPrint% (Character)
    FnBIOSPrint% = 0                    'assume no errors
    Registers.AX = Character            'put the character into AL, 0 into AH
    Registers.DX = PC.BiosLpt           'specify LPT1: (use 1 for LPT2: etc.)
    Interrupt &H17, Registers           'call the BIOS printer service
    AH = Registers.AX \ 256             'get the error result from AH
    AH = AH OR 128                      'ignore the busy flag
    AH = AH AND 191                     'ditto for the printer acknowledgement
    IF AH <> 144 THEN FnBIOSPrint% = -1 'printer isn't ready or it's off-line
END DEF

CALL CritErrOff                         'Disable DOS critical errors

'============== Set some constant variables
 ESC$ = CHR$(27)                                'Standard ESC code
 FF$ = CHR$(12)                                 'Page Feed
 LF$ = CHR$(10)                                 'Line Feed
 CrLf$ = CHR$(10) + CHR$(13)                    'Carriage return
 OutFile$ = "LPT1"                              'Default printer port
 PC.BiosLpt = 0                                 '   numeric port default
 JustCount% = 0                                 'Pause after page count off
 Tune% = 0                                      'default sound off
 PC.LineLen = 80                                'Maximum length of line
 PC.ErrFlag = 0

 CLS
 CALL PrintLogo                                 'Print opening credits

 JCommand$ = UCASE$(COMMAND$)                   'PDQ allows lowercase Command$

'============== Setup from the command line
IF LEN(JCommand$) THEN                           'do this only when JCommand$ is used
   IF LEFT$(LTRIM$(JCommand$), 1) <> "/" THEN
      IF INSTR(JCommand$, "/") THEN
         FileName$ = MID$(LTRIM$(JCommand$), 1, INSTR(LTRIM$(JCommand$), " "))
      ELSE
         FileName$ = LTRIM$(JCommand$)
      END IF
   END IF

   IF INSTR(JCommand$, "/D") THEN
      PC.CurDate = -1                           'Do current date
      PC.DoHeader = -1
   END IF

   IF INSTR(JCommand$, "/F") THEN
      PC.FileTitle = -1                         'Do file title
      PC.DoHeader = -1
   END IF

   IF INSTR(JCommand$, "/P") THEN
      PC.PgNumber = -1                          'Do page numbers
      PC.DoHeader = -1
   END IF

   IF INSTR(JCommand$, "/C") THEN
      JustCount% = -1                           'Just count pages
   END IF

   IF INSTR(JCommand$, "/2") THEN               'Use LPT2
      OutFile$ = "Lpt2"
      PC.BiosLpt = 1
   END IF

   IF INSTR(JCommand$, "/W") THEN               'Use linewrap
      PC.LineWrap = -1
   END IF

   IF INSTR(JCommand$, "/S") THEN               'Use beep statements
      Tune% = -1
   END IF

   IF INSTR(JCommand$, "/R") THEN               'Use rear tray
      PRINT "Collating for Rear Tray"
      RearTray% = -1
   END IF

   IF INSTR(JCommand$, "/I") THEN               'Use ignore printer errors
      PC.ErrorTrap = -1
   END IF

   IF INSTR(JCommand$, "/?") THEN               'Show help
      PRINT "Usage: PCBOOK filename [/F] [/P] [/D] [/C] [/2] [/A] [/W] [/S] [/R] [/?]"
      PRINT "/F - prints file name at top of page"
      PRINT "/P - prints page numbers"
      PRINT "/D - prints current date on every page"
      PRINT "/C - pauses after physical page count"
      PRINT "/2 - print to LPT2"
      PRINT "/A - prompt for alternate file to print to"
      PRINT "/W - set line wrap on"
      PRINT "/S - sound on for user prompts"
      PRINT "/R - rear tray order on pages "
      PRINT "/I - ignore printer errors "
      PRINT "/? - this help message"
      GOTO OutHere
    END IF
END IF

'============== Open text file

GetName:
    DO
    IF LEN(FileName$) = 0 THEN
       IF Tune% THEN PDQSound 500, 2
       LINE INPUT "Enter file name to print: "; FileName$
       PRINT
       IF FileName$ = "" THEN GOTO OutHere
    END IF                                      'Test if file is there
    IF PDQExist%(FileName$) THEN EXIT DO
    FileName$ = ""
    LOOP

'============== Prompt for new output file if requested
   IF INSTR(JCommand$, "/A") THEN
      PRINT
      IF Tune% THEN PDQSound 500, 2
      LINE INPUT "Enter alternate output file: "; Temp$
      IF Temp$ <> "" THEN
         OutFile$ = Temp$                       'Allow a change of mind
         PC.AltFile = -1
      END IF
      PRINT
   END IF

'============== Build index array for pages in FileName$
   PRINT "Reading file "; FileName$
   CALL BuildArray(PtrArray&(), Page%)          'Built pointer array
   IF PC.ErrFlag THEN GOTO OutHere              'Error exit

'============== Figure number of pages needed
   IF Page% MOD 4 THEN                          'Even multiples of 4 only
      Page% = Page% + (4 - Page% MOD 4)         '  correct for less
   END IF
  
   IF Tune% THEN PDQSound 500, 2                'Report total pages
   PRINT CrLf$; "You will print "; Page% \ 4; "sheets"; CrLf$;

   IF JustCount% THEN
      PRINT "Press any key to continue, or ESC to cancel printing"
      GOSUB KeyIn
      IF A% = 27 THEN GOTO OutHere
   END IF

'============== If an alternate output file is specified, use it
   IF PC.AltFile% THEN
     DO
       OPEN OutFile$ FOR OUTPUT AS #2           'Open output file
       IF ERR THEN
         IF ErrorDept%(ERR) THEN
           GOTO OutHere
         END IF
       ELSE
         EXIT DO
       END IF
     LOOP
   END IF
   CALL PrintSetup                              'Set up printer
   IF PC.ErrFlag THEN GOTO OutHere

'============== Page parsing variables
   LeftSide% = Page%
   RightSide% = 1
   FirstPass% = -1

DO
   OPEN FileName$ FOR BINARY AS #1              'Open the input file
   IF ERR THEN
     IF ErrorDept%(ERR) THEN
        GOTO OutHere
     END IF
   ELSE
     EXIT DO
   END IF
LOOP
  
   PRINT "Printing Side 1 to "; OutFile$;       'Track what is going on

'============== Start of print routine

DoPass:
   BookMark% = (Page% \ 4)                      'Flag for halfway through
   IF BookMark% = 0 THEN BookMark% = 1          'Force 1 if too small

'============== Read text and send to printer
DO                                              'Print the right side of the page first
    IF PtrArray&(RightSide% + 1) = 0 THEN       'If blank, then skip it
       GOTO NextPage
    END IF
                                                'Execute the macro for right side
    IF PrintLine%(ESC$ + "&f2y2X") THEN GOTO OutHere
    IF PC.DoHeader THEN CALL Header(RightSide%) 'Header if needed
    IF PrintLine%(CrLf$) THEN GOTO OutHere      'Force an extra line
   
    IF PtrArray&(RightSide% + 1) - PtrArray&(RightSide%) > 1 THEN
       Buffer$ = SPACE$(PtrArray&(RightSide% + 1) - PtrArray&(RightSide%))
    ELSE
       GOTO NextPage
    END IF
   
    DO
      GET #1, PtrArray&(RightSide%), Buffer$    'Read in a page and
      IF ERR THEN                               'check for an error
        IF ErrorDept%(ERR) THEN                 'like removing the disk, etc...
          GOTO OutHere
        END IF
      ELSE
        EXIT DO
      END IF
    LOOP
    IF INSTR(Buffer$, FF$) THEN                 'If the last character is a PF
       Temp$ = LEFT$(Buffer$, INSTR(Buffer$, FF$) - 1)  'print only text
       IF PrintLine%(Temp$) THEN GOTO OutHere
    ELSE
       IF PrintLine%(Buffer$) THEN GOTO OutHere 'Otherwise print full line
    END IF

NextPage:
    IF PtrArray&(LeftSide% + 1) = 0 THEN        'Don't print blank pages
       GOTO NextPage1
    END IF
    IF PrintLine%(ESC$ + "&f1y2X") THEN GOTO OutHere      'Reset to left side Macro
    IF PC.DoHeader THEN CALL Header(LeftSide%)  'Header if needed
    IF PrintLine%(CrLf$) THEN GOTO OutHere      'Force an extra line
   
    IF PtrArray&(LeftSide% + 1) - PtrArray&(LeftSide%) > 1 THEN
       Buffer$ = SPACE$(PtrArray&(LeftSide% + 1) - PtrArray&(LeftSide%))                'Setup buffer for input
    ELSE
       GOTO NextPage1
    END IF
  
    IF LeftSide% = 0 THEN                       'If pointing at blank page, skip
       GOTO NextPage1
    END IF
  DO
    GET #1, PtrArray&(LeftSide%), Buffer$       'Read in a page
    IF ERR THEN
      IF ErrorDept%(ERR) THEN
        GOTO OutHere
      END IF
    ELSE
      EXIT DO
    END IF
  LOOP
 
    IF INSTR(Buffer$, FF$) THEN                 'If the last character is a PF
       Temp$ = LEFT$(Buffer$, INSTR(Buffer$, FF$) - 1)  'print only text
       IF PrintLine%(Temp$) THEN GOTO OutHere
    ELSE
       IF PrintLine%(Buffer$) THEN GOTO OutHere '   otherwise print all
    END IF

NextPage1:


'============== Calculate next page in series
    IF FirstPass THEN                           'First pass both sides the same
      LeftSide% = LeftSide - 2
      RightSide% = RightSide + 2
    ELSE
      IF RearTray% THEN                         'Rear tray gets reverse count down
        LeftSide% = LeftSide + 2
        RightSide% = RightSide - 2
      ELSE
        LeftSide% = LeftSide - 2                'Top tray gets normal
        RightSide% = RightSide + 2
      END IF
    END IF
    BookMark% = BookMark% - 1                   'Track our progress
    IF PrintLine%(FF$) THEN GOTO OutHere        'Page feed current side
LOOP UNTIL BookMark% = 0                        'Print pages until halfway through

'============== Pause between sides
    IF FirstPass THEN                           'If side one, prompt and get 2nd side
      IF NOT PC.AltFile THEN
        LOCATE CSRLIN, 1
        PRINT "Insert paper back in tray and press Enter"
        IF Tune% THEN PDQSound 500, 2
WaitKey:                                        'Press any key to continue loop
        GOSUB KeyIn
        IF A% = 27 THEN GOTO PrtReset           'ESC key, takes you out
        IF A% <> 13 THEN GOTO WaitKey           'Enter key only to prevent accidentally
      END IF
      FirstPass = 0                              'Flag for second pass
      PRINT CrLf$; "Printing Side 2 to "; OutFile$ 'Report on progress
      IF RearTray THEN
        LeftSide% = 2                           'Adjust pages for reverse
        RightSide% = Page% - 1                  '
      END IF
      GOTO DoPass
    END IF                                      'End of first pass

    LOCATE CSRLIN, 1                            'Printing is done now
    PRINT "Printing completed "; SPACE$(60)
    IF Tune% THEN PDQSound 500, 2

PrtReset:
    IF PrintLine%(ESC$ + "E") THEN GOTO OutHere
   
OutHere:
    CLOSE                                       'Close all files
    CALL CritErrOn
    END                                         'Thats all for now


KeyIn:                                          'Wait on error for a key
     DO
       A% = PDQInkey%                          'Get a key if one is pending
     LOOP UNTIL A%                             'Integer compares faster than strings
RETURN

'============================ End of main module ============================

SUB BuildArray (PtrArray&(), PgCount%) STATIC
'FileName$ is shared from the main module
  PC.ErrFlag% = 0
  MaxLines% = 66                               'Maximum number of lines
  Offset& = 1                                  'Start of file (seek point)
  DO
  OPEN FileName$ FOR BINARY AS #1 LEN = 1      'Open file to check
  IF ERR THEN
    IF ErrorDept%(ERR) THEN
      PC.ErrFlag% = -1
      EXIT SUB
    END IF
  ELSE
    EXIT DO
  END IF
  LOOP
 
  TotalSize& = LOF(1)                          'Get LEN of file so we don't read too far
  FileLeft& = TotalSize&                       'Setup a counter to show whats left
  MemAvail& = FRE(FileName$) - 2048            'Check available string memory
  IF MemAvail& < 2048 THEN ERROR 14            'Force out of memory error

  BufSize& = 16384                             'Arbitrary buffer to scan
  IF MemAvail& < BufSize& THEN BufSize& = MemAvail&

  PgCount% = 1                                 'Initialize page count
  PtrArray&(PgCount%) = 1                      'First pointer is always 1
  LnCount% = 0                                 'Initialize line count

GetPage:
                                               'Read the file
  IF FileLeft& < BufSize& THEN                 'Check amount left to read
    Buffer$ = SPACE$(FileLeft&)                'If less than our buffer, use lessor
  ELSE
    Buffer$ = SPACE$(BufSize&)                 'Otherwise use full buffer size
  END IF

  GET #1, Offset&, Buffer$                     'Read in a buffers worth
  StPtr% = 1                                   'Pointer into buffer$

PageCheck:
  TempLn% = INSTR(StPtr%, Buffer$, LF$)        ' Position of next linefeed
  TempPg% = INSTR(StPtr%, Buffer$, FF$)        ' Position of next pagefeeds

  IF TempPg% THEN                              ' If there was a page feed,
    IF TempPg% < TempLn% OR TempLn% = 0 THEN   ' was it before our linefeed?
      TempLn% = TempPg%                        ' YES, treat as a LF for
    ELSE                                       ' purpose of line wrap.
      TempPg% = 0                              ' NO, ignore FF and clear flag
    END IF                                     ' when LF preceeds the FF.
  END IF                                       ' We'll catch the FF again
                                               ' on the next pass.

  IF TempLn% THEN                              'Linefeed

    IF PC.LineWrap THEN                        'If /W then check line length
      IF TempLn% - StPtr% > PC.LineLen THEN    'Greater than 80?
        DO                                     'check # of line wraps
          IF LnCount% = MaxLines% - 1 THEN     'only room for 1 more line
            TempLn% = StPtr% + PC.LineLen - 1  'so force a page break
            EXIT DO                            'in the middle of this line
          ELSE
            LnCount% = LnCount% + 1
            StPtr% = StPtr% + PC.LineLen
          END IF
        LOOP WHILE TempLn% - StPtr% > PC.LineLen
      END IF
    END IF

PageBreak:
    LnCount% = LnCount% + 1                   'Increment page count
    IF LnCount% = MaxLines% OR TempPg% <> 0 THEN
      PgCount% = PgCount% + 1
      PtrArray&(PgCount%) = Offset& + TempLn% 'point to next in point in file
      IF PgCount% > PC.TotalPages THEN
        PgCount% = PC.TotalPages              'just filled in PtrArray&(PC.TotalPages)
        PRINT "Too many pages - printing only "; PC.TotalPages
        GOTO EndBuild
      END IF
      LnCount% = 0
    END IF

    StPtr% = TempLn% + 1                       'point ahead 1 byte for next scan
    IF StPtr% <= LEN(Buffer$) THEN GOTO PageCheck  'keep checking
  END IF

  Offset& = Offset& + LEN(Buffer$)              'Pointer into file (tally)
  FileLeft& = TotalSize& - Offset& + 1
  IF Offset& <= TotalSize& THEN GOTO GetPage

  IF PtrArray&(PgCount%) <= TotalSize& THEN
    PtrArray&(PgCount% + 1) = TotalSize& + 1    'Set last pointer to end of file
  ELSE
    PgCount% = PgCount% - 1                     'we already saved the last value
  END IF                                        'and PgCount% is 1 too high

EndBuild:
  CLOSE #1                                      'Close input file

END SUB                                         'End of BuildArray Module

FUNCTION ErrorDept (TError%)
       PDQSound 500, 2                          'make a beep sound
   SELECT CASE TError%
      CASE 99
         PRINT "* Printer Error *"
      CASE 53                                   'Source file not there
         PRINT "* File "; FileName$; " not found *"
         FileName$ = ""
      CASE 71                                   'Open drive door
         PRINT "* Device Not Ready *"
      CASE ELSE
         PRINT "* Error number "; TError%; " *"
    END SELECT
       
AWayOut:
   PRINT "Press any key to try again or ESC to quit"
   DO
     A% = PDQInkey%                          'Get a key if one is pending
   LOOP UNTIL A%                             'Integer compares faster than strings

   IF A% = 27 THEN                      'Exit out if ESC is pressed
     ErrorDept% = -1                    'through routines
   ELSE
     ErrorDept% = 0
   END IF

END FUNCTION

SUB Header (Page%) STATIC
   Hdr$ = SPACE$(PC.LineLen)                    'Create a string to print
   IF PC.FileTitle THEN                         'Print the filename
      MID$(Hdr$, 40 - LEN(FileName$) \ 2) = UCASE$(FileName$)
   END IF

   IF PC.PgNumber THEN                          'Print the current page
     PTemp$ = "Page " + STR$(Page%)
     IF Page% MOD 2 THEN
        MID$(Hdr$, PC.LineLen - LEN(PTemp$)) = PTemp$ 'odd page, right side
     ELSE
        MID$(Hdr$, 1) = PTemp$                  'even page, left side
     END IF
   END IF

   IF PC.CurDate THEN                           'Print the current date
     IF Page% MOD 2 THEN
        MID$(Hdr$, 1) = DATE$                   'even page, left side
     ELSE
         MID$(Hdr$, PC.LineLen - LEN(DATE$)) = DATE$ 'odd page, right side
     END IF
   END IF
   DO
   LOOP WHILE PrintLine%(Hdr$)                         'Print the Header
   DO
   LOOP WHILE PrintLine%(CrLf$)                        ' and skip a line for readability

END SUB

FUNCTION PrintLine% (Text$)
PrintLine% = 0                          'Assume no errors
IF PC.AltFile THEN                      'If altfile, then use #2
  DO
    PRINT #2, Text$;                    'Print text$
    IF ERR THEN                         'Error? then check it out
     IF ErrorDept%(ERR) THEN
       PrintLine% = -1
       EXIT FUNCTION
     END IF
   ELSE
     EXIT DO
   END IF
  LOOP
ELSE
  FOR X = 1 TO LEN(Text$)                 'Send the selected code to the printer
    Char = ASC(MID$(Text$, X))            'Get this character
    PrnError = FnBIOSPrint%(Char)
    IF PrnError THEN                      'The printer wasn't ready or something
      PDQSound 500, 2                     'Make a beep sound
      IF PC.ErrorTrap = 0 THEN
        IF ErrorDept%(99) THEN
          PrintLine% = -1
          EXIT FOR                        'Skip the rest of the string
        ELSE
          IF PDQInkey% THEN               'Just in case someone messed up
             IF ErrorDept%(99) THEN       'Allow a way out by hanging on a key
                PrintLine% = -1
                EXIT FOR
             END IF
          END IF
          X = X + 1                       'ignore last character problem
        END IF
      END IF
    END IF
  NEXT
END IF
END FUNCTION

SUB PrintLogo STATIC                            'Banner logo
PRINT STRING$(80, 61);
PRINT "PCBOOK 1.1 - PC Magazine Booklet Printing Utility"
PRINT "Copyright (c) 1990 Ziff Communcations  PC Magazine  Jay Munro"
PRINT "Some portions Copyright (c) 1990 Crescent Software"
PRINT "PCBOOK /? for help"
PRINT STRING$(80, 61)
END SUB

SUB PrintSetup
'Left Side margins
    LL$ = "2"
    LR$ = "82"
'Right Side margins
    RL$ = "95"
    RR$ = "185"

'============== Send codes to prepare printer
DO
    IF PrintLine%(ESC$ + "E") THEN EXIT DO               'Reset laserjet (simple isn't it!)
    IF PrintLine%(ESC$ + "&l1o5.45C") THEN EXIT DO       'Select lineprinter font"
    IF PrintLine%(ESC$ + "(s0p16.66H") THEN EXIT DO      '  and pitch
    IF PrintLine%(ESC$ + "&l0L") THEN EXIT DO            'Turn off page feed at 66 lines

    IF PC.LineWrap THEN                                  'Wrap lines > 80 chars
       IF PrintLine%(ESC$ + "&s0C") THEN EXIT DO
    END IF

    IF PrintLine%(ESC$ + "&l2E") THEN EXIT DO            'Top margin 2 lines

'======== Macros to control page printing
    IF PrintLine%(ESC$ + "&f1Y") THEN EXIT DO            'Macro will have an id of 1
    IF PrintLine%(ESC$ + "&f0X") THEN EXIT DO            'Start the macro now
    IF PrintLine%(ESC$ + "9") THEN EXIT DO               'Reset left - right margins
    IF PrintLine%(ESC$ + "&a" + LL$ + "l" + LR$ + "M") THEN EXIT DO 'set margins
    IF PrintLine%(ESC$ + "&a0r" + LL$ + "C") THEN EXIT DO 'Home the cursor
    IF PrintLine%(ESC$ + "&f1y1X") THEN EXIT DO          'Send end of macro command
    IF PrintLine%(ESC$ + "&f1y9X") THEN EXIT DO          'Make it temporary (10 to be permanent)

'Right Side macro
    IF PrintLine%(ESC$ + "&f2Y") THEN EXIT DO            'Macro will have an id of 2
    IF PrintLine%(ESC$ + "&f0X") THEN EXIT DO            'Start the macro now
    IF PrintLine%(ESC$ + "9") THEN EXIT DO               'Reset left - right margins
    IF PrintLine%(ESC$ + "&a" + RL$ + "l" + RR$ + "M") THEN EXIT DO 'set margins
    IF PrintLine%(ESC$ + "&a0r" + RL$ + "C") THEN EXIT DO 'Home the cursor
    IF PrintLine%(ESC$ + "&f2y1X") THEN EXIT DO          'Send end of macro command
    IF PrintLine%(ESC$ + "&f2y9X") THEN EXIT DO          'Make it temporary (10 to be permanent)
    PC.ErrFlag = 0
    EXIT SUB
LOOP
    
ErrorExit:
    PC.ErrFlag = -1
END SUB

