;****************************************************************************
; RENDIR renames subdirectories.  Its syntax is:
;
;       RENDIR [d:][path]dirname1 dirname2
;
; where "dirname1" is the current name of the subdirectory and "dirname2"
; is the new name it's to be given.  RENDIR requires DOS 3.0 or later.
;****************************************************************************

code            segment
                assume  cs:code,ds:code
                org     100h
begin:          jmp     main

helpmsg         db      "Renames a subdirectory.",13,10,13,10
                db      "RENDIR [d:][path]dirname1 dirname2",13,10,13,10
                db      "  dirname1   Current subdirectory name."
                db      13,10
                db      "  dirname2   New subdirectory name.",13,10,"$"

errmsg1         db      "DOS 3.0 or later required",13,10,"$"
errmsg2         db      "Syntax: RENDIR [d:][path]dirname1 dirname2",13,10,"$"
errmsg3         db      "Subdirectory not found or path invalid",13,10,"$"
errmsg4         db      "Not a subdirectory",13,10,"$"
errmsg5         db      "A file or subdirectory of that name already "
                db      "exists",13,10,"$"
errmsg6         db      "Cannot rename the current directory",13,10,"$"
errmsg7         db      "Subdirectory could not be renamed",13,10,"$"

param1          dw      ?                       ;Address of first parameter
endparam1       dw      ?                       ;Ending address of parameter
param2          dw      ?                       ;Address of second parameter

;****************************************************************************
; Procedure MAIN
;****************************************************************************

main            proc    near
                cld                             ;Clear direction flag
                mov     si,81h                  ;Point SI to command line
                call    scanhelp                ;Scan for "/?" switch
                jnc     checkver                ;Branch if not found
                mov     ah,09h                  ;Display help text and exit
                mov     dx,offset helpmsg       ;  with ERRORLEVEL=0
                int     21h
                mov     ax,4C00h
                int     21h
;
; Check DOS version and exit if less than 3.0.
;
checkver:       mov     ah,30h                  ;Get DOS version
                int     21h
                cmp     al,3                    ;Continue of 3.0 or
                jae     parse                   ;  later

                mov     dx,offset errmsg1       ;Display error message and
error:          mov     ah,09h                  ;  exit with ERRORLEVEL=1
                int     21h
                mov     ax,4C01h
                int     21h
;
; Parse the command line for parameters.
;
parse:          mov     dx,offset errmsg2       ;Initialize error pointer
                call    findchar                ;Find first entry
                jc      error                   ;Error if not found
                mov     param1,si               ;Save address
                call    finddelim               ;Find end of entry
                jc      error                   ;Exit if end of line
                mov     byte ptr [si],0         ;Convert to ASCIIZ
                mov     endparam1,si            ;Save address

                inc     si                      ;Advance SI past 0
                call    findchar                ;Find second entry
                jc      error                   ;Error if not found
                mov     param2,si               ;Save address
                cmp     byte ptr [si+1],":"     ;Error if "dirname2" has a
                jc      error                   ;  drive specifier attached
                call    finddelim               ;Find end of entry
                mov     byte ptr [si],0         ;Convert to ASCIIZ

                mov     cx,si                   ;Get length of "dirname2"
                sub     cx,param2               ;  in CX
                inc     cx
                mov     di,param2               ;Point DI to "dirname2"
                mov     al,"\"                  ;Scan "dirname2" for "\"
                repne   scasb                   ;  characters
                je      error                   ;Error if found
;
; Make sure the subdirectory exists and that it's not a file.
;
                mov     ax,4300h                ;Get attributes
                mov     dx,param1
                int     21h
                mov     dx,offset errmsg3       ;Error if entry does not
                jc      error                   ;  exist
                mov     dx,offset errmsg4       ;Error if entry is a file,
                test    cx,10h                  ;  not a subdirectory
                jz      error
;
; Build the specification for the new subdirectory name.
;
                mov     cx,endparam1            ;Get length of "dirname1"
                sub     cx,param1               ;  in CX
                mov     di,endparam1            ;Point DI to the end of
                dec     di                      ;  "dirname1"
                mov     al,"\"
                std
                repne   scasb                   ;Scan for "\" character
                cld
                mov     di,offset newname
                jne     copyname                ;Branch if none found

                mov     si,param1               ;Copy everything up to and
                inc     cx                      ;  including the final "\"
                rep     movsb                   ;  to NEWNAME

copyname:       mov     si,param2               ;Append "dirname2" to the
copy2:          movsb                           ;  end of the string
                cmp     byte ptr [si-1],0
                jne     copy2
;
; Make sure a file or directory with the new name doesn't already exist.
;
                mov     ax,4300h                ;Get attributes
                mov     dx,offset newname
                int     21h
                mov     dx,offset errmsg5       ;Error if entry already
                jnc     goto_error              ;  exists
;
; Rename the subdirectory and exit.
;
                mov     ah,56h                  ;Rename it with DOS
                mov     dx,param1               ;  function 56H
                mov     di,offset newname
                int     21h
                jnc     exit                    ;Exit if call succeeded

                mov     dx,offset errmsg6       ;Error if user tried to
                cmp     ax,10h                  ;  rename current directory
                je      goto_error
                mov     dx,offset errmsg7       ;All other errors
goto_error:     jmp     error

exit:           mov     ax,4C00h                ;Exit with ERRORLEVEL=0
                int     21h
main            endp

;****************************************************************************
; FINDCHAR advances SI to the next non-space or non-comma character.
; On return, carry set indicates EOL was encountered.
;****************************************************************************

findchar        proc    near
                lodsb                           ;Get the next character
                cmp     al,20h                  ;Loop if space
                je      findchar
                cmp     al,2Ch                  ;Loop if comma
                je      findchar
                dec     si                      ;Point SI to the character
                cmp     al,0Dh                  ;Exit with carry set if end
                je      eol                     ;  of line is reached

                clc                             ;Clear carry and exit
                ret

eol:            stc                             ;Set carry and exit
                ret
findchar        endp

;****************************************************************************
; FINDDELIM advances SI to the next space or comma character.  On return,
; carry set indicates EOL was encountered.
;****************************************************************************

finddelim       proc    near
                lodsb                           ;Get the next character
                cmp     al,20h                  ;Exit if space
                je      fd_exit
                cmp     al,2Ch                  ;Exit if comma
                je      fd_exit
                cmp     al,0Dh                  ;Loop back for more if end
                jne     finddelim               ;  of line isn't reached

                dec     si                      ;Set carry and exit
                stc
                ret

fd_exit:        dec     si                      ;Clear carry and exit
                clc
                ret
finddelim       endp

;****************************************************************************
; SCANHELP scans the command line for a /? switch.  If found, carry returns
; set and SI contains its offset.  If not found, carry returns clear.
;****************************************************************************

scanhelp        proc    near
                push    si                      ;Save SI
scanloop:       lodsb                           ;Get a character
                cmp     al,0Dh                  ;Exit if end of line
                je      scan_exit
                cmp     al,"?"                  ;Loop if not "?"
                jne     scanloop
                cmp     byte ptr [si-2],"/"     ;Loop if not "/"
                jne     scanloop

                add     sp,2                    ;Clear the stack
                sub     si,2                    ;Adjust SI
                stc                             ;Set carry and exit
                ret

scan_exit:      pop     si                      ;Restore SI
                clc                             ;Clear carry and exit
                ret
scanhelp        endp

newname         =       $                       ;New subdirectory name

code            ends
                end     begin
