;****************************************************************************
; SETPOS sets the cursor position to the row and column specified.  Its
; syntax is:
;
;       SETPOS row col
;
; where "row" is the row where the cursor should be placed and "col" is
; the column.  Row and column numbers are zero-based, so the upper left
; corner of the screen is 0,0.
;****************************************************************************

code            segment
                assume  cs:code,ds:code
                org     100h
begin:          jmp     short main

msg1            db      13,10,"Syntax: SETPOS row col",13,10,"$"
msg2            db      13,10,"Invalid parameter",13,10,"$"
row             db      ?

;****************************************************************************
; Procedure MAIN
;****************************************************************************

main            proc    near
                cld                             ;Clear direction flag
                mov     si,81h                  ;Point SI to command line
                call    findchar                ;Advance to first character
                jnc     parse                   ;Branch if found

error1:         mov     dx,offset msg1          ;Display error message
error2:         mov     ah,09h
                int     21h
                mov     ax,4C01h                ;Exit with ERRORLEVEL=1
                int     21h
;
; Parse the command line entries.
;
parse:          call    asc2bin                 ;Get the row number
                mov     dx,offset msg2
                jc      error2
                mov     row,al

                call    findchar                ;Advance to next character
                jc      error1

                call    asc2bin                 ;Get the column number
                mov     dx,offset msg2
                jc      error2
                mov     dl,al                   ;Place row and column in
                mov     dh,row                  ;  DH and DL
;
; Set the cursor position and exit.
;
                mov     ah,0Fh                  ;Get active page number
                int     10h                     ;  in BH
                mov     ah,02h                  ;Set cursor position
                int     10h
                mov     ax,4C00h                ;Exit with ERRORLEVEL=0
                int     21h
main            endp

;****************************************************************************
; FINDCHAR advances SI to the next non-space or non-comma character.
; On return, carry set indicates EOL was encountered.
;****************************************************************************

findchar        proc    near
                lodsb                           ;Get the next character
                cmp     al,20h                  ;Loop if space
                je      findchar
                cmp     al,2Ch                  ;Loop if comma
                je      findchar
                dec     si                      ;Point SI to the character
                cmp     al,0Dh                  ;Exit with carry set if end
                je      eol                     ;  of line is reached

                clc                             ;Clear carry and exit
                ret

eol:            stc                             ;Set carry and exit
                ret
findchar        endp

;****************************************************************************
; ASC2BIN converts a decimal number entered in ASCII form into a binary
; value in AL.  Carry set on return indicates that an error occurred in
; the conversion.
;****************************************************************************

asc2bin         proc    near
                sub     ax,ax                   ;Initialize registers
                sub     bh,bh
                mov     dl,10

a2b_loop:       mov     bl,[si]                 ;Get a character
                inc     si
                cmp     bl,20h                  ;Exit if space
                je      a2b_exit
                cmp     bl,2Ch                  ;Exit if comma
                je      a2b_exit
                cmp     bl,0Dh                  ;Exit if carriage return
                je      a2b_exit

                cmp     bl,"0"                  ;Error if character is not
                jb      a2b_error               ;  a number
                cmp     bl,"9"
                ja      a2b_error

                mul     dl                      ;Multiply the value in AL by
                jc      a2b_error               ;  10 and exit on overflow
                sub     bl,30h                  ;ASCII => binary
                add     ax,bx                   ;Add latest value to AX
                cmp     ax,255                  ;Error if sum > 255
                jna     a2b_loop                ;Loop back for more

a2b_error:      dec     si                      ;Set carry and exit
                stc
                ret

a2b_exit:       dec     si                      ;Clear carry and exit
                clc
                ret
asc2bin         endp

code            ends
                end     begin
