;****************************************************************************
; WAITTIL delays until a specified hour, minute, and, optionally, second
; is reached.  Its syntax is:
;
;       WAITTIL hh:mm[:ss]
;
; where "hh" represents hours (miltary format), "mm" minutes, and "ss"
; seconds.  Example:
;
;       WAITTIL 18:30:00
;
; causes a batch file to pause until 6:30 p.m.  The delay loop can be
; interrupted with Ctrl-C or Ctrl-Break.
;****************************************************************************

code            segment
                assume  cs:code,ds:code
                org     100h
begin:          jmp     short main

msg1            db      13,10,"Syntax: WAITTIL hh:mm[:ss]",13,10,"$"
msg2            db      13,10,"Invalid parameter",13,10,"$"
hours           db      ?
minutes         db      ?
seconds         db      0

;****************************************************************************
; Procedure MAIN
;****************************************************************************

main            proc    near
                cld                             ;Clear direction flag
                mov     si,81h                  ;Point SI to command line
                call    findchar                ;Advance to first character
                jnc     parse                   ;Branch if found

error1:         mov     dx,offset msg1          ;Error if no command line
error2:         mov     ah,09h                  ;  parameters entered
                int     21h
                mov     ax,4C01h                ;Exit with ERRORLEVEL=1
                int     21h
;
; Parse the command line and determine the specified time.
;
parse:          call    asc2bin                 ;Get hours
                jc      error1
                mov     hours,al
                cmp     bl,3Ah                  ;Syntax error if no colon
                jne     error1
                mov     dx,offset msg2          ;Error if greater than 23
                cmp     al,23
                ja      error2

                call    asc2bin                 ;Get minutes
                jc      error1
                mov     minutes,al
                mov     dx,offset msg2          ;Error if greater than 59
                cmp     al,59
                ja      error2
                cmp     bl,3Ah                  ;Done if no colon
                jne     delay

                call    asc2bin                 ;Get seconds
                jc      error1
                mov     seconds,al
                mov     dx,offset msg2          ;Error if greater than 59
                cmp     al,59
                ja      error2
;
; Wait until the specified time arrives, then terminate.
;
delay:          mov     ah,0Bh                  ;Check the keyboard buffer
                int     21h
                or      al,al                   ;Branch if no key codes are
                jz      gettime                 ;  awaiting processing

                mov     ah,08H                  ;Read character
                int     21h
                or      al,al                   ;Branch if not an extended
                jz      gettime                 ;  key code
                mov     ah,08h                  ;Read extended key code
                int     21h

gettime:        mov     ah,2Ch                  ;Get current time
                int     21h                     ;  from DOS
                cmp     ch,hours                ;Compare hours
                jne     delay
                cmp     cl,minutes              ;Compare minutes
                jb      delay
                cmp     dh,seconds              ;Compare seconds
                jb      delay
                mov     ax,4C00h                ;Exit with ERRORLEVEL=0
                int     21h
main            endp

;****************************************************************************
; FINDCHAR advances SI to the next non-space character.  On return,
; carry set indicates EOL was encountered.
;****************************************************************************

findchar        proc    near
                lodsb                           ;Get the next character
                cmp     al,20h                  ;Loop if space
                je      findchar
                dec     si                      ;Point SI to the character
                cmp     al,0Dh                  ;Exit with carry set if end
                je      eol                     ;  of line is reached

                clc                             ;Clear carry and exit
                ret

eol:            stc                             ;Set carry and exit
                ret
findchar        endp

;****************************************************************************
; ASC2BIN converts a decimal number entered in ASCII form into a binary
; value in AL.  Carry set on return indicates that an error occurred in
; the conversion.
;****************************************************************************

asc2bin         proc    near
                sub     ax,ax                   ;Initialize registers
                sub     bh,bh
                mov     dl,10

a2b_loop:       mov     bl,[si]                 ;Get a character
                inc     si
                cmp     bl,20h                  ;Exit if space
                je      a2b_exit
                cmp     bl,3Ah                  ;Exit if colon
                je      a2b_exit
                cmp     bl,0Dh                  ;Exit if carriage return
                je      a2b_exit

                cmp     bl,"0"                  ;Error if character is not
                jb      a2b_error               ;  a number
                cmp     bl,"9"
                ja      a2b_error

                mul     dl                      ;Multiply the value in AL by
                jc      a2b_error               ;  10 and exit on overflow
                sub     bl,30h                  ;ASCII => binary
                add     ax,bx                   ;Add latest value to AX
                cmp     ax,255                  ;Error if sum > 255
                jna     a2b_loop                ;Loop back for more

a2b_error:      stc                             ;Set carry and exit
                ret

a2b_exit:       clc                             ;Clear carry and exit
                ret
asc2bin         endp

code            ends
                end     begin
