// FILEDATE.CPP Part of VULCAN
// Copyright (c) 1993 John Deurbrouck
#include<windows.h>
#include<time.h>
#include"filedate.hpp"

typedef union{
     unsigned int ff_ftime;
     struct time_bit_struct{
          unsigned ft_tsec:5;
          unsigned ft_min:6;
          unsigned ft_hour:5;
     }time_bits;
}dos_time_split;
typedef union{
     unsigned int ff_fdate;
     struct date_bit_struct{
          unsigned fd_day:5;
          unsigned fd_month:4;
          unsigned fd_year:7;
     }date_bits;
}dos_date_split;
static char unknown[]="(unknown)";

void get_ascii_time(LPSTR buffer,unsigned dos_time,unsigned dos_date){
    if(!dos_time && !dos_date){
        lstrcpy(buffer,unknown);
        return;
    }
    if(!dos_date){
        wsprintf(buffer,"(no date) ");
    }
    else{
        dos_date_split ds;
        ds.ff_fdate=dos_date;
        int year=ds.date_bits.fd_year+80;
        if(year>100)year+=1900; // show as 2009 sted 109
        wsprintf(buffer,"%02d-%02d-%02d ",
            (int)(ds.date_bits.fd_month),
            (int)(ds.date_bits.fd_day),
            year);
    }
    while(*buffer)buffer++; // end of string
    {
        dos_time_split ts;
        ts.ff_ftime=dos_time;
        int pm=ts.time_bits.ft_hour>11?1:0;
        ts.time_bits.ft_hour%=12;
        if(!ts.time_bits.ft_hour)ts.time_bits.ft_hour=12;
        wsprintf(buffer,"%2d:%02d%c",
            (int)(ts.time_bits.ft_hour),
            (int)(ts.time_bits.ft_min),
            (int)(pm?'p':'a'));
    }
}
#if(0)
// time_t version might be handy...
void get_ascii_time(LPSTR buffer,time_t time){
    if(time==0){
        lstrcpy(buffer,unknown);
        return;
    }
    tm *ltp=localtime(&time);
    int pm=ltp->tm_hour>11?1:0;
    ltp->tm_hour%=12;
    if(!ltp->tm_hour)ltp->tm_hour=12;
    wsprintf(buffer,"%02d-%02d-%02d %2d:%02d%c",
        (int)(ltp->tm_mon+1),
        (int)(ltp->tm_mday),
        (int)(ltp->tm_year),
        (int)(ltp->tm_hour),
        (int)(ltp->tm_min),
        (int)(pm?'p':'a'));
}
#endif
