                *** ANSIPLUS VERSION 3.10 RELEASE NOTES ***
                             Shareware Package

Thank you for evaluating ANSIPLUS.  This file briefly describes ANSIPLUS, lists
the files included in the ANSIPLUS Shareware package, gives quick installation
instructions, and describes recent changes made to ANSIPLUS.


What is ANSIPLUS?
---- -- ---------

The ANSIPLUS console device driver integrates major console elements missing
from DOS and the personal computer BIOS into a single compact device driver
that can easily be controlled and personalized.  With ANSIPLUS installed:

 * User interaction with the DOS command shell and many applications will be
   significantly improved.

 * Screen output will be faster than with DOS's ANSI and non-ANSI drivers.

 * The user will have complete control over colors and VGA/EGA capabilities.

 * Users of Windows 3 will have access to ANSIPLUS features in all windowed and
   full screen DOS sessions.

 * The user will also benefit from all the other display and keyboard features
   provided by ANSIPLUS.


The ANSIPLUS enhanced DOS console device driver is tailored to take advantage
of VGA and EGA display capabilities:

 * It automatically adapts to VGA or EGA screen modes, both text and graphics,
   including extended modes with large numbers of lines and/or columns.  The
   driver also automatically compensates for older video controllers with very
   limited numbers of colors or shades (eg.  CGA or monochrome boards).

 * In text and in 16-color VGA/EGA graphics display modes, the driver bypasses
   the BIOS and writes directly to the video RAM, so it can operate much faster
   than either the original DOS console driver or the DOS ANSI driver.

 * ANSIPLUS gives the user control over VGA/EGA palette registers and VGA DAC
   registers to select and maintain colors using the video controller's full
   capabilities.

 * Text character height can be selected in any VGA/EGA display mode, extending
   user control to the number of lines per display page.

 * Smooth scrolling is provided as an option (requires a faster computer, eg.
   80386 with 16-bit VGA).



The ANSIPLUS driver efficiently integrates several useful console functions
that in the past had to be provided by separate TSR programs or device drivers:

 * A screen saver monitors display, keyboard and mouse activity.

 * Scroll-back lets the user examine lines that have scrolled off the top of
   the screen.

 * Fast screen output can be frozen and released with the Scroll Lock key.

 * Keyboard buffer size is increased and configurable.

 * Undesired repeat keys are suppressed and several other key processing
   options are provided.

 * Keys can be added to the keyboard buffer under program control for later
   consumption by programs.

 * A timer-controlled beep tone generator allows user customizable tones.

Other ANSIPLUS features include:

 * Menu driven, mouse controllable utilities that give the user full control
   over selected colors, color palettes, border colors, video modes, text
   height, key reassignment, beep tone definition, driver table sizes, and all
   other configurable features.

 * Special loading options for XMS upper memory blocks, high memory area and
   expanded memory reduce low memory requirements to below 5K.

 * Highlighting of user-typed keys when they are displayed by DOS on the screen
   to give a clear visual separation of typed entries from computer output.

 * Support for all DOS ANSI.sys escape sequences, plus additional ANSI/VT-100
   escape sequences for clearing the screen, erasing lines, inserting and
   deleting lines, and inserting and deleting characters.

 * Free BBS updates.  Registered ANSIPLUS users can obtain free updates by
   installing future Shareware versions of ANSIPLUS over their registered
   copies.  The ANSIPLUS installation program will automatically register a
   Shareware copy when it is installed on a disk that boots a registered copy.

 * And much, much more.

See "Features Summary" in the ANSIPLUS documentation for more information about
ANSIPLUS features.


ANSIPLUS Packing List
-------- ------- ----

     File                Description
     ----                -----------

     ANSIPLUS.sys        ANSIPLUS console device driver
     ANSIPLUS.doc        ANSIPLUS Shareware documentation
     SETCOLOR.exe        Color control utility program
     SETAPLUS.exe        Driver features control utility program
     ANSICOM.exe         ANSI escape sequence editor
     NEWAPLUS.exe        ANSIPLUS bootup configuration program
     APLUSLIB.exe        Execution library for the utility programs
     SETCOLOR.sch        Color schemes file for SETCOLOR.exe
     CONSETUP.com        Sample escape sequence program
     PUSHVID.com         Save current video mode, video page and colors
     POPVID.com          Restore saved video mode, page and colors
     LOCKPAL.com         Lock the 16-color palette
     UNLOKPAL.com        Unlock the 16-color palette
     WINVGA16.com        MS Windows 16-color VGA driver palette change
     APLUS.pif           Sample Windows PIF file
     INSTALL.exe         Installation program
     INSTALL.inf         Installation control file
     REGISTER.pls        ANSIPLUS registration form
     README.pls          Release notes, this file


The documentation file, ANSIPLUS.doc, is a complete and up to date copy of the
ANSIPLUS Shareware manual, except for the section on ANSIPLUS Escape Sequences,
which are covered in detail only in the printed version.  The file is formatted
for 80 characters per line and 60 lines per page, and uses no special
characters or other printer control other than form feeds.



Quick Installation Instructions
----- ------------ ------------

Before installing ANSIPLUS, or any other new device driver, be sure you have a
bootable floppy disk as insurance against trouble getting your system to run
after the device driver is installed.

The ANSIPLUS package includes an installation and configuration program called
INSTALL.exe, which should properly handle most installations.  Context
sensitive help (via the F1 key) is provided for all entries.  The following
three examples illustrate using INSTALL to install ANSIPLUS:

 * If you received ANSIPLUS on a floppy disk and want to install it on your
   hard disk, use the following installation procedure:

    (1) Set the default directory to the hard disk (ie. get a C> prompt).
    (2) Insert the ANSIPLUS diskette in drive A: (or other floppy drive).
    (3) Enter the following command:

            A:INSTALL

 * If you received ANSIPLUS as a ZIP file, use the following procedure:

    (1) Create a temporary sub-directory  on the hard disk to contain the
        unzipped ANSIPLUS files. Move ANSIPLUS.zip to this directory and make
        it be the default directory. This directory must be different from the
        directory that will receive the installed ANSIPLUS files.
    (2) Unzip the files into the directory with the command:

            PKUNZIP ANSIPLUS

    (3) Then enter the command:

            INSTALL

 * To install ANSIPLUS on bootable disk B:, from hard disk directory C:\APLUS,
   enter the command:

            C:\APLUS\INSTALL B:

International users should be aware of the following:

 * If you are using the KEYB program to set up your keyboard, the following
   command MUST be executed after you load KEYB, otherwise most ANSIPLUS
   keyboard related features will not work:

            SETAPLUS LINK KEYEVENT

   The INSTALL program will automatically add this command to your AUTOEXEC.bat
   file if it finds a reference in it to KEYB.

 * If you are using the DISPLAY.sys device driver for code page switching, the
   ANSIPLUS device driver must be installed before DISPLAY.sys in your
   CONFIG.sys file.  The INSTALL program will also automatically handle this.

See "Installing ANSIPLUS" in the documentation for more information about
ANSIPLUS installation and configuration.


Recent ANSIPLUS Changes
------ -------- -------

 4/06/94 Version 3.10 released.

 3/08/94 The NEWAPLUS installation and configuration utility should now be able
         to locate CONFIG.sys and the ANSIPLUS driver file on systems using
         Stacker or similar disk compression utilities that can have their hard
         disk drive letters changed around.  NEWAPLUS will now search other
         drives for CONFIG.sys when it is not found on the original boot drive,
         and it will also search other drives when the ANSIPLUS driver is not
         found where CONFIG.sys says it will be.  A system environment variable
         (SET ANSIPLUS=d:) may also be used to identify the drive containing
         CONFIG.sys and the ANSIPLUS driver, and this will override any search.

 3/06/94 The NEWAPLUS and SETAPLUS utilities now use second-level menus to
         directly select features for explanation or revision, rather than
         forcing the user to go through all the features in a group one at a
         time.  Features now can also be enabled or disabled easily with
         special keys or the mouse directly from the menu.

 2/28/94 The ANSIPLUS scroll-back functions have been extensively rewritten.
         Major improvements include:

         (1) The driver can now use expanded memory (LIM EMS 4.0) to hold up to
             64k of scroll-back data (about 1,000 lines), roughly doubling
             scroll-back capacity.  Use of EMS for scroll-back instead of video
             RAM also eliminates compatibility problems with Windows video
             drivers caused by memory accesses to video RAM locations not
             visible on the virtual screen, or to RAM not retained by Windows.

         (2) When scrolling back, the Home/End, Page Up/Down and Tab/Shift-Tab
             keys now move instantly through the data, rather than a line at a
             time.

         (3) Under Windows, scroll-back lines now are captured as they are
             completed, rather than as they scroll off the top of the screen.
             This change was made because some Windows video drivers (eg.,
             Microsoft VGA) trap BIOS scrolling requests completely when
             running a DOS session in a window, making it impossible for
             ANSIPLUS to know when the screen has scrolled if a BIOS call was
             used to do it.  Some important DOS programs now mix DOS output
             with BIOS calls for scrolling (eg., 4DOS 5.0 (and NDOS 8.0) when
             displaying multi-colored directories).


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 2/26/94 Under Windows, when running a DOS session in a window using
         Microsoft's 16-color VGA video driver, only 13 distinct colors were
         available on the ANSIPLUS 16 color palette (ie., 3 colors were
         duplicated: brown was the same as dark red, light blue was the same as
         light cyan, and pink was white.) Other video drivers do not seem to
         have this problem because they do not try to adapt to color palette
         settings made by programs running in a window.  The standard ANSIPLUS
         palette has been adjusted slightly to allow brown to show as dark
         yellow and light blue as light blue under the Microsoft VGA driver.
         Pink can be converted to light magenta by running the WINVGA16.com
         program now provided with ANSIPLUS.  See "ANSIPLUS and Windows 3" in
         the documentation for more information.

 2/12/94 Two new scroll-back control keys have been added for deleting lines
         from scroll-back storage: Control-Home will delete all scroll-back
         lines that are before the lines currently on the screen, and
         Control-End will delete all lines currently on the screen and later.

 1/31/94 The ANSIPLUS Int 2Fh installation check now returns the ANSIPLUS
         version number in CX: CH = major version, CL = minor version.

 1/05/94 After the screen saver has blanked the screen, if the screen is then
         unblanked by a keystroke, the key will now be ignored as input.

 1/04/94 The text currently available for scrollback can now be saved to a file
         or sent to the printer (ie., to file PRN).  The function is performed
         by two new SETAPLUS command options:

          SETAPLUS SAVESCROLLTEXT <file>  saves all scrollback text to a file
          SETAPLUS SAVESCROLLANSI <file>  saves the scrollback text with ANSI
                                          escape sequences for color control

 1/04/94 Bug fix: Under the 4DOS and NDOS command shells, when bright key
         echoing is enabled, ANSIPLUS will highlight the entire DOS command
         line during entry, not just keys echoed on the screen.  Unfortunately,
         the Int 2Fh calls issued before and after command entries by older
         versions of 4DOS (before 4.0) and NDOS (before 7.0) are not the same
         as those used currently, and this caused output highlighting to remain
         in effect after a command is entered.  The special command line
         highlighting feature is now disabled for the older 4DOS/NDOS command
         shells.

12/29/93 Bug fix: INSTALL/NEWAPLUS could hang while analyzing the system
         configuration if the system PATH referred to a non-existent drive.

12/17/93 Version 3.02 released.

12/17/93 Bug fix: The key input buffers are now cleared whenever the screen is
         frozen by the Scroll-Lock key, so type-ahead now will not be processed
         as Scroll-Back control.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

12/04/93 Bug fix: Programs that mix DOS character output and Int 10h BIOS
         scrolling, such as 4DOS 5.0 when it is using multiple directory
         colors, would sometimes have the entire screen added to scroll-back
         storage by the BIOS scrolling call instead of just the lines scrolled
         off the top.

12/03/93 For systems with limited available XMS upper memory, ANSIPLUS can now
         load its shared code to expanded memory (EMS), leaving only about 5K
         of the driver that must be loaded into either low memory or XMS upper
         memory.  See the loading option discussion under "Changing the
         ANSIPLUS Startup Configuration" in the documentation for cautions on
         using this feature.  Configuration is handled by selecting the loading
         option in NEWAPLUS, or by the following CONFIG.sys command:

                DEVICE = ANSIPLUS.sys /E

 9/30/93 To simplify setting up key reassignments when the system is booted,
         the new SETAPLUS SAVEKEYS <filename> command can now save all current
         key reassignments to a file which can later be loaded in AUTOEXEC.bat.
         If <filename> ends in ".com", the keys are saved as an executable
         program.  Otherwise, they are saved as an ASCII file that is loadable
         by the SETAPLUS LOADKEYS <filename> command.

 9/29/93 Bug fix: When the keyboard break interrupt was taken over by a TSR,
         ANSIPLUS would lose its ability to translate Control-Break into
         Control-C at the DOS prompt.  And when some applications bypassed DOS
         keyboard input (used Int 16h instead), but did not take over keyboard
         break, ANSIPLUS could defer action on a Control-Break entered to the
         application until after it terminated and normal DOS prompting and
         keyboard input was resumed.

 9/22/93 Version 3.01 released.

 9/11/93 Independent key reassignment has been extended to the gray keys on
         enhanced keyboards.  Gray keys that are also on the numeric keypad
         (for example, Home or PageUp) may optionally share reassignment with
         or be independent of the numeric keypad key.  Gray key reassignments
         may be defined either in SETAPLUS or by ANSI escape sequence.

 9/07/93 The screen saver blanking time can now be changed while the system is
         running, either with the new SETAPLUS BLANKTIME <minutes> command or
         from the SETAPLUS menu.

 9/06/93 The "typematic" key delay can now be controlled by ANSIPLUS.  Bootup
         configuration is set with NEWAPLUS, and runtime changes are made using
         the SETAPLUS menu or the new SETAPLUS DELAY <quartersecs> command.

 9/03/93 The SETAPLUS "Set Video Display Mode" menu now captures and displays
         VESA mode numbers instead of OEM mode numbers for VESA-defined modes.

 8/29/93 SETAPLUS INTERRUPT reports should now handle more driver and TSR
         combinations correctly.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 8/28/93 The screen saver now delays hooking Int 74h (PS/2 mouse events) or
         testing the MS-Mouse on Int 33h until after one minute of idle time
         passes (or half the screen saver blanking time, whichever is less).

 8/25/93 Key reassignment can now be applied either to keys entered through DOS
         or to all keys entered through both DOS and BIOS Interrupt 16h.  This
         new configurable feature now makes it possible to reassign keys for
         applications that bypass DOS and use Int 16h for keyboard input.

 8/21/93 Bug fix: As a "last resort" test for system activity, the screen saver
         was reading scan codes from the keyboard controller at port 60h.
         Unfortunately, on some computers, reading this port during timer ticks
         can interfere with processing of the arrow and page up/down keys on an
         enhanced keyboard and with a PS/2-type mouse.  Two changes were made
         to eliminate the problem: reading of port 60h by the screen saver is
         now a configurable feature (disabled by default); and when this
         feature is enabled, one minute of complete inactivity must elapse
         before the saver will read port 60h.

 8/03/93 Bug fix: To be consistent with the MS-DOS 4.0-6.0 ANSI.sys drivers,
         the escape sequence parser now generates a zero parameter when an
         omitted parameter is implied by the presence of a separator (so, for
         example, "Esc [;20H" is now equivalent to "Esc [0;20H").

 7/19/93 Bug fix: SETCOLOR SCHEME HELP got stuck in an error message loop.
         Now, the current color schemes in file SETCOLOR.sch are listed, or, if
         the file cannot be found, a single error message is displayed.

 7/14/93 The driver now saves and restores the VGA graphics controller index
         (port 3CEh) when analyzing video modes.

 6/22/93 Bug fixes: In CGA modes 4 or 5, the ANSIPLUS color palette was being
         loaded into the PAL/DAC registers, which changed the colors from the
         CGA 4-color scheme (black, magenta, cyan and white) to something else.
         The driver also now reduces the foreground and background colors from
         16 to 4 properly, assuring visibility of the foreground over the
         background for DOS output in the 4-color CGA modes.

 6/09/93 Bug fixes: INSTALL/NEWAPLUS refused to register drivers with serial
         numbers that start with zero.  Also, when the registered ANSIPLUS.exe
         driver was installed over the ANSIPLUS.sys Shareware driver, an
         incorrect DEVICE= line would be left in CONFIG.sys if the user had
         edited it to contain "ansiplus.sys" in lower case.

 5/29/93 Bug fix: If the "Prevent ANSI Key Reassignment Redefinition" feature
         was enabled in NEWAPLUS, subsequent executions of NEWAPLUS would
         terminate with a numeric overflow error.  This feature happens to use
         the 32nd feature bit, and operations to get/set this bit had a bug.

 5/25/93 Bug fix: SETCOLOR BORDER <colorname> was not setting the border to the
         correct named color.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 5/23/93 The INSTALL/NEWAPLUS program now will not copy ANSIPLUS files unless
         it was invoked by the INSTALL commmand.  If ANSIPLUS is already
         installed, running NEWAPLUS, even from a directory that contains
         INSTALL.inf, will only allow changes to the boot configuration for a
         currently installed driver.  In the installation copying process,
         NEWAPLUS will now check to be sure that the ANSIPLUS driver is not
         being installed in the same directory as it is being copied from.

 5/23/93 Bug fix: In ANSICOM, when a file was inserted via the Insert key, the
         screen was not updated properly after the insertion, and an execution
         error would sometimes be reported by the program.

 5/17/93 Version 3.00 released.

 5/11/93 The keyboard repeat rate can now optionally be controlled by the
         ANSIPLUS driver.  Rates from 20 to 300 characters per second are
         accepted by both the SETAPLUS and NEWAPLUS utility programs.  The
         feature requires an enhanced keyboard, and is disabled under Windows
         because timing is imprecise when Windows is running.

 5/08/93 ANSIPLUS can now load itself into high memory (HMA) under DOS versions
         before 5.0, or under DOS 5.0/6.0 whether DOS=HIGH is in CONFIG.sys or
         not.  The HMA is now allocated by calling DOS, by XMS driver call, or
         by using the "VDISK.sys" method.

 5/03/93 Setting the text height by escape sequence or IOCTL call (eg., by MODE
         command) can now preserve the contents of the screen using XMS memory.
         This feature is automatically activated if preserving scroll-back data
         with XMS memory is enabled.

 4/23/93 The NEWAPLUS, SETAPLUS, SETCOLOR and ANSICOM utility programs all now
         support use of the mouse for menu and other selections.

 4/20/93 INSTALL/NEWAPLUS now recognizes MS-DOS 6.0 CONFIG.sys files that have
         menus and multiple configuration blocks.  Installations require that
         the user select the configuration block to receive ANSIPLUS.  Updates
         to reconfigure a driver will select from only those blocks that refer
         to ANSIPLUS.  Several other maintenance changes were also made to
         NEWAPLUS.

 4/13/93 A TSR-capable version of the ANSIPLUS driver, ANSIPLUS.exe, is now
         supplied to registered users.  This ANSIPLUS version may be loaded
         into memory from the DOS command line, from a batch file
         (AUTOEXEC.bat), or from CONFIG.sys with DEVICE=, DEVICEHIGH=, or
         INSTALL= commands.

 3/30/93 To provide additional user control over color schemes of 16-color
         programs that set their own palettes or border colors, such as DBASE
         III or EDIT.com, ANSIPLUS can now lock the color palette, preventing
         such programs from loading the PAL/DAC and border color registers by
         BIOS calls.  This feature should only be used when all other means of
         control fail.  It can be enabled or disabled by the new LOCKPAL.com
         and UNLOKPAL.com ANSIPLUS utilities in a batch file that executes the
         application to be controlled.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 3/19/93 ANSIPLUS can now preserve scroll-back data across video mode changes
         or when running graphics mode applications (including Windows) by
         saving the data in XMS memory.  DOS sessions under Windows 3.1 can use
         this feature as well if they can access XMS memory.  The feature is
         enabled or disabled in the Scrolling section of SETAPLUS or NEWAPLUS.

 3/17/93 Scroll-back capacity has been tripled for typical applications to
         about 500 lines by using compression techniques to store scroll-back
         data.

 3/08/93 Version 2.07 released.

 3/05/93 Using its own configurable-size key buffers, ANSIPLUS now supports key
         stacking, which adds keys to the keyboard buffer for later consumption
         by programs.  The feature is controlled by SETAPLUS command, ANSIPLUS
         escape sequence, or the 4DOS command shell KEYSTACK command.  Users of
         4DOS 4.0+ now do not need to load KSTACK.com if ANSIPLUS is installed.

 2/28/93 Added more control over key reassignment: a new configurable feature
         can prevent changes to key reassignment definitions with the Esc [p
         ANSI control sequence.  The driver also now generates an ominous tone
         (like the theme from "Dragnet") when an attempt is made to redefine
         keys if redefinition of key reassignment is disabled.

 2/23/93 When the DISPLAY.sys driver is used with Windows 3.0 or 3.1, the
         colors and other variables of either ANSIPLUS or the DOS ANSI.sys
         driver are not localized to each virtual 8086.  This appears to be
         because Windows only localizes the first CON driver it finds on the
         DOS device chain, and this will be the most recent CON device
         installed, which is DISPLAY.sys, not ANSIPLUS.  Two system setup
         changes are required to circumvent the problem:

            (1) Enter the following command to change the name of the ANSIPLUS
                driver in memory from "CON" to "CONAPLUS":

                    SETAPLUS LOCALCON

                This command is automatically inserted into AUTOEXEC.bat by the
                ANSIPLUS INSTALL program when DISPLAY.sys is detected.

            (2) Add the following command to the [386Enh] section of the
                Windows SYSTEM.ini file:

                    LOCAL=CONAPLUS

                This causes Windows to localize the ANSIPLUS driver to each
                virtual 8086.  The SYSTEM.ini file is not altered by the
                ANSIPLUS INSTALL program.

         These setup changes are totally unnecessary if you are not using the
         DISPLAY.sys driver.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 2/21/93 Apparently, some 256-color drivers for Windows assume that the OEM
         256-color palette has been loaded when the 256-color mode was
         selected, and never define the colors that Windows will use.  Some DOS
         256-color applications also have the same problem.  When using such a
         Windows driver or DOS application, if the ANSIPLUS default colors are
         loaded on mode set, the wrong colors could be displayed.  Because of
         this, features have been added to the driver and utility programs to
         allow control over loading the ANSIPLUS colors in DOS and Windows
         256-color modes.  By default, ANSIPLUS now will not load its colors
         when a 256-color mode is selected under Windows.

 2/15/93 Version 2.06 released.

 2/13/93 Minor changes to SETAPLUS: maintain color selection when shifting from
         256-color to 16-color video modes, and improve listing of Alt and Ctrl
         keys in SETAPLUS LISTKEYS option.

 2/10/93 Added a feature to use BIOS calls for text mode scrolling instead of
         directly moving data in the video display RAM.  This may help in those
         unusual cases where other drivers or TSRs need to be informed when the
         screen is scrolled up.

 2/10/93 Changed the default status for the graphics mode pseudo-cursor to be
         disabled.  Also added a separate feature to control use of the pseudo-
         cursor when in 256-color graphics modes (also disabled as default).

 1/25/93 When the screen saver is enabled, the screen can now be blanked
         immediately by entering the Alt-Ctrl-Scroll Lock key combination.

 1/06/93 Bug fix: Improved handling of palette in 256-color modes, particularly
         when the OEM palette is being used.

 1/05/93 Bug fix: Automatic registration of Shareware version when installed
         over a Registered version did not always work.

12/02/92 Version 2.05 released.

11/29/92 Changes for international support and using DISPLAY.sys: INSTALL/
         NEWAPLUS now loads ANSIPLUS before DISPLAY.sys in CONFIG.sys because
         MODE CON CP SELECT command will not work correctly if ANSIPLUS is
         installed after DISPLAY.sys; and minor cosmetic changes to SETCOLOR
         and SETAPLUS screens when not using U.S.  code page 437.

11/21/92 Revised INSTALL/NEWAPLUS to recognize reference to the KEYB TSR (for
         international keyboard users) in AUTOEXEC.bat.  The install process
         will then automatically add a SETAPLUS LINK KEYEVENT command to
         AUTOEXEC.bat following KEYB if this command was not already there.
         See the next item for further explanation.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

11/19/92 Added the capability to relink ANSIPLUS interrupts after they have
         been stolen by TSR's such as MS-DOS KEYB.  The KEYB program grabs the
         key event interrupt (Int 09h), without passing calls through to
         whatever was installed before it (ie., to ANSIPLUS).  This has
         prevented most ANSIPLUS keyboard functions, such as scroll-back,
         scroll lock, etc., from working correctly with international
         keyboards.  Now, to restore ANSIPLUS's access to the key event
         interrupt, the following command must be entered after KEYB has been
         loaded:

            SETAPLUS LINK KEYEVENT

         This command should be placed in AUTOEXEC.bat immediately after KEYB.

11/19/92 The programs connected to any system interrupt, including those used
         by ANSIPLUS, can be identified using the new SETAPLUS command:

            SETAPLUS INTERRUPT <number> [<number> ...]

         where <number> is any hexadecimal interrupt number.  For example,
         SETAPLUS INTERRUPT 2F would list the programs connected to the
         Multiplex interrupt, number 2Fh.  This listing is not guaranteed to be
         correct in all cases, but has been remarkably accurate in our
         experience.

11/18/92 Two screen saver changes should blank the screen more appropriately:
         Relaxed the test for a fast timer tick a little to allow the screen to
         blank when running applications with extensive timer tick processing,
         but not to blank when running games that speed up the timer, such as
         Flight Simulator.  Also removed, except for XT-type machines, the
         requirement before blanking that the Int 09h vector point to the same
         place as when the last Int 09h key event was intercepted.

11/09/92 Changed SETCOLOR and SETAPLUS utilities to display menus using video
         page 0 instead of page 1 when not running on a VGA or EGA.  This
         should make the menus visible on Hercules-type boards that seem to
         have a problem accessing higher video pages.

11/09/92 Bug fix: Insert key caused lockup when screen was scrolled back.

10/21/92 Increase delay times for direct port access to video controller.

10/20/92 Bug fix: Generic IOCTL was never called by DOS because the driver
         header bit for it was not set.  Now MODE CON reports lines and
         columns, and MODE CON LINES={25, 43 or 50} works.  However, setting
         display columns to 40 or 80 with MODE is still not supported by
         ANSIPLUS, and the DOS 5.0 MODE program incorrectly reports 40 columns
         for any screen mode not having 80 columns (for example, 132).

 9/23/92 Version 2.04 released.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 9/22/92 When updating a driver file that has been changed from the default
         configuration, the INSTALL program now gives the user an option to
         copy the configuration of the updated driver into the newly installed
         driver.

 9/20/92 Obtaining updates for registered versions of ANSIPLUS is now greatly
         simplified: Effective with Version 2.04, when any Shareware copy of
         ANSIPLUS is installed on a disk containing a Registered copy of
         ANSIPLUS (2.04 or later), the INSTALL program will convert the new
         Shareware copy into a Registered copy with the same serial number and
         signon message as the Registered ANSIPLUS already on the disk.
         Registered users can thus benefit from future improvements to ANSIPLUS
         at no cost, if they have access to a BBS that maintains current
         Shareware versions of ANSIPLUS.

 9/19/92 Bug fix: Prevent bright key echo when the next output byte equals the
         scan code of a function or other special key just entered.

 9/17/92 Revised installation program (NEWAPLUS.exe) to be more tolerant of and
         informative about missing or unreadable files during installation.
         Versions of ANSIPLUS on some BBS's seem to be missing files (usually
         SETCOLOR.sch, which is a minor supporting file), and this has
         prevented potential users from evaluating ANSIPLUS.

 9/04/92 When Scroll-Lock is used to freeze the screen during rapid output, and
         then the screen is released by Page-Down, Tab, Down arrow, or a shift
         key until the next input prompt is made by the computer, the driver
         can now recognize the input request and will automatically release the
         scroll freeze condition after a key is typed.

 9/04/92 Under Windows and OS/2, the driver now yields the CPU for the
         remainder of a time slice whenever it is in a tight key input/testing
         loop.

 9/03/92 Under Windows, whenever the scroll-back storage area is initialized, a
         RAM search is now made to see if the video RAM is a full 32k.  If less
         is available, the scroll-back storage is reduced accordingly, and
         smooth scrolling, which uses the top of the 32k video RAM, is
         disabled.  This should work around problems with 256-color Windows
         drivers that do not provide a full 32k of text mode video RAM in
         certain situations.

 9/02/92 Under Windows, in a virtual 8086 DOS session running in a window,
         scroll-back appeared to be inoperative because Windows 3.1 failed to
         update the windowed screen as it was scrolled backward or forward.  If
         the same DOS session was run full screen, scroll back would perform
         correctly.  The driver is now able to cause the windowed screen to be
         updated in most cases (such as when DOS keyboard input is requested),
         so scroll-back should work in a window most of the time.  However, it
         is still not always possible to scroll the screen backward in a window
         while it has been frozen by Scroll-Lock during rapid screen output.

 8/31/92 Version 2.03 released.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 8/22/92 Bug fix: made VGA screen saver less likely to interfere with running
         programs by disabling interrupts while the screen is being blanked or
         unblanked and by restoring the sequencer index after the operation.

 8/22/92 Bug fix: push/pop mismatch in VESA set mode processing.  Symptom was
         inability to start Windows.

 8/22/92 Now use Int 15h keyboard intercept rather than direct port access to
         get key scan codes for repeated-key detection and other key
         processing.

 8/21/92 Version 2.02 released.

 8/14/92 Added mouse reset to Windows exit processing.  Windows 3.1 leaves some
         mice (for example, Logitech C7) in an undefined state at termination,
         so the mouse could not unblank the screen until the next DOS mouse-
         using program had been executed.

 8/12/92 Bug fix: still intermittent trouble with keyboard under Windows 3.1.
         Made all of Int 09h handler uninterruptible.

 7/22/92 Version 2.01 released.

 7/21/92 Extended repeated key suppression to the Scroll Lock key.  Now, when
         Scroll Lock is held down for a long time, the scroll lock or smooth
         scroll toggles will not change repeatedly.

 7/17/92 Bug fix: 16-color to monochrome text attribute adjustments for EGA
         monochrome now show low intensity as well as high intensity for both
         foreground and background.  VGA, CGA, MDA and color EGA are
         unaffected.

 7/16/92 Minor changes to INSTALL/NEWAPLUS target drive and file path
         selection.

 7/16/92 Minor changes to scroll freeze when smooth scrolling is active.

 7/16/92 Bug fix: Scroll back storage is reorganized whenever a previously
         unused display page is selected.  In several display modes, including
         25x80 text, a bug caused the scroll-back data to be scrambled when
         reorganization was required.

 7/15/92 Bug fix: On certain PC/XT compatible computers, all keystrokes were
         erroneously recognized as repeat keys, causing all digit keys to be
         ignored.  Repeated key suppression is now disabled on XT's.

 7/15/92 Bug fix: Repeated keys entered to QuickBasic programs such as DOS 5.0
         EDIT.com caused pointer errors when keys were transferred between BIOS
         and extended key buffers.  Symptom was strange jumps in cursor
         position or "phantom" keystrokes while holding down an arrow key.
         Fixed by making the key shuffling subroutine uninterruptible.

 6/09/92 Version 2.00 released.

