DECLARE SUB JULIA ()
DECLARE FUNCTION GETCOLOR& (ROFF!, GOFF!, BOFF!, INC!)
DECLARE SUB KOCHLINE (L%, LLEN!)
DECLARE FUNCTION SINE! (RAD!)
DECLARE FUNCTION COSINE! (RAD!)
DECLARE SUB SPIPAINT (X1%, Y1%, K%, BK%)
DECLARE SUB CHAINS (SWITCH&)
DECLARE FUNCTION ALTERCOLOR& (X&, I!)
DECLARE SUB FILLPAL (I%)
DECLARE FUNCTION FADECOLOR& (INDEX%, DEC%)
DECLARE SUB ARCS4 (X%, Y%, R%, K%, F!, T!, A!)
DECLARE SUB SPIARCS (X%, Y%, R%, K%, F!, T!, A!)
DECLARE FUNCTION ROUNDPI! (P!)
DECLARE FUNCTION CGAK% (K%)
DECLARE FUNCTION UPK% (K%)
DECLARE SUB PSET4 (X1%, Y1%, K%)
DECLARE SUB DOSTARS ()
DECLARE SUB SPIBOXESF (X1%, Y1%, X2%, Y2%, K%)
DECLARE SUB TORNSQR ()
DECLARE SUB DOLINES (DIST!, LEVEL!)
DECLARE SUB MANDELBROT ()
DECLARE SUB WEBS (X%)
DECLARE SUB VECTORSPIN (ORGX%, ORGY%, BEGANGLE!, ROTANGLE!, SEGANGLE!, RADIUS1%, RADIUS2%, K%)
DECLARE SUB FORWARD (DISTANCE%, K%)
DECLARE SUB DOFLOWER (LEVEL%, STEMLEN%, STEMINC%, STEMA%, FX%, FY%)
DECLARE SUB SPIPSET (X1%, Y1%, K%)
DECLARE SUB LDRAGON (LEVEL%)
DECLARE SUB DRAGON ()
DECLARE SUB RDRAGON (LEVEL%)
DECLARE SUB SPILINES (X1%, Y1%, X2%, Y2%, K%)
DECLARE SUB SPIBOXES (X1%, Y1%, X2%, Y2%, K%)
DECLARE SUB SPICIRCLES (X1%, Y1%, R%, K%, A!)
DECLARE SUB CSPIRAL ()
DECLARE SUB LC (LEVEL%)
DECLARE SUB RC (LEVEL%)
DECLARE SUB LINES4 (X1%, Y1%, X2%, Y2%, K%)
DECLARE SUB BOXES4 (X1%, Y1%, X2%, Y2%, K%)
DECLARE SUB CIRCLES4 (X1%, Y1%, R%, K%, A!)

        DEFINT A-Z:
        DIM PAL(64) AS LONG
        DIM SINETAB!(720), COSINETAB!(720)
        COMMON U, V, T, BG, TILE$, SINETAB!(), COSINETAB!()
        CONST PI! = 3.141593, PIHALF! = PI / 2
        CONST PI2! = PI * 2, PI3HALF! = 3 * PI / 2
        CONST DEG! = PI / 180
        CONST SQR2! = 1.4142135#
        CONST DRAWBOX$ = "R2 U2 L2 D2 "
        CONST MIDNITE! = 86400!
        RANDOMIZE TIMER
        DEF FNRNDU = RND * U
        DEF FNRNDT = RND * T - (T / 2)
        DEF FNSCRSAV& (X1, Y1, X2, Y2) = 4 + INT(((X2 - X1 + 1) + 7 / 8) * 4 * ((Y2 - Y1) + 1))
        DEF FNRND3TO8 = FIX(RND * 5) + 3
        DEF FNTIMER! (N!) = (TIMER + N!) + MIDNITE! * ((TIMER + N!) > MIDNITE!)
        ON TIMER(1) GOSUB TYME
        FOR I = 1 TO 10
                ON KEY(I) GOSUB HALT
                KEY(I) ON
        NEXT I
        ON KEY(30) GOSUB HALT
        ON KEY(31) GOSUB HALT
        KEY(30) ON
        KEY(31) ON
        TIMER ON
        CLS
        GOSUB GETSHAPE
        GOSUB GETSTYLE
        NEWSTART = -1
        TC! = FNTIMER!(10)
        DO
        X1 = FNRNDU: XS1 = FNRNDT
        X2 = FNRNDU: XS2 = FNRNDT
        Y1 = FNRNDU: YS1 = FNRNDT
        Y2 = FNRNDU: YS2 = FNRNDT
        R1 = ABS(FNRNDU): R2 = FNRNDT
        IF STYLE = 3 OR STYLE = 4 THEN
                IF XS1 <> 0 THEN XS1 = XS1 / ABS(XS1)'RESOLVES TO 1 OR -1
                IF YS1 <> 0 THEN YS1 = YS1 / ABS(YS1)'RESOLVES TO 1 OR -1
                IF XS2 <> 0 THEN XS2 = XS2 / ABS(XS2)'RESOLVES TO 1 OR -1
                IF YS2 <> 0 THEN YS2 = YS2 / ABS(YS2)'RESOLVES TO 1 OR -1
                IF R2 <> 0 THEN R2 = R2 / ABS(R2)
        END IF
        N = ABS(FNRNDU) / (RND * 2 + 1) + 1
        A! = 180 / N
'        SHAPE = 6
        FOR I = 1 TO N
        IF (R1 + R2) < 2 OR (R1 + R2) > U THEN R2 = -R2
        R1 = ABS(R1 + R2)
        SELECT CASE SHAPE
        CASE IS < 38
        ON SHAPE GOSUB SPIRAL, COMBINE, SCROLL, ROLLER, WANDER, EYES, CURLS, GLOBE, SQUIGGLE, FANS, RAYS, BOLTS, GEOROSE, EGGS, LINKS, CONES, SPLINES, POLYSPIN, NESTPOLY, STARS, CIRCLES, LINES, BOXES, ELIPSES, QUILT, TWIRLS, GEOTUBE, BUBBLE, TWISTER _
, BUTTERFLY, SCREWUP, LUPS, WHORLS, CROSS, WEB, ARCS, HAIRYARCS
        CASE ELSE
        ON SHAPE - 37 GOSUB DRAGONS, MANDEL, JULIA, FLOWERS, SPONGE, RAYS3, TSQR, KOCHCURVE
        END SELECT
        IF INKEY$ <> "" THEN GOSUB SHUTOFF
        NEWSTART = 0
        IF ABS(X1 + XS1) >= U THEN XS1 = -XS1
        IF ABS(Y1 + YS1) >= U THEN YS1 = -YS1
        IF ABS(X2 + XS2) >= U THEN XS2 = -XS2
        IF ABS(Y2 + YS2) >= U THEN YS2 = -YS2
        X1 = (X1 + XS1)
        X2 = (X2 + XS2)
        Y1 = (Y1 + YS1)
        Y2 = (Y2 + YS2)
        IF KSWITCH THEN K = UPK(FIX(I / (N / 15))) ELSE K = UPK(K)
        TU& = STALL& 'SLOW DOWN THOSE BIG MUTHA'S
        DO WHILE TU& > 0
                TU& = TU& - 1
        LOOP
        NEXT I
        COMB% = 0
        IF KOUNT = 7 THEN
                IF STALL& < 1E+08 THEN STALL& = STALL& + 100
                C = -1
        ELSE
                KOUNT = KOUNT + 1
                IF C AND (STALL& >= 100) THEN STALL& = STALL& - 100
        END IF
        IF C THEN GOSUB ROTATE.PALETTE
        IF C THEN
                CLS
                BG = ABS(BG)
                GOSUB GETSTYLE
                GOSUB GETSHAPE
                NEWSTART = -1
                KSWITCH = RND < .25
                KOUNT = 0
                K = 1
                C = 0
                IF V = 1 THEN COLOR RND * 16, RND * 2
        END IF
        LOOP
        SYSTEM
HALT:
        SCREEN 0
        SYSTEM
TYME:
        IF BG = 1 THEN
                BACKGROUND = BACKGROUND MOD (UBOUND(PAL) - 16) + 1
                PAL(0) = FADECOLOR&(BACKGROUND, 51)
                IF V = 1 THEN COLOR RND * 15 ELSE PALETTE 0, PAL(0)
        END IF
        IF TIMER > TC! THEN
                C = -1
                TC! = FNTIMER!(10)
        END IF
        RETURN

VARIABLE:
        A! = PI2 / (UBOUND(PAL) - 16)
        B! = RND * PI2
        C! = RND * PI2
        D! = RND * PI2
        FOR I = 1 TO UBOUND(PAL)
                PAL(I) = GETCOLOR&(B!, C!, D!, A! * I)
        NEXT I
        RETURN

SPECTRUM:
        IF RND < .5 THEN GOTO SPECTRUM2
        A! = PI2 / (UBOUND(PAL) - 16)
        B! = RND * PI2
        FOR I = 1 TO UBOUND(PAL)
                PAL(I) = GETCOLOR&(180 + B!, 90 + B!, B!, A! * I)
        NEXT I
        RETURN

SPECTRUM2:
        A! = PI2 / (UBOUND(PAL) / 4)
        B! = RND * PI2
        FOR I = 1 TO UBOUND(PAL)
                PAL(I) = GETCOLOR&(180 + B!, 90 + B!, B!, A! * I)
        NEXT I
        RETURN

TWOTONE:
        IF V < 9 THEN RETURN
        CY& = 0
        FOR I = 56 TO 0 STEP -8
                GOSUB TT2
                CY& = CX&
        NEXT I
        RETURN

TT2:
        CX& = GETCOLOR&(180, 90, 0, RND * PI2)
        IF CX& = 0 THEN GOTO TT2
        IF CX& = CY& THEN GOTO TT2
        IF (V = 9 AND (CX& > 7)) THEN GOTO TT2
        A! = PI / 8
        FOR J = 1 TO 8
                IF V = 9 THEN GOSUB EGASHADOW ELSE GOSUB VGASHADOW
                PAL(I + J) = PAL(J)
        NEXT J
        RETURN

FOURTONE:
        IF V < 9 THEN RETURN
        CY& = 0
        FOR I = 48 TO 0 STEP -16
                GOSUB TT3
                CY& = CX&
        NEXT I
        RETURN

TT3:
        CX& = GETCOLOR&(180, 90, 0, RND * PI2)
        IF CX& = 0 THEN GOTO TT3
        IF CX& = CY& THEN GOTO TT3
        IF (V = 9 AND (CX& > 7)) THEN GOTO TT3
        A! = PI / 16
        FOR J = 1 TO 16
                IF V = 9 THEN GOSUB EGASHADOW ELSE GOSUB VGASHADOW
                PAL(I + J) = PAL(J)
        NEXT J
        RETURN

SHADOW:
        IF V < 9 THEN RETURN
        CX& = GETCOLOR&(180, 90, 0, RND * PI2)
        IF CX& = 0 THEN GOTO SHADOW
        IF (V = 9 AND (CX& > 7)) THEN GOTO SHADOW
        A! = PI / 32
        FOR J = 1 TO 32
                IF V = 12 THEN GOSUB VGASHADOW ELSE GOSUB EGASHADOW
        PAL(32 + J) = PAL(J)
        NEXT J
        RETURN

VGASHADOW:
        PAL(J) = ALTERCOLOR&(CX&, SINE!(A! * J))
        RETURN
EGASHADOW:
        IF J < 8 OR J > 24 THEN PAL(J) = (CX& AND &H7) * 8 ELSE PAL(J) = CX&
        IF J < 4 OR J > 28 THEN PAL(J) = 0
        RETURN

SHUTOFF:
        C = -1
        I = N
        RETURN

GEOTUBE:
        IF I = 1 THEN
                A! = PI2 / FNRND3TO8
                R2 = FIX(U / N)
                R1 = R2
                B! = A! / 2
        END IF
        CALL VECTORSPIN(0, 0, 0, A!, A!, R1, R1, K)
        CALL VECTORSPIN(0, 0, B!, A!, A!, R1, R1, CGAK(UPK(K + 8)))
        RETURN


SCROLL:
        IF NEWSTART THEN
                B = FIX(RND * 12)
                R = SGN(FIX(RND * 3) - 1)
        END IF
        IF I = 1 THEN
                IF RND > .5 THEN G = 10 ELSE G = -10
                R2 = R1 / N
                B! = 0
                A = FNRNDT
        END IF
        B! = B! + G * DEG
        X1 = X2 + R1 * SINE!(B!)
        Y1 = Y2 + R1 * COSINE!(B!)
        'B = 1
        IF I > 1 THEN
                SELECT CASE B
                CASE 0
                        IF R < 0 THEN CALL LINES4(CINT(CX&), CINT(CY&), X1, Y1, K)
                        IF R > 0 THEN CALL SPILINES(CINT(CX&), CINT(CY&), X1, Y1, K)
                        IF R = 0 THEN
                                CALL LINES4(CINT(CX&), CINT(CY&), X1, Y1, K)
                                CALL LINES4(CINT(CY&), CINT(CX&), Y1, X1, K)
                        END IF
                CASE 1
                        IF R < 0 THEN CALL SPIPSET(X1, Y1, K)
                        IF R > 0 THEN CALL PSET4(X1, Y1, K)
                        IF R = 0 THEN
                                CALL PSET4(X1, Y1, K)
                                CALL PSET4(Y1, X1, K)
                        END IF
                CASE 2
                        IF R < 0 THEN CALL BOXES4(0, 0, X1, Y1, K)
                        IF R > 0 THEN CALL SPIBOXES(0, 0, X1, Y1, K)
                        IF R = 0 THEN
                                CALL BOXES4(0, 0, X1, Y1, K)
                                CALL BOXES4(0, 0, Y1, X1, K)
                                I = I + 1
                        END IF
                CASE 3
                        IF R < 0 THEN CALL BOXES4(CINT(CX&), CINT(CY&), X1, Y1, K)
                        IF R > 0 THEN CALL SPIBOXES(CINT(CX&), CINT(CY&), X1, Y1, K)
                        IF R = 0 THEN
                                CALL BOXES4(CINT(CX&), CINT(CY&), X1, Y1, K)
                                CALL BOXES4(CINT(CY&), CINT(CX&), Y1, X1, K)
                        END IF
                CASE 4
                        IF R < 0 THEN CALL CIRCLES4(X1, Y1, CINT(ABS(CX& - X1)), K, 1)
                        IF R > 0 THEN CALL SPICIRCLES(X1, Y1, CINT(ABS(CX& - X1)), K, 1)
                        IF R = 0 THEN
                                CALL CIRCLES4(X1, Y1, CINT(ABS(CX& - X1)), K, 1)
                                CALL CIRCLES4(Y1, X1, CINT(ABS(CX& - X1)), K, 1)
                        END IF
                CASE 5
                        CX& = CX& - X1
                        CY& = CY& - Y1
                        IF R < 0 THEN CALL LINES4(CINT(X1 + CX&), CINT(Y1 + CY&), CINT(X1 - CX&), CINT(Y1 - CY&), K)
                        IF R > 0 THEN CALL SPILINES(CINT(X1 + CX&), CINT(Y1 + CY&), CINT(X1 - CX&), CINT(Y1 - CY&), K)
                        IF R = 0 THEN
                                CALL LINES4(CINT(X1 + CX&), CINT(Y1 + CY&), CINT(X1 - CX&), CINT(Y1 - CY&), K)
                                CALL LINES4(CINT(Y1 + CY&), CINT(X1 + CX&), CINT(Y1 - CY&), CINT(X1 - CX&), K)
                        END IF
                CASE 6
                        A! = I * A * DEG
                        IF R < 0 THEN CALL SPIARCS(X1, Y1, CINT(ABS(CX& - X1)), K, A!, PIHALF + A!, 1)
                        IF R > 0 THEN CALL ARCS4(Y1, X1, CINT(ABS(CX& - X1)), K, -A!, PIHALF - A!, 1)
                        IF R = 0 THEN
                                CALL ARCS4(Y1, X1, CINT(ABS(CX& - X1)), K, -A!, PIHALF - A!, 1)
                                CALL ARCS4(X1, Y1, CINT(ABS(CX& - X1)), K, -A!, PIHALF - A!, 1)
                        END IF
                CASE 7 TO 11
                        SELECT CASE B
                        CASE 7
                                A! = 0
                                C! = 0
                        CASE 8
                                A! = U
                                C! = U
                        CASE 9
                                XS2 = 0
                                YS2 = 0
                        CASE 10
                                A! = U
                                C! = 0
                        CASE 11
                                A! = X2
                                C! = Y2
                        CASE ELSE
                        END SELECT
                        IF R < 0 THEN CALL LINES4(CINT(A!), CINT(C!), X1, Y1, K)
                        IF R > 0 THEN CALL SPILINES(CINT(A!), CINT(C!), X1, Y1, K)
                        IF R = 0 THEN
                                CALL LINES4(CINT(A!), CINT(C!), X1, Y1, K)
                                CALL LINES4(CINT(C!), CINT(A!), Y1, X1, K)
                                I = I + 1
                        END IF
                CASE ELSE
                END SELECT
        END IF
        I = I + 1
        CX& = X1
        CY& = Y1
        IF RND < .01 THEN G = -G
        RETURN

KOCHCURVE:
        G = U / 15
        R = U
        J = 3 - (RND < .5)
        STP = 0
        DO WHILE R > G AND NOT (STP)
                B = J
                DO
                        B! = (R * SINE!(60 * DEG)) * 2
                        X1 = R * .75 * SINE!(0)
                        Y1 = R * COSINE!(0)
                        CA = 150
                        CALL KOCHLINE(B, B!)
                        IF NOT (STP) THEN PAINT (0, 0), UPK(K + 7), K
                        K = UPK(K)
                        B = B - 1
                LOOP WHILE J = 3 AND B > 0
        R = R - G
        LOOP
        GOSUB SHUTOFF
        RETURN

EYES:
        J = U / 8
        R1 = J
        R = 1
        REDIM S&(FNSCRSAV&(-J, -J, J, J) / 4)
        DO
                CALL CIRCLES4(J, J, R, K, 1)
                CIRCLE (0, 0), R1, K
                PSET (0, 0), 0
                PAINT (0, 0), K, K
        K = UPK(K)
        R1 = R1 - 3
        IF R > 0 THEN R = R + 1
        IF INKEY$ <> "" THEN EXIT DO
        LOOP WHILE R1 > 1
        GET (-J, -J)-(J, J), S&
        X1 = PMAP(-U, 0)
        X2 = PMAP(U - J * 2, 0)
        Y1 = PMAP(U, 1)
        Y2 = PMAP(-U + J * 2, 1)
        XS1 = FIX((X2 - X1) / 7)
        YS2 = FIX((Y2 - Y1) / 7)
        YS1 = Y1
        WINDOW
        DO WHILE X1 < X2
                Y1 = YS1
                DO WHILE Y1 < Y2
                        PUT (X1, Y1), S&, PSET
                        Y1 = Y1 + YS2
                LOOP
                X1 = X1 + XS1
        LOOP
        WINDOW (-U, -U)-(U, U)
        GOSUB SHUTOFF
        ERASE S&
        RETURN

TSQR:
        CALL TORNSQR
        GOSUB SHUTOFF
        RETURN

FANS:
        IF I = 1 THEN
                XS1 = ABS(XS1) * 10
                YS1 = ABS(YS1) * 10
                XS2 = 0
                YS2 = 0
        END IF
        IF I > 1 THEN
                CALL LINES4(X2, Y2, X1, Y1, K)
                CALL LINES4(Y2, X2, Y1, X1, K)
        END IF
        I = I + 1
        RETURN

BOLTS:
        IF I = 1 THEN
                R2 = FIX(U / N)
                R1 = 1
                A! = RND * PI
                DO
                        B! = RND * PI
                LOOP WHILE A! = B!
        END IF
        X1 = R1 * SINE!(A!)
        Y1 = R1 * COSINE!(A!)
        IF I MOD 2 = 1 THEN
                X1 = R1 * SINE!(B!)
                Y1 = R1 * COSINE!(B!)
        END IF
        IF I > 1 THEN
                CALL LINES4(CINT(CX&), CINT(CY&), X1, Y1, K)
                CALL LINES4(CINT(CY&), CINT(CX&), Y1, X1, K)
        END IF
        CX& = X1
        CY& = Y1
        RETURN

HAIRYARCS:
        IF I = 1 THEN
                B = RND < .5
                A = RND < .5
        END IF
        A! = (RND * 44 + 1) * DEG
        C! = (RND * 44 + 45) * DEG
        GOTO ARCSALL
ARCS:
        IF I = 1 THEN
                A! = (RND * 44 + 1) * DEG
                C! = (RND * 44 + 45) * DEG
                B = RND < .5
                A = RND < .5
        END IF
ARCSALL:
        D! = TAN(DEG * I)
        IF B AND (D! <> 0) THEN D! = 1 / D!
        IF (ABS(X1) + R1) > U THEN X1 = -X1
        IF (ABS(Y1) + R1) > U THEN Y1 = -Y1
        IF A THEN
                CALL ARCS4(X1, Y1, R1, K, A!, C!, D!)
        ELSE
                CALL SPIARCS(X1, Y1, R1, K, A!, C!, D!)
        END IF
        RETURN

GLOBE:
        FOR A! = 0 TO PI / 2 STEP 7 * DEG
                B! = COSINE!(A!)
                CIRCLE (0, 0), R1, K, , , B!
                CIRCLE (0, 0), R1, K, , , 1 / B!
                 K = UPK(K)
        NEXT A!
        I = N
        RETURN

CIRCLES:
        CALL CIRCLES4(X1, Y1, R1, K, 1)
        RETURN

ELIPSES:
        IF NEWSTART THEN
                B = (RND < .5)
        END IF
        C! = TAN(I * DEG)
        IF B AND (C! <> 0!) THEN C! = 1 / C!
        CALL CIRCLES4(X1, Y1, R1, K, C!)
        RETURN

LINES:
        IF NEWSTART AND STYLE > 2 THEN KSWITCH = -1
        CALL LINES4(X1, Y1, X2, Y2, K)
        RETURN

BOXES:
        IF NEWSTART THEN KSWITCH = -1
        CALL BOXES4(X1, Y1, X2, Y2, K)
        RETURN

WANDER:
        IF NEWSTART THEN B = (RND > .5)
        IF I = 1 THEN
                XS2 = 0
                YS2 = 0
                X2 = X1
                Y2 = Y1
                R = U / 20
        END IF
        DO
        XS1 = FIX(RND * 7)
        LOOP WHILE XS1 = YS1
        IF B THEN
                X1 = R * SINE!(XS1 * 45 * DEG) + X2
                Y1 = R * COSINE!(XS1 * 45 * DEG) + Y2
        ELSE
                X1 = R * INT(RND * 2 - 1) + X2
                Y1 = R * INT(RND * 2 - 1) + Y2
        END IF
        CALL LINES4(X2, Y2, X1, Y1, K)
        CALL LINES4(Y2, X2, Y1, X1, K)
        YS1 = XS1
        X2 = X1
        Y2 = Y1
        IF ABS(X2) + R > U THEN X2 = FNRNDU
        IF ABS(Y2) + R > U THEN Y2 = FNRNDU
        RETURN

COMBINE:
        IF COMB% = 0 THEN
                COMB% = FIX(RND * 17) + 1
                NEWSTART = -1
        END IF
        ON COMB% GOTO ARROW, WANDER, GLOBE, CURLS, SQUIGGLE, FANS, BOLTS, GEOROSE, BOXES, CIRCLES, ELIPSES, LINES, RAYS, WHORLS, ARCS, HAIRYARCS, TWIRLS
        COMB% = 0
        GOTO COMBINE


SPONGE:
        YS1 = INT(RND * 3)
        SELECT CASE YS1
        CASE 2
                XS1 = 5
                B! = 3
        CASE 1
                XS1 = 4
                B! = 2.5
        CASE ELSE
                XS1 = 3
                B! = 2
        END SELECT
        A! = DEG * 360 / XS1
        REDIM XX(XS1), YY(XS1)
        FOR I = 0 TO XS1 - 1
                XX(I) = U * SINE!(I * A!)
                YY(I) = U * COSINE!(I * A!)
        NEXT I
        CX& = RND * U
        CY& = RND * U
        R1 = 0
        C = 0
        XS2 = U / 16
        A = 0
        DO WHILE C = 0 AND R1 < 6 AND A < 25000
                A = A + 1
                I = FIX(RND * XS1)
                CX& = (CX& - XX(I)) / B!
                CY& = (CY& - YY(I)) / B!
                K = CGAK(SQR(ABS(CX& * CX&) + ABS(CY& * CY&)) / XS2)
                PSET (CX&, CY&), K
                IF C <> 0 THEN C = 0: R1 = R1 + 1
                IF INKEY$ <> "" THEN EXIT DO
        LOOP
        GOSUB SHUTOFF
        ERASE XX, YY
        RETURN

DRAGONS:
        CALL DRAGON
        GOSUB SHUTOFF
        RETURN

ARROW:
        IF I = 1 THEN
                X1 = ABS(X1)
                Y1 = ABS(Y1)
                X2 = PMAP(-X1, 0)
                Y2 = PMAP(-Y1, 1)
                X1 = PMAP(X1, 0)
                Y1 = PMAP(Y1, 1)
                B = PMAP(-U, 1) / 20
                R = (ABS(XS1 * 10) MOD (255 - B)) + B
                IF RND < .5 THEN
                A$ = " S" + STR$(R) + "H1 NE1 H1 BF2 G1 NF1 G1 E2 BR2 H1 NE1 H1 BF2 G1 NF1 G1 E2"
                ELSE
                A$ = " S" + STR$(R) + "BL2 NU2 R1 NU2 R1 NU2 BU2 NR2 D1 NR2 D1 NR2 BR2 ND2 L1 ND2 L1 ND2 BD2 NL2 U1 NL2 U1 NL2"
                END IF
                B = (RND < .5)
        END IF
        G = 0
        FOR I = Y1 TO Y2 STEP R
          FOR J = X2 TO X1 STEP R
                DRAW " BM" + STR$(J) + "," + STR$(I) + " TA" + STR$(G) + " C" + STR$(K) + A$
                K = UPK(K)
                IF B THEN G = (G + 180) MOD 360
                IF INKEY$ <> "" THEN
                        C = -1
                        I = Y2 + R
                        J = X1 + R
                END IF
          NEXT J
          IF NOT (B) THEN G = (G + 180) MOD 360
        NEXT I
        I = N
        C = 0   'GIVE 'EM ANOTHER SHOT
        RETURN

SQUIGGLE:
        IF NEWSTART THEN B = RND > .5
        IF I = 1 THEN
                GOSUB XINCNULL
                B! = RND * PIHALF
                C! = 0
                A! = 10 * PI / N
                R1 = U
                DO WHILE R2 = 0
                        R2 = FNRNDT
                LOOP
        END IF
        C! = C! + A!
        IF B THEN
                X1 = R1 / 10 * SINE!(2 * C! + PIHALF - B!)
                Y1 = R1 / 5 * SINE!(C! + PIHALF - B!)
        ELSE
                X1 = R1 / 5 * COSINE!(C!)
                Y1 = R1 / 5 * SINE!(C!)
        END IF
        X1 = X1 + R1 * SINE!(B!)
        Y1 = Y1 + R1 * COSINE!(B!)
        IF I > 1 THEN
                CALL LINES4(X2, Y2, X1, Y1, K)
                CALL LINES4(Y2, X2, Y1, X1, K)
        END IF
        X2 = X1
        Y2 = Y1
        RETURN

STARS:
        IF NEWSTART THEN GOSUB BLACKBACK
        XS1 = RND * (U / 15) + (U / 20)
        XS2 = XS1 * 2 / 5
        CA = RND * 359
        CALL DOSTARS
        X1 = -FNRNDU
        Y1 = FNRNDU
        CALL DOSTARS
        X1 = FNRNDU
        Y1 = -FNRNDU
        CALL DOSTARS
        X1 = -FNRNDU
        Y1 = -FNRNDU
        CALL DOSTARS
        IF C OR (KOUNT = 7) THEN
                IF V > 8 AND STYLE = 3 THEN
                        GOSUB MOON
                ELSE
                        GOSUB METEOR
                END IF
        END IF
        I = N
        RETURN

MOON:
        X1 = FNRNDU
        Y1 = FNRNDU
        FOR I = 1 TO 89
        J = FIX(I / (90 / 7))
         CIRCLE (X1, Y1), (U / 8), J + 7, 90 * DEG, 270 * DEG, 1 / SINE!(DEG * I)
         CIRCLE (X1, Y1), (U / 8), J + 1, 270 * DEG, 90 * DEG, 1 / COSINE!(DEG * I)
        NEXT I
        LINE (X1, Y1 - (U / 9))-(X1, Y1 + (U / 9)), J + 1
        RETURN

METEOR:
        SELECT CASE V
        CASE 12
                PALETTE 15, 4144959
        CASE 9
                PALETTE 15, 63
        CASE ELSE
        END SELECT
        REDIM S&(FNSCRSAV&(0, 0, 15, 15) / 4)
        CX& = U * 1.5
        FOR B! = -10 TO -85 STEP -1
                A! = DEG * B!
                X1 = U + CX& * SINE!(A!)
                Y1 = -U + CX& * COSINE!(A!)
                X2 = X1 + 15
                Y2 = Y1 - 15
                XS1 = COSINE!(A!)
                YS1 = SINE!(A!)
                TU! = FNTIMER!(.025)
                GET (X1, Y1)-(X2, Y2), S&
                CIRCLE (X1 + 5, Y2 + 5), 4, 15
                PAINT STEP(0, 0), 15, 15
                CIRCLE STEP(2, 2), 2, 15
                PAINT STEP(0, 0), 15, 15
                PSET STEP(1, 1), RND * 15
                PSET STEP(2, 2), RND * 15
                PSET STEP(3, 3), RND * 15
                PSET STEP(4, 4), RND * 15
                DO WHILE TIMER < TU!
                LOOP
                PUT (X1, Y2), S&, PSET
        NEXT B!
        ERASE S&
        RETURN

LINKS:
        CALL CHAINS(INT(RND * 15))
        GOSUB SHUTOFF
        RETURN

EGGS:
        IF I = 1 THEN
                R1 = 0
        END IF
        FOR A! = 0 TO 180 STEP 10
                R2 = ABS((U / 10) * COSINE!(A! * DEG))
                X1 = 0
                FOR B! = 0 TO A! STEP 10
                        C! = ABS(COSINE!(B! * DEG))
                        R = (U / 10) * C!
                        K = CGAK((K + (14 * C!)) MOD 14 + 1)
                        C! = R2 / 2.5
                        IF C! > R / 2.5 THEN C! = R / 2.5
                        CALL SPICIRCLES(X1, R1, CINT(C!), K, .8)
                        CALL SPICIRCLES(R1, X1, CINT(C!), K, .8)
                        CALL SPIPAINT(X1, R1, K, K)
                        CALL SPIPAINT(R1, X1, K, K)
                        X1 = X1 + R
                NEXT B!
                R1 = R1 + R2
                IF INKEY$ <> "" THEN EXIT FOR
        NEXT A!
        GOSUB SHUTOFF
        RETURN
RAYS:
        IF I = 1 AND STYLE > 2 THEN KSWITCH = -1
        CALL LINES4(0, 0, X1, Y1, K)
        CALL LINES4(0, 0, Y1, X1, K)
        IF ABS(X1 + XS1) > U THEN X1 = 0
        IF ABS(Y1 + YS1) > U THEN Y1 = 0
        IF ABS(X2 + XS2) > U THEN X2 = 0
        IF ABS(Y2 + YS2) > U THEN Y2 = 0
        RETURN

MANDEL:
        CALL MANDELBROT
        WINDOW (-U, -U)-(U, U)
        GOSUB SHUTOFF
      RETURN

JULIA:
        CALL JULIA
        WINDOW (-U, -U)-(U, U)
        GOSUB SHUTOFF
      RETURN

FLOWERS:
        IF V = 12 THEN
                PAL(3) = 73008
                PAL(6) = 1982235
                PAL(9) = 1982235
        END IF
        GOSUB BLACKBACK
        IF RND < .5 THEN GOTO QALACE
        STP = 0
        X1 = RND * (U / 4) + (U / 4)'LENGTH OF STALK
        X2 = 360 / (RND * 2 + 2)'NUMBER OF STALKS
        CALL DOFLOWER(4, X1, X2, 0, 0, 0)
        GOSUB SHUTOFF
        RETURN

QALACE:
        REDIM TX(5, 5)
        A = 0
        TX(1, 2) = 60
        TX(1, 1) = U / 2'LENGTH OF STALK
        FOR YS2 = 2 TO 5'UBOUND(TX)
                TX(YS2, 1) = INT(TX(YS2 - 1, 1) / (6 - YS2))
                TX(YS2, 2) = TX(YS2 - 1, 2)
        NEXT YS2
        GOSUB QA2
        A = 30
        GOSUB QA2
        A = 15
        TX(1, 1) = U / 3'LENGTH OF STALK
        GOSUB QA2
        A = 7
        TX(1, 2) = 30
        TX(1, 1) = U / 5'LENGTH OF STALK
        GOSUB QA2
        ERASE TX
        GOSUB SHUTOFF
        RETURN

QA2:
        TX(1, 3) = A
        DO WHILE TX(1, 3) < 360 AND CX& <> 1
        YS2 = 1: GOSUB DOQA
         TX(2, 3) = A
         DO WHILE TX(2, 3) < 360 AND CX& <> 1
         YS2 = 2: GOSUB DOQA
          TX(3, 3) = A
          DO WHILE TX(3, 3) < 360 AND CX& <> 1
          YS2 = 3: GOSUB DOQA
           TX(4, 3) = A
           DO WHILE TX(4, 3) < 360 AND CX& <> 1
           YS2 = 4: GOSUB DOQA
                IF INKEY$ <> "" THEN CX& = 1
          LOOP
         LOOP
        LOOP
        LOOP
        RETURN

DOQA:
        K = CGAK(YS2 * 3)
        TX(YS2, 3) = TX(YS2, 3) + TX(YS2, 2)'ANGEL OF STEMS
        A! = (TX(YS2, 3) + (RND * 10 - 5)) * DEG
        X1 = TX(YS2 - 1, 4)
        Y1 = TX(YS2 - 1, 5)
        TX(YS2, 4) = X1 + (TX(YS2, 1) + (RND * 6 - 3)) * .75 * SINE!(A!)
        TX(YS2, 5) = Y1 + (TX(YS2, 1) + (RND * 6 - 3)) * COSINE!(A!)
        LINE (X1, Y1)-(TX(YS2, 4), TX(YS2, 5)), K
        PSET STEP(0, 0), 0
        RETURN


QUILT:
        K = CGAK(RND * 14 + 1)
        R1 = 0
        C! = 0
        R = U / 14
        A = UPK(K + 8)
        DO
                CX& = 360
                GOSUB GETNUM
        LOOP WHILE CX& < 45
        DO WHILE R1 < U - R
                R2 = INT(RND * 2)
        A! = C! * DEG
        IF R2 = 1 THEN
        CALL VECTORSPIN(0, 0, A!, CX& * DEG, (CX& / 2) * DEG, R1 + R, R1, K)
        CALL VECTORSPIN(0, 0, A!, CX& * DEG, 0, R1 + R, R1 + R + R, K)
        CALL VECTORSPIN(0, 0, A!, CX& * DEG, (CX& / 2) * DEG, R1 + R + R, R1 + R, K)
        CALL VECTORSPIN(0, 0, (C! + (CX& / 2)) * DEG, CX& * DEG, (CX& / 2) * DEG, R1 + R, R1 + R + R, K)
        CALL VECTORSPIN(0, 0, (C! + (CX& / 2)) * DEG, CX& * DEG, (CX& / 2) * DEG, R1, R1 + R, K)
        ELSE
        CALL VECTORSPIN(0, 0, A!, CX& * DEG, (CX& / 2) * DEG, R1 + R, R1, K)
        CALL VECTORSPIN(0, 0, A!, CX& * DEG, (CX& / 2) * DEG, R1 + R, R1 + R + R, K)
        CALL VECTORSPIN(0, 0, (C! + (CX& / 2)) * DEG, CX& * DEG, (CX& / 2) * DEG, R1 + R + R, R1 + R, K)
        CALL VECTORSPIN(0, 0, (C! + (CX& / 2)) * DEG, CX& * DEG, (CX& / 2) * DEG, R1, R1 + R, K)
        END IF
        FOR B! = C! TO C! + 360 STEP CX&
                A! = (B! + (CX& / 2)) * DEG
                X1 = (R1 + R / 2) * .75 * SINE!(A!)
                Y1 = (R1 + R / 2) * COSINE!(A!)
                PAINT (X1, Y1), UPK(K + 8), K
        NEXT B!
        K = UPK(K)
        R1 = R1 + R
        IF R2 <> 1 THEN C! = C! + (CX& / 2)
        IF INKEY$ <> "" THEN EXIT DO
        GOSUB GETNUM
        LOOP
        GOSUB SHUTOFF
        RETURN

GETNUM:
        CY& = RND * 104 + 16
        DO UNTIL CX& MOD CY& = 0
                CY& = CY& - 1
        LOOP
        CX& = CY&
        RETURN

BUBBLE:
        IF I = 1 THEN
                IF .5 < RND THEN X1 = -X1
                IF .5 < RND THEN X2 = -X2
                IF .5 < RND THEN Y1 = -Y1
                IF .5 < RND THEN Y2 = -Y2
                IF STYLE < 3 AND V >= 9 THEN
                        ON STYLE GOSUB SHADOW, FOURTONE
                        PALETTE USING PAL
                        STYLE = STYLE + 2
                END IF
        END IF
        R1 = N / 4 + 1
        FOR A! = 0 TO R1 STEP .5
                B! = ABS(R1 * COSINE!(DEG * A! * 90 / R1))
                C! = A! / 3
                K = CGAK(A! / (R1 / 15))
                CIRCLE (X1 - C!, Y1 + C!), B! / 2, K
                PAINT (X1 - C!, Y1 + C!), K, K
                CIRCLE (X2 - C!, Y2 + C!), B!, K
                PAINT (X2 - C!, Y2 + C!), K, K
        NEXT A!
        I = N
        RETURN

CONES:
        IF I = 1 THEN
                IF .5 < RND THEN X1 = -X1
                IF .5 < RND THEN Y1 = -Y1
                X1 = X1 MOD (U / 2)
                Y1 = Y1 MOD (U / 2)
                R1 = N / 4 + 1
                IF STYLE < 3 AND V >= 9 THEN
                        ON STYLE GOSUB SHADOW, FOURTONE
                        PALETTE USING PAL
                        STYLE = STYLE + 2
                END IF
        END IF
        FOR A! = 90 TO 180 STEP ATN(1 / (.4 * R1)) / DEG
                B! = R1 * SINE!(DEG * A!)
                C! = R1 * .4 * COSINE!(DEG * A!)
                K = CGAK(15 / 180 * A!)
                LINE (X1 + B!, Y1 + C!)-(X1, Y1 + R1 + R1), K
                LINE (X1 - B!, Y1 + C!)-(X1, Y1 + R1 + R1), K
                LINE (X1 + B!, Y1 + C!)-(X1 - B!, Y1 + C!), K
                PAINT (X1, Y1 + C! + 1), K, K
        NEXT A!
        X1 = X1 - R1 - R1
        Y1 = Y1 + C! + C!
        FOR A! = 90 TO 180 STEP ATN(1 / (.4 * R1)) / DEG
                B! = R1 * SINE!(DEG * A!)
                C! = R1 * .4 * COSINE!(DEG * A!)
                K = CGAK(15 / 180 * A!)
                LINE (X1 + B!, Y1 + C!)-(X1 - B!, Y1 + C! + R1 + R1), K, BF
                LINE (X1 + B!, Y1 + C! + R1 + R1)-(X1, Y1 + R1 + R1), K
                LINE (X1 - B!, Y1 + C! + R1 + R1)-(X1, Y1 + R1 + R1), K
                LINE (X1 + B!, Y1 - C! + R1 + R1)-(X1, Y1 + R1 + R1), 16 - K
                LINE (X1 - B!, Y1 - C! + R1 + R1)-(X1, Y1 + R1 + R1), 16 - K
        NEXT A!
        X1 = X1 + (R1 * 3)
        Y1 = Y1 + (C! * 3)
        FOR A! = 90 TO 180 STEP ATN(1 / (.4 * R1)) / DEG
                B! = R1 * SINE!(DEG * A!)
                C! = R1 * .4 * COSINE!(DEG * A!)
                K = CGAK(15 / 180 * A!)
                CIRCLE (X1, Y1 - C!), ABS(B!), K
                PAINT (X1, Y1 - C!), K, K
        NEXT A!
        I = N
        RETURN

ROLLER:
        IF I = 1 THEN
                KSWITCH = 0     'FORCE K SWITCH OFF
                R2 = 0
                R1 = ABS(X1)
                B = RND * 9 + 1
                YS2 = 0
                XS1 = RND * 154 + 101
                A! = PI2 / N
                IF RND < .5 THEN A! = -A!
                G = FNRND3TO8
        END IF
        X1 = R1 * .75 * SINE!(I * A!)
        Y1 = R1 * COSINE!(I * A!)
        X2 = (R1 / 2) * .75 * SINE!(I * A!)
        Y2 = (R1 / 2) * COSINE!(I * A!)
        'B = 10
        SELECT CASE B
        CASE 1
                CIRCLE (X1, Y1), ABS(X1), K
                CIRCLE (X1, Y1), ABS(.8 * Y1), K
        CASE 2
                CIRCLE (X1, Y1), R1, K
        CASE 3
                LINE (X1, Y1)-(0, 0), K, B
        CASE 4
                LINE (X1, Y1)-(X2, Y2), K, B
        CASE 5
                A$ = " BM" + STR$(PMAP(0, 0)) + "," + STR$(PMAP(0, 1)) + " S" + STR$(ABS(XS1))
                DRAW "TA" + STR$(INT(I * (180 / N)) MOD 180) + " C" + STR$(K) + A$ + DRAWBOX$
                DRAW "TA" + STR$(INT((N - I) * (180 / N)) MOD 180) + " C" + STR$(K) + A$ + DRAWBOX$
                DRAW "TA" + STR$(-INT(I * (180 / N)) MOD 180) + " C" + STR$(K) + A$ + DRAWBOX$
                DRAW "TA" + STR$(-INT((N - I) * (180 / N)) MOD 180) + " C" + STR$(K) + A$ + DRAWBOX$
                I = I + 3
        CASE 6
                A$ = " BM" + STR$(PMAP(X1, 0)) + "," + STR$(PMAP(Y1, 1)) + " S" + STR$(ABS(XS1))
                DRAW "TA" + STR$(INT(-I * A! / DEG) MOD 360) + " C" + STR$(K) + A$ + DRAWBOX$
        CASE 7
                A$ = " BM" + STR$(PMAP(X1, 0)) + "," + STR$(PMAP(Y1, 1)) + " S" + STR$(ABS(XS1))
                DRAW "TA" + STR$(INT(-I * (A! / DEG + 45) MOD 360)) + " C" + STR$(K) + A$ + DRAWBOX$
        CASE 8 TO 10
                B! = PI2 / G
                C! = B!
                IF B = 9 THEN B! = B! + B!
                IF B = 10 THEN C! = B! + B!
                CALL VECTORSPIN(X1 + X2, Y1 + Y2, YS1 * I * A!, B!, C!, R1, R1, K)
        CASE ELSE
        STOP
        END SELECT
        RETURN

SPIRAL:
        IF NEWSTART THEN
                B = FIX(RND * 27)
                IF RND < .5 THEN CY& = 2 ELSE CY& = -2
                IF RND < .5 THEN CX& = 1 ELSE CX& = -1
                IF B = 0 THEN GOSUB BLACKBACK 'GALAXY
        END IF
        IF I = 1 THEN
                R1 = U
                R2 = FIX(CX& * R1 / N)
                B! = CY& * PI / N
        END IF
        WINDOW (-SQR2 * U, -U)-(SQR2 * U, U)
        X1 = R1 * SINE!(I * B!)
        Y1 = R1 * COSINE!(I * B!)
        'B = 11
        SELECT CASE B
        CASE 0  'GALAXY
                R = (U - R1) / 4
                X1 = R1 * .75 * SINE!(I * B!)
                XS1 = RND * (R + R) - R
                YS1 = RND * (R + R) - R
                PSET (-Y1 - YS1, X1 + XS1), K
                PSET (Y1 + YS1, -X1 - XS1), K
        CASE 1  'CROSSES
                LINE (-X1, -Y1)-(X1, Y1), K
                LINE (Y1, -X1)-(-Y1, X1), K
        CASE 2  'DOTS
                CALL SPIPSET(X1, Y1, K)
        CASE 3
                CALL SPIBOXES(0, 0, X1, Y1, K)
        CASE 4
                R = R1 / 2
                CALL SPICIRCLES(X1, Y1, R, K, 1)
        CASE 5, 6
                IF B = 5 THEN
                        R = (U - R1) / 2
                ELSE
                        R = U - R1 / 2
                END IF
                CALL SPICIRCLES(X1, Y1, R, K, 1)
        CASE 7
                R = (U - R1) / 2
                CALL SPIBOXES(X1 - R, Y1 - R, X1 + R, Y1 + R, K)
        CASE 8
                R = (U - R1) / 2
                C! = ABS(TAN(I * B!))
                CALL SPICIRCLES(X1, Y1, R, K, C!)
        CASE 9
                R = (U - R1) / 2
                C! = (360 - INT(I * B! / DEG)) MOD 360
                A$ = " S" + STR$((ABS(R) MOD 255) + 1) + " C" + STR$(K) + DRAWBOX$
                X2 = PMAP(X1, 0)
                Y2 = PMAP(Y1, 1)
                DRAW " BM" + STR$(X2) + "," + STR$(Y2) + " TA" + STR$(C!) + A$
                X2 = PMAP(-X1, 0)
                Y2 = PMAP(-Y1, 1)
                DRAW " BM" + STR$(X2) + "," + STR$(Y2) + " TA" + STR$((C! + 180) MOD 360) + A$
                X2 = PMAP(-Y1, 0)
                Y2 = PMAP(X1, 1)
                DRAW " BM" + STR$(X2) + "," + STR$(Y2) + " TA" + STR$((C! + 90) MOD 360) + A$
                X2 = PMAP(Y1, 0)
                Y2 = PMAP(-X1, 1)
                DRAW " BM" + STR$(X2) + "," + STR$(Y2) + " TA" + STR$((C! + 270) MOD 360) + A$
        CASE 10
                R = (U - R1) / 2
                C! = R1 * SINE!(I * XS2 * B!)
                X2 = R * .75 * SINE!(C!)
                Y2 = R * COSINE!(C!)
                CALL SPILINES(X1 - X2, Y1 - Y2, X1 + X2, Y1 + Y2, K)
        CASE 11
                R = U - R1 / 2
                C! = R1 * SINE!(I * XS2 * B!)
                X2 = R * .75 * SINE!(C!)
                Y2 = R * COSINE!(C!)
                CALL SPILINES(X1 - X2, Y1 - Y2, X1 + X2, Y1 + Y2, K)
                IF N > (U / 2) THEN
                        I = I + 1
                        IF I >= N THEN C = -1
                END IF
        CASE 12
                R = (U - R1) / 2
                CALL SPILINES(X1 - R, Y1 - R, X1 + R, Y1 + R, K)
        CASE 18 TO 25
                IF B MOD 2 = 1 THEN
                        XS2 = 0
                        YS2 = 0
                END IF
                IF I = 1 THEN
                                SELECT CASE B
                                CASE 18, 19
                                        X2 = 0
                                        Y2 = 0
                                CASE 20, 21
                                        X2 = U
                                        Y2 = U
                                CASE 22, 23
                                        X2 = U
                                        Y2 = 0
                                CASE ELSE
                                END SELECT
                        END IF
                CALL SPILINES(X2, Y2, X1, Y1, K)
        CASE 13
                CALL CSPIRAL
                GOSUB SHUTOFF
        CASE 14
                C! = ROUNDPI!(ABS(I * B!))
                DO WHILE C! > PIHALF
                        C! = C! - PIHALF
                LOOP
                CALL SPIARCS(0, 0, R1, K, C!, PIHALF, 1)
                IF I = N AND N > 20 THEN GOSUB SHUTOFF
        CASE 15, 16, 17
                IF B = 16 THEN
                        R = (U - R1) / 2
                ELSEIF B = 17 THEN
                        R = U - R1 / 2
                ELSE
                        R = R1
                END IF
                C! = ROUNDPI!(ABS(I * B!))
                CALL SPIARCS(X1, Y1, R, K, C!, PIHALF + C!, 1)
        CASE 26
                WINDOW (-U, -U)-(U, U)
                X1 = R1 * .75 * SINE!(I * B!)
                IF I = 1 THEN
                        C! = PI / FIX(RND * 2 + 3)
                        IF RND < .5 THEN R = FNRND3TO8 ELSE R = 1
                END IF
                D! = R * I * B!
                J = R1 / 2
                CALL VECTORSPIN(X1, Y1, PI + D!, C!, C!, J, J, K)
                CALL VECTORSPIN(-X1, -Y1, D!, C!, C!, J, J, K)
                CALL VECTORSPIN(-Y1, X1, PI3HALF + D!, C!, C!, J, J, K)
                CALL VECTORSPIN(Y1, -X1, PIHALF + D!, C!, C!, J, J, K)
        CASE ELSE
        END SELECT
        A$ = ""
        WINDOW (-U, -U)-(U, U)
        RETURN

TWISTER:
        IF NEWSTART THEN
                KSWTICH = 0
                DO
                        B = RND * 6 + 1
                LOOP WHILE B <= 2
        END IF
        IF I = 1 THEN
                R2 = 0
                R1 = ABS(X1)
                XS2 = RND * 8 + 1
                IF RND < .5 THEN CX& = -1: B = -B ELSE CX& = 1
                G = FNRND3TO8
        END IF
        A! = CX& * PI2 / N
        X1 = R1 * .75 * SINE!(I * A!)
        Y1 = R1 * COSINE!(I * A!)
        X2 = (R1 / 2) * .75 * SINE!(I * B * A!)
        Y2 = (R1 / 2) * COSINE!(I * B * A!)
        'XS2 = 8
        SELECT CASE XS2
        CASE 1
                LINE (X1, Y1)-(X1 + X2, Y1 + Y2), K, B
        CASE 2
                LINE (X1, Y1)-(X1 + X2, Y1 + Y2), K
        CASE 3
                CIRCLE (X1 + X2, Y1 + Y2), XS2 * (U / 40), K
        CASE 4
                CIRCLE (X1 + X2, Y1 + Y2), ABS(R1 / 2), K
        CASE 5
                LINE (X2, Y2)-(X1, Y1), K
        CASE 6
                LINE ((R1 / 2) * .75 * SINE!(I * B * A!) + X2, (R1 / 2) * COSINE!(I * B * A!) + Y2)-(X1, Y1), K
        CASE 7
                IF (ABS(B) MOD 2) = 1 THEN
                        LINE (0, 0)-(X1 + X2, Y1 + Y2), K, B
                ELSE
                        LINE (0, 0)-(X1 + X2, Y1 + Y2), K
                END IF
        CASE 8, 9
                B! = PI2 / G
                C! = B!
                IF XS2 = 9 THEN C! = B! + B!
                CALL VECTORSPIN(X1 + X2, Y1 + Y2, XS1 * I * A!, B!, C!, R1, R1, K)
                IF N > (U / 2) THEN I = I + 1
        CASE ELSE
        END SELECT
        RETURN

CURLS:
        IF NEWSTART THEN
                G = RND > .5
                A = RND > .5
                R = RND > .5
        END IF
        IF I = 1 THEN
                IF A THEN R2 = 0
                R1 = R1 / 2
        END IF
        DO WHILE ABS(B) < 2
                B = FNRNDT
        LOOP
        B! = I * B * DEG
        IF R THEN C! = SINE!(I * DEG) ELSE C! = 1
        X2 = R1 * .75 * SINE!(A!)
        Y2 = R1 * COSINE!(A!)
        IF G THEN
                CALL SPIARCS(X1, Y1, R1, K, B!, PIHALF + B!, C!)
        ELSE
                CALL ARCS4(X1, Y1, R1, K, B!, PIHALF + B!, C!)
        END IF
        RETURN

TWIRLS:
        IF NEWSTART THEN
                G = ABS(FNRNDT)
                B = FNRND3TO8
                R = ABS(RND < .5)
        END IF
        DO WHILE XS1 = 0
                XS1 = FNRNDT
        LOOP
        R2 = R2 * R
        A! = I * XS1 * DEG
        X2 = R1 * .75 * SINE!(A!)
        Y2 = R1 * COSINE!(A!)
        SELECT CASE G
        CASE 0, 4
                CALL SPILINES(X1 + X2, Y1 + Y2, X1 - X2, Y1 - Y2, K)
        CASE 1
                CALL LINES4(X1 + X2, Y1 + Y2, X1 - X2, Y1 - Y2, K)
        CASE 2
                CALL SPILINES(X1, Y1, X1 + X2, Y1 + Y2, K)
        CASE 3
                CALL LINES4(X1, Y1, X1 - X2, Y1 - Y2, K)
        CASE ELSE
        END SELECT
        RETURN

LUPS:
        IF I = 1 THEN
                GOSUB BLACKBACK
                B = RND < .5
                IF A > 0 THEN A = -1 ELSE A = 1
                DO WHILE XS1 = 0
                        XS1 = FNRNDT
                LOOP
                G = 0
        END IF
        R2 = R1 * SINE!(I * A! * DEG)
        R2 = R2 * SINE!(I * XS1 * A! * DEG)
        IF A = 1 THEN
                B! = (A! / 2) * I * DEG
        ELSE
                B! = (A! / 2) * (N - I) * DEG
        END IF
        X1 = R2 * COSINE!(B!)
        Y1 = R2 * SINE!(B!)
        IF I > 1 THEN CALL PSET4(X1, Y1, K)
        I = I + 2
        IF G = 0 AND I > N - 2 THEN I = 2: G = 1
        R2 = XS1
        IF RND < .5 THEN GOTO SCREWUP
        RETURN

SCREWUP:
        IF I = 1 THEN
                GOSUB BLACKBACK
                B = RND < .5
                IF Y2 > 0 THEN Y2 = -1 ELSE Y2 = 1
                G = 0
        END IF
        IF N > (U / 2) THEN X2 = 2 ELSE X2 = 1
        R2 = R1 * SINE!(I * A! * DEG)
        B! = Y2 * (A! / 2) * I * DEG
        X1 = R2 * COSINE!(B!)
        Y1 = R2 * SINE!(B!)
        IF I > 1 THEN CALL PSET4(X1, Y1, K)
        I = I + X2
        IF G = 0 AND I > N - 2 THEN I = 2: G = 1
        R2 = XS1
        IF RND < .5 THEN GOTO LUPS
        RETURN

BUTTERFLY:
        IF I = 1 THEN
                G = 0
                R = R2
                GOSUB BLACKBACK
        END IF
        PSET (1, 0)
        R1 = ABS(R1 + R) MOD U
        R = R1 * SINE!(I * A! * DEG)
        B! = (A! / 2) * I * DEG
        X1 = R * COSINE!(B!)
        Y1 = R * SINE!(B!)
        PSET (X1, Y1), K
        PSET (X1 / 2, -Y1 / 2), K
        PSET (-X1, Y1), K
        PSET (-X1 / 2, -Y1 / 2), K
        IF G = 0 AND I > N - 1 THEN
                I = 2
                G = 1
                R1 = R1 / 2
        END IF
        RETURN

        TYPE RAYS
                RAD AS INTEGER
                SINOF AS SINGLE
                COSOF AS SINGLE
                X AS INTEGER
                Y AS INTEGER
                K AS INTEGER
        END TYPE

RAYS3:
        REDIM TW(10) AS RAYS
        GOSUB TWOTONE
        FOR J = 0 TO 15
                PAL(J + UBOUND(PAL) - 16) = PAL(J)
                IF J <= UBOUND(TW) THEN TW(J).RAD = 0
        NEXT J
        GOSUB BLACKBACK
        A$ = ""
        DO
                A = FIX(RND * 180) + 1
                IF INSTR(A$, CHR$(A)) = 0 THEN
                        A$ = A$ + CHR$(A)
                        PSET (2 * FNRNDU - U, 2 * FNRNDU - U), (RND * 14) + 1
                END IF
        LOOP WHILE LEN(A$) < 180
        J = 0
        DO WHILE LEN(A$) > 0
                FOR CY& = 1 TO UBOUND(TW)
                        IF TW(CY&).RAD = 0 AND LEN(A$) > 0 THEN
                                A = ASC(A$) * 2
                                TW(CY&).RAD = 1
                                TW(CY&).K = UPK(RND * 14)
                                TW(CY&).SINOF = SINE!(A * DEG)
                                TW(CY&).COSOF = COSINE!(A * DEG)
                                TW(CY&).X = 0
                                TW(CY&).Y = 0
                                A$ = MID$(A$, 2)
                        END IF
                        TW(CY&).RAD = TW(CY&).RAD + RND * TW(CY&).RAD
                        X1 = TW(CY&).RAD * TW(CY&).SINOF
                        Y1 = TW(CY&).RAD * TW(CY&).COSOF
                        TW(CY&).K = UPK(TW(CY&).K)
                        LINE (TW(CY&).X, TW(CY&).Y)-(X1, Y1), 16 - TW(CY&).K
                        IF TW(CY&).RAD > U THEN
                                TW(CY&).RAD = 0
                        ELSE
                                TW(CY&).X = X1
                                TW(CY&).Y = Y1
                        END IF
                NEXT CY&
                IF INKEY$ <> "" THEN EXIT DO
                J = J MOD (UBOUND(PAL) - 16) + 1
                SWAP PAL(J), PAL(0)
                PALETTE USING PAL(J)
                SWAP PAL(0), PAL(J)
        LOOP
        ERASE TW
        GOSUB SHUTOFF
        RETURN

CROSS:
        IF I = 1 THEN
                GOSUB XINCNULL
                R2 = -1
                C! = RND + 3
                D! = RND
                R1 = RND * (U / 2) + (U / 2)
        END IF
        D! = D! + COSINE!(A! * DEG)
        Y1 = R1 * SINE!(A! * DEG)
        X1 = ABS(U * SINE!(B! * DEG))
        IF I > 1 THEN
                CALL LINES4(X2, Y2, X1, Y1, K)
                CALL LINES4(Y2, X2, Y1, X1, K)
        END IF
        B! = (B! + C!)
        A! = (A! + D!)
        X2 = X1
        Y2 = Y1
        RETURN

WHORLS:
        IF I = 1 THEN
                KSWITCH = -1
                GOSUB XINCNULL
                DO WHILE R2 < 4
                        R2 = ABS(FNRNDT) * 3
                LOOP
                R = ABS(R2) / 2
                R1 = 1
                G = 1
        END IF
        Y2 = Y1 - R1
        FOR X2 = X1 - R1 TO X1 + R1 - R2 STEP R2
                GOSUB XX
        NEXT X2
        FOR Y2 = Y1 - R1 TO Y1 + R1 - R2 STEP R2
                GOSUB XX
        NEXT Y2
        FOR X2 = X1 + R1 TO X1 - R1 STEP -R2
                GOSUB XX
        NEXT X2
        FOR Y2 = Y1 + R1 TO Y1 - R1 STEP -R2
                GOSUB XX
        NEXT Y2
        IF INKEY$ <> "" THEN GOSUB SHUTOFF
        I = I + 3
        RETURN

XX:
        IF ABS(X2) + ABS(R) > U OR ABS(Y2) + ABS(R) > U THEN I = N
        LINE (X2 - R, Y2 - R)-(X2 + R, Y2 + R), K, BF
        LINE (-X2 - R, Y2 - R)-(-X2 + R, Y2 + R), K, BF
        LINE (X2 - R, -Y2 - R)-(X2 + R, -Y2 + R), K, BF
        LINE (-X2 - R, -Y2 - R)-(-X2 + R, -Y2 + R), K, BF
        K = UPK(K)
        RETURN

WEB: CALL WEBS(INT(FIX(RND * 4)))
        GOSUB SHUTOFF
        RETURN

SPLINES:
        A! = 0
        R = (RND < .5)
        DO
                G = SGN(RND - .5)
        LOOP WHILE G = 0
        R1 = U
        STP = 0
        FOR J = 8 TO 3 STEP -1
                GOSUB SPLINEX
                IF R THEN
                        R1 = C! * COSINE!(B! / 2)
                ELSE
                        R1 = C!
                END IF
                IF STP THEN EXIT FOR
        NEXT J
        GOSUB SHUTOFF
        RETURN
SPLINEX:
        K = CGAK(RND * 15)
        B! = 360 / J * DEG
        C! = R1 * COSINE!(B! / 2)
        CX! = G * R1 * SINE!(B! / 2)
        FOR THETA! = -CX! TO CX! STEP CX! / 7.5
                IF R THEN
                        A! = ATN(THETA! / C!)
                        D! = C! * TAN(A!)
                        R1 = SQR(ABS(C! * C!) + ABS(D! * D!))
                ELSE
                        A! = (THETA! / (CX! / 7.5) * (B! / 15))
                END IF
                K = UPK(K)
                CALL VECTORSPIN(0, 0, A!, B!, B!, -R1, -R1, K)
                IF INKEY$ <> "" THEN
                        STP = -1
                        EXIT FOR
                END IF
        NEXT THETA!
        RETURN

GEOROSE:
        R1 = (R1 MOD (U / 4)) + 30
        K = 1
        A! = 0
        J = FNRND3TO8
        B! = 360 / J
        IF RND < .5 THEN
                FOR A! = A! TO A! + (B! / 2 * 10) STEP B! / 2
                        GOSUB GROSE1
                        R1 = R1 * COSINE!(B! / 2 * DEG)
                NEXT A!
        ELSE
                FOR A! = A! - (B! / 2) TO A! + (B! / 2) STEP B! / 10
                        C! = R1 * COSINE!(B! / 2 * DEG)
                        D! = C! * TAN(B! * .4 * DEG)    '(9/10'S OF B!/2)
                        R1 = SQR(ABS(C! * C!) + ABS(D! * D!))
                        GOSUB GROSE1
                NEXT A!
        END IF
        IF V > 1 THEN
                K = K - 2
                IF K < 1 THEN K = K + 4
                PAINT (X1, Y1), TILE$, K
                PAINT (-X1, Y1), TILE$, K
                PAINT (X1, -Y1), TILE$, K
                PAINT (-X1, -Y1), TILE$, K
        END IF
        I = N
        RETURN

GROSE1:
        FOR I = 0 TO J
                X2 = -R1 * SINE!((A! + (I * B!)) * DEG)
                Y2 = -R1 * COSINE!((A! + (I * B!)) * DEG)
                IF I > 0 THEN
                        CALL LINES4(X1 + CX&, Y1 + CY&, X1 + X2, Y1 + Y2, K)
                END IF
                CX& = X2
                CY& = Y2
        NEXT I
        PAINT (X1, Y1), UPK(K + 8), K
        PAINT (-X1, Y1), UPK(K + 8), K
        PAINT (X1, -Y1), UPK(K + 8), K
        PAINT (-X1, -Y1), UPK(K + 8), K
        K = UPK(K + 1)
        RETURN

NESTPOLY:
        R1 = U
        G = RND
        J = FNRND3TO8
        B! = 360 / J
        FOR A! = A! - (B! / 2) TO A! + (B! / 2) STEP B! / 20
                C! = R1 * COSINE!(B! / 2 * DEG)
                D! = C! * TAN(B! * .45 * DEG)'(9/10'S OF B!/2)
                R1 = SQR(ABS(C! * C!) + ABS(D! * D!))
                CALL VECTORSPIN(0, 0, A! * DEG, B! * DEG, B! * DEG, -R1, -R1, K)
                K = UPK(K)
        NEXT A!
        GOSUB SHUTOFF
        RETURN

POLYSPIN:
        IF NEWSTART THEN
                C! = PI2 / FNRND3TO8 * (1 - (RND < .5)) 'TIMES 1 OR 2
                R = RND < .5
        END IF
        IF I = 1 THEN
                IF RND < .5 THEN R1 = U ELSE R1 = 0
                R2 = FIX(U / N)
                IF RND > .5 THEN A! = -A!
        END IF
        IF NOT (R) THEN G = K ELSE G = -1
        CALL VECTORSPIN(0, 0, A! * I, C!, C!, R1, R1, G)
        IF I = N AND I > 10 THEN GOSUB SHUTOFF
        RETURN

GETSHAPE:
        SHAPE = FIX(RND * 6) + 1
        SELECT CASE SHAPE
        CASE 1, 2
        SHAPE = FIX(RND * 4) + 1   'SPIRALS, COMBINE, SCROLL AND ROLLER ONLY
        CASE 3 TO 5
        SHAPE = FIX(RND * 37) + 1
        CASE ELSE
        SHAPE = FIX(RND * 8) + 38
        END SELECT
        RETURN

GETSTYLE:
        STYLE = FIX(RND * 5) + 1
        K = 1
        ERASE PAL
        IF V < 9 THEN
                FOR I = 0 TO 15
                        PAL(I) = I
                        CALL FILLPAL(I)
                NEXT I
        ELSE
                ON STYLE GOSUB VARIABLE, SPECTRUM, SHADOW, FOURTONE, TWOTONE
        END IF
        SELECT CASE STYLE
        CASE 1
                IF V < 12 THEN GOSUB BLACKBACK
        CASE 2
                IF BG = 1 THEN
                        BACKGROUND = FIX(RND * 15)
                        FOR J = 45 TO 51
                                PAL(0) = FADECOLOR&(BACKGROUND, J)
                                PALETTE 0, PAL(0)
                        NEXT J
                END IF
        CASE ELSE
                BACKGROUND = 0
        END SELECT
        PALETTE USING PAL(0)
        TC! = FNTIMER!(10)
        RETURN

ROTATE.PALETTE:
        TIMER OFF
        C = 0
        GOSUB RPAL2
        BG = -ABS(BG)
        ON RND * 11 + 1 GOSUB SPIBLOCOUT, RBLOCOUT, CROSSOUT, COLOROUT, FANOUT, FADEOUT, WIPEOUT, BLOCKOUT, ZOOMOUT, ZOOMIN, SPHINCTER, SPIRALOUT
        TIMER ON
        RETURN

RPAL2:
        PAL2.BEGIN% = 0
        DO
                TC! = FNTIMER!(.125)
                PAL2.BEGIN% = PAL2.BEGIN% + 1
                IF BG = 1 THEN
                        BACKGROUND = (BACKGROUND + 1) MOD (UBOUND(PAL) - 16)
                        PAL(0) = FADECOLOR&(BACKGROUND, 51)
                END IF
                SWAP PAL(0), PAL(PAL2.BEGIN%)
                PALETTE USING PAL(PAL2.BEGIN%)
                SWAP PAL(0), PAL(PAL2.BEGIN%)
                DO WHILE TC! > TIMER 'PACE FOR VIDEO ACCELLERATORS
                        IF TIMER - TC! < -.125 THEN TC! = FNTIMER!(.125)
                LOOP
                IF INKEY$ <> "" THEN EXIT DO
                IF STYLE = 3 AND PAL2.BEGIN% = UBOUND(PAL) / 2 THEN EXIT DO
        LOOP UNTIL PAL2.BEGIN% = UBOUND(PAL) - 16
        IF BG = 1 THEN
                FOR I = 64 TO 50 STEP -1
                        PAL(PAL2.BEGIN%) = FADECOLOR&(PAL2.BEGIN%, I)
                        PALETTE 0, PAL(PAL2.BEGIN%)
                NEXT I
        END IF
        IF V <= 9 THEN PALETTE 0, 0
        RETURN

FADEOUT:
        IF V >= 9 THEN
        FOR I = 63 TO 50 STEP -1
                PAL(PAL2.BEGIN%) = 0
                FOR J = PAL2.BEGIN% + 1 TO PAL2.BEGIN% + 16
                        IF R1 = 0 THEN R1 = (PAL(J) > 0)
                        SELECT CASE V
                        CASE 12
                                PAL(J) = FADECOLOR&(J, I)
                        CASE 9
                                PAL(J) = (PAL(J) AND &H7) * 8
                        CASE ELSE
                                ERASE PAL
                                R1 = -1
                                EXIT FOR
                        END SELECT
                NEXT J
                PALETTE USING PAL(PAL2.BEGIN%)
                IF R1 = 0 THEN EXIT FOR
                IF INKEY$ <> "" THEN EXIT FOR
        NEXT I
        END IF
        C = -1
        RETURN

COLOROUT:
        IF V >= 9 THEN
        FOR J = PAL2.BEGIN% TO PAL2.BEGIN% + 16
                PAL(J) = 0
                IF INKEY$ <> "" THEN EXIT FOR
                PALETTE USING PAL(PAL2.BEGIN%)
        NEXT J
        END IF
        C = -1
        RETURN

WIPEOUT:
        I = 2
        R2 = 2
        X1 = 0
        Y1 = 0
        DO WHILE ABS(X1) < U AND ABS(Y1) < U
                A! = DEG * I * I
                X1 = R1 * SINE!(A!)
                Y1 = R1 * COSINE!(A!)
                IF Y1 > 0 THEN
                        LINE (X1, Y1)-(X1 + R2, Y1 + R2), RND * 16, BF
                ELSE
                        LINE (X1 - R2, Y1 - R2)-(X1, Y1), RND * 16, BF
                END IF
                I = I + 2
                R1 = I
                R2 = I / 2 + 1
                IF INKEY$ <> "" THEN EXIT DO
        LOOP
        C = -1
        CLS
        RETURN

BLOCKOUT:
        X1 = 4
        N = 1
        DO
                CX& = U / X1
                DO
                        FOR I = -U TO U STEP CX&
                        FOR J = -U TO U STEP CX&
                        K = POINT(I, J)
                        LINE (I - N, J - N)-(I + N, J + N), K, BF
                        NEXT J, I
                        N = N + (CX& / 10)
                LOOP UNTIL N >= (CX& / 2) + 1
                X1 = X1 / 2
                IF INKEY$ <> "" THEN EXIT DO
        LOOP UNTIL X1 = 0
        C = -1
        CLS
        RETURN

SPIBLOCOUT4:
        A$ = ""
        R = (RND < .5)
        SX1 = 0
        SY1 = 5
        B = 1
        IF RND < .5 THEN SWAP SX1, SY1: B = -1
        GOTO RBLOCALL

SPIBLOCOUT:
        A$ = ""
        SX1 = 0
        SY1 = 5
        B = 1
        IF RND < .5 THEN SWAP SX1, SY1: B = -1
        G = RND < .5
        FOR Y1 = SX1 TO SY1 STEP B
                IF G THEN
                        FOR X1 = Y1 TO 9 - Y1
                                A$ = A$ + CHR$(Y1 * 10 + X1)
                        NEXT X1
                        FOR X1 = Y1 TO 9 - Y1
                                A$ = A$ + CHR$(X1 * 10 + 9 - Y1)
                        NEXT X1
                        FOR X1 = 9 - Y1 TO Y1 STEP -1
                                A$ = A$ + CHR$(90 - (Y1 * 10) + X1)
                        NEXT X1
                        FOR X1 = 9 - Y1 TO Y1 STEP -1
                                A$ = A$ + CHR$(X1 * 10 + Y1)
                        NEXT X1
                ELSE
                        SX2 = Y1
                        SY2 = 9 - Y1
                        G = 1
                        IF R THEN SWAP SX2, SY2: G = -1
                        FOR X1 = SX2 TO SY2 STEP G
                                A$ = A$ + CHR$(Y1 * 10 + X1) + CHR$(90 - (Y1 * 10) + 9 - X1)
                                A$ = A$ + CHR$((X1 * 10) + 9 - Y1) + CHR$(90 - (X1 * 10) + Y1)
                        NEXT X1
                END IF
        NEXT Y1
        GOTO RBLOCALL

RBLOCOUT:
        A$ = ""
        DO WHILE LEN(A$) < 101
                I = RND * 100
                IF INSTR(A$, CHR$(I)) = 0 THEN A$ = A$ + CHR$(I)
        LOOP

RBLOCALL:
        J = U \ 5
        G = RND < .5
        IF NOT (G) THEN K = 0
        DO WHILE LEN(A$) > 0
                X1 = -U + (J * (ASC(A$) \ 10))
                Y1 = -U + (J * (ASC(A$) MOD 10))
                IF G THEN K = POINT(X1 + J / 2, Y1 + J / 2)
                LINE (X1, Y1)-(X1 + J, Y1 + J), K, BF
                A$ = MID$(A$, 2)
                IF INKEY$ <> "" THEN EXIT DO
        LOOP
        C = -1
        CLS
        A$ = ""
        RETURN

CROSSOUT:
        X1 = U / 2
        Y1 = X1
        R2 = 3
        R1 = 0
        N = U / R2 / 2
        FOR I = 1 TO N
                X2 = I * R2
                CALL SPIBOXESF(X1 - X2, Y1 - X2, X1 + X2, Y1 + X2, 0)
                IF INKEY$ <> "" THEN EXIT FOR
        NEXT I
        C = -1
        RETURN

ZOOMOUT:
        FOR I = 0 TO U + 6
        LINE (I, I)-(-I, -I), 0, BF
        I = I + 6
        IF INKEY$ <> "" THEN EXIT FOR
        NEXT I
        C = -1
        RETURN

ZOOMIN:
        FOR I = U + 6 TO 0 STEP -6
                LINE (I, I)-(-I, I - 6), 0, BF
                LINE (-I, -I)-(I, -I + 6), 0, BF
                LINE (I, I - 6)-(I - 6, -I + 6), 0, BF
                LINE (-I, I)-(-I + 6, -I + 6), 0, BF
                IF INKEY$ <> "" THEN EXIT FOR
        NEXT I
        C = -1
        RETURN

SPHINCTER:
        FOR I = U TO -U STEP -2
                CALL SPILINES(U, U, -U, I, 0)
                IF INKEY$ <> "" THEN EXIT FOR
        NEXT I
        C = -1
        RETURN

FANOUT:
        XS1 = -U
        XS2 = U
        DO
                G = SGN(RND - RND)
        LOOP WHILE G = 0
        IF G = -1 THEN SWAP XS1, XS2
        FOR I = XS1 TO XS2 STEP G
                CALL SPILINES(0, 0, I, U, 0)
                IF INKEY$ <> "" THEN EXIT FOR
        NEXT I
        C = -1
        RETURN

SPIRALOUT:
        X1 = U
        Y1 = U
        R1 = U
        R2 = 3
        N = U / R2
        A! = 90 / N
        IF RND < .5 THEN
                A! = -A!
                X1 = -U
        END IF
        IF RND > .5 THEN
                R1 = 0
                R2 = -R2
                X1 = 0
        END IF
        FOR I = 1 TO N
                R1 = R1 - R2
                X2 = R1 * SINE!(I * A! * DEG)
                Y2 = R1 * COSINE!(I * A! * DEG)
                CALL SPIBOXESF(X1, Y1, X2, Y2, 0)
                IF INKEY$ <> "" THEN EXIT FOR
        NEXT I
        C = -1
        RETURN

XINCNULL:
        XS1 = 0
        YS1 = 0
        XS2 = 0
        YS2 = 0
        RETURN

BLACKBACK:
        BG = -ABS(BG)
        PAL(0) = 0
        PALETTE USING PAL(0)
        RETURN

FUNCTION ALTERCOLOR& (X&, I!) STATIC
        R = (X& MOD 256) * I!
        G = ((X& / 256) MOD 256) * I!
        B = (X& / 65536) * I!
        ALTERCOLOR& = (65536 * ABS(B)) + (256 * ABS(G)) + ABS(R)
END FUNCTION

SUB ARCS4 (X, Y, R, K, F!, T!, A!) STATIC
        CIRCLE (X, Y), R, K, ROUNDPI!(F!), ROUNDPI!(T!), ABS(A!)
        CIRCLE (-X, -Y), R, K, ROUNDPI!(PI + F!), ROUNDPI!(PI + T!), ABS(A!)
        CIRCLE (-X, Y), R, K, ROUNDPI!(PI - T!), ROUNDPI!(PI - F!), ABS(A!)
        CIRCLE (X, -Y), R, K, ROUNDPI!(PI2 - T!), ROUNDPI!(PI2 - F!), ABS(A!)
END SUB

SUB BOXES4 (X1, Y1, X2, Y2, K)
        LINE (X1, Y1)-(X2, Y2), K, B
        LINE (-X1, Y1)-(-X2, Y2), K, B
        LINE (X1, -Y1)-(X2, -Y2), K, B
        LINE (-X1, -Y1)-(-X2, -Y2), K, B
END SUB

FUNCTION CGAK (K) STATIC
SHARED V
IF V = 1 THEN CGAK = K MOD 3 + 1 ELSE CGAK = K
END FUNCTION

SUB CHAINS (SWITCH&) STATIC
SHARED A!, B!, U, X1, Y1, K, R1
        TS = (SWITCH& AND 8) = 8
        SPIN = (SWITCH& AND 4) = 4
        KS = (SWITCH& AND 2) = 2
        FS = ((SWITCH& AND 1) = 1) AND KS
        WINDOW (-SQR2 * U, -U)-(SQR2 * U, U)
        R1 = U / 15
        IF TS THEN
                A! = PIHALF! / 15
                R2 = ABS(R1 * SINE!(A!))
        ELSE
                R2 = R1
                A = ATN(R1 / PI2) / DEG
                DO WHILE (360 MOD A) <> 0
                        A = A + 1
                LOOP
                A! = A * DEG
        END IF
        DO
                B! = 0
                C! = PIHALF!
                DO
                        X1 = R1 * SINE!(B!)
                        Y1 = R1 * COSINE!(B!)
                        IF SPIN THEN SWAP X1, Y1
                        IF TS THEN R2 = ABS(R1 * SINE!(A!))
                        CALL SPICIRCLES(X1, Y1, R2, K, 1)
                        IF FS THEN
                                CALL SPIPSET(X1, Y1, 0)
                                CALL SPIPAINT(X1, Y1, UPK(K + 8), K)
                        END IF
                        B! = B! + A!
                        IF KS THEN K = UPK(K)
                        IF INKEY$ <> "" THEN B! = C!: R1 = U'END BOTH LOOPS
                LOOP WHILE B! < C!
                R1 = R1 + R2
                IF NOT (TS) THEN
                        IF ABS(R1 * SINE!(A!)) > R2 THEN A! = A! / 2
                END IF
                IF NOT (KS) THEN K = UPK(K)
        LOOP WHILE R1 < U
        WINDOW (-U, -U)-(U, U)
END SUB

SUB CIRCLES4 (X1, Y1, R, K, A!) STATIC
        CIRCLE (X1, Y1), R, K, , , ABS(A!)
        CIRCLE (-X1, Y1), R, K, , , ABS(A!)
        CIRCLE (X1, -Y1), R, K, , , ABS(A!)
        CIRCLE (-X1, -Y1), R, K, , , ABS(A!)
END SUB

FUNCTION COSINE! (RAD!) STATIC
SHARED SINETAB!(), COSINETAB!()
R = (RAD! + RAD!) / DEG MOD 720
IF R < 0 THEN R = 720 + R
COSINE! = COSINETAB!(R)
END FUNCTION

SUB CSPIRAL
SHARED SIZE, CA, K, U, STP, X, Y
SIZE = INT(U / 45)
X = 0
Y = 0
STP = 0
CA = 0
K = 1
IF (RND > .5) THEN CALL RC(10) ELSE CALL LC(10)
END SUB

SUB DOFLOWER (LEVEL, STEMLEN, STEMINC, STEMA, FX, FY)
SHARED STP
        DO WHILE STEMA < 360 AND STP = 0
        K = CGAK(15 - LEVEL * 3)
        STEMA = STEMA + (RND * STEMINC + 35) 'ANGEL OF STEMS
        A! = STEMA * DEG
        X2 = FX + STEMLEN * (RND + .5) * SINE!(A!)
        Y2 = FY + STEMLEN * (RND + .5) * COSINE!(A!)
        LINE (FX, FY)-(X2, Y2), K
        PSET STEP(0, 0), 0
        IF INKEY$ <> "" THEN STP = -1
        IF LEVEL > 1 THEN
                CALL DOFLOWER(LEVEL - 1, STEMLEN / 3, STEMINC / 2, 0, X2, Y2)
        END IF
        LOOP
END SUB

DEFSNG A-Z
SUB DOLINES (DIST!, LEVEL)
SHARED TA!, TX, TY, K%, STP%
        IF STP% = -1 THEN EXIT SUB
        IF LEVEL = 0 THEN
                IF INKEY$ <> "" THEN STP% = -1
                X2 = TX + DIST! * SINE!(TA! * DEG)
                Y2 = TY + DIST! * COSINE!(TA! * DEG)
                CALL SPILINES(CINT(TX), CINT(TY), CINT(X2), CINT(Y2), K%)
                TX = X2
                TY = Y2
        ELSE
                A! = ((SQR(2) * DIST!) / 2) * SINE!(5 * DEG)
                D! = DIST! / 2 - A!
                F! = ATN(A! / D!) / DEG
                CALL DOLINES(D!, LEVEL - 1)
                TA! = TA! - 90 + F!
                CALL DOLINES(D!, LEVEL - 1)
                TA! = TA! + 180 - F! - F!
                CALL DOLINES(D!, LEVEL - 1)
                TA! = TA! - 90 + F!
                CALL DOLINES(D!, LEVEL - 1)
        END IF
END SUB

DEFINT A-Z
SUB DOSTARS
SHARED X1, Y1, X2, Y2, XS1, XS2, CA, A!, D, K
        PSET (X1, Y1), 0
        D = (K MOD 13) + 1
        A! = 36 * DEG
        CALL VECTORSPIN(X1, Y1, CA * DEG, A! + A!, A!, XS1, XS2, D)
        CALL VECTORSPIN(X1, Y1, (CA + 36) * DEG, A! + A!, A!, XS2, XS1, D)
        PAINT (X1, Y1), RND * 13 + 1, D
END SUB

SUB DRAGON
SHARED SIZE, CA, K, U, STP, X1, Y1
        A = RND < .5
        SIZE = U / 50
        STP = 0
        CA = 0
        K = 1
        X1 = 0
        Y1 = 0
        IF A THEN CALL LDRAGON(11) ELSE CALL RDRAGON(11)
END SUB

FUNCTION FADECOLOR& (INDEX, DEC) STATIC
SHARED V, PAL() AS LONG
IF V >= 12 THEN
        FADECOLOR& = ALTERCOLOR&(PAL(INDEX), DEC / 64)
ELSE
        FADECOLOR& = PAL(INDEX)
END IF

END FUNCTION

SUB FILLPAL (I) STATIC
SHARED PAL() AS LONG
        X = UBOUND(PAL) / 4
        FOR N = X TO UBOUND(PAL) - X STEP X
                PAL(N + I) = PAL(I)
        NEXT N
END SUB

SUB FORWARD (DISTANCE, K)
SHARED CA, X1, Y1
        X2 = DISTANCE * .75 * SINE!(CA * DEG)
        Y2 = DISTANCE * COSINE!(CA * DEG)
        IF CA <> 0 THEN LINE -(X2, Y2), K ELSE PSET (X2, Y2), K
END SUB

FUNCTION GETCOLOR& (ROFF!, GOFF!, BOFF!, INC!) STATIC
SHARED V
        SELECT CASE V
        CASE IS >= 12
                R = 63 * SINE!(ROFF! + INC!)
                G = 63 * SINE!(GOFF! + INC!)
                B = 63 * SINE!(BOFF! + INC!)
                GETCOLOR& = (65536 * ABS(B)) + (256 * ABS(G)) + ABS(R)
        CASE 9
                GETCOLOR& = FIX(INC! / DEG) MOD 63 + 1
        CASE IS < 9
                GETCOLOR& = FIX(INC! / DEG) MOD 16
        END SELECT
END FUNCTION

SUB JULIA STATIC
SHARED U
        MAXLOOP = 50
        X1 = -800
        Y1 = 625
        Y2 = -625
        X2 = 800
        I = (FIX(RND * 7) + 1) * 16
        A$ = "               -65  302 625 531-280 236 717 470  56 -32 492 515-385 127 747 427  92 -61 466 528182 175  474 573 199-215 490 588-544  54 797 359"
        CX = VAL(MID$(A$, I, 4))
        CY = VAL(MID$(A$, I + 4, 4))
        MAXX = VAL(MID$(A$, I + 8, 4))
        MAXY = VAL(MID$(A$, I + 12, 4))
        WINDOW (X1, Y1)-(X2, Y2)
        FOR NEWY = PMAP(0, 1) - 1 TO PMAP(MAXY, 1) STEP -2
                OLDCOLOR = 0           ' Start with background color.
                XS1 = X1
                R1 = 2
                NEWX = -MAXX
                DO WHILE NEWX <= MAXX
                        NEWX = NEWX + R1
                        LOGICX = PMAP(NEWX, 2)
                        LOGICY = PMAP(NEWY, 3)
                        MandelX& = LOGICX
                        MandelY& = LOGICY

                      ' Do the calculations to see if this point is in
                      ' the Mandelbrot Set:
                      FOR I = 1 TO MAXLOOP
                         RealNum& = MandelX& * MandelX&
                         ImagNum& = MandelY& * MandelY&
                         CV = ((RealNum& + ImagNum&) <= 10000)
                         DV = (RealNum& + ImagNum&) >= 640000
                         IF CV OR DV THEN EXIT FOR
                         MandelY& = (MandelX& * MandelY&) / 250 + CY
                         MandelX& = (RealNum& - ImagNum&) / 500 + CX
                         IF INKEY$ <> "" THEN EXIT SUB
                      NEXT I
                      ' Assign a color to the point:
                      IF DV THEN
                                PCOLOR = 0
                      ELSE
                        P! = (RealNum& + ImagNum&) / 1000000
                        IF P! <> 0 THEN PCOLOR = ABS(LOG(P!)) * 1.4
                      END IF
                      ' If color has changed, draw a line from the
                      ' last point referenced to the new point,
                      ' using the old color:
                      IF PCOLOR <> OLDCOLOR THEN
                         IF OLDCOLOR >= 1 THEN
                                LINE (XS1, LOGICY)-(LOGICX, LOGICY), CGAK(OLDCOLOR)
                                LINE (-XS1, -LOGICY)-(-LOGICX, -LOGICY), CGAK(OLDCOLOR)
                                LINE (XS1, PMAP(NEWY + 1, 3))-(LOGICX, PMAP(NEWY + 1, 3)), CGAK(OLDCOLOR)
                                LINE (-XS1, -PMAP(NEWY + 1, 3))-(-LOGICX, -PMAP(NEWY + 1, 3)), CGAK(OLDCOLOR)
                         END IF
                          OLDCOLOR = PCOLOR
                          XS1 = LOGICX
                      END IF
              LOOP
              IF OLDCOLOR >= 1 THEN
              LINE (XS1, LOGICY)-(LOGICX, LOGICY), CGAK(OLDCOLOR)
              LINE (-XS1, -LOGICY)-(-LOGICX, -LOGICY), CGAK(OLDCOLOR)
              LINE (XS1, PMAP(NEWY + 1, 3))-(LOGICX, PMAP(NEWY + 1, 3)), CGAK(OLDCOLOR)
              LINE (-XS1, -PMAP(NEWY + 1, 3))-(-LOGICX, -PMAP(NEWY + 1, 3)), CGAK(OLDCOLOR)
              END IF
        NEXT NEWY
END SUB

SUB KOCHLINE (L, LLEN!)
SHARED CA, K, X1, Y1, X2, Y2, STP
IF L = 0 THEN
        X2 = X1 + LLEN! * .75 * SINE!(CA * DEG)
        Y2 = Y1 + LLEN! * COSINE!(CA * DEG)
        IF (X1 >= 0 AND Y1 >= 0) THEN
                CALL LINES4(X1, Y1, X2, Y2, K)
        END IF
        X1 = X2
        Y1 = Y2
        IF INKEY$ <> "" THEN STP = -1
ELSE
        IF STP THEN EXIT SUB
        CALL KOCHLINE(L - 1, LLEN! / 3)
        CA = (CA - 60) MOD 360
        CALL KOCHLINE(L - 1, LLEN! / 3)
        CA = (CA + 120) MOD 360
        CALL KOCHLINE(L - 1, LLEN! / 3)
        CA = (CA - 60) MOD 360
        CALL KOCHLINE(L - 1, LLEN! / 3)
END IF
END SUB

SUB LC (LEVEL)
SHARED SIZE, CA, K, STP, X, Y
        IF STP = -1 THEN EXIT SUB
        IF LEVEL = 0 THEN
                NX = X + SIZE * SINE!(CA * DEG)
                NY = Y + SIZE * COSINE!(CA * DEG)
                CALL SPILINES(X, Y, NX, NY, K)
                X = NX
                Y = NY
                IF INKEY$ <> "" THEN STP = -1
        ELSE
                K = UPK(K)
                CALL LC(LEVEL - 1)
                CA = (CA - 90) MOD 360
                CALL LC(LEVEL - 1)
                CA = (CA + 90) MOD 360
        END IF
END SUB

SUB LDRAGON (LEVEL)
SHARED SIZE, CA, K, STP, X1, Y1, X2, Y2, STYLE
        IF STP = -1 THEN EXIT SUB
        IF LEVEL = 0 THEN
                X2 = X1 + SIZE * SINE!(CA * DEG)
                Y2 = Y1 + SIZE * COSINE!(CA * DEG)
                CIRCLE (X2, Y2), SIZE / 2, K
                CIRCLE (-X2, -Y2), SIZE / 2, K
                IF STYLE > 2 THEN
                        PAINT (X2, Y2), K, K
                        PAINT (-X2, -Y2), K, K
                END IF
                X1 = X2
                Y1 = Y2
                IF INKEY$ <> "" THEN STP = -1
        ELSE
                K = UPK(K)
                CALL LDRAGON(LEVEL - 1)
                CA = (CA + 90) MOD 360
                CALL RDRAGON(LEVEL - 1)
        END IF
END SUB

SUB LINES4 (X1, Y1, X2, Y2, K) STATIC
        LINE (X1, Y1)-(X2, Y2), K
        LINE (-X1, Y1)-(-X2, Y2), K
        LINE (X1, -Y1)-(X2, -Y2), K
        LINE (-X1, -Y1)-(-X2, -Y2), K
END SUB

SUB MANDELBROT STATIC
SHARED U
CONST MAXLOOP = 50
        X1 = -800
        Y1 = 625
        Y2 = -625
        X2 = 450
        WINDOW (X1, Y1)-(X2, Y2)
        A$ = SPACE$(180)
        DO WHILE INSTR(A$, " ") <> 0
                DO
                J = RND * 179 + 1
                LOOP UNTIL " " = MID$(A$, J, 1)
        MID$(A$, J, 1) = "1"
        J = J - 90
        SINOFJ! = SINE!(DEG * J)
        COSOFJ! = COSINE!(DEG * J)
        OLDCOLOR = 0           ' Start with background color.
        R1 = 1                  ' START WITH RADIUS =1
        R2 = 1
        XS1 = 0
        YS1 = 0                  ' START AT (0,0)
        DO
NEWPOINT:
        R1 = R1 + R2
        XS2 = PMAP(R1 * SINOFJ!, 0)
        YS2 = PMAP(R1 * COSOFJ!, 1)
        IF PMAP(LOGICX, 0) = XS2 AND PMAP(LOGICY, 1) = YS2 THEN GOTO NEWPOINT
        LOGICX = PMAP(XS2, 2)
        LOGICY = PMAP(YS2, 3)
      MandelX& = LOGICX
      MandelY& = LOGICY

      ' Do the calculations to see if this point is in
      ' the Mandelbrot Set:
      FOR I = 1 TO MAXLOOP
         RealNum& = MandelX& * MandelX&
         ImagNum& = MandelY& * MandelY&
         IF (RealNum& + ImagNum&) >= 640000 THEN EXIT FOR
         MandelY& = (MandelX& * MandelY&) \ 250 + LOGICY
         MandelX& = (RealNum& - ImagNum&) \ 500 + LOGICX
         IF INKEY$ <> "" THEN EXIT SUB
      NEXT I
      ' Assign a color to the point:
        IF I <= MAXLOOP THEN
                PCOLOR = LOG(I) * 5
        ELSE
                PCOLOR = 0
        END IF
      ' If color has changed, draw a line from the
      ' last point referenced to the new point,
      ' using the old color:
      IF PCOLOR <> OLDCOLOR THEN
         IF OLDCOLOR >= 1 THEN
                LINE (XS1, YS1)-(LOGICX, LOGICY), CGAK(OLDCOLOR)
                LINE (XS1, -YS1)-(LOGICX, -LOGICY), CGAK(OLDCOLOR)
         END IF
         R2 = 2
         OLDCOLOR = PCOLOR
         XS1 = LOGICX
         YS1 = LOGICY
      ELSE
         R2 = R2 MOD 14 + 2
      END IF
      LOOP WHILE LOGICX > X1 AND LOGICX < X2 AND LOGICY < Y1 AND LOGICY > Y2
      IF OLDCOLOR >= 1 THEN
              LINE (XS1, YS1)-(LOGICX, LOGICY), CGAK(OLDCOLOR)
              LINE (XS1, -YS1)-(LOGICX, -LOGICY), CGAK(OLDCOLOR)
      END IF
      LOOP

END SUB

SUB PSET4 (X1, Y1, K)
        PSET (X1, Y1), K
        PSET (X1, -Y1), K
        PSET (-X1, Y1), K
        PSET (-X1, -Y1), K
END SUB

SUB RC (LEVEL)
SHARED SIZE, CA, K, STP, X, Y
        IF STP = -1 THEN EXIT SUB
        IF LEVEL = 0 THEN
                NX = X + SIZE * SINE!(CA * DEG)
                NY = Y + SIZE * COSINE!(CA * DEG)
                CALL SPILINES(X, Y, NX, NY, K)
                X = NX
                Y = NY
                IF INKEY$ <> "" THEN STP = -1
        ELSE
                K = UPK(K)
                CALL RC(LEVEL - 1)
                CA = (CA + 90) MOD 360
                CALL RC(LEVEL - 1)
                CA = (CA - 90) MOD 360
        END IF
END SUB

SUB RDRAGON (LEVEL)
SHARED SIZE, CA, K, STP, X1, Y1, X2, Y2, STYLE
        IF STP = -1 THEN EXIT SUB
        IF LEVEL = 0 THEN
                X2 = X1 + SIZE * SINE!(CA * DEG)
                Y2 = Y1 + SIZE * COSINE!(CA * DEG)
                CIRCLE (X2, Y2), SIZE / 2, K
                CIRCLE (-X2, -Y2), SIZE / 2, K
                IF STYLE > 2 THEN
                        PAINT (X2, Y2), K, K
                        PAINT (-X2, -Y2), K, K
                END IF
                X1 = X2
                Y1 = Y2
                IF INKEY$ <> "" THEN STP = -1
        ELSE
                K = UPK(K)
                CALL LDRAGON(LEVEL - 1)
                CA = (CA - 90) MOD 360
                CALL RDRAGON(LEVEL - 1)
        END IF
END SUB

FUNCTION ROUNDPI! (P!) STATIC
        R = (FIX(P! / DEG) MOD 360)
        IF R < 0 THEN R = R + 360
        ROUNDPI! = ABS(R * DEG)
END FUNCTION

FUNCTION SINE! (RAD!) STATIC
SHARED SINETAB!(), COSINETAB!()
R = (RAD! + RAD!) / DEG MOD 720
IF R < 0 THEN R = 720 + R
SINE! = SINETAB!(R)
END FUNCTION

SUB SPIARCS (X, Y, R, K, F!, T!, A!) STATIC
                CIRCLE (X, Y), R, K, ROUNDPI!(F!), ROUNDPI!(T!), ABS(A!)
                CIRCLE (-X, -Y), R, K, ROUNDPI!(PI + F!), ROUNDPI!(PI + T!), ABS(A!)
                CIRCLE (-Y, X), R, K, ROUNDPI!(PIHALF + F!), ROUNDPI!(PIHALF + T!), ABS(A!)
                CIRCLE (Y, -X), R, K, ROUNDPI!(PI3HALF + F!), ROUNDPI!(PI3HALF + T!), ABS(A!)
END SUB

SUB SPIBOXES (X1, Y1, X2, Y2, K)
        LINE (X1, Y1)-(X2, Y2), K, B
        LINE (-X1, -Y1)-(-X2, -Y2), K, B
        LINE (-Y1, X1)-(-Y2, X2), K, B
        LINE (Y1, -X1)-(Y2, -X2), K, B
END SUB

SUB SPIBOXESF (X1, Y1, X2, Y2, K)
                LINE (X1, Y1)-(X2, Y2), K, BF
                LINE (-X1, -Y1)-(-X2, -Y2), K, BF
                LINE (-Y1, X1)-(-Y2, X2), K, BF
                LINE (Y1, -X1)-(Y2, -X2), K, BF
END SUB

SUB SPICIRCLES (X1, Y1, R, K, A!) STATIC
        CIRCLE (X1, Y1), R, K, , , ABS(A!)
        CIRCLE (-X1, -Y1), R, K, , , ABS(A!)
        CIRCLE (-Y1, X1), R, K, , , ABS(A!)
        CIRCLE (Y1, -X1), R, K, , , ABS(A!)
END SUB

SUB SPILINES (X1, Y1, X2, Y2, K)
        LINE (X1, Y1)-(X2, Y2), K
        LINE (-X1, -Y1)-(-X2, -Y2), K
        LINE (-Y1, X1)-(-Y2, X2), K
        LINE (Y1, -X1)-(Y2, -X2), K
END SUB

SUB SPIPAINT (X1, Y1, K, BK) STATIC
        PAINT (X1, Y1), K, BK
        PAINT (-X1, -Y1), K, BK
        PAINT (-Y1, X1), K, BK
        PAINT (Y1, -X1), K, BK
END SUB

SUB SPIPSET (X1, Y1, K)
        PSET (X1, Y1), K
        PSET (-X1, -Y1), K
        PSET (-Y1, X1), K
        PSET (Y1, -X1), K
END SUB

DEFSNG A-Z
SUB TORNSQR
SHARED U%, K%, TILE$, V%, TX, TY, TA!, STP%
A! = SQR2 * U%
WINDOW (-A!, -U% - 10)-(A!, U% + 10)
        SELECT CASE V%
        CASE 12
                PALETTE 15, 4144959
        CASE 9
                PALETTE 15, 63
        CASE ELSE
        END SELECT
STP% = 0
TA! = -90
TX = U%
TY = U%
K% = 15
A! = U% * 2
L = 5
CALL DOLINES(A!, L)
CALL DOLINES(5, 0)'FINISH OFF THE LAST PIECE IN THE CORNER
IF STP% = 0 THEN
        PAINT (0, 0), TILE$, 15
        PAINT (0, U%), 1, 15
END IF
WINDOW (-U%, -U%)-(U%, U%)
END SUB

DEFINT A-Z
FUNCTION UPK (K)
SHARED V
        IF V > 1 THEN M = 15 ELSE M = 3
        UPK = (K MOD M) + 1
END FUNCTION

SUB VECTORSPIN (ORGX%, ORGY%, BEGANGLE!, ROTANGLE!, SEGANGLE!, RADIUS1, RADIUS2, KK) STATIC
SHARED K
        G = (KK < 0)
        IF NOT (G) THEN K2 = KK
        FOR A! = BEGANGLE! TO PI2 + BEGANGLE! - DEG STEP ROTANGLE!
                X1 = ORGX + RADIUS1 * .75 * SINE!(A!)
                Y1 = ORGY + RADIUS1 * COSINE!(A!)
                X2 = ORGX + RADIUS2 * .75 * SINE!((A! + SEGANGLE!))
                Y2 = ORGY + RADIUS2 * COSINE!((A! + SEGANGLE!))
                LINE (X2, Y2)-(X1, Y1), K2
                IF G THEN K2 = UPK(K2)
        NEXT A!
END SUB

SUB WEBS (X) STATIC
SHARED X1, X2, Y1, Y2, XS1, XS2, YS1, YS2, R1, R2, CX&, CY&, CA
SHARED C, U, I, G, A, R, B, K, STP
SHARED A!, B!, C!
    ON FIX(RND * 6) + 1 GOSUB WEB1, WEB2, WEB3, WEB4, WEB5, WEB6
EXIT SUB
REM THIS ROUTINE DRAWS A LINE ACROSS A CIRCLE TO A POINT N DEGREES LESS THAN
REM THE CURRENT POINT+180.  THIS CONTINUES UNTIL THE POINT RETURNS TO ITS
REM ORIGIN.
WEB1:
        IF I = 1 THEN
                R2 = 0
                R1 = U
                DO
                        XS1 = RND * 75 + 15
                LOOP WHILE 360 MOD XS1 <> 0
                XS2 = RND * 2 + 1
                G = (RND < .5)
        END IF
        FOR YS1 = 1 TO 6 STEP 2
                A! = XS1 / 2 + YS1
                B! = A! * (360 / XS1) * DEG
                X2 = R1 * .75 * SINE!(B!)
                Y2 = R1 * COSINE!(B!)
                CX& = X2
                CY& = Y2
                DO
                        IF G THEN K = UPK(K)
                        A! = A! + XS1 / 2 + YS1
                        B! = A! * (360 / XS1) * DEG
                        X1 = R1 * .75 * SINE!(B!)
                        Y1 = R1 * COSINE!(B!)
                        LINE (X1, Y1)-(X2, Y2), K
                        X2 = X1
                        Y2 = Y1
                LOOP UNTIL CX& = X2 AND CY& = Y2
                I = 1
                IF NOT G THEN K = UPK(K + K)
        NEXT YS1
        RETURN

REM THIS ROUTINE DRAWS SPLINE CURVES WITHIN EACH SEGMENT OF N DEGREES OF A
REM CIRCLE.
WEB2:
        IF I = 1 THEN
                A = FNRND3TO8
                B! = 360 / A * DEG
                R1 = U
                G = RND < .5
        END IF
DO WHILE R1 > 1
        R2 = U - R1
        IF NOT (G) THEN K = UPK(K) ELSE K = G
        CALL VECTORSPIN(0, 0, 0, B!, B!, R1, R2, K)
        IF A MOD 2 = 1 THEN
                IF NOT (G) THEN K = UPK(K) ELSE K = G
                CALL VECTORSPIN(0, 0, PI, B!, B!, R1, R2, K)
        END IF
        R1 = R1 - (U / 20)
        IF INKEY$ <> "" THEN EXIT DO
LOOP
RETURN

REM THIS ROUTINE DRAWS LINES FROM EACH N DEGREES AROUND A CIRCLE TO A POINT
REM X * N AWAY, WHERE X=1 - 3.  REPEAT WITH N=N+N UNTIL N>180.
WEB3:
        IF I = 1 THEN
                R2 = 0
                R1 = U
                DO
                        XS1 = RND * 19 + 5
                LOOP WHILE 360 MOD XS1 <> 0
                DO
                        XS2 = RND * 2 + 1
                LOOP WHILE XS1 MOD XS2 <> 0
                DO
                        G = SGN(RND - RND)
                LOOP WHILE G = 0
                A = ((360 / XS1) MOD 2 = 0)
                IF A THEN YS1 = 180 ELSE YS1 = 360
        END IF
        FOR A! = XS1 * XS2 TO 180 STEP XS1 * XS2
        IF NOT (G) THEN K = UPK(K) ELSE K = G
                B! = XS1 * DEG
                CALL VECTORSPIN(0, 0, 0, B!, A! * DEG, R1, R1, K)
        NEXT A!
        RETURN

REM THIS ROUTINE DRAWS A POLYGON WITHIN A CIRCLE.  THE CENTERLINE OF THE
REM POLYGON MAY BE AN ODD MULTIPLE OF 360.  THE POLYGON IS DRAWN, ROTATING
REM BY A GIVEN N UNTIL A MULTIPLE OF 360 IS REACHED.  THEN THE ANGLES OF THE
REM POLYGON ARE ADJUSTED.  "PHASE-SHIFTED POLYGON".
WEB4:
        S1 = U
        X1 = 0
        Y1 = 0
        CA = 0
        C! = 0
        DO
                A! = INT(RND * 20)
        LOOP WHILE (A! MOD 2) = 0
        IF RND < .5 THEN
                DO
                        B! = INT(RND * 20)
                LOOP WHILE (B! MOD 2) = 0
                I = B! * 10
        ELSE
                I = 1
                B! = 1
        END IF
        IF RND < .5 THEN A! = -A!
        DO
                C! = C! + 2 * I
                DO
                        CALL FORWARD(S1 * COSINE!(B! * DEG), K)
                        CA = (CA + A!) MOD 360
                        B! = B! + C!
                        K = UPK(K)
                        IF INKEY$ <> "" THEN C = -1: CA = 0
                LOOP UNTIL CA = 0
        LOOP UNTIL C
        RETURN

WEB5:
        C! = 3
        R1 = 1
        B = RND > .5
        FOR A! = 0 TO PI STEP PI / 15
                R2 = R1
                R1 = 1.5 * R1
                IF B THEN K = B ELSE K = UPK(K)
                CALL VECTORSPIN(0, 0, 0, PI / 15, A!, R2, R1, K)
                IF INKEY$ <> "" THEN EXIT FOR
        NEXT A!
        RETURN

WEB6:
        G = 3 + (INT(RND + .5))
        A = G
        B = RND > .5
        STP = 0
        DO WHILE R1 < U AND NOT (STP)
                B! = 180 / G * DEG
                R2 = U * .75 * SINE!(B!)
                R1 = U * COSINE!(B!)
                FOR A! = 0 TO PI2 STEP B! * 2
                        X1 = R1 * .75 * SINE!(A!)
                        Y1 = R1 * COSINE!(A!)
                        B! = ABS(ROUNDPI!(PI - A!) - DEG)
                        C! = ABS(ROUNDPI!(-A!) - DEG)
                        IF B THEN K = UPK(K)
                        CIRCLE (X1, Y1), R2, K, B!, C!, 1
                        IF INKEY$ <> "" THEN STP = -1: EXIT FOR
                NEXT A!
                IF NOT (B) THEN K = UPK(K + 1)
                G = G + A
        LOOP
        RETURN

END SUB

