' This is the BASIC interface to Screen Font Editor, (C) 1993 Jeremy Lilley
' callable from Quick Basic (R) 4.0 or 4.5. You must create a QB library
' file using the /Q option on LINK with the FONTS_BS.OBJ file. You may 
' re-assemble FONTS_BS.ASM to make any changes, but the author is not 
' responsible for any damage caused by the interface or modified versions of
' it, so be careful, ESPECIALLY with the sequencefonts and desequencefonts 
' subroutines, as any modification of them could cause PERMANENT DAMAGE to
' your monitor.
'
' To interface SFF or SFS files to these subroutines, you can do any of the
' following :
'
' 1) Use the QB utilities to create an object file out of a SFF or SFS file
'    and then declare it as a pseudo subroutine.
'
' 2) Use LANGUAGE.EXE to either create a BSave file from a SFS.
'
' 3) Use file IO and load files into arrays created with the DIM command.
'    These files tend to get lost though.
'
' 4) Use LANGUAGE.EXE to create BASIC Data statements, then load them into an
'    array.
'
' 5) Use LANGUAGE.EXE to create assembly language DB statements then make them
'    into a PUBLIC reference and interface as a pseudo-subroutine.
'
' Here are the PUBLIC subroutines :
'
'
' Readfont : This subroutine reads a font in memory and displays it on screen.
' The screen is not cleared.
DECLARE SUB READFONT ( A& )
'
' Readscreen : This subroutine reads a screen or portion of one and loads it
' into video memory. Only the block defined will be replaced on-screen.
DECLARE SUB READSCREEN ( A& )
' 
' ResetFonts : Resets fonts and sets VGA to 400 line mode.
DECLARE SUB RESETFONTS ( )
'
' Sequencefonts : This need never be called by the programmer. It sets the 
' video system up so that you can alter the fonts by moving bit patterns
' in and out of segment &A000. There are 32 bytes allocated to each bit 
' pattern, so the first character would be placed at &A000:0, the second
' at &A000:32, et cetera. This messes up the screen when it is on, so you
' should call desequencefonts as soon as possible.
DECLARE SUB SEQUENCEFONTS ( )
'
' Desequencefonts : This normalizes the video system after a call to 
' sequencefonts.
DECLARE SUB DESEQUENCEFONTS ( ) 
'
' SetScanLines : Sets scan lines on a VGA monitor. The value passed on can
' be 0 = 200 lines, 1 = 350 lines, 2 = 400 lines.
DECLARE SUB SETSCANLINES ( A% )
'
' Savefonts : Saves the state of the font buffer. 8192 bytes are required as
' a save buffer.
DECLARE SUB SAVEFONTS ( A& )
'
' RestoreFonts : Restores previously saved fonts
DECLARE SUB RESTOREFONTS ( A& )
