_TEXT SEGMENT BYTE PUBLIC 'CODE'
ASSUME CS:_TEXT
; This is the FAR implementation of Fontools in C-callable format.
; Pointers are 32 bit and the large memory model should be used.
; For more details, see the manual or the C header file.

false equ 0
true equ 1
lines200 equ 0
lines350 equ 1
lines400 equ 2
parama equ [bp+6]

vseg dw 0b800h
linesperchar db 13 ; points - 1
vga db false
ega db false
vedone db false

fontheader db '@JLSFF',1

cmpegafalse proc near
cmp byte ptr vedone,true
je cef
call detega
cef:
cmp byte ptr ega,false
ret
cmpegafalse endp

cmpvgafalse proc near
cmp byte ptr vedone,true
je cvf
call detega
cvf:
cmp byte ptr vga,false
ret
cmpvgafalse endp

PUBLIC _SEQUENCEFONTS

_sequencefonts proc far
call cmpegafalse
je nosequence
push ax
push dx
mov ax,0704h
mov dx,03c4h
out dx,ax
mov dx,03ceh
mov ax,0204h
out dx,ax
mov ax,5
out dx,ax
mov ax,0406h
out dx,ax
mov ax,0402h
mov dx,03c4h
out dx,ax
pop dx
pop ax
nosequence:
ret
_sequencefonts endp

PUBLIC _DESEQUENCEFONTS

_desequencefonts proc far
call cmpegafalse
je nodesequence
push ax
push dx
mov dx,03c4h
mov ax,0302h
out dx,ax
mov ax,0304h
out dx,ax
mov dx,03ceh
mov ax,4
out dx,ax
mov ax,01005h
out dx,ax
mov ax,0e06h
cmp vseg,0b000h
jne d1
mov ax,0606h
d1:
out dx,ax
pop dx
pop ax
nodesequence:
ret
_desequencefonts endp

PUBLIC _SETSCANLINES

_setscanlines proc far ; number of scanlines as parameter, al
 ; 0=200 lines  1 = 350 lines  2 = 400 lines
push bp
mov bp,sp
jmp ssl
scnlns db 0
ssl:
push ax
push bx
push cx
mov al,parama
mov scnlns,al
cmp al,2
ja nossl
call cmpvgafalse
je nossl
mov al,scnlns
mov ah,012h
mov bx,030h
int 010h
mov ax,083h   ; set mode with no video memory clearing
cmp vseg,0b000h
jne s1
mov ax,087h
s1:
int 010h
mov cx,0c0dh
mov al,scnlns
cmp al,0
jne s2
mov cx,0708h
s2:
mov ax,0100h
int 010h
nossl:
pop cx
pop bx
pop ax
pop bp
ret
_setscanlines endp

setlinesperchar proc near
call cmpegafalse
je noslpc
push ax
push bx
push cx
push dx
mov ax,01100h
mov bh,linesperchar
xor bl,bl
xor cx,cx
xor dx,dx
int 010h
pop dx
pop cx
pop bx
pop ax
noslpc:
ret
setlinesperchar endp

comparestrings proc near ; compares DS:SI & ES:DI and increments SI & DI
 ; does for CX bytes sets carry flag
cstr:
repe cmpsb
ret
comparestrings endp

PUBLIC _READFONT

_readfont proc far ; pass on far pointer
push bp
mov bp,sp
push ds
push es
push si
push di
call cmpegafalse
jne rf1
jmp norf
numberofentries db 0
i dw 0
j dw 0
k dw 0
begchar dw 0
endchar dw 0
rf1:
lds si,parama
mov di,seg fontheader
mov es,di
mov di,offset fontheader
mov cx,7
call comparestrings
je goon1
jmp norf
goon1:
xor ax,ax
lodsb
push ax
call _setscanlines
pop ax
lodsb
mov linesperchar,al
cmp al,16
jb goon2
jmp norf
goon2:
call setlinesperchar
lodsb
mov numberofentries,al
mov i,0
f2:
lodsb
xor ah,ah
mov begchar,ax
lodsb
mov endchar,ax

mov ax,begchar
mov j,ax
f1:
call _sequencefonts
mov di,0a000h
mov es,di
mov bx,j
mov di,bx
mov cl,5
shl di,cl
mov cl,linesperchar
inc cl
xor ch,ch
shr cl,1
rep movsw
call _desequencefonts
inc j
mov ax,endchar
cmp j,ax
jbe f1
inc i
mov al,numberofentries
xor ah,ah
cmp i,ax
jbe f2
norf:
pop di
pop si
pop es
pop ds
pop bp
ret
_readfont endp

PUBLIC _READSCREEN

_readscreen proc far ; 32 bit FAR pointer must be passed on
push bp
mov bp,sp
push ds
push es
push si
push di
jmp rs1
xy db 0 
x1 db 1
y1 db 1
x2 db 80
y2 db 25
rs1:
lds si,parama
lodsb
mov x1,al
lodsb
mov y1,al
lodsb
mov x2,al
lodsb
mov y2,al
mov al,y1
mov xy,al
r1:
mov cl,x2
inc cl
mov ch,x1
sub cl,ch
xor ch,ch
shl cx,1
mov di,vseg
mov es,di
mov al,xy
dec al
mov ah,0
mov bl,80
mul bl
mov bl,x1
dec bl
xor bh,bh
add bx,ax
shl bx,1
mov di,bx
r2:
lodsb
stosb
loop r2
inc xy
mov al,y2
cmp xy,al
jbe r1
pop di
pop si
pop es
pop ds
pop bp
ret 
_readscreen endp

EGAGrfx proc near ; index in al , value in ah
push dx
mov dx,03ceh
out dx,al
inc dx
mov al,ah
out dx,al
pop dx
ret
EGAgrfx endp

detEGA proc near
mov vedone,true
jmp dega
testmask db 1
BIOSbyte db 0
dega:
xor ax,ax
mov es,ax
mov vseg,0b800h
mov bx,0410h
mov al,es:[bx]
and al,48
cmp al,48
jne deg2
mov vseg,0b000h
deg2:
mov bx,0487h
mov al,es:[bx]
mov biosbyte,al
mov ah,012h
mov bx,0ff10h
int 010h
mov al,biosbyte
and al,060h
mov cl,5
shr al,cl
cmp bl,al
je degcont
cmp bh,0ffh
jne degcont
mov ega,false
jmp degend
degcont:
mov ah,testmask
mov al,8
call EGAGrfx
mov dx,03ceh
mov al,8
out dx,al
mov vga,false
mov dx,03cfh
in al,dx
cmp al,testmask
jne eg1
mov vga,true
eg1:
mov ax,0ff08h
call egagrfx
mov EGA,TRUE
degend:
ret
detega endp

PUBLIC _SAVEFONTS

_savefonts proc far ; pass on FAR pointer for 8192 bytes,
push bp
mov bp,sp
push ds
push es
push si
push di
les di,parama
call _sequencefonts
mov si,0a000h
mov ds,si
xor si,si
mov cx,4096
rep movsw
call _desequencefonts
pop di
pop si
pop es
pop ds
pop bp
ret
_savefonts endp

PUBLIC _RESTOREFONTS

_restorefonts proc far ; pass on FAR pointer - 8192 bytes req.
push bp
mov bp,sp
push ds
push es
push si
push di
lds si,parama
call _sequencefonts
mov di,0a000h
mov es,di
xor di,di
mov cx,4096
rep movsw
call _desequencefonts
pop di
pop si
pop es
pop ds
pop bp
ret
_restorefonts endp

PUBLIC _RESETFONTS

_resetfonts proc far ; no params
push ax
mov ax,083h
int 010h
mov al,2
push ax
call _setscanlines
pop ax
pop ax
ret
_resetfonts endp 

_TEXT ENDS
END
