/************************************************************************/
/* File     : swarm.c                                                   */
/* Written  : 93-02-05, JPS                                             */
/* Notes    : This was actually converted from a version of xswarm, an  */
/*            X-Windows screen blanker.                                 */
/* Usage    : swarm                                                     */
/************************************************************************/
#include <alloc.h>
#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
#include <graphics.h>
#include <time.h>		/* for randomize() */

#define BGIPATH		""

#define TIMES   4   /* number of time positions recorded */
#define BEEACC	3		/* acceleration of bees */
#define WASPACC 5		/* maximum acceleration of wasp */
#define BEEVEL  11  /* maximum bee velocity */
#define WASPVEL 12  /* maximum wasp velocity */
#define BORDER  50  /* wasp won't go closer than this to the edge */

#define SEED	50		/* for random() calls */

/* Macros */
#define X(t,b)	(sp->x[(t)*sp->beecount+(b)])
#define Y(t,b)	(sp->y[(t)*sp->beecount+(b)])
#define RAND(v)	((random(SEED)%(v))-((v)/2))	/* random number around 0 */

typedef struct {
    int x1;
    int y1;
    int x2;
    int y2;
    } Segment;

typedef struct {
    int         pix;
    int         width;
    int         height;
    int         beecount;  /* number of bees */
    Segment    *segs;      /* bee lines */
    Segment    *old_segs;  /* old bee lines */
    short      *x;
    short      *y;         /* bee positions x[time][bee#] */
    short      *xv;
    short      *yv;        /* bee velocities xv[bee#] */
    short       wx[3];
    short       wy[3];
    short       wxv;
    short       wyv;
}           swarmstruct;

int g_driver, g_mode, g_error;

static swarmstruct swarms;
static int beecolor = YELLOW;
static int waspcolor = WHITE;
static int bees = 100;    /* # in the swarm */

/* Prototypes */
void init_graph( void );
void init_swarm( void );
void draw_swarm( void );

void init_graph( void )
{
   int g_driver = DETECT;

   if (g_driver < 0)
     { printf ("No graphics hardware detected!\n");
       exit (1);
     }

   initgraph (&g_driver, &g_mode, BGIPATH);

   if (g_error < 0)
      { printf ("Graphics error: %s.\n",grapherrormsg(g_error));
        exit(1);
      }
}

void init_swarm( void )
{
  swarmstruct *sp = &swarms;
  int         b;

  sp->beecount = bees;
  sp->width    = getmaxx();
  sp->height   = getmaxy();

  /* Clear the background. */
  clearviewport();

  /* Allocate memory. */
  if (!sp->segs)
    {
    sp->segs = (Segment *) malloc(sizeof(Segment) * sp->beecount);
    sp->old_segs = (Segment *) malloc(sizeof(Segment) * sp->beecount);
    sp->x = (short *) malloc(sizeof(short) * sp->beecount * TIMES);
    sp->y = (short *) malloc(sizeof(short) * sp->beecount * TIMES);
    sp->xv = (short *) malloc(sizeof(short) * sp->beecount);
    sp->yv = (short *) malloc(sizeof(short) * sp->beecount);
    }

  /* Initialize point positions, velocities, etc. */

  randomize();

  /* wasp */
  sp->wx[0] = BORDER + random(sp->width - 2 * BORDER);
  sp->wy[0] = BORDER + random(sp->height - 2 * BORDER);
  sp->wx[1] = sp->wx[0];
  sp->wy[1] = sp->wy[0];
  sp->wxv = 0;
  sp->wyv = 0;

  /* bees */
  for (b = 0; b < sp->beecount; b++)
    {
    sp->x[b] = random(sp->width);
    X(1, b) = sp->x[b];
    sp->y[b] = random(sp->height);
    Y(1, b) = sp->y[b];
    sp->xv[b] = RAND(7);
    sp->yv[b] = RAND(7);
    }
}



void draw_swarm( void )
{
  swarmstruct *sp = &swarms;
  int         b;
  int   n;

  /* <=- Wasp -=> */
  /* Age the arrays. */
  sp->wx[2] = sp->wx[1];
  sp->wx[1] = sp->wx[0];
  sp->wy[2] = sp->wy[1];
  sp->wy[1] = sp->wy[0];

  /* Accelerate */
  sp->wxv += RAND(WASPACC);
  sp->wyv += RAND(WASPACC);

  /* Speed Limit Checks */
  if (sp->wxv > WASPVEL)
    sp->wxv = WASPVEL;
  if (sp->wxv < -WASPVEL)
    sp->wxv = -WASPVEL;
  if (sp->wyv > WASPVEL)
    sp->wyv = WASPVEL;
  if (sp->wyv < -WASPVEL)
    sp->wyv = -WASPVEL;

  /* Move */
  sp->wx[0] = sp->wx[1] + sp->wxv;
  sp->wy[0] = sp->wy[1] + sp->wyv;

  /* Bounce Checks */
  if ((sp->wx[0] < BORDER) || (sp->wx[0] > sp->width - BORDER - 1))
    {
    sp->wxv = -sp->wxv;
    sp->wx[0] += sp->wxv;
    }
  if ((sp->wy[0] < BORDER) || (sp->wy[0] > sp->height - BORDER - 1))
    {
    sp->wyv = -sp->wyv;
    sp->wy[0] += sp->wyv;
    }

  /* Don't let things settle down. */
  sp->xv[random(SEED) % sp->beecount] += RAND(3);
  sp->yv[random(SEED) % sp->beecount] += RAND(3);

  /* <=- Bees -=> */
  for (b = 0; b < sp->beecount; b++)
    {
    int         distance,
                dx,
                dy;

    /* Age the arrays. */
    X(2, b) = X(1, b);
    X(1, b) = X(0, b);
    Y(2, b) = Y(1, b);
    Y(1, b) = Y(0, b);

    /* Accelerate */
    dx = sp->wx[1] - X(1, b);
    dy = sp->wy[1] - Y(1, b);
    distance = abs(dx) + abs(dy); /* approximation */
    if (distance == 0)
	    distance = 1;
    sp->xv[b] += (dx * BEEACC) / distance;
    sp->yv[b] += (dy * BEEACC) / distance;

    /* Speed Limit Checks */
    if (sp->xv[b] > BEEVEL)
      sp->xv[b] = BEEVEL;
    if (sp->xv[b] < -BEEVEL)
	    sp->xv[b] = -BEEVEL;
    if (sp->yv[b] > BEEVEL)
	    sp->yv[b] = BEEVEL;
    if (sp->yv[b] < -BEEVEL)
	    sp->yv[b] = -BEEVEL;

    /* Move */
    sp->x[b] = X(1, b) + sp->xv[b];
    sp->y[b] = Y(1, b) + sp->yv[b];

    /* Fill the segment lists. */
    sp->segs[b].x1 = sp->x[b];
    sp->segs[b].y1 = sp->y[b];
    sp->segs[b].x2 = X(1, b);
    sp->segs[b].y2 = Y(1, b);
    sp->old_segs[b].x1 = X(1, b);
    sp->old_segs[b].y1 = Y(1, b);
    sp->old_segs[b].x2 = X(2, b);
    sp->old_segs[b].y2 = Y(2, b);
    }

    /* Erase last scene */
    setcolor(BLACK);
    line(sp->wx[1], sp->wy[1], sp->wx[2], sp->wy[2]);
    for (n=0; n < sp->beecount; n++)
      line(sp->old_segs[n].x1, sp->old_segs[n].y1,
           sp->old_segs[n].x2, sp->old_segs[n].y2);

    /* Draw new scene */
    setcolor(waspcolor);
    line(sp->wx[0], sp->wy[0], sp->wx[1], sp->wy[1]);
    setcolor(beecolor);
    for (n=0; n < sp->beecount; n++)
      line(sp->segs[n].x1, sp->segs[n].y1,
           sp->segs[n].x2, sp->segs[n].y2);
}

void main( void )
{
  init_graph();       /* Turns on graphics */
  init_swarm();
  while (!kbhit())
    draw_swarm();
  closegraph();
}
