// File Search and Replace
// This routine will scan a DOS file searching and replacing
// matching text strings. The file to be opened will be specified
// on the command line, and the new file that will be created will
// be called FSR.NEW. After completing the operating and closing
// both files, the original file will be replaced and FSR.NEW will
// be renamed the same as the old file. As an Option you can pass
// argc[4] as the TempFile name and this will be used instead of
// FSR.NEW.
// Command Line: FILENAME SEARCHSTRING REPLACESTRING [TempFile]

// FSR.CPP - By Todd Osborne CIS ID: 71431,2243
// 09/16/93 - Compiled with Microsoft Visual C++ 1.00

// This source code and program are Public Domain

// Feel free to copy and use this source code in other programs.
// Please let me know if you find any bugs or want improvements!!

// **** THIS PROGRAM IS CASE-SENSITIVE ****

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Function Prototypes
int 	FileSearchAndReplace (char*, char*, char*, char*);
void 	ReplaceString (char*, char *, char *);
int 	CopyTextFile (char*, char *);
void	ShowHelp(void);

void main (int argv, char *argc[] )
{
	if (argv < 4)
		{
		ShowHelp();
		exit (0);
		}
    else
    
    //argc[4] can be used to specify the temp file name (FSR.NEW is default)
    if (argc[4]==NULL)
    	{
    	FileSearchAndReplace (argc[1], argc[2], argc[3], "FSR.NEW");
        }
        else FileSearchAndReplace (argc[1], argc[2], argc[3], argc[4]);
    exit (0);
}


int FileSearchAndReplace (char *FileName, char *SearchString, char *ReplaceStr, char *TempFile)
{
	// Perform the File Search and Replace
	// Function returns 1 if successfull, 0 if not
	
	FILE *FP1, *FP2;						// File Pointer 1 (Open File) and 2 (New File)
	char InString[256]="";
	char *loc="";							// Pointer to character location in InString
		
	if ( (FP1=fopen(FileName, "r")) != NULL )
		{
		//Open Output File
		if ( (FP2=fopen(TempFile, "w")) == NULL )
			{
			fcloseall();				// Something's Wrong!!
			return (0);
			}
		
		// Process this file
		while ( (fgets (InString, 256, FP1)) != NULL )
			{
			//There may be more than one string in each line, so loop
			while ( (loc=strstr(InString, SearchString)) != NULL )
				{
				ReplaceString (InString, SearchString, ReplaceStr);
				}	
			fputs (InString, FP2);		// Write modified line to new file
			}
	    fcloseall();					// Close open files
		
		// Copy File instead of rename. If you only rename it, the file
		// will exists in the same directory as FSR.EXE. We want it to
		// be placed in the same location it came from!
		CopyTextFile (TempFile, FileName);
		remove (TempFile);
		return (1);
		}
	else 
		{
		printf("\nFile not found.\n");
		return (0);
		}
}


void ReplaceString (char *InString, char *SearchString, char *ReplaceStr)
{
    //Do the Actual String Replacement Here
    
    char NewString1[256]="";				// 1st Part of New String
	char NewString2[256]="";                // 2nd Part of New String
	char *loc="";
	
	loc=strstr(InString, SearchString);
	strncpy (NewString1, InString, loc-InString);
	strncpy (NewString2, InString + ( (loc-InString) + (strlen(SearchString)) ), 256);
	strcpy (InString, NewString1);			// Combine these suckers
	strcat (InString, ReplaceStr);          //
	strcat (InString, NewString2);          //
}


int CopyTextFile (char *SourceFile, char *DestFile)
{
	// This routine copies TEXT files ONLY !!
	
	FILE *FP1, *FP2;
	char InString[256]="";
	
	if ( (FP1=fopen(SourceFile, "r")) != NULL )
		{
		//Open Output File
		if ( (FP2=fopen(DestFile, "w")) == NULL )
			{
			fcloseall();				// Something's Wrong!!
			return (0);
			}
		else
		// Process this file
			while ( (fgets (InString, 256, FP1)) != NULL )
				{
	            fputs (InString, FP2);
	            }
	    fcloseall();
	    return (1);
	    }        
	else return (0);
}


void ShowHelp(void)
{
	int i=0;
	
	printf("\n%c", 201);
	for (i=2; i<80; i++) printf("%c", 205);
	printf("%c", 187);
	printf("%c                            File Search and Replace                           %c", 186, 186);
    printf("%c", 204);
    for (i=2; i<80; i++) printf("%c", 205);
    printf("%c", 185);
    printf("%c                                                                              %c", 186, 186);
    printf("%c Command Line Argument: FN SS SR [TF]                                         %c", 186, 186);
    printf("%c                                                                              %c", 186, 186);
    printf("%c FN = File Name to Search     SS = String to Search For                       %c", 186, 186);
    printf("%c SR = Replacement String      TF = Optional Temporary File Name               %c", 186, 186);
    printf("%c                                                                              %c", 186, 186);
    printf("%c   Public Domain Software By Todd Osborne: CIS ID 71431,2243 Charlotte, NC    %c", 186, 186);
    printf("%c   Date: 09/16/93   Version 1.00   Coded using Microsoft Visual C++  V1.00    %c", 186, 186);
    printf("%c                                                                              %c", 186, 186);
    printf("%c NOTE: This Program is Case-Sensitive (Example: Hello is the same as hello)   %c", 186, 186);
    printf("%c", 200);
	for (i=2; i<80; i++) printf("%c", 205);
	printf("%c\ndir ", 188);
}