/* gsar.h ***************************************** UPDATED: 930325.19:31 TT
 *
 * Description : Header file for gsar
 * Author      : Tormod Tjaberg
 *
 * Changes:
 *
 * Currently compiles under :
 * Turbo C 2.0, Turbo C++ 1.0, Turbo C++ 3.0, Zortech C++ 3.0,
 * Watcom C 386 8.0, Ultrix ANSI C, Microsoft 6.0, GCC
 */


/* System type defined upon the following
 * __TURBOC__ : All Borland C/C++ versions
 * __ZTC__    : Zortech
 * MSDOS      : Set by various DOS compilers... ( Watcom 386, Microsoft )
 */

#if defined(__TURBOC__) || defined(__ZTC__) || defined(MSDOS)
#ifndef MSDOS
#define MSDOS     5
#endif
#else
#ifndef __UNIX__
#define __UNIX__  3
#endif
#endif

#ifndef BUFSIZ                            /* ANSI C predefined constant */
#ifdef MSDOS
#define BUFSIZ 1024                       /* size of search buffer */
#else             /* its __UNIX__ */
#define BUFSIZ 4048                       /* size of search buffer */
#endif
#endif

#define TXT_CONTEXT 80      /* length of textual context     */
#define HEX_CONTEXT 64      /* amount of hex bytes displayed */
#define PAT_BUFSIZ  128     /* buffer limit < unsigned short */

typedef struct
{
   char fVerbose;           /* true if we are to be verbose */
   char fByteOffset;        /* display byte offset in file */
   char fTextual;           /* display context textual */
   char fFileSpec;          /* display filespec */
   char fHex;               /* display contents in hex */
   char *pInputFile;        /* current input file name */
   FILE *fpIn;              /* input stream */
   FILE *fpOut;             /* output stream */
   FILE *fpMsg;             /* message stream */
   unsigned short Context;  /* length of context to display */
} OUTPUT_CTRL;


/* function prototypes
 */
void BMGSetup( char *, int, char);
long BMGSearch( OUTPUT_CTRL * );
long BMGSearchReplace( OUTPUT_CTRL *, char *, unsigned short );
void Abort( char *, ... );

